/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.api.common;

import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseException;
import com.ibm.es.nuvo.util.parser.ParseTree;
import com.ibm.es.nuvo.util.parser.Parser;
import java.io.InputStream;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CredentialsList {
    private Vector<IdentityItem> identityItems = null;

    public Vector<IdentityItem> getIdentityItems() {
        return this.identityItems;
    }

    public static CredentialsList loadFrom(InputStream is) throws ParseException {
        Parser parser = new Parser();
        ParseTree tree = new ParseTree();
        tree.addSetSubcomponent("/UserSecurityContext/credentials/identity", "buildIdentityItem");
        tree.addCallMethod("/UserSecurityContext/credentials/identity/username/", "setUserName");
        tree.addCallMethod("/UserSecurityContext/credentials/identity/password/", "setPassword");
        CredentialsList list = new CredentialsList();
        parser.parse(is, tree, list);
        return list;
    }

    public String toXML() {
        XMLTagger tagger = new XMLTagger();
        tagger.startPI("version = 1.0 encoding=\"UTF-8\"");
        tagger.endPI();
        tagger.writeText("\n");
        tagger.startElement("UserSecurityContext version=\"1.0\"");
        tagger.writeText("\n");
        tagger.startElement("credentials");
        tagger.writeText("\n");
        for (IdentityItem item : this.identityItems) {
            tagger.startElement("identity");
            tagger.writeText("\n");
            if (item.getUserName() != null) {
                tagger.startElement("username");
                tagger.writeText(item.getUserName());
                tagger.endElement("username");
                tagger.writeText("\n");
            }
            if (item.getPassword() != null) {
                tagger.startElement("password");
                tagger.writeText(item.getPassword());
                tagger.endElement("password");
                tagger.writeText("\n");
            }
            tagger.endElement("identity");
            tagger.writeText("\n");
        }
        tagger.endElement("credentials");
        tagger.writeText("\n");
        tagger.endElement("UserSecurityContext");
        return tagger.getXML();
    }

    public IdentityItem buildIdentityItem() {
        if (this.identityItems == null) {
            this.identityItems = new Vector();
        }
        IdentityItem identityItem = new IdentityItem();
        this.identityItems.add(identityItem);
        return identityItem;
    }

    public class IdentityItem {
        private String userName = null;
        private String password = null;

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

