/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.api.common;

import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseException;
import com.ibm.es.nuvo.util.parser.ParseTree;
import com.ibm.es.nuvo.util.parser.Parser;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrawlSpaceItem {
    private static final String ELEM_SPACE = "space";
    private static final String ELEM_PROPERTY = "property";
    private static final String ELEM_PROPERTY_LIST = "propertyList";
    private static final String ELEM_ITEM = "item";
    private static final String ELEM_FIELD = "field";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ENABLED = "enabled";
    private static final String ATTR_UNIQUE_KEY = "uniqueKey";
    private Vector<Property1> properties = null;
    private Vector<PropertyList> propertyLists = null;
    private Vector<Field> fields = null;

    public static CrawlSpaceItem loadFrom(InputStream is) throws ParseException {
        Parser parser = new Parser();
        ParseTree tree = new ParseTree();
        String rootPath = "/space/";
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put(ATTR_NAME, ATTR_NAME);
        tree.addSetSubcomponent(rootPath + ELEM_PROPERTY, "buildProperty");
        tree.addAttributesRule(rootPath + ELEM_PROPERTY, propertyMap);
        tree.addCallMethod(rootPath + ELEM_PROPERTY, "setValue");
        tree.addSetSubcomponent(rootPath + ELEM_PROPERTY_LIST, "buildPropertyList");
        tree.addAttributesRule(rootPath + ELEM_PROPERTY_LIST, propertyMap);
        tree.addCallMethod(rootPath + ELEM_PROPERTY_LIST + "/" + ELEM_ITEM, "setItem");
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put(ATTR_NAME, ATTR_NAME);
        fieldMap.put(ATTR_ENABLED, ATTR_ENABLED);
        fieldMap.put(ATTR_UNIQUE_KEY, ATTR_UNIQUE_KEY);
        tree.addSetSubcomponent(rootPath + ELEM_FIELD, "buildField");
        tree.addAttributesRule(rootPath + ELEM_FIELD, fieldMap);
        CrawlSpaceItem list = new CrawlSpaceItem();
        parser.parse(is, tree, list);
        return list;
    }

    public String toXML() {
        XMLTagger tagger = new XMLTagger();
        tagger.startPI("version = 1.0 encoding=\"UTF-8\"");
        tagger.endPI();
        tagger.writeText("\n");
        tagger.startElement("space version=\"1.0\"");
        tagger.writeText("\n");
        if (this.properties != null) {
            for (Property1 prop : this.properties) {
                tagger.openStartElement(ELEM_PROPERTY);
                tagger.writeAttr(ATTR_NAME, prop.getName());
                tagger.closeTag();
                tagger.writeText(prop.getValue());
                tagger.endElement(ELEM_PROPERTY);
                tagger.writeText("\n");
            }
        }
        if (this.propertyLists != null) {
            for (PropertyList propList : this.propertyLists) {
                Vector<String> items = propList.getItems();
                if (items == null) continue;
                tagger.openStartElement(ELEM_PROPERTY_LIST);
                tagger.writeAttr(ATTR_NAME, propList.getName());
                tagger.closeTag();
                tagger.writeText("\n");
                for (String item : items) {
                    tagger.startElement(ELEM_ITEM);
                    tagger.writeText(item);
                    tagger.endElement(ELEM_ITEM);
                    tagger.writeText("\n");
                }
                tagger.endElement(ELEM_PROPERTY_LIST);
                tagger.writeText("\n");
            }
        }
        if (this.fields != null) {
            for (Field field : this.fields) {
                tagger.openStartElement(ELEM_FIELD);
                tagger.writeAttr(ATTR_NAME, field.getName());
                tagger.writeAttr(ATTR_ENABLED, String.valueOf(field.isEnabled()));
                tagger.writeAttr(ATTR_UNIQUE_KEY, String.valueOf(field.isUniqueKey()));
                tagger.closeEndElementTag();
                tagger.writeText("\n");
            }
        }
        tagger.endElement(ELEM_SPACE);
        return tagger.getXML();
    }

    public Vector<Property1> getProperties() {
        return this.properties;
    }

    public Vector<PropertyList> getPropertyLists() {
        return this.propertyLists;
    }

    public Vector<Field> getFields() {
        return this.fields;
    }

    public String getPropertyValue(String name) {
        String value = null;
        if (this.properties != null) {
            for (Property1 prop : this.properties) {
                if (!prop.getName().equals(name)) continue;
                value = prop.getValue();
                break;
            }
        }
        return value;
    }

    public Vector<String> getPropertyListItems(String name) {
        Vector<String> items = null;
        if (this.propertyLists != null) {
            for (PropertyList propList : this.propertyLists) {
                if (!propList.getName().equals(name)) continue;
                items = propList.getItems();
                break;
            }
        }
        return items;
    }

    public Field getField(String name) {
        Field field = null;
        if (this.fields != null) {
            for (Field temp : this.fields) {
                if (!temp.getName().equals(name)) continue;
                field = temp;
                break;
            }
        }
        return field;
    }

    public Property1 buildProperty() {
        if (this.properties == null) {
            this.properties = new Vector();
        }
        Property1 property = new Property1();
        this.properties.add(property);
        return property;
    }

    public PropertyList buildPropertyList() {
        if (this.propertyLists == null) {
            this.propertyLists = new Vector();
        }
        PropertyList propertyList = new PropertyList();
        this.propertyLists.add(propertyList);
        return propertyList;
    }

    public Field buildField() {
        if (this.fields == null) {
            this.fields = new Vector();
        }
        Field field = new Field();
        this.fields.add(field);
        return field;
    }

    public class Field {
        private String name = null;
        private boolean enabled;
        private boolean uniqueKey;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setEnabled(String enabled) {
            this.enabled = Boolean.parseBoolean(enabled);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setUniqueKey(String uniqueKey) {
            this.uniqueKey = Boolean.parseBoolean(uniqueKey);
        }

        public boolean isUniqueKey() {
            return this.uniqueKey;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PropertyList {
        private String name = null;
        private Vector<String> items = null;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setItem(String item) {
            if (this.items == null) {
                this.items = new Vector();
            }
            this.items.add(item);
        }

        public Vector<String> getItems() {
            return this.items;
        }
    }

    public class Property1 {
        private String name = null;
        private String value = null;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

