/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.anchortext;

import com.ibm.es.nuvo.anchortext.AnchorTextException;
import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.es.nuvo.tokenizer.TokenVector;

public class TargetAnchorText {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private TokenVector anchorText;
    private final String targetURL;
    private int linkCount = 0;

    public TargetAnchorText(String targetURL) throws AnchorTextException {
        this(targetURL, null);
    }

    public TargetAnchorText(String targetURL, TokenVector anchorText) throws AnchorTextException {
        this.targetURL = AnchorTextException.checkString("target URL", targetURL);
        this.anchorText = null;
        if (anchorText != null) {
            this.appendAnchorText(anchorText);
        }
    }

    public void appendAnchorText(TokenVector additionalAnchorText) throws AnchorTextException {
        if (additionalAnchorText == null) {
            throw new AnchorTextException.InvalidArgumentValueException("anchor text", (Object)null);
        }
        if (this.anchorText == null) {
            this.anchorText = new TokenVector();
        }
        this.anchorText.addToken(TToken.newSentenceBreak());
        this.anchorText.appendTokenVector(additionalAnchorText);
        ++this.linkCount;
    }

    public TokenVector getAnchorText() {
        return this.anchorText;
    }

    public int getReferrerCount() {
        return this.linkCount;
    }

    public String getTargetURL() {
        return this.targetURL;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append("TargetAnchorText(").append(this.targetURL).append(":").append(this.anchorText.toString()).append(")");
        return sb.toString();
    }
}

