/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.anchortext;

public class Stopwatch {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final int SW_PROC_ALL = -1;
    private String name;
    private String[] names;
    private long[] time;
    private long[] start;
    private long[] end;
    private boolean[] started;
    private long[] min;
    private long[] max;
    private int[] count;

    public Stopwatch(String name, String[] names) {
        if (name == null || names == null || names.length == 0) {
            throw new IllegalArgumentException("invalid stopwatch arguments");
        }
        this.name = name;
        this.names = new String[names.length];
        for (int j = 0; j < names.length; ++j) {
            this.names[j] = names[j];
        }
        this.time = new long[names.length];
        this.start = new long[names.length];
        this.end = new long[names.length];
        this.started = new boolean[names.length];
        this.min = new long[names.length];
        this.max = new long[names.length];
        this.count = new int[names.length];
        this._reset();
    }

    public synchronized void start(int whichProcess) {
        long now = System.currentTimeMillis();
        int first = whichProcess;
        int last = whichProcess;
        if (whichProcess == -1) {
            first = 0;
            last = this.names.length - 1;
        }
        for (int j = first; j <= last; ++j) {
            if (this.started[j]) continue;
            this.started[j] = true;
            this.start[j] = now;
        }
    }

    public synchronized void end(int whichProcess) {
        long now = System.currentTimeMillis();
        int first = whichProcess;
        int last = whichProcess;
        if (whichProcess == -1) {
            first = 0;
            last = this.names.length - 1;
        }
        for (int j = first; j <= last; ++j) {
            if (!this.started[j]) continue;
            this.started[j] = false;
            this.end[j] = now;
            long diff = now - this.start[j];
            int n = j;
            this.time[n] = this.time[n] + diff;
            int n2 = j;
            this.count[n2] = this.count[n2] + 1;
            if (diff > this.max[j]) {
                this.max[j] = diff;
            }
            if (diff >= this.min[j]) continue;
            this.min[j] = diff;
        }
    }

    public void reset() {
        this._reset();
    }

    private void _reset() {
        for (int j = 0; j < this.names.length; ++j) {
            this.time[j] = 0L;
            this.start[j] = 0L;
            this.end[j] = 0L;
            this.started[j] = false;
            this.min[j] = Long.MAX_VALUE;
            this.max[j] = -1L;
            this.count[j] = 0;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append("Stopwatch ").append(this.name).append("(");
        for (int j = 0; j < this.time.length; ++j) {
            sb.append("\n   ").append(this.names[j]).append(" Ct=").append(this.count[j]).append(" Tot=").append(this.time[j]);
            if (this.count[j] <= 0) continue;
            sb.append(" Min=").append(this.min[j]).append(" Max=").append(this.max[j]).append(" Avg=").append(this.time[j] / (long)this.count[j]);
        }
        sb.append(")");
        return sb.toString();
    }
}

