/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.anchortext;

import com.ibm.es.nuvo.anchortext.AnchorTextException;
import com.ibm.es.nuvo.anchortext.TargetAnchorText;
import com.ibm.es.nuvo.tokenizer.TToken;
import com.ibm.es.nuvo.tokenizer.TokenVector;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ReferrerAnchorText
implements Serializable {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private volatile TreeMap<String, TokenVector> references = new TreeMap();
    private final String referringURL;
    private String referringCrawlSpace;
    private static int maxNumberOfOutLinksPerURL = 50;
    private static final long serialVersionUID = 1L;

    public ReferrerAnchorText(String referringURL) throws AnchorTextException {
        this.referringURL = AnchorTextException.checkString("referring URL", referringURL);
    }

    public synchronized boolean addReference(String targetURL, TokenVector tokens) throws AnchorTextException {
        targetURL = AnchorTextException.checkString("target URL", targetURL);
        if (this.references.size() >= maxNumberOfOutLinksPerURL) {
            return false;
        }
        TokenVector tv = this.references.get(targetURL);
        if (tv == null) {
            tv = new TokenVector();
            this.references.put(targetURL, tv);
        }
        tv.appendTokenVector(tokens);
        return true;
    }

    public synchronized TargetAnchorText[] extractAnchorText() throws AnchorTextException {
        TargetAnchorText[] tat = new TargetAnchorText[this.references.size()];
        Set<Map.Entry<String, TokenVector>> es = this.references.entrySet();
        int index = 0;
        for (Map.Entry<String, TokenVector> me : es) {
            tat[index++] = new TargetAnchorText(me.getKey(), me.getValue());
        }
        this.references.clear();
        return tat;
    }

    public synchronized TargetAnchorText extractAnchorText(String targetURL) throws AnchorTextException {
        TokenVector tv = this.references.remove(targetURL);
        if (tv == null) {
            return null;
        }
        return new TargetAnchorText(targetURL, tv);
    }

    public String getReferringURL() {
        return this.referringURL;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ReferrerAnchorText(").append(this.referringURL).append(":");
        Set<Map.Entry<String, TokenVector>> es = this.references.entrySet();
        try {
            Iterator<Map.Entry<String, TokenVector>> iter = es.iterator();
            while (iter.hasNext()) {
                Map.Entry<String, TokenVector> me = iter.next();
                sb.append(new TargetAnchorText(me.getKey(), me.getValue()).toString());
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
        }
        catch (AnchorTextException anchorTextException) {
            // empty catch block
        }
        sb.append(")");
        return sb.toString();
    }

    public String getReferringCrawlSpace() {
        return this.referringCrawlSpace;
    }

    public void setReferringCrawlSpace(String referringCrawlSpace) {
        this.referringCrawlSpace = referringCrawlSpace;
    }

    public static int getMaximumNumberOfOutLinksPerURL() {
        return maxNumberOfOutLinksPerURL;
    }

    public static void setMaximumNumberOfOutLinksPerURL(int maximumNumberOfOutLinksPerURL) {
        maxNumberOfOutLinksPerURL = maximumNumberOfOutLinksPerURL;
    }

    public static void main(String[] args) {
        try {
            ReferrerAnchorText rat = new ReferrerAnchorText("http://referringURL");
            TokenVector tv = new TokenVector();
            tv.addToken(TToken.newSentenceBreak());
            rat.setReferringCrawlSpace("cs12345");
            rat.addReference("http://targeturl1", tv);
            rat.addReference("http://targeturl2", tv);
            rat.addReference("http://targeturl3", tv);
            FileOutputStream fos = null;
            FileInputStream fis = null;
            ObjectOutputStream oos = null;
            ObjectInputStream ois = null;
            fos = new FileOutputStream("tmp.tmp");
            oos = new ObjectOutputStream(fos);
            oos.writeObject(rat);
            oos.close();
            fos.close();
            fis = new FileInputStream("tmp.tmp");
            ois = new ObjectInputStream(fis);
            ReferrerAnchorText rat2 = (ReferrerAnchorText)ois.readObject();
            ois.close();
            fis.close();
            System.out.println("Referring URL  okay? " + rat.referringURL.equals(rat2.referringURL));
            System.out.println("Referring CS   okay? " + rat.referringCrawlSpace.equals(rat2.referringCrawlSpace));
            System.out.println("Number of refs okay? " + (rat.references.size() == rat2.references.size()));
            for (String key : rat.references.keySet()) {
                TokenVector tv1 = rat.references.get(key);
                TokenVector tv2 = rat2.references.get(key);
                System.out.println("Ref " + key + " okay? " + (tv1 != null && tv2 != null));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

