/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.anchortext;

import com.ibm.es.nuvo.anchortext.AnchorTextException;
import com.ibm.es.nuvo.util.FileUtils;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnchorTextRebuildFIFO {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private int batchSize;
    private File backingDirectory;
    private LinkedHashSet<String> writeTable;
    private LinkedHashSet<String> readList;
    private long numberOfEntriesAdded;
    private long numberOfEntriesRemoved;
    private int readFileIndex;
    private int writeFileIndex;
    private static final String METADATA_FILENAME = "ATRFMeta";
    private boolean closed;

    public AnchorTextRebuildFIFO(File backingDirectory, int batchSize) throws AnchorTextException {
        if (backingDirectory == null) {
            throw new AnchorTextException.InvalidArgumentValueException("backing directory", (Object)null);
        }
        if (batchSize < 1) {
            throw new AnchorTextException.InvalidArgumentValueException("batch size", (Object)batchSize);
        }
        this.batchSize = batchSize;
        this.backingDirectory = backingDirectory;
        this.initializeBackingStore();
        this.writeTable = new LinkedHashSet(this.batchSize);
        this.readList = new LinkedHashSet(this.batchSize);
    }

    public synchronized String get() throws AnchorTextException {
        Iterator iter;
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.numberOfEntriesRemoved == this.numberOfEntriesAdded) {
            return null;
        }
        if (this.numberOfEntriesRemoved > this.numberOfEntriesAdded) {
            new AnchorTextException.InconsistentStateException("invalid add/remove counts: " + this.numberOfEntriesAdded + "/" + this.numberOfEntriesRemoved).log();
            if (this.numberOfEntriesAdded < 0L) {
                this.numberOfEntriesAdded = 0L;
            }
            this.numberOfEntriesRemoved = this.numberOfEntriesAdded;
        }
        while (this.readList.size() < this.batchSize && this.loadEntries()) {
        }
        String url = null;
        if (this.readList.size() > 0) {
            url = (String)this.readList.iterator().next();
            this.readList.remove(url);
        } else if (!this.writeTable.isEmpty() && (iter = this.writeTable.iterator()).hasNext()) {
            url = (String)iter.next();
            if (url == null) {
                throw new RuntimeException("TODO replace: null in read list");
            }
            this.writeTable.remove(url);
        }
        if (url != null) {
            ++this.numberOfEntriesRemoved;
        }
        return url;
    }

    public synchronized boolean put(String url) throws AnchorTextException {
        if (this.closed) {
            throw new IllegalStateException();
        }
        if (!this.writeTable.add(url)) {
            return false;
        }
        ++this.numberOfEntriesAdded;
        if (this.writeTable.size() >= this.batchSize) {
            this.saveEntries();
            this.writeTable.clear();
        }
        return true;
    }

    public long size() {
        return this.numberOfEntriesAdded - this.numberOfEntriesRemoved;
    }

    public synchronized void close() throws AnchorTextException {
        if (!this.closed) {
            int trial;
            this.closed = true;
            if (!this.writeTable.isEmpty()) {
                this.saveEntries();
            }
            if (!this.readList.isEmpty() && (trial = (this.readFileIndex - 1) % 0x1000000) != this.writeFileIndex) {
                this.readFileIndex = trial;
                this.saveEntries(this.readList, this.readFileIndex);
            }
            this.syncMetadata(SyncOperation.Save);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    private int incrementReadFileIndex() {
        int old = this.readFileIndex++;
        this.readFileIndex %= 0x1000000;
        return old;
    }

    private int incrementWriteFileIndex() {
        int old = this.writeFileIndex++;
        this.writeFileIndex %= 0x1000000;
        if (this.readFileIndex == this.writeFileIndex) {
            this.incrementReadFileIndex();
        }
        return old;
    }

    private boolean storeIsEmpty() {
        return this.readFileIndex == this.writeFileIndex;
    }

    private File fileForIndex(int index) {
        int d0 = 0;
        int d1 = 0;
        int f = 0;
        d0 = index / 65536;
        d1 = (index %= 65536) / 256;
        f = index % 256;
        StringBuffer sb = new StringBuffer();
        sb.append(Integer.toString(d0)).append(File.separator).append(Integer.toString(d1)).append(File.separator).append(Integer.toString(f));
        return new File(this.backingDirectory, sb.toString());
    }

    private boolean loadEntries() throws AnchorTextException {
        File readFile = null;
        while (!this.storeIsEmpty() && readFile == null) {
            File f = this.fileForIndex(this.incrementReadFileIndex());
            if (!f.exists()) continue;
            readFile = f;
        }
        if (readFile == null) {
            return false;
        }
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            String readObj22;
            fis = new FileInputStream(readFile);
            ois = new ObjectInputStream(fis);
            while ((readObj22 = (String)ois.readObject()) != null) {
                if (this.readList.add(readObj22)) continue;
                ++this.numberOfEntriesRemoved;
            }
            boolean readObj22 = true;
            return readObj22;
        }
        catch (ClassNotFoundException cnfe) {
            throw new AnchorTextException.RebuildFIFOLoadException("instantiation", (Throwable)cnfe);
        }
        catch (EOFException eofe) {
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            throw new AnchorTextException.RebuildFIFOLoadException("I/O", (Throwable)ioe);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Exception e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
            if (readFile != null && !readFile.delete()) {
                throw new AnchorTextException.RebuildFIFOLoadException("delete " + readFile);
            }
        }
    }

    private void saveEntries() throws AnchorTextException {
        this.saveEntries(this.writeTable, this.incrementWriteFileIndex());
    }

    private void saveEntries(LinkedHashSet<String> coll, int fileIndex) throws AnchorTextException {
        File writeFile = this.fileForIndex(fileIndex);
        File writeDirectory = writeFile.getParentFile();
        if (!writeDirectory.exists() && !writeDirectory.mkdirs()) {
            throw new AnchorTextException.RebuildFIFOSaveException("create dir " + writeDirectory);
        }
        Iterator iter = coll.iterator();
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(writeFile);
            oos = new ObjectOutputStream(fos);
            while (iter.hasNext()) {
                oos.writeObject(iter.next());
            }
        }
        catch (IOException ioe) {
            throw new AnchorTextException.RebuildFIFOSaveException("write " + writeFile, (Throwable)ioe);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException ioe) {
                    throw new AnchorTextException.RebuildFIFOSaveException("close(1) " + writeFile, (Throwable)ioe);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    throw new AnchorTextException.RebuildFIFOSaveException("close(2) " + writeFile, (Throwable)ioe);
                }
            }
        }
    }

    private void initializeBackingStore() throws AnchorTextException {
        if (!this.backingDirectory.exists()) {
            if (!this.backingDirectory.mkdirs()) {
                throw new AnchorTextException.RebuildFIFOSaveException("create dir " + this.backingDirectory);
            }
        } else if (!this.backingDirectory.canWrite() || !this.backingDirectory.isDirectory()) {
            throw new AnchorTextException.RebuildFIFOSaveException("write in dir " + this.backingDirectory);
        }
        this.syncMetadata(SyncOperation.Init);
    }

    private void syncMetadata(SyncOperation operation) throws AnchorTextException {
        File mdFile = new File(this.backingDirectory, METADATA_FILENAME);
        if (operation == SyncOperation.Init) {
            if (mdFile.exists()) {
                this.loadMetadata(mdFile);
            } else {
                this.saveMetadata(mdFile);
            }
        } else {
            this.saveMetadata(mdFile);
        }
    }

    private void loadMetadata(File mdFile) throws AnchorTextException {
        FileReader fr = null;
        try {
            fr = new FileReader(mdFile);
            char[] cbuf = new char[256];
            fr.read(cbuf);
            String s = new String(cbuf);
            String[] sa = s.split("[ \t,]+");
            if (sa == null || sa.length != 4) {
                throw new AnchorTextException.RebuildFIFOLoadException("md count: " + mdFile);
            }
            for (int j = 0; j < sa.length; ++j) {
                sa[j] = sa[j].trim();
            }
            this.readFileIndex = Integer.parseInt(sa[1]);
            this.writeFileIndex = Integer.parseInt(sa[2]);
            this.numberOfEntriesAdded = Long.parseLong(sa[3]);
        }
        catch (NumberFormatException nfe) {
            throw new AnchorTextException.RebuildFIFOLoadException("md values: " + mdFile, (Throwable)nfe);
        }
        catch (IOException ioe) {
            throw new AnchorTextException.RebuildFIFOLoadException("md access: " + mdFile, (Throwable)ioe);
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Exception ioe) {
                    throw new AnchorTextException.RebuildFIFOLoadException("md close: " + mdFile, (Throwable)ioe);
                }
            }
        }
    }

    private void saveMetadata(File mdFile) throws AnchorTextException {
        FileWriter fw = null;
        try {
            fw = new FileWriter(mdFile);
            StringBuffer sb = new StringBuffer();
            sb.append(Integer.toString(this.batchSize)).append(" ");
            sb.append(Integer.toString(this.readFileIndex)).append(" ");
            sb.append(Integer.toString(this.writeFileIndex)).append(" ");
            sb.append(Long.toString(this.numberOfEntriesAdded - this.numberOfEntriesRemoved)).append("\n");
            fw.write(sb.toString());
        }
        catch (IOException ioe) {
            throw new AnchorTextException.RebuildFIFOSaveException("write md: " + mdFile, (Throwable)ioe);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception ioe) {
                    throw new AnchorTextException.RebuildFIFOSaveException("close md: " + mdFile, (Throwable)ioe);
                }
            }
        }
    }

    private void dump(String label) {
        StringBuffer sb = new StringBuffer(label);
        sb.append(": ").append(Integer.toString(this.batchSize)).append(", ").append(Integer.toString(this.readFileIndex)).append(", ").append(Integer.toString(this.writeFileIndex)).append(", ").append(Long.toString(this.numberOfEntriesAdded)).append(", ").append(Long.toString(this.numberOfEntriesRemoved)).append(", ").append(Integer.toString(this.readList.size())).append(", ").append(Integer.toString(this.writeTable.size())).append(", ");
        System.err.println(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyFile(String name, int expCount) {
        File readFile = new File(this.backingDirectory, name);
        if (!readFile.exists()) {
            System.err.println("no file " + name);
            return;
        }
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        int count = 0;
        try {
            String readObj;
            fis = new FileInputStream(readFile);
            ois = new ObjectInputStream(fis);
            while ((readObj = (String)ois.readObject()) != null) {
                ++count;
            }
        }
        catch (EOFException eofe) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Exception e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
            if (count != expCount) {
                System.err.println("wrong count: " + count + " not " + expCount + " from " + name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String testDirectory = "C:\\tmp\\foobar";
        AnchorTextRebuildFIFO fbs = null;
        String url = null;
        try {
            FileWriter fw;
            int j;
            FileUtils.removeDirectory(new File("C:\\tmp\\foobar"));
            fbs = new AnchorTextRebuildFIFO(new File("C:\\tmp\\foobar"), 10);
            fbs.dump("100");
            if (fbs.size() != 0L) {
                System.err.println("Wrong size 100");
            }
            if (fbs.get() != null) {
                System.err.println("Wrong get 101");
            }
            if (fbs.size() != 0L) {
                System.err.println("Wrong size 102");
            }
            fbs.dump("103");
            fbs.put("http://w3.ibm.com/dir0/dir1/test103.html");
            fbs.dump("200");
            if (fbs.size() != 1L) {
                System.err.println("Wrong size 200");
            }
            if ((url = fbs.get()) == null || !url.equals("http://w3.ibm.com/dir0/dir1/test103.html")) {
                System.err.println("Wrong get 201");
            }
            if (fbs.size() != 0L) {
                System.err.println("Wrong size 202");
            }
            if (fbs.get() != null) {
                System.err.println("Wrong get 203");
            }
            if (fbs.size() != 0L) {
                System.err.println("Wrong size 204");
            }
            for (j = 0; j < 1321; ++j) {
                fbs.put("http://w3.ibm.com/dir0/dir1/" + j + ".html");
            }
            if (fbs.size() != 1321L) {
                System.err.println("wrong size 300");
            }
            for (j = 0; j < 463; ++j) {
                fbs.get();
            }
            if (fbs.size() != 858L) {
                System.err.println("wrong size 301");
            }
            fbs.close();
            fbs = new AnchorTextRebuildFIFO(new File("C:\\tmp\\foobar"), 10);
            if (fbs.size() != 858L) {
                System.err.println("Wrong size 400");
            }
            for (j = 0; j < 13; ++j) {
                fbs.get();
            }
            if (fbs.size() != 845L) {
                System.err.println("wrong size 401");
            }
            fbs.close();
            fbs = new AnchorTextRebuildFIFO(new File("C:\\tmp\\foobar"), 10);
            if (fbs.size() != 845L) {
                System.err.println("wrong size 500");
            }
            for (j = 0; j < 152; ++j) {
                fbs.get();
            }
            if (fbs.size() != 693L) {
                System.err.println("wrong size 501");
            }
            fbs.close();
            fbs = new AnchorTextRebuildFIFO(new File("C:\\tmp\\foobar"), 10);
            if (fbs.readList.size() != 0) {
                System.err.println("wrong size 600: " + fbs.readList.size() + " instead of 0");
            }
            if (fbs.writeTable.size() != 0) {
                System.err.println("wrong size 601: " + fbs.writeTable.size() + " instead of 0");
            }
            if (fbs.size() != 693L) {
                System.err.println("wrong size 602: " + fbs.size() + " instead of 693");
            }
            fbs.dump("690");
            fbs.verifyFile("0/0/62", 2);
            fbs.verifyFile("0/0/63", 10);
            fbs.verifyFile("0/0/64", 10);
            fbs.verifyFile("0/0/132", 1);
            int counter = 0;
            while (true) {
                if (fbs.get() == null) break;
                if (++counter % 100 != 0) continue;
                fbs.dump("690+" + counter);
            }
            fbs.dump("null");
            if (fbs.size() != 0L) {
                System.err.println("wrong size 700: " + fbs.size());
                fbs.dump("700");
            }
            fbs.get();
            if (counter != 693) {
                System.err.println("wrong count 701: " + counter + " instead of 693");
            }
            fbs.close();
            if (fbs.size() != 0L) {
                System.err.println("wrong size 702: " + fbs.size() + " instead of zero");
            }
            FileUtils.removeDirectory(new File("C:\\tmp\\foobar"));
            final AnchorTextRebuildFIFO fbsf = fbs = new AnchorTextRebuildFIFO(new File("C:\\tmp\\foobar"), 10);
            final FileWriter fwf = fw = new FileWriter("C:\\tmp\\foobar\\test.log");
            Thread t1 = null;
            Thread t2 = null;
            t1 = new Thread(){

                public void run() {
                    try {
                        for (int j = 0; j < 1321; ++j) {
                            fbsf.put("http://w3.ibm.com/dir0/dir1/" + j + ".html");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            t1.start();
            t2 = new Thread(){

                public void run() {
                    try {
                        String s = null;
                        for (int j = 0; j < 999; ++j) {
                            s = fbsf.get();
                            while (s == null) {
                                Thread.sleep(50L);
                                s = fbsf.get();
                            }
                            fwf.write("At " + fbsf.size() + " " + s + "\n");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            t2.start();
            t1.join();
            t2.join();
            fw.close();
            fbs.close();
            fbs = new AnchorTextRebuildFIFO(new File("C:\\tmp\\foobar"), 10);
            System.err.println("Size of store on reopen: " + fbs.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fbs != null) {
                try {
                    fbs.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SyncOperation {
        Init,
        Save;

    }
}

