/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.anchortext;

import com.ibm.es.nuvo.anchortext.AnchorTextConfiguration;
import com.ibm.es.nuvo.anchortext.AnchorTextDatabaseStore;
import com.ibm.es.nuvo.anchortext.AnchorTextException;
import com.ibm.es.nuvo.anchortext.AnchorTextIndexStore;
import com.ibm.es.nuvo.anchortext.AnchorTextMessage;
import com.ibm.es.nuvo.anchortext.AnchorTextStore;
import com.ibm.es.nuvo.anchortext.AnchorTextStore2;
import com.ibm.es.nuvo.anchortext.ReferrerAnchorText;
import com.ibm.es.nuvo.anchortext.ReferrerIterator;
import com.ibm.es.nuvo.anchortext.TargetAnchorText;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.configuration.IndexDescriptorProperties;
import com.ibm.es.nuvo.tokenizer.IndexableDocument;
import com.ibm.es.nuvo.tokenizer.PostTokenizeAnalyzer;
import com.ibm.es.nuvo.tokenizer.TokenizerException;
import com.ibm.es.nuvo.util.TimeUtils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;

public class AnchorTextIndexer
implements AnchorTextStore {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static boolean asynchronousProcessingEnabled = true;
    private int asyncCumulativeCount;
    private final String collectionID;
    private AnchorTextConfiguration anchorTextConfiguration = new AnchorTextConfiguration();
    private Object putDeleteMutex = new Object();
    private AnchorTextStore2 store;
    private boolean shutdownCalled;
    private PostTokenizeAnalyzer analyzer;
    private static final int ASYNC_BATCH_SIZE = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteURL(String urlToDelete) throws AnchorTextException {
        urlToDelete = AnchorTextException.checkString("URL to delete", urlToDelete);
        Object object = this.putDeleteMutex;
        synchronized (object) {
            try {
                this.store.deleteReferencesToURL(urlToDelete);
            }
            catch (AnchorTextException ate) {
                throw new AnchorTextException.DeleteInCollectionException(ate, urlToDelete, this.collectionID);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doAsyncProcessing(IndexWriter writer, long maxTime, TimeUnit maxTimeUnit) {
        if (writer == null) {
            return;
        }
        if (!AnchorTextIndexer.asynchronousProcessingEnabled) {
            return;
        }
        timeoutTime = TimeUtils.timeoutTime(maxTime, maxTimeUnit);
        reader = null;
        outer /* !! */  = null;
        this.asyncCumulativeCount = 0;
        try {
            this.sync();
            reader = IndexReader.open((Directory)writer.getDirectory());
            do {
                if (!this.shutdownCalled) continue;
                var11_7 = null;
                if (this.asyncCumulativeCount <= 0) ** GOTO lbl87
                ** GOTO lbl86
            } while (this.doAsyncBatch(writer, reader) && System.currentTimeMillis() < timeoutTime);
            ** GOTO lbl102
        }
        catch (IOException e) {
            outer /* !! */  = e;
            var11_9 = null;
            if (this.asyncCumulativeCount > 0) {
                new AnchorTextMessage.BatchDoneMessage(this.asyncCumulativeCount, this.collectionID).log();
            }
            try {
                this.sync();
            }
            catch (AnchorTextException e /* !! */ ) {
                new AnchorTextException.AsyncProcessingException(e /* !! */ , this.collectionID).log();
            }
            if (outer /* !! */  != null) {
                new AnchorTextException.AsyncProcessingException(outer /* !! */ , this.collectionID).log();
            }
            if (reader == null) return;
            try {
                reader.close();
                return;
            }
            catch (Exception e /* !! */ ) {
                new AnchorTextException.AsyncProcessingException(e /* !! */ , this.collectionID).log();
                return;
            }
        }
        catch (AnchorTextException e) {
            block32: {
                outer /* !! */  = e;
                var11_10 = null;
                if (this.asyncCumulativeCount > 0) {
                    new AnchorTextMessage.BatchDoneMessage(this.asyncCumulativeCount, this.collectionID).log();
                }
                ** try [egrp 2[TRYBLOCK] [11 : 152->159)] { 
lbl49:
                // 1 sources

                this.sync();
                break block32;
lbl51:
                // 1 sources

                catch (AnchorTextException e /* !! */ ) {
                    new AnchorTextException.AsyncProcessingException(e /* !! */ , this.collectionID).log();
                }
            }
            if (outer /* !! */  != null) {
                new AnchorTextException.AsyncProcessingException(outer /* !! */ , this.collectionID).log();
            }
            if (reader == null) return;
            try {}
            catch (Exception e /* !! */ ) {
                new AnchorTextException.AsyncProcessingException(e /* !! */ , this.collectionID).log();
                return;
            }
            reader.close();
            return;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        {
            block35: {
                block34: {
                    catch (Throwable var10_20) {
                        block33: {
                            var11_11 = null;
                            if (this.asyncCumulativeCount > 0) {
                                new AnchorTextMessage.BatchDoneMessage(this.asyncCumulativeCount, this.collectionID).log();
                            }
                            ** try [egrp 2[TRYBLOCK] [11 : 152->159)] { 
lbl72:
                            // 1 sources

                            this.sync();
                            break block33;
lbl74:
                            // 1 sources

                            catch (AnchorTextException e /* !! */ ) {
                                new AnchorTextException.AsyncProcessingException(e /* !! */ , this.collectionID).log();
                            }
                        }
                        if (outer /* !! */  != null) {
                            new AnchorTextException.AsyncProcessingException(outer /* !! */ , this.collectionID).log();
                        }
                        if (reader == null) throw var10_20;
                        ** try [egrp 3[TRYBLOCK] [12 : 203->211)] { 
lbl81:
                        // 1 sources

                        reader.close();
                        throw var10_20;
lbl83:
                        // 1 sources

                        catch (Exception e /* !! */ ) {
                            new AnchorTextException.AsyncProcessingException(e /* !! */ , this.collectionID).log();
                        }
                        throw var10_20;
                    }
lbl86:
                    // 1 sources

                    new AnchorTextMessage.BatchDoneMessage(this.asyncCumulativeCount, this.collectionID).log();
lbl87:
                    // 2 sources

                    ** try [egrp 2[TRYBLOCK] [11 : 152->159)] { 
lbl88:
                    // 1 sources

                    this.sync();
                    break block34;
lbl90:
                    // 1 sources

                    catch (AnchorTextException e /* !! */ ) {
                        new AnchorTextException.AsyncProcessingException(e /* !! */ , this.collectionID).log();
                    }
                }
                if (outer /* !! */  != null) {
                    new AnchorTextException.AsyncProcessingException(outer /* !! */ , this.collectionID).log();
                }
                if (reader == null) return;
                ** try [egrp 3[TRYBLOCK] [12 : 203->211)] { 
lbl97:
                // 1 sources

                reader.close();
                return;
lbl99:
                // 1 sources

                catch (Exception e /* !! */ ) {
                    new AnchorTextException.AsyncProcessingException(e /* !! */ , this.collectionID).log();
                }
                return;
lbl102:
                // 1 sources

                var11_8 = null;
                if (this.asyncCumulativeCount > 0) {
                    new AnchorTextMessage.BatchDoneMessage(this.asyncCumulativeCount, this.collectionID).log();
                }
                ** try [egrp 2[TRYBLOCK] [11 : 152->159)] { 
lbl106:
                // 1 sources

                this.sync();
                break block35;
lbl108:
                // 1 sources

                catch (AnchorTextException e /* !! */ ) {
                    new AnchorTextException.AsyncProcessingException(e /* !! */ , this.collectionID).log();
                }
            }
            if (outer /* !! */  != null) {
                new AnchorTextException.AsyncProcessingException(outer /* !! */ , this.collectionID).log();
            }
            if (reader == null) return;
            try {}
            catch (Exception e /* !! */ ) {}
            new AnchorTextException.AsyncProcessingException(e /* !! */ , this.collectionID).log();
            return;
            reader.close();
            return;
        }
    }

    public TargetAnchorText getTargetAnchorText(String targetURL) throws AnchorTextException {
        targetURL = AnchorTextException.checkString("ReferrerAnchorText.collectionID", targetURL);
        try {
            return this.store.lookupTarget(targetURL);
        }
        catch (AnchorTextException ate) {
            throw new AnchorTextException.TargetLookupException(ate, targetURL, this.collectionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCrawlSpace(String crawlSpaceBeingRemoved) throws AnchorTextException {
        crawlSpaceBeingRemoved = AnchorTextException.checkString("crawl space to delete", crawlSpaceBeingRemoved);
        Object object = this.putDeleteMutex;
        synchronized (object) {
            try {
                this.store.handleCrawlSpaceRemoval(crawlSpaceBeingRemoved);
            }
            catch (AnchorTextException ate) {
                throw new AnchorTextException.DeleteInCollectionException(ate, crawlSpaceBeingRemoved, this.collectionID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateReferrerAnchorText(ReferrerAnchorText rat) throws AnchorTextException {
        ReferrerIterator iter = null;
        Object object = this.putDeleteMutex;
        synchronized (object) {
            try {
                int k;
                this.store.deleteOutlinksForReferrer(rat.getReferringURL());
                iter = this.store.lookupReferrer(rat.getReferringURL());
                iter.setReferringCrawlSpace(rat.getReferringCrawlSpace());
                TargetAnchorText[] tata = rat.extractAnchorText();
                int n = k = tata == null ? 0 : tata.length;
                for (int j = 0; j < k; ++j) {
                    iter.add(tata[j]);
                }
            }
            catch (AnchorTextException ate) {
                throw new AnchorTextException.UpdateReferrerException(ate, rat.getReferringURL(), this.collectionID);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
            finally {
                if (iter != null) {
                    iter.close();
                }
            }
        }
    }

    public void sync() throws AnchorTextException {
        this.store.sync();
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    String[] getTargetsNeedingRebuild(int limit) throws AnchorTextException {
        return this.store.getTargetsNeedingRebuild(limit);
    }

    public void clear() throws AnchorTextException {
        try {
            if (this.store == null) {
                throw new IllegalStateException("no store");
            }
            this.store.clear();
        }
        catch (Exception e) {
            throw new AnchorTextException.OperationException(e, "clear", this.collectionID);
        }
    }

    public void destroy() throws AnchorTextException {
        try {
            if (this.store == null) {
                throw new IllegalStateException("no store");
            }
            this.store.destroy();
        }
        catch (Exception e) {
            throw new AnchorTextException.OperationException(e, "destroy", this.collectionID);
        }
    }

    public File getDirectory() throws AnchorTextException {
        try {
            if (this.store == null) {
                throw new IllegalStateException("no store");
            }
            return this.store.getDirectory();
        }
        catch (Exception e) {
            throw new AnchorTextException.OperationException(e, "getDirectory", this.collectionID);
        }
    }

    public void shutdown() throws AnchorTextException {
        try {
            if (this.store == null) {
                throw new IllegalStateException("no store");
            }
            this.shutdownCalled = true;
            this.store.shutdown();
        }
        catch (Exception e) {
            throw new AnchorTextException.OperationException(e, "shutdown", this.collectionID);
        }
    }

    public AnchorTextIndexer(String collectionID, PostTokenizeAnalyzer analyzer) throws AnchorTextException {
        this.collectionID = collectionID;
        this.analyzer = analyzer;
        try {
            CollectionConfiguration cc = ConfigurationManager.getConfigurationManager().getCollection(this.collectionID);
            IndexDescriptorProperties properties = cc.getIndexDescriptorFor(IndexDescriptor.IndexType.Anchor).getProperties();
            AnchorTextConfiguration atc = new AnchorTextConfiguration();
            atc.setLuceneMaxBufferSizeInMB((String)properties.get("BufferSize"));
            atc.setLuceneMaxFieldLength((String)properties.get("MaxFieldLength"));
            atc.setLuceneMaxNumberOfBufferedDocuments((String)properties.get("MaxBufferedDocs"));
            String maxMergeDocs = "MaxMergeDocs";
            if (maxMergeDocs != null) {
                atc.setLuceneMaxMergeDocs((String)properties.get(maxMergeDocs));
            }
            atc.setMaxNumberOfInLinksPerURL((String)properties.get("MaxNumberOfInLinksPerURL"));
            atc.setMaxNumberOfOutLinksPerURL((String)properties.get("MaxNumberOfOutLinksPerURL"));
            atc.setMaxNumberOfUnflushedWrites((String)properties.get("MaxNumberOfUnflushedWrites"));
            atc.setLuceneMergeFactor((String)properties.get("MergeFactor"));
            atc.setLuceneUseCompoundFile((String)properties.get("UseCompoundFile"));
            atc.setRebuildBufferCapacity((String)properties.get("RebuildBufferCapacity"));
            this.setAnchorTextConfiguration(atc);
            File directory = new File(cc.getIndexPath(IndexDescriptor.IndexType.Anchor));
            this.init(directory, StoreType.Index, ProcessModel.Integrated);
        }
        catch (Exception e) {
            throw new AnchorTextException.InitException(e, this.collectionID);
        }
    }

    public AnchorTextIndexer(String collectionID, String directory) throws AnchorTextException {
        this.collectionID = collectionID;
        try {
            this.init(new File(directory), StoreType.Index, ProcessModel.Integrated);
        }
        catch (Exception e) {
            throw new AnchorTextException.InitException(e, this.collectionID);
        }
    }

    static void disableAsynchronousProcessing() {
        asynchronousProcessingEnabled = false;
    }

    static void enableAsynchronousProcessing() {
        asynchronousProcessingEnabled = true;
    }

    void setAnchorTextConfiguration(AnchorTextConfiguration configuration) {
        this.anchorTextConfiguration = configuration;
        if (this.store != null) {
            this.store.setConfiguration(this.anchorTextConfiguration);
        }
        ReferrerAnchorText.setMaximumNumberOfOutLinksPerURL(this.anchorTextConfiguration.getMaxNumberOfOutLinksPerURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doAsyncBatch(IndexWriter writer, IndexReader reader) throws AnchorTextException {
        String[] urlsToProcess = this.store.getTargetsNeedingRebuild(10);
        for (int j = 0; j < urlsToProcess.length; ++j) {
            Exception inner = null;
            String url = urlsToProcess[j];
            try {
                if (this.shutdownCalled) break;
                this.doAsyncDocument(writer, reader, url);
                continue;
            }
            catch (IOException e) {
                inner = e;
                continue;
            }
            catch (AnchorTextException e) {
                inner = e;
                continue;
            }
            finally {
                if (inner != null) {
                    new AnchorTextException.AsyncDocumentException(inner, url, this.collectionID).log();
                }
            }
        }
        return urlsToProcess.length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAsyncDocument(IndexWriter writer, IndexReader reader, String url) throws AnchorTextException, IOException {
        block16: {
            TermDocs termDocs = null;
            try {
                termDocs = reader.termDocs(new Term("uri", url));
                Document doc = null;
                while (termDocs.next()) {
                    if (reader.isDeleted(termDocs.doc())) continue;
                    doc = reader.document(termDocs.doc());
                    this.restoreNorm("_urldepth", termDocs.doc(), doc, reader);
                    this.restoreNorm("_datedays", termDocs.doc(), doc, reader);
                    break;
                }
                if (doc == null) break block16;
                this.store.setAsync(true);
                TargetAnchorText tat = this.getTargetAnchorText(url);
                IndexableDocument id = null;
                try {
                    id = IndexableDocument.loadFromDocument(doc);
                }
                catch (TokenizerException e) {
                    this.store.setAsync(false);
                    if (termDocs != null) {
                        try {
                            termDocs.close();
                        }
                        catch (Exception e2) {
                            new AnchorTextException.AsyncDocumentException(e2, url, this.collectionID).log();
                        }
                    }
                    return;
                }
                id.setAnchorText(tat);
                float plainTextBoost = Similarity.decodeNorm((byte)reader.norms("_plain")[termDocs.doc()]);
                id.writeDocument(doc, plainTextBoost);
                Field uriField = doc.getField("uri");
                if (uriField == null) {
                    doc.add((Fieldable)new Field("uri", url, Field.Store.YES, Field.Index.UN_TOKENIZED));
                }
                writer.updateDocument(new Term("uri", url), doc, (Analyzer)this.analyzer);
                ++this.asyncCumulativeCount;
            }
            finally {
                this.store.setAsync(false);
                if (termDocs != null) {
                    try {
                        termDocs.close();
                    }
                    catch (Exception e) {
                        new AnchorTextException.AsyncDocumentException(e, url, this.collectionID).log();
                    }
                }
            }
        }
    }

    void restoreNorm(String fieldName, int docId, Document doc, IndexReader reader) throws IOException {
        Field field = doc.getField(fieldName);
        if (field != null) {
            field.setBoost(Similarity.decodeNorm((byte)reader.norms(fieldName)[docId]));
        }
    }

    private void init(File directory, StoreType storeType, ProcessModel model) throws AnchorTextException {
        if (directory == null) {
            throw new AnchorTextException.InvalidArgumentValueException("store directory", (Object)null);
        }
        if (model != ProcessModel.Integrated) {
            throw new AnchorTextException.InvalidArgumentValueException("store model", (Object)model);
        }
        this.store = storeType == StoreType.Database ? new AnchorTextDatabaseStore(directory) : new AnchorTextIndexStore(directory);
        this.store.setConfiguration(this.anchorTextConfiguration);
        this.store.init();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StoreType {
        Index,
        Database;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProcessModel {
        Integrated,
        Standalone;

    }
}

