/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.anchortext;

import com.ibm.es.nuvo.anchortext.AnchorTextConfiguration;
import com.ibm.es.nuvo.anchortext.AnchorTextException;
import com.ibm.es.nuvo.anchortext.AnchorTextRebuildFIFO;
import com.ibm.es.nuvo.anchortext.AnchorTextStore2;
import com.ibm.es.nuvo.anchortext.ReferrerIterator;
import com.ibm.es.nuvo.anchortext.TargetAnchorText;
import com.ibm.es.nuvo.indexer.ExtendedIndexWriter;
import com.ibm.es.nuvo.tokenizer.TokenVector;
import com.ibm.es.nuvo.util.FileUtils;
import com.ibm.es.nuvo.util.stream.DocumentFieldInputStream;
import com.ibm.es.nuvo.util.stream.DocumentFieldOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class AnchorTextIndexStore
implements AnchorTextStore2 {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private boolean async;
    private AnchorTextConfiguration anchorTextConfiguration;
    private FSDirectory directory;
    private boolean exists;
    private IndexReader reader;
    private ExtendedIndexWriter writer;
    private int unflushedWriteCount;
    private int openTermDocsCount;
    private State storeState = State.OFF;
    private Object storeStateLock = new Object();
    private AnchorTextRebuildFIFO rebuildFIFO;
    public static final String REFERRER_FIELD = "referrer";
    public static final String TARGET_FIELD = "target";
    public static final String ANCHORTEXT_FIELD = "at";
    public static final String CRAWLSPACE_FIELD = "cs";

    public AnchorTextIndexStore(File directory) throws AnchorTextException {
        if (directory == null) {
            throw new AnchorTextException.InvalidArgumentValueException("index directory", (Object)null);
        }
        if (!directory.exists() && !directory.mkdirs()) {
            throw new AnchorTextException.NoDirectoryException(directory);
        }
        if (!directory.isDirectory()) {
            throw new AnchorTextException.NotADirectoryException(directory);
        }
        if (!directory.canWrite()) {
            throw new AnchorTextException.NoWritePermissionException(directory);
        }
        try {
            this.exists = IndexReader.indexExists((File)directory);
            this.directory = FSDirectory.getDirectory((File)directory);
        }
        catch (IOException ioe) {
            throw new AnchorTextException.StoreOperationException(ioe, "construct", directory);
        }
    }

    public void init() throws AnchorTextException {
        try {
            if (!this.exists) {
                this.openWriter();
                this.closeWriter();
            }
            this.rebuildFIFO = new AnchorTextRebuildFIFO(this.getDirectory(), this.anchorTextConfiguration.getRebuildBufferCapacity());
        }
        catch (IOException ioe) {
            throw new AnchorTextException.StoreOperationException(ioe, "init", this.getDirectory());
        }
    }

    public void deleteReferencesToURL(String urlToDelete) throws AnchorTextException {
        TermDocs termDocs = null;
        try {
            this.setState(State.UPSERT);
            termDocs = this.reader.termDocs(new Term(REFERRER_FIELD, urlToDelete));
            while (termDocs.next()) {
                if (this.reader.isDeleted(termDocs.doc())) continue;
                String targetURL = this.reader.document(termDocs.doc()).get(TARGET_FIELD);
                this.flagTargetForRebuild(targetURL);
            }
            termDocs.close();
            termDocs = null;
            this.writer.deleteDocuments(new Term(TARGET_FIELD, urlToDelete));
            this.writer.deleteDocuments(new Term(REFERRER_FIELD, urlToDelete));
        }
        catch (IOException ioe) {
            throw new AnchorTextException.DeleteURLException(ioe, urlToDelete);
        }
        finally {
            try {
                if (termDocs != null) {
                    termDocs.close();
                }
            }
            catch (IOException ioe) {
                throw new AnchorTextException.DeleteURLException(ioe, urlToDelete);
            }
        }
    }

    public String[] getTargetsNeedingRebuild(int limit) throws AnchorTextException {
        if (limit < 0) {
            throw new AnchorTextException.InvalidArgumentValueException("limit", (Object)limit);
        }
        LinkedList<String> ll = new LinkedList<String>();
        try {
            String url;
            while (ll.size() < limit && (url = this.rebuildFIFO.get()) != null) {
                ll.add(url);
            }
            return ll.toArray(new String[ll.size()]);
        }
        catch (IllegalStateException e) {
            throw new AnchorTextException.CallAfterShutdownException();
        }
        catch (AnchorTextException e) {
            throw new AnchorTextException.StoreOperationException(e, "get targets", this.getDirectory());
        }
    }

    public void deleteOutlinksForReferrer(String referringURL) throws AnchorTextException {
        referringURL = AnchorTextException.checkString("referring URL", referringURL);
        try {
            this.setState(State.UPSERT);
            this.writer.deleteDocuments(new Term(REFERRER_FIELD, referringURL));
        }
        catch (IOException ioe) {
            throw new AnchorTextException.ReferrerIterationStartException(ioe, referringURL);
        }
    }

    public void handleCrawlSpaceRemoval(String crawlSpaceBeingRemoved) throws AnchorTextException {
        TermDocs termDocs = null;
        try {
            this.setState(State.UPSERT);
            termDocs = this.reader.termDocs(new Term(CRAWLSPACE_FIELD, crawlSpaceBeingRemoved));
            while (termDocs.next()) {
                if (this.reader.isDeleted(termDocs.doc())) continue;
                String targetURL = this.reader.document(termDocs.doc()).get(TARGET_FIELD);
                this.flagTargetForRebuild(targetURL);
            }
            termDocs.close();
            termDocs = null;
            this.writer.deleteDocuments(new Term(CRAWLSPACE_FIELD, crawlSpaceBeingRemoved));
        }
        catch (IOException ioe) {
            throw new AnchorTextException.DeleteCrawlSpaceException(ioe, crawlSpaceBeingRemoved);
        }
        finally {
            try {
                if (termDocs != null) {
                    termDocs.close();
                }
            }
            catch (IOException ioe) {
                throw new AnchorTextException.DeleteCrawlSpaceException(ioe, crawlSpaceBeingRemoved);
            }
        }
    }

    public ReferrerIterator lookupReferrer(String referringURL) throws AnchorTextException {
        referringURL = AnchorTextException.checkString("referring URL", referringURL);
        try {
            this.setState(State.READING);
        }
        catch (IOException ioe) {
            throw new AnchorTextException.ReferrerIterationStartException(ioe, referringURL);
        }
        return new ReferrerIteratorImpl(referringURL);
    }

    public TargetAnchorText lookupTarget(String targetURL) throws AnchorTextException {
        TermDocs termDocs = null;
        try {
            this.setState(State.READING);
            TargetAnchorText tat = new TargetAnchorText(targetURL);
            LinkedList<Integer> ll = new LinkedList<Integer>();
            termDocs = this.reader.termDocs(new Term(TARGET_FIELD, targetURL));
            while (termDocs.next()) {
                if (!this.reader.isDeleted(termDocs.doc())) {
                    ll.add(termDocs.doc());
                }
                if (ll.size() < this.anchorTextConfiguration.getMaxNumberOfInLinksPerURL()) continue;
            }
            while (!ll.isEmpty()) {
                Document d = this.reader.document(((Integer)ll.removeFirst()).intValue());
                tat.appendAnchorText(this.anchorTextFromDocument(d));
            }
            TargetAnchorText targetAnchorText = tat;
            return targetAnchorText;
        }
        catch (IOException ioe) {
            throw new AnchorTextException.StoreTargetLookupException(ioe, targetURL);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                if (termDocs != null) {
                    termDocs.close();
                }
            }
            catch (IOException ioe) {
                throw new AnchorTextException.StoreTargetLookupException(ioe, targetURL);
            }
        }
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean yesno) {
        this.async = yesno;
    }

    public synchronized void clear() throws AnchorTextException {
        try {
            if (this.directory == null) {
                throw new IllegalStateException("no directory");
            }
            File dir = this.directory.getFile();
            this.directory.close();
            this.directory = null;
            this.directory = FSDirectory.getDirectory((File)dir);
        }
        catch (Exception e) {
            throw new AnchorTextException.StoreOperationException(e, "clear", this.directory.getFile());
        }
    }

    public synchronized void destroy() throws AnchorTextException {
        try {
            if (this.directory == null) {
                return;
            }
            File dir = this.directory.getFile();
            this.directory.close();
            this.directory = null;
            FileUtils.removeDirectory(dir);
        }
        catch (Exception e) {
            throw new AnchorTextException.StoreOperationException(e, "destroy", this.directory.getFile());
        }
    }

    public synchronized File getDirectory() {
        return this.directory == null ? null : this.directory.getFile();
    }

    public synchronized void shutdown() throws AnchorTextException {
        try {
            this.setState(State.SHUTDOWN);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sync() throws AnchorTextException {
        try {
            this.setState(State.OFF);
        }
        catch (IOException ioe) {
            throw new AnchorTextException.StoreOperationException(ioe, "sync", this.directory.getFile());
        }
    }

    public void setConfiguration(AnchorTextConfiguration anchorTextConfiguration) {
        this.anchorTextConfiguration = anchorTextConfiguration;
    }

    private TokenVector anchorTextFromDocument(Document doc) throws IOException {
        DocumentFieldInputStream dis = new DocumentFieldInputStream(doc, ANCHORTEXT_FIELD);
        TokenVector tv = new TokenVector();
        tv.deserialize(dis);
        dis.close();
        return tv;
    }

    private void flagTargetForRebuild(String targetURL) throws AnchorTextException {
        try {
            this.rebuildFIFO.put(targetURL);
        }
        catch (IllegalStateException e) {
            throw new AnchorTextException.CallAfterShutdownException();
        }
    }

    private void closeReader() throws IOException {
        if (this.reader != null) {
            if (this.openTermDocsCount > 0) {
                System.err.println("Should not happen: closeReader");
                Thread.dumpStack();
            }
            this.reader.close();
            this.reader = null;
        }
    }

    private IndexReader openReader() throws IOException {
        if (this.reader == null) {
            this.reader = IndexReader.open((Directory)this.directory);
        }
        return this.reader;
    }

    private void addDocument(Document doc) throws IOException {
        this.writer.addDocument(doc);
        ++this.unflushedWriteCount;
    }

    private void closeWriter() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
            this.exists = true;
            this.unflushedWriteCount = 0;
        }
    }

    private ExtendedIndexWriter openWriter() throws IOException {
        if (this.writer == null) {
            this.exists = IndexReader.indexExists((Directory)this.directory);
            this.writer = new ExtendedIndexWriter(this.directory.getFile(), (Analyzer)new SimpleAnalyzer(), !this.exists);
            this.writer.setUseCompoundFile(this.anchorTextConfiguration.getLuceneUseCompoundFile());
            this.writer.setMaxBufferedDocs(this.anchorTextConfiguration.getLuceneMaxNumberOfBufferedDocuments());
            this.writer.setMaxBufferedDeleteTerms(this.anchorTextConfiguration.getLuceneMaxNumberOfBufferedDocuments());
            this.writer.setMergeFactor(this.anchorTextConfiguration.getLuceneMergeFactor());
            this.writer.setMaxBufferSize(this.anchorTextConfiguration.getLuceneMaxBufferSizeInBytes());
            this.writer.setMaxFieldLength(this.anchorTextConfiguration.getLuceneMaxFieldLength());
        }
        return this.writer;
    }

    private void incrementOpenTermDocsCount() {
        ++this.openTermDocsCount;
    }

    private void decrementOpenTermDocsCount() {
        if (this.openTermDocsCount > 0) {
            --this.openTermDocsCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(State newValue) throws IOException, AnchorTextException {
        Object object = this.storeStateLock;
        synchronized (object) {
            if (this.storeState == newValue) {
                return;
            }
            if (this.storeState == State.SHUTDOWN) {
                throw new AnchorTextException.CallAfterShutdownException();
            }
            if (newValue == State.READING) {
                if (this.unflushedWriteCount > this.anchorTextConfiguration.getMaxNumberOfUnflushedWrites()) {
                    this.closeWriter();
                    this.closeReader();
                }
                this.openReader();
            } else if (newValue == State.ADDING) {
                this.openWriter();
            } else if (newValue == State.UPSERT) {
                this.openReader();
                this.openWriter();
            } else if (newValue == State.OFF) {
                this.closeWriter();
                this.closeReader();
            } else if (newValue == State.SHUTDOWN) {
                AnchorTextException.StoreOperationException ate = null;
                File dirFile = this.directory == null ? null : this.directory.getFile();
                try {
                    this.closeWriter();
                }
                catch (Exception e) {
                    ate = new AnchorTextException.StoreOperationException(e, "shutdown1", dirFile);
                }
                try {
                    this.closeReader();
                }
                catch (Exception e) {
                    ate = new AnchorTextException.StoreOperationException(e, "shutdown2", dirFile);
                }
                try {
                    this.rebuildFIFO.close();
                }
                catch (Exception e) {
                    ate = new AnchorTextException.StoreOperationException(e, "shutdown3", dirFile);
                }
                try {
                    if (this.directory != null) {
                        this.directory.close();
                    }
                }
                catch (Exception e) {
                    ate = new AnchorTextException.StoreOperationException(e, "shutdown4", dirFile);
                }
                this.storeState = newValue;
                if (ate != null) {
                    this.storeState = newValue;
                    throw ate;
                }
            }
            this.storeState = newValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReferrerIteratorImpl
    implements ReferrerIterator {
        private String currentTargetURL;
        private String referringCrawlSpace;
        private String referringURL;
        private TermDocs termDocs;
        private boolean hasMore;
        private Document document;
        private int documentNumber;
        private LinkedList<DocWrapper> addList;

        public ReferrerIteratorImpl(String referringURL) throws AnchorTextException {
            try {
                AnchorTextIndexStore.this.incrementOpenTermDocsCount();
                this.referringURL = referringURL;
                this.termDocs = AnchorTextIndexStore.this.reader.termDocs(new Term(AnchorTextIndexStore.REFERRER_FIELD, referringURL));
                this.advance();
            }
            catch (Exception ioe) {
                this.errorClose();
                throw new AnchorTextException.ReferrerIterationStartException(ioe, referringURL);
            }
        }

        @Override
        public void add(TargetAnchorText tat) throws AnchorTextException {
            try {
                Document doc = new Document();
                doc.add((Fieldable)new Field(AnchorTextIndexStore.REFERRER_FIELD, this.referringURL, Field.Store.NO, Field.Index.UN_TOKENIZED));
                doc.add((Fieldable)new Field(AnchorTextIndexStore.TARGET_FIELD, tat.getTargetURL(), Field.Store.YES, Field.Index.UN_TOKENIZED));
                if (this.referringCrawlSpace != null) {
                    doc.add((Fieldable)new Field(AnchorTextIndexStore.CRAWLSPACE_FIELD, this.referringCrawlSpace, Field.Store.NO, Field.Index.UN_TOKENIZED));
                }
                DocumentFieldOutputStream out = new DocumentFieldOutputStream(doc, AnchorTextIndexStore.ANCHORTEXT_FIELD);
                tat.getAnchorText().serialize(out);
                ((OutputStream)out).close();
                this.getAddList().add(new DocWrapper(this.referringURL, doc));
                AnchorTextIndexStore.this.flagTargetForRebuild(tat.getTargetURL());
            }
            catch (Exception ioe) {
                this.errorClose();
                throw new AnchorTextException.StoreInsertException(ioe, this.referringURL, tat.getTargetURL());
            }
        }

        private void advance() throws IOException {
            this.hasMore = false;
            if (this.termDocs != null) {
                while (this.termDocs.next()) {
                    this.documentNumber = this.termDocs.doc();
                    if (AnchorTextIndexStore.this.reader.isDeleted(this.documentNumber)) continue;
                    this.hasMore = true;
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void errorClose() {
            AnchorTextIndexStore.this.decrementOpenTermDocsCount();
            this.addList = null;
            if (this.termDocs != null) {
                try {
                    this.termDocs.close();
                }
                catch (Exception ioe) {
                    System.err.println("Should not happen: errorClose");
                    ioe.printStackTrace();
                }
                finally {
                    this.termDocs = null;
                }
            }
        }

        @Override
        public void close() throws AnchorTextException {
            LinkedList<DocWrapper> ll = this.addList;
            this.addList = null;
            if (this.termDocs != null) {
                try {
                    this.termDocs.close();
                }
                catch (Exception ioe) {
                    throw new AnchorTextException.StoreOperationException(ioe, "close", AnchorTextIndexStore.this.directory.getFile());
                }
                finally {
                    this.termDocs = null;
                    AnchorTextIndexStore.this.decrementOpenTermDocsCount();
                }
            }
            try {
                if (ll != null && ll.size() > 0) {
                    AnchorTextIndexStore.this.setState(State.ADDING);
                }
            }
            catch (Exception ioe) {
                throw new AnchorTextException.StoreOperationException(ioe, "enter add state", AnchorTextIndexStore.this.directory.getFile());
            }
            while (ll != null && ll.size() > 0) {
                DocWrapper wrapper = ll.removeFirst();
                if (wrapper == null) continue;
                try {
                    AnchorTextIndexStore.this.addDocument(wrapper.wrappedDocument);
                }
                catch (Exception ioe) {
                    throw new AnchorTextException.StoreInsertException(ioe, wrapper.wrappedReferrer, wrapper.wrappedDocument.get(AnchorTextIndexStore.TARGET_FIELD));
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasMore;
        }

        @Override
        public TargetAnchorText next() {
            this.currentTargetURL = null;
            if (!this.hasMore) {
                throw new NoSuchElementException();
            }
            try {
                this.document = AnchorTextIndexStore.this.reader.document(this.documentNumber);
                this.advance();
                this.currentTargetURL = this.document.get(AnchorTextIndexStore.TARGET_FIELD);
                return new TargetAnchorText(this.currentTargetURL, AnchorTextIndexStore.this.anchorTextFromDocument(this.document));
            }
            catch (Exception e) {
                this.errorClose();
                throw new RuntimeException("Wrapped exception", new AnchorTextException.ReferrerIterationAdvanceException(e, this.referringURL));
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setReferringCrawlSpace(String referringCrawlSpace) {
            this.referringCrawlSpace = referringCrawlSpace;
        }

        @Override
        public void update(TokenVector anchorText) throws AnchorTextException {
            throw new UnsupportedOperationException();
        }

        private LinkedList<DocWrapper> getAddList() {
            if (this.addList == null) {
                this.addList = new LinkedList();
            }
            return this.addList;
        }

        private class DocWrapper {
            Document wrappedDocument;
            String wrappedReferrer;

            public DocWrapper(String referringURL, Document document) {
                this.wrappedReferrer = referringURL;
                this.wrappedDocument = document;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        OFF,
        READING,
        ADDING,
        UPSERT,
        SHUTDOWN;

    }
}

