/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.anchortext;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.util.StringUtils;
import java.io.File;
import java.io.Serializable;
import java.util.logging.Level;

public class AnchorTextException
extends ExtendedException
implements Serializable {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long serialVersionUID = 1L;

    public AnchorTextException(String msgKey, Object ... args) {
        super(new Message(msgKey, args));
    }

    public AnchorTextException(String msgKey, Throwable cause, Object ... args) {
        super(new Message(msgKey, args), cause);
    }

    public static String checkString(String name, String value) throws InvalidArgumentValueException {
        String[] tr = new String[1];
        if (StringUtils.noData(value, tr)) {
            throw new InvalidArgumentValueException(name, (Object)value);
        }
        return tr[0];
    }

    public void log() {
        ExtendedLogger logger = Loggers.tracer;
        Level level = AnchorTextException.logLevelFromMessage(this.getNonLocalizedMessage());
        if (logger.isLoggable(level)) {
            logger.log(level, this);
        }
    }

    static Level logLevelFromMessage(Message message) {
        int ix;
        if (message != null && message.getKey() != null && (ix = message.getKey().indexOf(46)) > 0) {
            switch (message.getKey().charAt(ix - 1)) {
                case 'E': {
                    return Level.SEVERE;
                }
                case 'W': {
                    return Level.WARNING;
                }
                case 'I': {
                    return Level.INFO;
                }
                case 'F': {
                    return Level.FINE;
                }
                case 'R': {
                    return Level.FINER;
                }
                case 'T': {
                    return Level.FINEST;
                }
            }
        }
        return Level.OFF;
    }

    public static class DeleteCrawlSpaceException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0031W.ATP";
        private static final long serialVersionUID = 1L;

        public DeleteCrawlSpaceException(String deletedCS) {
            super(MESSAGE_CODE, deletedCS);
        }

        public DeleteCrawlSpaceException(Throwable cause, String deletedCS) {
            super(MESSAGE_CODE, cause, deletedCS);
        }
    }

    public static class RebuildFIFOSaveException
    extends AnchorTextException
    implements Serializable {
        private static final String msgPrefix = "Rebuild FIFO save error: ";
        private static final long serialVersionUID = 1L;

        public RebuildFIFOSaveException(String message) {
            super("G0002I.TRACE_MESSAGE", msgPrefix + message);
        }

        public RebuildFIFOSaveException(String message, Throwable cause) {
            super("G0002I.TRACE_MESSAGE", cause, msgPrefix + message);
        }
    }

    public static class RebuildFIFOLoadException
    extends AnchorTextException
    implements Serializable {
        private static final String msgPrefix = "Rebuild FIFO load error: ";
        private static final long serialVersionUID = 1L;

        public RebuildFIFOLoadException(String message) {
            super("G0002I.TRACE_MESSAGE", msgPrefix + message);
        }

        public RebuildFIFOLoadException(String message, Throwable cause) {
            super("G0002I.TRACE_MESSAGE", cause, msgPrefix + message);
        }
    }

    public static class InconsistentStateException
    extends AnchorTextException
    implements Serializable {
        private static final String msgPrefix = "Inconsistent internal state: ";
        private static final long serialVersionUID = 1L;

        public InconsistentStateException(String message) {
            super("G0002I.TRACE_MESSAGE", msgPrefix + message);
        }

        public InconsistentStateException(String message, Throwable cause) {
            super("G0002I.TRACE_MESSAGE", cause, msgPrefix + message);
        }
    }

    public static class UpdateReferrerException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0010W.ATP";
        private static final long serialVersionUID = 1L;

        public UpdateReferrerException(Throwable cause, String referringURL, String collectionID) {
            super(MESSAGE_CODE, cause, referringURL, collectionID);
        }
    }

    public static class TargetLookupException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0025W.ATP";
        private static final long serialVersionUID = 1L;

        public TargetLookupException(Throwable cause, String targetURL, String collectionID) {
            super(MESSAGE_CODE, cause, targetURL, collectionID);
        }
    }

    public static class StoreUpdateException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0021W.ATP";
        private static final long serialVersionUID = 1L;

        public StoreUpdateException(Throwable cause, String referringURL, String targetURL) {
            super(MESSAGE_CODE, cause, referringURL, targetURL);
        }
    }

    public static class StoreTargetLookupException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0012W.ATP";
        private static final long serialVersionUID = 1L;

        public StoreTargetLookupException(String targetURL) {
            super(MESSAGE_CODE, targetURL);
        }

        public StoreTargetLookupException(Throwable cause, String targetURL) {
            super(MESSAGE_CODE, cause, targetURL);
        }
    }

    public static class StoreOperationException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0009E.ATP";
        private static final long serialVersionUID = 1L;

        public StoreOperationException(String operationName, File directory) {
            super(MESSAGE_CODE, operationName, directory.getAbsolutePath());
        }

        public StoreOperationException(Throwable cause, String operationName, File directory) {
            super(MESSAGE_CODE, cause, operationName, directory.getAbsolutePath());
        }
    }

    public static class StoreInsertException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0011W.ATP";
        private static final long serialVersionUID = 1L;

        public StoreInsertException(Throwable cause, String referringURL, String targetURL) {
            super(MESSAGE_CODE, cause, referringURL, targetURL);
        }
    }

    public static class ReferrerIterationStartException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0022W.ATP";
        private static final long serialVersionUID = 1L;

        public ReferrerIterationStartException(Throwable cause, String referringURL) {
            super(MESSAGE_CODE, cause, referringURL);
        }
    }

    public static class ReferrerIterationDeleteException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0016W.ATP";
        private static final long serialVersionUID = 1L;

        public ReferrerIterationDeleteException(Throwable cause, String referringURL, String targetURL) {
            super(MESSAGE_CODE, cause, targetURL, referringURL);
        }
    }

    public static class ReferrerIterationAdvanceException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0015W.ATP";
        private static final long serialVersionUID = 1L;

        public ReferrerIterationAdvanceException(String referringURL) {
            super(MESSAGE_CODE, referringURL);
        }

        public ReferrerIterationAdvanceException(Throwable cause, String referringURL) {
            super(MESSAGE_CODE, cause, referringURL);
        }
    }

    public static class RecursiveDeleteException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0023W.ATP";
        private static final long serialVersionUID = 1L;

        public RecursiveDeleteException(String pathname) {
            super(MESSAGE_CODE, pathname);
        }

        public RecursiveDeleteException(Throwable cause, String pathname) {
            super(MESSAGE_CODE, cause, pathname);
        }
    }

    public static class OperationException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0013W.ATP";
        private static final long serialVersionUID = 1L;

        public OperationException(String operationName, String collectionID) {
            super(MESSAGE_CODE, operationName, collectionID);
        }

        public OperationException(Throwable cause, String operationName, String collectionID) {
            super(MESSAGE_CODE, cause, operationName, collectionID);
        }
    }

    public static class NoWritePermissionException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0008E.ATP";
        private static final long serialVersionUID = 1L;

        public NoWritePermissionException(File file) {
            super(MESSAGE_CODE, file.getAbsolutePath());
        }
    }

    public static class NotADirectoryException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0007E.ATP";
        private static final long serialVersionUID = 1L;

        public NotADirectoryException(File file) {
            super(MESSAGE_CODE, file.getAbsolutePath());
        }
    }

    public static class NoDirectoryException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0003E.ATP";
        private static final long serialVersionUID = 1L;

        public NoDirectoryException(File file) {
            super(MESSAGE_CODE, file.getAbsolutePath());
        }

        public NoDirectoryException(Throwable cause, File file) {
            super(MESSAGE_CODE, cause, file.getAbsolutePath());
        }
    }

    public static class InvalidStateException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0002E.ATP";
        private static final long serialVersionUID = 1L;

        public InvalidStateException(String command, String collectionID) {
            super(MESSAGE_CODE, command, collectionID);
        }
    }

    public static class InvalidConfigParamException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0030W.ATP";
        private static final long serialVersionUID = 1L;

        public InvalidConfigParamException(Object parameterValue, String parameterName, String fileName) {
            super(MESSAGE_CODE, parameterValue == null ? "null" : parameterValue.toString(), parameterName, fileName);
        }
    }

    public static class InvalidArgumentValueException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "G0009E.ARGUMENT_INVALID_VALUE";
        private static final long serialVersionUID = 1L;

        public InvalidArgumentValueException(String name, Object value) {
            super(MESSAGE_CODE, name, value == null ? "null" : value.toString());
        }
    }

    public static class InitException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0001E.ATP";
        private static final long serialVersionUID = 1L;

        public InitException(String collectionID) {
            super(MESSAGE_CODE, collectionID);
        }

        public InitException(Throwable cause, String collectionID) {
            super(MESSAGE_CODE, cause, collectionID);
        }
    }

    public static class DeleteURLException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0024W.ATP";
        private static final long serialVersionUID = 1L;

        public DeleteURLException(String targetURL) {
            super(MESSAGE_CODE, targetURL);
        }

        public DeleteURLException(Throwable cause, String deletedURL) {
            super(MESSAGE_CODE, cause, deletedURL);
        }
    }

    public static class DeleteInCollectionException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0026W.ATP";
        private static final long serialVersionUID = 1L;

        public DeleteInCollectionException(String targetURL, String collectionID) {
            super(MESSAGE_CODE, targetURL, collectionID);
        }

        public DeleteInCollectionException(Throwable cause, String deletedURL, String collectionID) {
            super(MESSAGE_CODE, cause, deletedURL, collectionID);
        }
    }

    public static class DatabaseLoadDriverException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0017E.ATP";
        private static final long serialVersionUID = 1L;

        public DatabaseLoadDriverException(Throwable cause, String classname) {
            super(MESSAGE_CODE, cause, classname);
        }
    }

    public static class DatabaseInitException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0020E.ATP";
        private static final long serialVersionUID = 1L;

        public DatabaseInitException(Throwable cause, String connectURL) {
            super(MESSAGE_CODE, cause, connectURL);
        }
    }

    public static class DatabaseConstructURLException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0018E.ATP";
        private static final long serialVersionUID = 1L;

        public DatabaseConstructURLException(Throwable cause, String connectURL) {
            super(MESSAGE_CODE, cause, connectURL);
        }
    }

    public static class DatabaseConnectException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0019E.ATP";
        private static final long serialVersionUID = 1L;

        public DatabaseConnectException(Throwable cause, String connectURL) {
            super(MESSAGE_CODE, cause, connectURL);
        }
    }

    public static class CallAfterShutdownException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0032I.ATP";
        private static final long serialVersionUID = 1L;

        public CallAfterShutdownException() {
            super(MESSAGE_CODE, new Object[0]);
        }
    }

    public static class AsyncProcessingException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0028W.ATP";
        private static final long serialVersionUID = 1L;

        public AsyncProcessingException(Throwable cause, String collectionID) {
            super(MESSAGE_CODE, cause, collectionID);
        }
    }

    public static class AsyncDocumentException
    extends AnchorTextException
    implements Serializable {
        public static final String MESSAGE_CODE = "X0027W.ATP";
        private static final long serialVersionUID = 1L;

        public AsyncDocumentException(Throwable cause, String targetURL, String collectionID) {
            super(MESSAGE_CODE, cause, targetURL, collectionID);
        }
    }
}

