/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.anchortext;

import com.ibm.es.nuvo.anchortext.AnchorTextConfiguration;
import com.ibm.es.nuvo.anchortext.AnchorTextException;
import com.ibm.es.nuvo.anchortext.AnchorTextStore2;
import com.ibm.es.nuvo.anchortext.ReferrerIterator;
import com.ibm.es.nuvo.anchortext.TargetAnchorText;
import com.ibm.es.nuvo.anchortext.TokenVectorBinaryStream;
import com.ibm.es.nuvo.tokenizer.TokenVector;
import com.ibm.es.nuvo.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.NoSuchElementException;

public class AnchorTextDatabaseStore
implements AnchorTextStore2 {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private boolean async;
    private AnchorTextConfiguration anchorTextConfiguration;
    private File directory;
    private boolean preexisting;
    private String connectionURL;
    private Connection connection;
    private PreparedStatement insert;
    private PreparedStatement findAT;
    private static final String DRIVER_CLASSNAME = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String PATH_PREFIX = "jdbc:derby:";
    private static final String PATH_DBNAME = "ATIDB";
    private static final String PATH_CREATE = ";create=true";

    public void init() throws AnchorTextException {
    }

    public void deleteOutlinksForReferrer(String url) throws AnchorTextException {
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean yesno) {
        this.async = yesno;
    }

    public AnchorTextConfiguration getConfiguration() {
        return this.anchorTextConfiguration;
    }

    public void setConfiguration(AnchorTextConfiguration anchorTextConfiguration) {
        this.anchorTextConfiguration = anchorTextConfiguration;
    }

    public AnchorTextDatabaseStore(File directory) throws AnchorTextException {
        if (directory == null) {
            throw new AnchorTextException.InvalidArgumentValueException("store directory", (Object)null);
        }
        boolean preexistingDirectory = directory.exists();
        if (!preexistingDirectory && !directory.mkdirs()) {
            throw new AnchorTextException.NoDirectoryException(directory);
        }
        if (!directory.isDirectory()) {
            throw new AnchorTextException.NotADirectoryException(directory);
        }
        if (!directory.canWrite()) {
            throw new AnchorTextException.NoWritePermissionException(directory);
        }
        this.directory = directory;
        try {
            Class.forName(DRIVER_CLASSNAME);
        }
        catch (ClassNotFoundException cnfe) {
            throw new AnchorTextException.DatabaseLoadDriverException(cnfe, DRIVER_CLASSNAME);
        }
        String extendedConnectionURL = null;
        try {
            StringBuffer sb = new StringBuffer(128);
            sb.append(PATH_PREFIX).append(this.directory.getCanonicalPath()).append(File.separatorChar).append(PATH_DBNAME);
            this.connectionURL = sb.toString();
            if (preexistingDirectory) {
                extendedConnectionURL = this.connectionURL;
                this.preexisting = true;
            } else {
                sb.delete(0, sb.length());
                sb.append(this.connectionURL);
                sb.append(PATH_CREATE);
                extendedConnectionURL = sb.toString();
            }
        }
        catch (IOException ioe) {
            throw new AnchorTextException.DatabaseConstructURLException(ioe, extendedConnectionURL);
        }
        try {
            this.connection = DriverManager.getConnection(extendedConnectionURL);
        }
        catch (SQLException sqle) {
            this.connection = null;
            throw new AnchorTextException.DatabaseConnectException(sqle, extendedConnectionURL);
        }
        if (!this.preexisting) {
            try {
                Statement s = this.connection.createStatement();
                s.execute("CREATE TABLE atp (referrer VARCHAR(1024), target VARCHAR(1024), text VARCHAR(27000))");
                s.execute("CREATE INDEX ridx ON atp(referrer)");
                s.execute("CREATE INDEX tidx ON atp(target)");
            }
            catch (SQLException sqle) {
                this.connection = null;
                throw new AnchorTextException.DatabaseInitException(sqle, extendedConnectionURL);
            }
        }
    }

    public void deleteReferencesToURL(String urlToDelete) throws AnchorTextException {
    }

    public String[] getTargetsNeedingRebuild(int limit) throws AnchorTextException {
        return new String[0];
    }

    public void handleCrawlSpaceRemoval(String crawlSpaceBeingRemoved) throws AnchorTextException {
    }

    public ReferrerIterator lookupReferrer(String referringURL) throws AnchorTextException {
        return new ReferrerIteratorImpl(referringURL);
    }

    public TargetAnchorText lookupTarget(String targetURL) throws AnchorTextException {
        ResultSet rs = null;
        try {
            rs = this._findAT(targetURL).executeQuery();
            if (rs.next()) {
                TokenVector tv = new TokenVector();
                tv.deserialize(rs.getBinaryStream(1));
                TargetAnchorText targetAnchorText = new TargetAnchorText(targetURL, tv);
                return targetAnchorText;
            }
            TargetAnchorText tv = null;
            return tv;
        }
        catch (Exception e) {
            throw new AnchorTextException.StoreTargetLookupException(e, targetURL);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException sqle) {}
        }
    }

    public synchronized void clear() throws AnchorTextException {
        try {
            Statement s = this.connection.createStatement();
            s.executeUpdate("DELETE FROM atp");
            s.close();
        }
        catch (SQLException sqle) {
            throw new AnchorTextException.StoreOperationException(sqle, "clear", this.directory);
        }
    }

    public synchronized void destroy() throws AnchorTextException {
        try {
            this.connection.close();
            FileUtils.removeDirectory(this.directory);
            this.connection = null;
        }
        catch (SQLException sqle) {
            throw new AnchorTextException.StoreOperationException(sqle, "destroy", this.directory);
        }
    }

    public File getDirectory() {
        return this.directory;
    }

    public synchronized void shutdown() throws AnchorTextException {
        block2: {
            try {
                DriverManager.getConnection(this.connectionURL + ";shutdown=true");
            }
            catch (SQLException sqle) {
                String msg = sqle.toString();
                if (msg != null && msg.matches(".*atabase '.*' shutdown.*")) break block2;
                throw new AnchorTextException.StoreOperationException(sqle, "shutdown", this.directory);
            }
        }
    }

    public void sync() throws AnchorTextException {
    }

    private PreparedStatement _insert(String referringURL, String targetURL, TokenVector tv) throws SQLException, IOException {
        if (this.insert == null) {
            this.insert = this.connection.prepareStatement("INSERT INTO atp (referrer,target,text) VALUES (?,?,?)");
        }
        this.insert.setString(1, referringURL);
        this.insert.setString(2, targetURL);
        TokenVectorBinaryStream bs = new TokenVectorBinaryStream(tv);
        InputStream is = bs.getInputStream();
        this.insert.setBinaryStream(3, is, bs.size());
        return this.insert;
    }

    private PreparedStatement _findAT(String targetURL) throws SQLException {
        if (this.findAT == null) {
            this.findAT = this.connection.prepareStatement("SELECT text FROM atp WHERE target = ?");
        }
        this.findAT.setString(1, targetURL);
        return this.findAT;
    }

    private class ReferrerIteratorImpl
    implements ReferrerIterator {
        private boolean hasNextFlag;
        private boolean hasNextChecked;
        private String currentTargetURL;
        private ResultSet resultSet;
        private String referringCrawlSpace;
        private String referringURL;
        private PreparedStatement queryByReferrer;
        private PreparedStatement update;

        public ReferrerIteratorImpl(String referringURL) throws AnchorTextException {
            try {
                this.referringURL = referringURL;
                this.resultSet = this._queryByReferrer().executeQuery();
            }
            catch (SQLException sqle) {
                this.resultSet = null;
                throw new AnchorTextException.ReferrerIterationStartException(sqle, referringURL);
            }
        }

        public void add(TargetAnchorText tat) throws AnchorTextException {
            try {
                AnchorTextDatabaseStore.this._insert(this.referringURL, tat.getTargetURL(), tat.getAnchorText());
            }
            catch (Exception e) {
                throw new AnchorTextException.StoreInsertException(e, this.referringURL, tat.getTargetURL());
            }
        }

        public void close() {
            if (this.resultSet != null) {
                try {
                    this.resultSet.close();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                this.resultSet = null;
            }
            if (this.queryByReferrer != null) {
                try {
                    this.queryByReferrer.close();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                this.queryByReferrer = null;
            }
            if (this.update != null) {
                try {
                    this.update.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.update = null;
            }
            this.hasNextChecked = false;
            this.hasNextFlag = false;
        }

        public String getReferringCrawlSpace() {
            return this.referringCrawlSpace;
        }

        public boolean hasNext() {
            if (!this.hasNextChecked) {
                try {
                    this.hasNextFlag = this.resultSet.next();
                }
                catch (Exception e) {
                    this.resultSet = null;
                    throw new RuntimeException("Wrapped exception", new AnchorTextException.ReferrerIterationAdvanceException(e, this.referringURL));
                }
                this.hasNextChecked = true;
            }
            return this.hasNextFlag;
        }

        public TargetAnchorText next() {
            this.currentTargetURL = null;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                this.currentTargetURL = this.resultSet.getString(1);
                TokenVector tv = new TokenVector();
                tv.deserialize(this.resultSet.getBinaryStream(2));
                this.hasNextChecked = false;
                return new TargetAnchorText(this.currentTargetURL, tv);
            }
            catch (Exception e) {
                throw new RuntimeException("Wrapped exception", new AnchorTextException.ReferrerIterationAdvanceException(e, this.referringURL));
            }
        }

        public void remove() {
            if (this.resultSet == null) {
                throw new IllegalStateException("Nothing to remove");
            }
            try {
                this.resultSet.deleteRow();
                this.hasNextChecked = false;
            }
            catch (SQLException sqle) {
                throw new RuntimeException("Wrapped exception", new AnchorTextException.ReferrerIterationDeleteException(sqle, this.referringURL, this.currentTargetURL));
            }
        }

        public void setReferringCrawlSpace(String referringCrawlSpace) {
            this.referringCrawlSpace = referringCrawlSpace;
        }

        public void update(TokenVector anchorText) throws AnchorTextException {
            Statement ps = null;
            try {
                if (this.currentTargetURL == null) {
                    throw new IllegalStateException("nothing to update");
                }
                ps = this._update(this.currentTargetURL, anchorText);
                ps.executeUpdate();
            }
            catch (Exception e) {
                throw new AnchorTextException.StoreUpdateException(e, this.referringURL, this.currentTargetURL);
            }
            finally {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException sqle) {}
            }
        }

        private PreparedStatement _queryByReferrer() throws SQLException {
            if (this.queryByReferrer == null) {
                this.queryByReferrer = AnchorTextDatabaseStore.this.connection.prepareStatement("SELECT target,text FROM atp WHERE referrer = ?");
            }
            this.queryByReferrer.setString(1, this.referringURL);
            return this.queryByReferrer;
        }

        private PreparedStatement _update(String targetURL, TokenVector tv) throws SQLException, IOException {
            if (this.update == null) {
                this.update = AnchorTextDatabaseStore.this.connection.prepareStatement("UPDATE atp SET text = ? WHERE referrer = ? AND target = ?");
            }
            TokenVectorBinaryStream bs = new TokenVectorBinaryStream(tv);
            InputStream is = bs.getInputStream();
            this.update.setBinaryStream(1, is, bs.size());
            this.update.setString(2, this.referringURL);
            this.update.setString(3, targetURL);
            return this.update;
        }
    }
}

