/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.anchortext;

import com.ibm.es.nuvo.anchortext.AnchorTextException;

public class AnchorTextConfiguration {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private int luceneMaxBufferSizeInBytes = 0xA00000;
    private int luceneMaxFieldLength = 10000;
    private int luceneMaxNumberOfBufferedDocuments = 1000;
    private int luceneMaxMergeDocs = Integer.MAX_VALUE;
    private int luceneMergeFactor = 17;
    private boolean luceneUseCompoundFile = true;
    private int maxNumberOfInLinksPerURL = 50;
    private int maxNumberOfOutLinksPerURL = 50;
    private int maxNumberOfUnflushedWrites = 50;
    private int rebuildBufferCapacity = 1000;

    public int getLuceneMaxBufferSizeInBytes() {
        return this.luceneMaxBufferSizeInBytes;
    }

    public int getLuceneMaxFieldLength() {
        return this.luceneMaxFieldLength;
    }

    public int getLuceneMaxNumberOfBufferedDocuments() {
        return this.luceneMaxNumberOfBufferedDocuments;
    }

    public int getLuceneMergeFactor() {
        return this.luceneMergeFactor;
    }

    public boolean getLuceneUseCompoundFile() {
        return this.luceneUseCompoundFile;
    }

    public int getMaxNumberOfInLinksPerURL() {
        return this.maxNumberOfInLinksPerURL;
    }

    public int getMaxNumberOfOutLinksPerURL() {
        return this.maxNumberOfOutLinksPerURL;
    }

    public int getMaxNumberOfUnflushedWrites() {
        return this.maxNumberOfUnflushedWrites;
    }

    public int getRebuildBufferCapacity() {
        return this.rebuildBufferCapacity;
    }

    public boolean setLuceneMaxBufferSizeInMB(int luceneMaxBufferSizeInMB) {
        if (luceneMaxBufferSizeInMB < 1) {
            new AnchorTextException.InvalidArgumentValueException("BufferSize", (Object)luceneMaxBufferSizeInMB).log();
            return false;
        }
        int newSizeInBytes = luceneMaxBufferSizeInMB * 1024 * 1024;
        if (this.luceneMaxBufferSizeInBytes != newSizeInBytes) {
            this.luceneMaxBufferSizeInBytes = newSizeInBytes;
            return true;
        }
        return false;
    }

    public boolean setLuceneMaxBufferSizeInMB(String luceneMaxBufferSizeInMB) {
        AnchorTextException ate = null;
        try {
            AnchorTextException.checkString("BufferSize", luceneMaxBufferSizeInMB);
            return this.setLuceneMaxBufferSizeInMB(Integer.parseInt(luceneMaxBufferSizeInMB));
        }
        catch (AnchorTextException e) {
            ate = e;
        }
        catch (NumberFormatException nfe) {
            ate = new AnchorTextException.InvalidArgumentValueException("BufferSize", (Object)luceneMaxBufferSizeInMB);
        }
        if (ate != null) {
            ate.log();
        }
        return false;
    }

    public boolean setLuceneMaxFieldLength(int luceneMaxFieldLength) {
        if (luceneMaxFieldLength < 1) {
            new AnchorTextException.InvalidArgumentValueException("BufferSize", (Object)luceneMaxFieldLength).log();
            return false;
        }
        if (this.luceneMaxFieldLength != luceneMaxFieldLength) {
            this.luceneMaxFieldLength = luceneMaxFieldLength;
            return true;
        }
        return false;
    }

    public boolean setLuceneMaxFieldLength(String luceneMaxFieldLength) {
        AnchorTextException ate = null;
        try {
            AnchorTextException.checkString("BufferSize", luceneMaxFieldLength);
            return this.setLuceneMaxFieldLength(Integer.parseInt(luceneMaxFieldLength));
        }
        catch (AnchorTextException e) {
            ate = e;
        }
        catch (NumberFormatException nfe) {
            ate = new AnchorTextException.InvalidArgumentValueException("BufferSize", (Object)luceneMaxFieldLength);
        }
        if (ate != null) {
            ate.log();
        }
        return false;
    }

    public boolean setLuceneMaxNumberOfBufferedDocuments(int luceneMaxNumberOfBufferedDocuments) {
        if (luceneMaxNumberOfBufferedDocuments < 1) {
            new AnchorTextException.InvalidArgumentValueException("MaxBufferedDocs", (Object)luceneMaxNumberOfBufferedDocuments).log();
            return false;
        }
        if (this.luceneMaxNumberOfBufferedDocuments != luceneMaxNumberOfBufferedDocuments) {
            this.luceneMaxNumberOfBufferedDocuments = luceneMaxNumberOfBufferedDocuments;
            return true;
        }
        return false;
    }

    public boolean setLuceneMaxNumberOfBufferedDocuments(String luceneMaxNumberOfBufferedDocuments) {
        AnchorTextException ate = null;
        try {
            AnchorTextException.checkString("MaxBufferedDocs", luceneMaxNumberOfBufferedDocuments);
            return this.setLuceneMaxNumberOfBufferedDocuments(Integer.parseInt(luceneMaxNumberOfBufferedDocuments));
        }
        catch (AnchorTextException e) {
            ate = e;
        }
        catch (NumberFormatException nfe) {
            ate = new AnchorTextException.InvalidArgumentValueException("MaxBufferedDocs", (Object)luceneMaxNumberOfBufferedDocuments);
        }
        if (ate != null) {
            ate.log();
        }
        return false;
    }

    public boolean setLuceneMaxMergeDocs(int luceneMaxMergeDocs) {
        if (luceneMaxMergeDocs < 1) {
            new AnchorTextException.InvalidArgumentValueException("MaxMergeDocs", (Object)luceneMaxMergeDocs).log();
            return false;
        }
        if (this.luceneMaxMergeDocs != luceneMaxMergeDocs) {
            this.luceneMaxMergeDocs = luceneMaxMergeDocs;
            return true;
        }
        return false;
    }

    public boolean setLuceneMaxMergeDocs(String luceneMaxMergeDocs) {
        AnchorTextException ate = null;
        try {
            AnchorTextException.checkString("MaxMergeDocs", luceneMaxMergeDocs);
            int value = luceneMaxMergeDocs.equals("Integer.MAX_VALUE") ? Integer.MAX_VALUE : Integer.parseInt(luceneMaxMergeDocs);
            return this.setLuceneMaxMergeDocs(value);
        }
        catch (AnchorTextException e) {
            ate = e;
        }
        catch (NumberFormatException nfe) {
            ate = new AnchorTextException.InvalidArgumentValueException("MaxMergeDocs", (Object)luceneMaxMergeDocs);
        }
        if (ate != null) {
            ate.log();
        }
        return false;
    }

    public boolean setLuceneMergeFactor(int luceneMergeFactor) {
        if (luceneMergeFactor < 1) {
            new AnchorTextException.InvalidArgumentValueException("MergeFactor", (Object)luceneMergeFactor).log();
            return false;
        }
        if (this.luceneMergeFactor != luceneMergeFactor) {
            this.luceneMergeFactor = luceneMergeFactor;
            return true;
        }
        return false;
    }

    public boolean setLuceneMergeFactor(String luceneMergeFactor) {
        AnchorTextException ate = null;
        try {
            AnchorTextException.checkString("MergeFactor", luceneMergeFactor);
            return this.setLuceneMergeFactor(Integer.parseInt(luceneMergeFactor));
        }
        catch (AnchorTextException e) {
            ate = e;
        }
        catch (NumberFormatException nfe) {
            ate = new AnchorTextException.InvalidArgumentValueException("MergeFactor", (Object)luceneMergeFactor);
        }
        if (ate != null) {
            ate.log();
        }
        return false;
    }

    public boolean setLuceneUseCompoundFile(boolean luceneUseCompoundFile) {
        if (this.luceneUseCompoundFile != luceneUseCompoundFile) {
            this.luceneUseCompoundFile = luceneUseCompoundFile;
            return true;
        }
        return false;
    }

    public boolean setLuceneUseCompoundFile(String luceneUseCompoundFile) {
        AnchorTextException ate = null;
        try {
            AnchorTextException.checkString("UseCompoundFile", luceneUseCompoundFile);
            return this.setLuceneUseCompoundFile(Boolean.parseBoolean(luceneUseCompoundFile));
        }
        catch (AnchorTextException e) {
            ate = e;
        }
        catch (NumberFormatException nfe) {
            ate = new AnchorTextException.InvalidArgumentValueException("UseCompoundFile", (Object)luceneUseCompoundFile);
        }
        if (ate != null) {
            ate.log();
        }
        return false;
    }

    public boolean setMaxNumberOfInLinksPerURL(int maxNumberOfInLinksPerURL) {
        if (maxNumberOfInLinksPerURL < 1) {
            new AnchorTextException.InvalidArgumentValueException("MaxNumberOfInLinksPerURL", (Object)maxNumberOfInLinksPerURL).log();
            return false;
        }
        if (this.maxNumberOfInLinksPerURL != maxNumberOfInLinksPerURL) {
            this.maxNumberOfInLinksPerURL = maxNumberOfInLinksPerURL;
            return true;
        }
        return false;
    }

    public boolean setMaxNumberOfInLinksPerURL(String maxNumberOfInLinksPerURL) {
        AnchorTextException ate = null;
        try {
            AnchorTextException.checkString("MaxNumberOfInLinksPerURL", maxNumberOfInLinksPerURL);
            return this.setMaxNumberOfInLinksPerURL(Integer.parseInt(maxNumberOfInLinksPerURL));
        }
        catch (AnchorTextException e) {
            ate = e;
        }
        catch (NumberFormatException nfe) {
            ate = new AnchorTextException.InvalidArgumentValueException("MaxNumberOfInLinksPerURL", (Object)maxNumberOfInLinksPerURL);
        }
        if (ate != null) {
            ate.log();
        }
        return false;
    }

    public boolean setMaxNumberOfOutLinksPerURL(int maxNumberOfOutLinksPerURL) {
        if (maxNumberOfOutLinksPerURL < 1) {
            new AnchorTextException.InvalidArgumentValueException("MaxNumberOfOutLinksPerURL", (Object)maxNumberOfOutLinksPerURL).log();
        }
        if (this.maxNumberOfOutLinksPerURL != maxNumberOfOutLinksPerURL) {
            this.maxNumberOfOutLinksPerURL = maxNumberOfOutLinksPerURL;
            return true;
        }
        return false;
    }

    public boolean setMaxNumberOfOutLinksPerURL(String maxNumberOfOutLinksPerURL) {
        AnchorTextException ate = null;
        try {
            AnchorTextException.checkString("MaxNumberOfOutLinksPerURL", maxNumberOfOutLinksPerURL);
            return this.setMaxNumberOfOutLinksPerURL(Integer.parseInt(maxNumberOfOutLinksPerURL));
        }
        catch (AnchorTextException e) {
            ate = e;
        }
        catch (NumberFormatException nfe) {
            ate = new AnchorTextException.InvalidArgumentValueException("MaxNumberOfOutLinksPerURL", (Object)maxNumberOfOutLinksPerURL);
        }
        if (ate != null) {
            ate.log();
        }
        return false;
    }

    public boolean setMaxNumberOfUnflushedWrites(int maxNumberOfUnflushedWrites) {
        if (maxNumberOfUnflushedWrites < 1) {
            new AnchorTextException.InvalidArgumentValueException("MaxNumberOfUnflushedWrites", (Object)maxNumberOfUnflushedWrites).log();
            return false;
        }
        if (this.maxNumberOfUnflushedWrites != maxNumberOfUnflushedWrites) {
            this.maxNumberOfUnflushedWrites = maxNumberOfUnflushedWrites;
            return true;
        }
        return false;
    }

    public boolean setMaxNumberOfUnflushedWrites(String maxNumberOfUnflushedWrites) {
        AnchorTextException ate = null;
        try {
            AnchorTextException.checkString("MaxNumberOfUnflushedWrites", maxNumberOfUnflushedWrites);
            return this.setMaxNumberOfUnflushedWrites(Integer.parseInt(maxNumberOfUnflushedWrites));
        }
        catch (AnchorTextException e) {
            ate = e;
        }
        catch (NumberFormatException nfe) {
            ate = new AnchorTextException.InvalidArgumentValueException("MaxNumberOfUnflushedWrites", (Object)maxNumberOfUnflushedWrites);
        }
        if (ate != null) {
            ate.log();
        }
        return false;
    }

    public boolean setRebuildBufferCapacity(int rebuildBufferCapacity) {
        if (rebuildBufferCapacity < 1) {
            new AnchorTextException.InvalidArgumentValueException("RebuildBufferCapacity", (Object)rebuildBufferCapacity).log();
            return false;
        }
        if (this.rebuildBufferCapacity != rebuildBufferCapacity) {
            this.rebuildBufferCapacity = rebuildBufferCapacity;
            return true;
        }
        return false;
    }

    public boolean setRebuildBufferCapacity(String rebuildBufferCapacity) {
        AnchorTextException ate = null;
        try {
            AnchorTextException.checkString("RebuildBufferCapacity", rebuildBufferCapacity);
            return this.setRebuildBufferCapacity(Integer.parseInt(rebuildBufferCapacity));
        }
        catch (AnchorTextException e) {
            ate = e;
        }
        catch (NumberFormatException nfe) {
            ate = new AnchorTextException.InvalidArgumentValueException("RebuildBufferCapacity", (Object)rebuildBufferCapacity);
        }
        if (ate != null) {
            ate.log();
        }
        return false;
    }
}

