/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.httplistener.HttpListenerManager;
import com.ibm.es.nuvo.httplistener.HttpListenerServer;
import com.ibm.es.nuvo.logging.Loggers;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Startup {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String DefaultWebSite = "http://www.cnn.com";
    private static FileChannel globalConfigChannel = null;
    public static String globalConfigFileLockExtension = ".lock";
    private static FileLock globalConfigFileLock = null;

    public static void main(String[] args) {
        String globalConfigPath = null;
        globalConfigPath = args.length == 0 ? "config/config.xml" : args[0];
        Vector<String> argVector = new Vector<String>();
        for (int i = 0; i < args.length; ++i) {
            argVector.add(args[i]);
        }
        Vector<String> fileCrawlCollectionIds = new Vector<String>();
        Vector<String> fileCrawlPaths = new Vector<String>();
        Vector<String> webCrawlCollectionIds = new Vector<String>();
        Vector<String> webCrawlPaths = new Vector<String>();
        boolean traceOn = Startup.doesArgExist("-trace", argVector, true);
        boolean disableCrawling = Startup.doesArgExist("-noCrawl", argVector, true);
        boolean sendStatus = Startup.doesArgExist("-status", argVector, true);
        if (Startup.doesArgExist("-?", argVector, true) || Startup.doesArgExist("?", argVector, true)) {
            Startup.printUsage();
            return;
        }
        try {
            File f = new File(globalConfigPath);
            if (!f.exists()) {
                Message msg = new Message("G0045E.GLOBAL_CONFIG_FILE_MISSING", f.getAbsolutePath());
                System.err.println(msg.getFormattedTextWithDisplayKey());
                Startup.printUsage();
                return;
            }
            globalConfigPath = f.getAbsolutePath();
            File globalConfigLockFile = new File(globalConfigPath + globalConfigFileLockExtension);
            globalConfigChannel = new RandomAccessFile(globalConfigLockFile, "rw").getChannel();
            try {
                globalConfigFileLock = globalConfigChannel.tryLock();
                if (globalConfigFileLock == null) {
                    Message msg = new Message("G0120E.CONFIG_DIR_ALREADY_USED_BY_RUNNING_SERVER", globalConfigPath);
                    System.err.println(msg.getFormattedTextWithDisplayKey());
                    msg = new Message("G0044E.WHITNEY_STARTUP_FAILED");
                    System.err.println(msg.getFormattedTextWithDisplayKey());
                    return;
                }
                globalConfigLockFile.deleteOnExit();
            }
            catch (OverlappingFileLockException e) {
                Message msg = new Message("G0120E.CONFIG_DIR_ALREADY_USED_BY_RUNNING_SERVER", globalConfigPath);
                System.err.println(msg.getFormattedTextWithDisplayKey());
                msg = new Message("G0044E.WHITNEY_STARTUP_FAILED");
                System.err.println(msg.getFormattedTextWithDisplayKey());
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (argVector.size() > 2) {
            int webCrawlIndex = Startup.getArgIndex("-webCrawl", argVector);
            if (webCrawlIndex >= 0) {
                if (webCrawlIndex == argVector.size() - 1) {
                    Message msg = new Message("G0110E.WEB_CRAWL_PARM_MISSING_OPTIONS");
                    System.err.println(msg.getFormattedTextWithDisplayKey());
                    Startup.printUsage();
                    return;
                }
                if (webCrawlIndex == argVector.size() - 2) {
                    argVector.add(DefaultWebSite);
                } else {
                    int numCrawlParms = argVector.size() - webCrawlIndex - 1;
                    if (numCrawlParms % 2 != 0) {
                        Message msg = new Message("G0110E.WEB_CRAWL_PARM_MISSING_OPTIONS");
                        System.err.println(msg.getFormattedTextWithDisplayKey());
                        Startup.printUsage();
                        return;
                    }
                }
                Startup.parsePairList(argVector, webCrawlIndex, webCrawlCollectionIds, webCrawlPaths);
            } else {
                int fileCrawlIndex = Startup.getArgIndex("-fileCrawl", argVector);
                if (fileCrawlIndex >= 0) {
                    int numCrawlParms = argVector.size() - fileCrawlIndex - 1;
                    if (numCrawlParms % 2 != 0) {
                        Message msg = new Message("G0111E.FILE_CRAWL_PARM_MISSING_OPTIONS");
                        System.err.println(msg.getFormattedTextWithDisplayKey());
                        Startup.printUsage();
                        return;
                    }
                    Startup.parsePairList(argVector, fileCrawlIndex, fileCrawlCollectionIds, fileCrawlPaths);
                }
            }
        }
        GlobalSystem globalSystem = GlobalSystem.getSingleInstance();
        try {
            globalSystem.initialize(globalConfigPath, traceOn, true, sendStatus);
            globalSystem.startDocumentPipeline(webCrawlCollectionIds, webCrawlPaths, disableCrawling, sendStatus, true);
            HttpListenerServer server = HttpListenerManager.getSingleInstanceListenerServer();
            if (server != null) {
                int adminHttp = server.getAdminHttpPort();
                int searchHttp = server.getSearchHttpPort();
                int adminHttps = server.getAdminHttpsPort();
                int searchHttps = server.getSearchHttpsPort();
                Message msg = null;
                msg = adminHttp == searchHttp && adminHttps == searchHttps ? (0 == adminHttp && adminHttps != 0 ? new Message("G0158I.ADMIN_SEARCH_COMBINED_STARTED_HTTPS", adminHttps) : (0 == adminHttps && adminHttp != 0 ? new Message("G0159I.ADMIN_SEARCH_COMBINED_STARTED_HTTP", adminHttp) : new Message("G0157I.ADMIN_SEARCH_COMBINED_STARTED_BOTH", adminHttp, adminHttps))) : (0 == adminHttp && 0 == searchHttp ? new Message("G0161I.ADMIN_SEARCH_DIVIDED_STARTED_HTTPS", adminHttps, searchHttps) : (0 == adminHttps && 0 == searchHttps ? new Message("G0162I.ADMIN_SEARCH_DIVIDED_STARTED_HTTP", adminHttp, searchHttp) : new Message("G0160I.ADMIN_SEARCH_DIVIDED_STARTED_BOTH", adminHttp, adminHttps, searchHttp, searchHttps)));
                if (Loggers.logger.isLoggable(Level.INFO)) {
                    Loggers.logger.log(Level.INFO, msg);
                }
                String formattedText = msg.getFormattedTextWithDisplayKey();
                System.out.println(formattedText);
            }
        }
        catch (Throwable e) {
            Message msg = new Message("G0044E.WHITNEY_STARTUP_FAILED");
            ExtendedException ee2 = null;
            ee2 = e instanceof ExtendedException ? (ExtendedException)e : new ExtendedException(e);
            System.out.println(ee2.getFormattedText(Locale.getDefault(), true));
            System.out.println(msg.getFormattedTextWithDisplayKey());
            if (Loggers.logger != null && Loggers.logger.isLoggable(Level.SEVERE)) {
                Loggers.logger.log(Level.SEVERE, msg.toString(), ee2);
            }
            if (Loggers.getWrappedLogger() != null) {
                Loggers.getWrappedLogger().flush();
                Loggers.getWrappedLogger().close();
            }
            if (Loggers.getWrappedQueryLogger() != null) {
                Loggers.getWrappedQueryLogger().flush();
                Loggers.getWrappedQueryLogger().close();
            }
            if (Loggers.getWrappedTracer() != null) {
                Loggers.getWrappedTracer().flush();
                Loggers.getWrappedTracer().close();
            }
            System.exit(4);
        }
    }

    private static int getArgIndex(String argName, Vector<String> argVector) {
        int foundAt = -1;
        for (int i = 0; i < argVector.size() && foundAt < 0; ++i) {
            if (!argName.equalsIgnoreCase(argVector.get(i))) continue;
            foundAt = i;
        }
        return foundAt;
    }

    private static boolean doesArgExist(String argName, Vector<String> argVector, boolean removeFromList) {
        boolean exist;
        int argIndex = Startup.getArgIndex(argName, argVector);
        boolean bl = exist = argIndex >= 0;
        if (removeFromList && exist) {
            argVector.removeElementAt(argIndex);
        }
        return exist;
    }

    private static void parsePairList(Vector<String> argVector, int startIndex, Vector<String> firstParms, Vector<String> secondParms) {
        int pairs = (argVector.size() - startIndex - 1) / 2;
        int index = startIndex + 1;
        for (int i = 0; i < pairs; ++i) {
            firstParms.addElement(argVector.get(index++));
            secondParms.addElement(argVector.get(index++));
        }
    }

    private static void printUsage() {
        Locale currentLocale = Locale.getDefault();
        String textBase = "G0109I.CMDLINE_HELP";
        String text = Message.getText(textBase, currentLocale);
        System.out.println(text);
    }
}

