/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo;

import com.ibm.es.nuvo.Startup;
import com.ibm.es.nuvo.authentication.AuthenticationData;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.ReleaseInfo;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.configuration.JettyConfiguration;
import com.ibm.es.nuvo.inyo.client.api.InyoSystem;
import com.ibm.es.nuvo.inyo.client.infra.InyoException;
import com.ibm.es.nuvo.launcher.Launcher;
import com.ibm.es.nuvo.launcher.LauncherFrame;
import com.ibm.es.nuvo.util.Encryption;
import com.ibm.es.nuvo.util.https.DisableSSLCertificateCheckUtil;
import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Shutdown {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int RETURN_CODE_SUCCESS = 0;
    private static final int RETURN_CODE_NOT_RUNNING = 0;
    private static final int RETURN_CODE_FAILURE = 1;
    private boolean consoleMode = false;
    private LauncherFrame launcherFrame = null;
    private Launcher launcher = null;
    private GlobalConfiguration config;
    private String globalConfigPath = null;
    private int port = -1;
    private Message productName;

    public static void main(String[] args) {
        Shutdown shutdown = new Shutdown();
        int ret = shutdown.initialize(args);
        if (ret < 0) {
            System.exit(ret);
        }
        try {
            if (shutdown.useCustomServer()) {
                System.exit(shutdown.stopCustomServer(args));
            } else {
                System.exit(shutdown.stopWhitney(args));
            }
        }
        catch (ExtendedException e) {
            shutdown.printMessage(e.getFormattedText(Locale.getDefault(), false));
        }
    }

    private int initialize(String[] args) {
        if (args.length == 0) {
            Shutdown.printUsage();
            return -1;
        }
        if (args.length == 1) {
            this.globalConfigPath = args[0];
        } else if (args.length == 2 && args[0].equals("-p")) {
            this.port = Integer.parseInt(args[1]);
        } else if (args.length == 2 && args[1].equals("-console")) {
            this.globalConfigPath = args[0];
            this.consoleMode = true;
        } else {
            Shutdown.printUsage();
            return -1;
        }
        try {
            GlobalConfiguration.initialize(this.globalConfigPath);
        }
        catch (Exception e) {
            this.printMessage(this.formatStackTrace(e));
            return -1;
        }
        return 0;
    }

    private static void printUsage() {
        System.out.println("usage: Shutdown [global config]");
        System.out.println("                [-p port]");
        System.out.println("  Options : ");
        System.out.println("     [global config]    : Fully qualified path to config.xml file ");
        System.out.println("     [-p port]          : The port which Whitney is running on to shutdown.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int stopWhitney(String[] args) {
        Message message;
        String ipAddress = "localhost";
        String apiContext = "/api";
        String stopURL = "/system?action=requestSystemStop";
        int retcode = 0;
        BufferedReader streamInput = null;
        this.launcher = new Launcher(this.globalConfigPath);
        try {
            ReleaseInfo.initialize(null);
        }
        catch (ExtendedException e) {
            return 1;
        }
        this.productName = new Message(ReleaseInfo.getReleaseInfo().getValue("System", "ProductName"));
        try {
            if (!ReleaseInfo.getReleaseInfo().getValueAsBoolean("System", "ShowStartupUI", true)) {
                this.consoleMode = true;
            }
        }
        catch (ExtendedException e) {
            // empty catch block
        }
        if (!this.consoleMode) {
            try {
                this.launcherFrame = new LauncherFrame();
                this.launcher.setLauncherFrame(this.launcherFrame);
                stopURL = stopURL + "&sendprogress=true";
            }
            catch (HeadlessException noDisplay) {
                this.consoleMode = true;
            }
        }
        String protocol = "http";
        if (this.globalConfigPath != null) {
            try {
                GlobalConfiguration.initialize(this.globalConfigPath);
                this.config = GlobalConfiguration.getConfiguration();
                this.config.validate();
                JettyConfiguration jettyConfig = new JettyConfiguration(this.config);
                ipAddress = jettyConfig.getHostName();
                this.port = jettyConfig.getAdminHttpPort();
                if (0 == this.port) {
                    this.port = jettyConfig.getAdminHttpsPort();
                    if (this.port != 0) {
                        protocol = "https";
                        DisableSSLCertificateCheckUtil.disableChecks();
                    }
                }
                apiContext = jettyConfig.getApiContext();
            }
            catch (Exception e) {
                this.printMessage(this.formatStackTrace(e));
                retcode = 1;
            }
        }
        if (retcode != 0) {
            if (this.launcherFrame != null) {
                this.launcher.dumpLog();
                this.launcherFrame.dispose();
            }
            return retcode;
        }
        try {
            String configPath = this.config.getConfigPath();
            File shutdownFile = new File(configPath, "shutdown.txt");
            shutdownFile.createNewFile();
            shutdownFile.deleteOnExit();
        }
        catch (IOException e1) {
            // empty catch block
        }
        try {
            int respCode;
            message = new Message("G0088I.SHUTDOWN_REQUEST_SENDING", protocol + "://" + ipAddress + ":" + this.port + apiContext + stopURL);
            URL url = new URL(protocol, ipAddress, this.port, apiContext + stopURL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            if (!this.consoleMode) {
                this.launcherFrame.setImageDirectory(this.config.getResourcePath() + File.separator + "images");
                this.launcherFrame.initializeUI();
            }
            if ((respCode = connection.getResponseCode()) == 200) {
                String respCodeText = respCode + "(" + new Message("A1500I.crawler.http.code." + respCode).getFormattedText() + ")";
                message = new Message("G0089I.SHUTDOWN_REQUEST_SENT_SUCCESSFUL", respCodeText);
                this.printMessage(message.getFormattedTextWithDisplayKey());
            } else {
                retcode = 1;
            }
            if (null != connection.getContentType()) {
                InputStream is = (InputStream)connection.getContent();
                streamInput = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                String line = streamInput.readLine();
                while (line != null) {
                    this.printMessage(line);
                    line = streamInput.readLine();
                }
            }
            File globalConfigLockFile = new File(this.globalConfigPath + Startup.globalConfigFileLockExtension);
            FileChannel globalConfigFileChannel = new RandomAccessFile(globalConfigLockFile, "rw").getChannel();
            globalConfigLockFile.deleteOnExit();
            try {
                globalConfigFileChannel.lock();
            }
            catch (OverlappingFileLockException e) {
                // empty catch block
            }
            message = new Message("G0025I.SHUTDOWN_COMPLETE");
            this.printMessage(message.getFormattedTextWithDisplayKey());
            retcode = 0;
        }
        catch (Exception e) {
            if (e instanceof ConnectException) {
                Message message2 = new Message("G0127E.SYSTEM_NOT_RUNNING", this.productName.getFormattedText());
                if (!this.consoleMode) {
                    this.launcherFrame.showInformational(message2.getFormattedTextWithDisplayKey());
                    this.launcherFrame.dispose();
                } else {
                    System.out.println(message2.getFormattedTextWithDisplayKey());
                }
                int connection = 0;
                return connection;
            }
            Message message2 = new Message("G0090E.SHUTDOWN_REQUEST_SENT_FAILED");
            ExtendedException ee = new ExtendedException(message2, (Throwable)e);
            this.printMessage(ee.getFormattedText(Locale.getDefault(), false));
            retcode = 1;
        }
        finally {
            if (streamInput != null) {
                try {
                    streamInput.close();
                }
                catch (Exception e) {}
            }
        }
        if (this.launcherFrame != null) {
            if (retcode == 0) {
                message = new Message("G0126E.SHUTDOWN_COMPLETE");
                this.launcherFrame.setStatusLabel(message.getFormattedText());
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.launcherFrame.dispose();
        }
        return retcode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int stopCustomServer(String[] args) {
        Message message;
        int retcode = 0;
        BufferedReader streamInput = null;
        String host = "localhost";
        String configPath = null;
        this.launcher = new Launcher(this.globalConfigPath);
        try {
            ReleaseInfo.initialize(null);
        }
        catch (ExtendedException e) {
            return 1;
        }
        this.productName = new Message(ReleaseInfo.getReleaseInfo().getValue("System", "ProductName"));
        try {
            if (!ReleaseInfo.getReleaseInfo().getValueAsBoolean("System", "ShowStartupUI", true)) {
                this.consoleMode = true;
            }
        }
        catch (ExtendedException e) {
            // empty catch block
        }
        if (!this.consoleMode) {
            try {
                this.launcherFrame = new LauncherFrame();
                this.launcher.setLauncherFrame(this.launcherFrame);
            }
            catch (HeadlessException noDisplay) {
                this.consoleMode = true;
            }
        }
        String protocol = "http";
        if (this.globalConfigPath != null) {
            try {
                this.config = GlobalConfiguration.getConfiguration();
                this.config.validate();
                this.port = this.getCustomAdminPort();
            }
            catch (Exception e) {
                this.printMessage(this.formatStackTrace(e));
                retcode = 1;
            }
        }
        if (retcode != 0) {
            if (this.launcherFrame != null) {
                this.launcher.dumpLog();
                this.launcherFrame.dispose();
            }
            return retcode;
        }
        if (!this.consoleMode) {
            this.launcherFrame.setImageDirectory(this.config.getResourcePath() + File.separator + "images");
            this.launcherFrame.initializeUI();
        }
        try {
            configPath = this.config.getConfigPath();
            File shutdownFile = new File(configPath, "shutdown.txt");
            shutdownFile.createNewFile();
            shutdownFile.deleteOnExit();
        }
        catch (IOException e1) {
            // empty catch block
        }
        int respCode = 200;
        try {
            message = new Message("G0088I.SHUTDOWN_REQUEST_SENDING", protocol + "://" + host + ":" + this.port);
            this.printMessage(message.getFormattedTextWithDisplayKey());
            String token = this.getAuthToken(configPath);
            try {
                InyoSystem sys = new InyoSystem(host, this.port, token);
                sys.stop();
                respCode = 500;
            }
            catch (InyoException ex) {
                retcode = 1;
                Message mesg = new Message("G0090E.SHUTDOWN_REQUEST_SENT_FAILED");
                ExtendedException ee = new ExtendedException(mesg, (Throwable)ex);
                this.printMessage(ee.getFormattedText(Locale.getDefault(), false));
                int n = retcode;
                if (streamInput != null) {
                    try {
                        streamInput.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return n;
            }
            if (respCode != 200) {
                String respCodeText = "" + respCode;
                message = new Message("G0089I.SHUTDOWN_REQUEST_SENT_SUCCESSFUL", respCodeText);
                this.printMessage(message.getFormattedTextWithDisplayKey());
            } else {
                retcode = 1;
            }
            File globalConfigLockFile = new File(this.globalConfigPath + Startup.globalConfigFileLockExtension);
            FileChannel globalConfigFileChannel = new RandomAccessFile(globalConfigLockFile, "rw").getChannel();
            globalConfigLockFile.deleteOnExit();
            try {
                globalConfigFileChannel.lock();
            }
            catch (OverlappingFileLockException e) {
                // empty catch block
            }
            message = new Message("G0025I.SHUTDOWN_COMPLETE");
            this.printMessage(message.getFormattedTextWithDisplayKey());
            retcode = 0;
        }
        catch (Exception e) {
            Message message2 = new Message("G0090E.SHUTDOWN_REQUEST_SENT_FAILED");
            ExtendedException ee = new ExtendedException(message2, (Throwable)e);
            this.printMessage(ee.getFormattedText(Locale.getDefault(), false));
            retcode = 1;
        }
        finally {
            if (streamInput != null) {
                try {
                    streamInput.close();
                }
                catch (Exception e) {}
            }
        }
        if (this.launcherFrame != null) {
            if (retcode == 0) {
                message = new Message("G0126E.SHUTDOWN_COMPLETE");
                this.launcherFrame.setStatusLabel(message.getFormattedText());
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.launcherFrame.dispose();
        }
        return retcode;
    }

    private int getCustomAdminPort() throws ExtendedException {
        String fName = this.config.getJettyConfigFilePath();
        try {
            JettyConfiguration jettyConfig = new JettyConfiguration(this.config);
            return jettyConfig.getAdminHttpPort();
        }
        catch (SAXException e) {
            throw new ExtendedException(new Message("D0054E.PARSING_FAILURE", fName), (Throwable)e);
        }
        catch (IOException e) {
            throw new ExtendedException(new Message("D0054E.PARSING_FAILURE", fName), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new ExtendedException(new Message("D0054E.PARSING_FAILURE", fName), (Throwable)e);
        }
    }

    private String getAuthToken(String configPath) throws ExtendedException {
        try {
            String pathName = configPath + File.separator + "authentication.xml";
            String keyFile = configPath + File.separator + "key.txt";
            Encryption.loadDefaultKey(keyFile);
            AuthenticationData authData = new AuthenticationData();
            authData.loadFrom(new FileInputStream(new File(pathName)));
            return authData.getApiPassword();
        }
        catch (Exception ex) {
            throw new ExtendedException(ex);
        }
    }

    private boolean useCustomServer() throws ExtendedException {
        boolean use = false;
        ReleaseInfo relInfo = ReleaseInfo.getReleaseInfo();
        if (relInfo == null) {
            ReleaseInfo.initialize(null);
            relInfo = ReleaseInfo.getReleaseInfo();
        }
        use = relInfo.getValueAsBoolean("System", "UseCustomServer", true);
        return use;
    }

    private void printMessage(String message) {
        if (this.consoleMode) {
            System.out.println(message);
        } else if (message != null && message.trim().length() != 0) {
            if ((message = message.trim()).startsWith("StatusNumSteps_")) {
                this.launcherFrame.setTotalSteps(new Integer(message.substring(15)));
            } else if (message.startsWith("Status_")) {
                int substringEnd = message.indexOf(" ");
                if (substringEnd == -1) {
                    substringEnd = message.length();
                }
                Integer step = new Integer(message.substring(7, substringEnd));
                this.launcherFrame.setProgress(step);
            } else {
                this.launcher.logMessage(message + "<br/>");
                if (message.startsWith("IQQ")) {
                    this.launcherFrame.setStatusLabel(message);
                }
                if (message.contains("IQQG0090E")) {
                    this.launcher.setErrorLog("shutdownErrors.html");
                    this.launcher.dumpLog();
                }
            }
        }
    }

    private String formatStackTrace(Exception e) {
        StringWriter stackTrace = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stackTrace);
        e.printStackTrace(printWriter);
        return ((Object)stackTrace).toString();
    }
}

