/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo;

import com.ibm.es.nuvo.common.DateTimeFormatter;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.ReleaseInfo;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.util.Base64;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class ManageCrawler {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String urlStrArg = "-h";
    private static final String indexArg = "-i";
    private static final String collectionArg = "-c";
    private static final String actionArg = "-a";
    private static final String crawlerTypeArg = "-t";
    private static final String apiPasswordArg = "-p";
    private static final String outputArg = "-o";
    private static final String recrawlArg = "-r";
    private static final String configFileArg = "-c";
    private static String urlStr = null;
    private static String index = null;
    private static String collection = null;
    private static String action = null;
    private static String crawlerType = null;
    private static String apiPassword = null;
    private static String output = null;
    private static String recrawl = null;
    private static String configFile = null;
    private static Locale inLocale = Locale.getDefault();
    private static DateFormat df = DateTimeFormatter.getDateFormatter(inLocale);
    private static DateFormat tf = DateTimeFormatter.getTimeFormatter(inLocale);
    private static PrintStream ps = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        Message msg;
        try {
            configFile = "config/config.xml";
            for (int argCount = 0; argv != null && argCount < argv.length; ++argCount) {
                String argPtr = argv[argCount];
                if (argPtr.length() == 0) {
                    ManageCrawler.displayUsage();
                    System.exit(0);
                }
                if (argPtr.compareTo(indexArg) == 0) {
                    if (++argCount >= argv.length) continue;
                    index = argv[argCount].trim();
                    continue;
                }
                if (argPtr.compareTo("-c") == 0) {
                    if (++argCount >= argv.length) continue;
                    collection = argv[argCount].trim();
                    continue;
                }
                if (argPtr.compareTo(urlStrArg) == 0) {
                    if (++argCount >= argv.length) continue;
                    urlStr = argv[argCount].trim();
                    continue;
                }
                if (argPtr.compareTo(actionArg) == 0) {
                    if (++argCount >= argv.length) continue;
                    action = argv[argCount].trim();
                    continue;
                }
                if (argPtr.compareTo(crawlerTypeArg) == 0) {
                    if (++argCount >= argv.length) continue;
                    crawlerType = argv[argCount].trim();
                    continue;
                }
                if (argPtr.compareTo(apiPasswordArg) == 0) {
                    if (++argCount >= argv.length) continue;
                    apiPassword = argv[argCount].trim();
                    continue;
                }
                if (argPtr.compareTo(outputArg) == 0) {
                    if (++argCount >= argv.length) continue;
                    output = argv[argCount].trim();
                    continue;
                }
                if (argPtr.compareTo(recrawlArg) == 0) {
                    if (++argCount >= argv.length) continue;
                    recrawl = argv[argCount].trim();
                    continue;
                }
                if (argPtr.compareTo("-c") == 0) {
                    if (++argCount >= argv.length) continue;
                    configFile = argv[argCount].trim();
                    continue;
                }
                if (argPtr.compareTo("-?") == 0) {
                    ManageCrawler.displayUsage();
                    return;
                }
                ManageCrawler.displayUsage();
                Message msg2 = new Message("G0007E.INVALID_ARGUMENT");
                msg2.addArgument(argPtr);
                ExtendedException ee = new ExtendedException(msg2);
                throw ee;
            }
            if (output != null) {
                FileOutputStream fos = new FileOutputStream(new File(output), true);
                ps = new PrintStream(fos);
                System.setOut(ps);
                System.setErr(ps);
            }
            if (urlStr == null) {
                ManageCrawler.displayUsage();
                msg = new Message("G0008E.MISSING_ARGUMENT");
                msg.addArgument(urlStrArg);
                ExtendedException ee = new ExtendedException(msg);
                throw ee;
            }
            if (!urlStr.endsWith("/")) {
                urlStr = urlStr + "/";
            }
            urlStr = urlStr + "api/admin";
            if (collection == null) {
                if (index == null) {
                    ManageCrawler.displayUsage();
                    msg = new Message("G0008E.MISSING_ARGUMENT");
                    msg.addArgument("-c");
                    ExtendedException ee = new ExtendedException(msg);
                    throw ee;
                }
                collection = index;
            }
            if (action == null) {
                ManageCrawler.displayUsage();
                msg = new Message("G0008E.MISSING_ARGUMENT");
                msg.addArgument(actionArg);
                ExtendedException ee = new ExtendedException(msg);
                throw ee;
            }
            if (crawlerType == null) {
                ManageCrawler.displayUsage();
                msg = new Message("G0008E.MISSING_ARGUMENT");
                msg.addArgument(crawlerTypeArg);
                ExtendedException ee = new ExtendedException(msg);
                throw ee;
            }
            if (apiPassword == null) {
                ManageCrawler.displayUsage();
                msg = new Message("G0008E.MISSING_ARGUMENT");
                msg.addArgument(apiPasswordArg);
                ExtendedException ee = new ExtendedException(msg);
                throw ee;
            }
            System.out.println("");
            msg = new Message("G0130I.SENDING_CRAWLER_REQUEST", action, crawlerType, urlStr);
            System.out.println(ManageCrawler.getDateTime() + msg.getFormattedText(inLocale));
            URL url = new URL(urlStr);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.addRequestProperty("action", action + "Crawl");
            connection.addRequestProperty("collection", collection);
            connection.addRequestProperty("crawlType", crawlerType);
            if (recrawl != null) {
                connection.addRequestProperty("recrawl", recrawl);
            }
            String creds = Base64.encode(new String(":" + apiPassword).getBytes());
            connection.addRequestProperty("Authorization", "Basic " + creds);
            connection.connect();
            int rspCode = connection.getResponseCode();
            msg = new Message("G0131I.HTTP_RETURN_CODE", String.valueOf(rspCode));
            System.out.println(ManageCrawler.getDateTime() + msg.getFormattedText(inLocale));
            if (rspCode == 401) {
                msg = new Message("R0034E.ADMIN_AUTHORIZATION_ERROR");
                System.err.println(ManageCrawler.getDateTime() + msg.getFormattedText(inLocale));
            } else if (rspCode != 200) {
                BufferedReader d = new BufferedReader(new InputStreamReader(connection.getErrorStream(), "UTF-8"));
                StringBuffer sb = new StringBuffer();
                String str = null;
                while (null != (str = d.readLine())) {
                    sb.append(str);
                }
                d.close();
                msg = new Message("G0133E.CRAWLER_REQUEST_FAILED_WITH_ERROR", action, crawlerType, sb.toString());
                System.err.println(ManageCrawler.getDateTime() + msg.getFormattedText(inLocale));
            } else {
                msg = new Message("G0134I.CRAWLER_REQUEST_SUCCESSFUL", action, crawlerType);
                System.err.println(ManageCrawler.getDateTime() + msg.getFormattedText(inLocale));
            }
        }
        catch (ExtendedException ee) {
            System.err.println(ManageCrawler.getDateTime() + ee.getFormattedText(inLocale));
            return;
        }
        catch (Exception e) {
            msg = new Message("G0133E.CRAWLER_REQUEST_FAILED_WITH_ERROR", action, crawlerType, e.getMessage());
            System.err.println(ManageCrawler.getDateTime() + msg.getFormattedText());
        }
        catch (Throwable t) {
            msg = new Message("G0133E.CRAWLER_REQUEST_FAILED_WITH_ERROR", action, crawlerType, t.getMessage());
            System.err.println(ManageCrawler.getDateTime() + msg.getFormattedText(inLocale));
            return;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        System.exit(0);
    }

    private static void displayUsage() throws Exception {
        Message msg = new Message("G0136I.MANAGE_CRAWLER_HELP");
        File f = new File(configFile);
        if (!f.exists()) {
            throw new ExtendedException(new Message("G0045E.GLOBAL_CONFIG_FILE_MISSING", f.getAbsolutePath()));
        }
        configFile = f.getAbsolutePath();
        GlobalConfiguration.initialize(configFile);
        ReleaseInfo relInfo = ReleaseInfo.getReleaseInfo();
        if (relInfo == null) {
            ReleaseInfo.initialize(null);
            relInfo = ReleaseInfo.getReleaseInfo();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(new Message("G0136I.MANAGE_CRAWLER_HELP.FILE_SYSTEM_CRAWLER").getFormattedText(inLocale));
        sb.append(new Message("G0136I.MANAGE_CRAWLER_HELP.WEB_CRAWLER").getFormattedText(inLocale));
        if (relInfo.getValueAsBoolean("System", "DatabaseCrawlerSupported", false)) {
            sb.append(new Message("G0136I.MANAGE_CRAWLER_HELP.DATABASE_CRAWLER").getFormattedText(inLocale));
        }
        if (relInfo.getValueAsBoolean("System", "SharepointCrawlerSupported", false)) {
            sb.append(new Message("G0136I.MANAGE_CRAWLER_HELP.SHAREPOINT_CRAWLER").getFormattedText(inLocale));
        }
        msg.addArgument(sb.toString());
        System.err.println(msg.getFormattedText(inLocale));
    }

    private static String getDateTime() {
        return df.format(new Date()) + " " + tf.format(new Date()) + " ";
    }
}

