/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo;

import com.ibm.dltj.DLT;
import com.ibm.es.nuvo.api.CrawlService;
import com.ibm.es.nuvo.authentication.AuthenticationManager;
import com.ibm.es.nuvo.authentication.AuthenticationModule;
import com.ibm.es.nuvo.backup.BackupManager;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.ReleaseInfo;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.CollectionCrawlspaceConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationLock;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.CrawlServiceFactory;
import com.ibm.es.nuvo.configuration.DocumentPipelineExtensionManager;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.configuration.LanguageConfiguration;
import com.ibm.es.nuvo.configuration.SettingsConfigurationManager;
import com.ibm.es.nuvo.configuration.SystemSettings;
import com.ibm.es.nuvo.configuration.crawler.CrawlerStateSnapshot;
import com.ibm.es.nuvo.configuration.remote.RemoteConfigurationNotificationService;
import com.ibm.es.nuvo.crawler.GlobalCrawlerManager;
import com.ibm.es.nuvo.crawler.GlobalCrawlerManagerFactory;
import com.ibm.es.nuvo.crawler.web.WebCrawler;
import com.ibm.es.nuvo.crawlspace.CollectionCrawlspace;
import com.ibm.es.nuvo.crawlspace.CrawlspaceBranch;
import com.ibm.es.nuvo.crawlspace.WebCrawlspace;
import com.ibm.es.nuvo.crawlspace.WebCrawlspaceBranch;
import com.ibm.es.nuvo.documentqueue.BaseDocument;
import com.ibm.es.nuvo.documentqueue.DocumentQueue;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInterface;
import com.ibm.es.nuvo.documentqueue.DocumentQueueXmitServices;
import com.ibm.es.nuvo.eventmonitor.EventManager;
import com.ibm.es.nuvo.httplistener.ContextType;
import com.ibm.es.nuvo.httplistener.HttpListenerManager;
import com.ibm.es.nuvo.indexer.DocumentIndexer;
import com.ibm.es.nuvo.indexer.DocumentIndexerListenerInterface;
import com.ibm.es.nuvo.indexer.ExtendedIndexWriter;
import com.ibm.es.nuvo.indexer.IndexerMonitor;
import com.ibm.es.nuvo.inyo.common.CustomServiceManager;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.logging.ThreadNameLoggerFilter;
import com.ibm.es.nuvo.manager.IndexManager;
import com.ibm.es.nuvo.manager.IndexThrottler;
import com.ibm.es.nuvo.manager.IndexUpdateSearchableSynchronizer;
import com.ibm.es.nuvo.network.NodeManager;
import com.ibm.es.nuvo.parser.transform.TransformationException;
import com.ibm.es.nuvo.parser.transform.TransformationService;
import com.ibm.es.nuvo.plugin.MetadataPluginClassLoader;
import com.ibm.es.nuvo.spell.querylog.QueryLogDictionaryBuildTask;
import com.ibm.es.nuvo.spell.querylog.QueryLogListener;
import com.ibm.es.nuvo.spell.querylog.QueryRuntimeStatistics;
import com.ibm.es.nuvo.tokenizer.TokenizerPool;
import com.ibm.es.nuvo.tokenizer.service.TokenizerManager;
import com.ibm.es.nuvo.util.BuildProperties;
import com.ibm.es.nuvo.util.Constants;
import com.ibm.es.nuvo.util.Encryption;
import com.ibm.es.nuvo.util.FileDeleteTask;
import com.ibm.es.nuvo.util.FileFilter;
import com.ibm.es.nuvo.util.FileUtils;
import com.ibm.es.nuvo.util.WindowsRegistryValidationTask;
import com.ibm.es.nuvo.util.threadpool.TaskPool;
import com.ibm.supa.demo.linker.index.LinkerIndexer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import java.util.SortedMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalSystem {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String StatusNumStartupSteps = "StatusNumSteps_20";
    private static final String StatusNumShutdownSteps = "StatusNumSteps_";
    private static final String StatusStep = "Status_";
    private static final int DocQueueMessageIntervalInMillis = 10000;
    private static final String JAAS_CONFIG_FILE = "jaas.config";
    private static final String DbLockFileName = "db.lck";
    private static final String ServicesShutdownFileName = "ServiceStopping.debug";
    private static GlobalSystem singleInstance = null;
    private CollectionCrawlspaceConfigurationManager myCollectionCrawlspaceConfigurationManager = null;
    private ConfigurationManager myConfigurationManager = null;
    private QueryRuntimeStatistics queryRuntimeStatistics = null;
    private Properties buildProperties = null;
    private TaskPool taskPool = null;
    private TokenizerManager tokenizerManager = null;
    private DocumentQueueInterface documentQueue = null;
    private QueryLogDictionaryBuildTask queryLogDicBuildTask = null;
    private Thread queryLogDicBuilderThread = null;
    private GlobalCrawlerManager globalCrawlerManager = null;
    private FileDeleteTask fileDeleteTask = null;
    private DocumentIndexer documentIndexer = null;
    private IndexManager indexManager = null;
    private IndexerMonitor indexerMonitor = null;
    private EventManager userEventManager = null;
    private int finishedDocCount = 0;
    private volatile boolean shutdownInProgress = false;
    private Object shutdownWaitObject = new Object();
    private String lineEnd = null;
    private QueryLogListener queryLogListener;
    private IndexThrottler indexThrottler;
    private Vector<String> availableCharsetNames = null;
    private boolean allowIndexing = true;
    private MetadataPluginClassLoader metadataPluginClassLoader;
    private LinkerIndexer linkerIndexer;
    private boolean stellentEnabled = true;

    public static GlobalSystem getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new GlobalSystem();
        }
        return singleInstance;
    }

    public static void forgetSingleton() {
        singleInstance = null;
    }

    private GlobalSystem() {
    }

    public ConfigurationManager getConfigurationManager() {
        if (this.myConfigurationManager == null) {
            this.myConfigurationManager = new ConfigurationManager();
        }
        return this.myConfigurationManager;
    }

    public CollectionCrawlspaceConfigurationManager getCollectionCrawlspaceConfigurationManager() {
        if (this.myCollectionCrawlspaceConfigurationManager == null) {
            this.myCollectionCrawlspaceConfigurationManager = new CollectionCrawlspaceConfigurationManager();
        }
        return this.myCollectionCrawlspaceConfigurationManager;
    }

    public QueryRuntimeStatistics getQueryRuntimeStatistics() {
        if (this.queryRuntimeStatistics == null) {
            this.queryRuntimeStatistics = new QueryRuntimeStatistics();
        }
        return this.queryRuntimeStatistics;
    }

    public synchronized Vector<String> getAvailableCharsetsNames() {
        if (this.availableCharsetNames == null) {
            this.availableCharsetNames = new Vector();
            SortedMap<String, Charset> charsets = Charset.availableCharsets();
            this.availableCharsetNames.addAll(charsets.keySet());
        }
        return this.availableCharsetNames;
    }

    public IndexerMonitor getIndexerMonitor() {
        return this.indexerMonitor;
    }

    public IndexManager getIndexManager() {
        return this.indexManager;
    }

    public DocumentQueueInterface getDocumentQueue() {
        return this.documentQueue;
    }

    public TaskPool getTaskPool() {
        return this.taskPool;
    }

    public WebCrawler getWebCrawler() {
        return (WebCrawler)this.getCrawlerFor(Constants.CrawlerType.Web);
    }

    public GlobalCrawlerManager getGlobalCrawlerManager() {
        return this.globalCrawlerManager;
    }

    private Object getCrawlerFor(Constants.CrawlerType type) {
        Object crawler = null;
        CrawlService service = CrawlServiceFactory.getInstance().getServiceFor(type);
        if (service != null) {
            crawler = service.getCrawler();
        }
        return crawler;
    }

    public TokenizerPool getTokenizerPool() {
        return this.tokenizerManager.getTokenizerPool();
    }

    public TokenizerPool getRuntimeTokenizerPool() {
        return this.tokenizerManager.getRuntimeTokenizerPool();
    }

    public TokenizerManager getTokenizerManager() {
        return this.tokenizerManager;
    }

    private void createIndexer() {
        int numberOfIndexers = GlobalConfiguration.getConfiguration().getNumberOfIndexers();
        this.indexManager = new IndexManager(numberOfIndexers, this.documentQueue, GlobalConfiguration.getConfiguration().getMultipleThreadPerCollection());
        this.documentIndexer = this.indexManager.getDocumentIndexer();
    }

    private void dispatchIndexer() {
        if (this.indexManager != null) {
            this.indexManager.run();
        }
    }

    public DocumentIndexer getDocumentIndexer() {
        return this.documentIndexer;
    }

    public LinkerIndexer getLinkerIndexer() {
        return this.linkerIndexer;
    }

    public boolean isStellentEnabled() {
        return this.stellentEnabled;
    }

    public EventManager getUserEventManager() {
        return this.userEventManager;
    }

    public LanguageConfiguration getLanguageConfiguration(Locale locale) {
        return new LanguageConfiguration(locale);
    }

    public Properties getBuildProperties() {
        return this.buildProperties;
    }

    public boolean isLocaleCJK() {
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        return language.equals(Locale.JAPANESE.getLanguage()) || language.equals(Locale.KOREAN.getLanguage()) || language.equals(Locale.CHINESE.getLanguage());
    }

    public FileDeleteTask getFileDeleteTask() {
        return this.fileDeleteTask;
    }

    public IndexThrottler getIndexThrottler() {
        return this.indexThrottler;
    }

    public boolean isShutdownInProgress() {
        return this.shutdownInProgress;
    }

    public void initialize(String globalConfigPath, boolean traceOn, boolean startJetty, boolean sendProgress) throws Exception {
        ReleaseInfo releaseInfo;
        GlobalConfiguration globalConfig;
        block28: {
            Message msg;
            this.shutdownInProgress = false;
            this.lineEnd = System.getProperty("line.separator");
            if (sendProgress) {
                System.out.println("StatusNumSteps_20 ");
                this.sendStatusMsg((OutputStream)System.out, "1", sendProgress);
                System.out.flush();
            }
            System.setProperty("org.mortbay.http.Version.paranoid", "true");
            System.setProperty("org.apache.lucene.store.FSDirectoryLockFactoryClass", "org.apache.lucene.store.SingleInstanceLockFactory");
            System.setProperty("org.apache.lucene.FSDirectory.class", ExtendedIndexWriter.ExtendedFSDirectory.class.getName());
            globalConfig = null;
            try {
                GlobalConfiguration.initialize(globalConfigPath);
                globalConfig = GlobalConfiguration.getConfiguration();
                globalConfig.validate();
                String installDirectory = globalConfig.getInstallPath();
                System.setProperty("whitney.home", installDirectory);
                String jaasConfig = globalConfig.getConfigPath() + File.separator + "authentication" + File.separator + JAAS_CONFIG_FILE;
                System.setProperty("java.security.auth.login.config", jaasConfig);
            }
            catch (Exception e) {
                Message msg2 = new Message("G0026E.CONFIG_FILE_ERROR");
                msg2.addArgument(globalConfigPath);
                ExtendedException ee = new ExtendedException(msg2, (Throwable)e);
                throw ee;
            }
            this.sendStatusMsg((OutputStream)System.out, "2", sendProgress);
            this.myConfigurationManager = null;
            try {
                this.buildProperties = BuildProperties.loadProperties();
            }
            catch (Exception e) {
                Message tempMsg = new Message("G0053E.SYSTEM_MISSING_FILE", globalConfig.getBuildPropertiesFileName());
                System.out.println(tempMsg.getFormattedTextWithDisplayKey());
                this.buildProperties = BuildProperties.getDummyProperties();
            }
            ReleaseInfo.initialize(null);
            this.sendStatusMsg((OutputStream)System.out, "3", sendProgress);
            String ourTempDir = globalConfig.getTempDirectory();
            FileUtils.cleanDirectory(new File(ourTempDir));
            String systemTempDir = System.getProperty("java.io.tmpdir");
            if (systemTempDir != null && ourTempDir != null && !systemTempDir.equals(ourTempDir)) {
                System.setProperty("java.io.tmpdir", ourTempDir);
            }
            this.sendStatusMsg((OutputStream)System.out, "4", sendProgress);
            try {
                Loggers.getWrappedLogger().initialize(0xA00000, 10);
                Loggers.getWrappedTracer().initialize(0x1400000, 10);
                Loggers.getWrappedQueryLogger().initialize(0x1400000, 10);
                this.queryLogListener = new QueryLogListener();
                Loggers.queryLogger.addHandler(this.queryLogListener);
                this.indexThrottler = new IndexThrottler();
                Loggers.queryLogger.addHandler(this.indexThrottler);
                SettingsConfigurationManager settingsConfigMgr = SettingsConfigurationManager.getConfigurationManager();
                SystemSettings systemSettings = (SystemSettings)settingsConfigMgr.getSettingsForUpdate(SettingsConfigurationManager.SettingsType.SystemSettings);
                Loggers.getWrappedLogger().setProperties(systemSettings);
                Loggers.getWrappedQueryLogger().setProperties(systemSettings);
                Loggers.getWrappedTracer().setProperties(systemSettings);
                if (traceOn) {
                    Loggers.getWrappedTracer().setLevel(Level.FINEST);
                } else {
                    Loggers.getWrappedTracer().setLevel(Level.OFF);
                }
                Logger annotatorsLogger = Logger.getLogger("com.ibm.es.nuvo.tokenizer.annotators");
                if (traceOn) {
                    annotatorsLogger.setLevel(Level.FINEST);
                    annotatorsLogger.setParent(Loggers.tracer);
                } else {
                    annotatorsLogger.setLevel(Level.OFF);
                }
                if (Loggers.getWrappedTracer().getLevel() != Level.OFF && Loggers.getWrappedTracer().getLevel() != Level.INFO) {
                    Message tempMsg = new Message("G0091I.TRACE_STARTED", globalConfig.getLogPath());
                    System.out.println(tempMsg.getFormattedTextWithDisplayKey());
                }
                if (!systemSettings.getClickThroughTracking()) {
                    systemSettings.setClickThroughTracking(true);
                    settingsConfigMgr.updateStateObject(SettingsConfigurationManager.SettingsType.SystemSettings, systemSettings);
                }
            }
            catch (Exception e) {
                Message msg3 = new Message("G0027W.LOGGER_INIT_ERROR");
                msg3.addArgument(globalConfig.getLogPath());
                ExtendedException ee = new ExtendedException(msg3, (Throwable)e);
                throw ee;
            }
            this.sendStatusMsg((OutputStream)System.out, "5", sendProgress);
            releaseInfo = ReleaseInfo.getReleaseInfo();
            this.setDatabaseEnvironmtnes();
            String keyFile = globalConfig.getKeyPath();
            try {
                Encryption.loadDefaultKey(keyFile);
            }
            catch (Exception e2) {
                msg = new Message("G0107E.ENCRYPTION_KEY_LOAD_FAILED", keyFile);
                ExtendedException ee = new ExtendedException(msg, (Throwable)e2);
                throw ee;
            }
            this.sendStatusMsg((OutputStream)System.out, "6", sendProgress);
            try {
                this.userEventManager = new EventManager();
                this.userEventManager.initialize();
            }
            catch (Exception e1) {
                msg = new Message("G0086E.ERROR_INITIALIZING_EVENT_MANAGER");
                ExtendedException ee = new ExtendedException(msg, (Throwable)e1);
                System.out.println(ee.getFormattedText());
                if (!Loggers.logger.isLoggable(Level.SEVERE)) break block28;
                Loggers.logger.log(Level.SEVERE, ee);
            }
        }
        this.sendStatusMsg((OutputStream)System.out, "7", sendProgress);
        String shutdownFileName = globalConfig.getShutdownFileName();
        File shutdownFile = new File(shutdownFileName);
        if (shutdownFile.exists()) {
            shutdownFile.delete();
        }
        this.fileDeleteTask = new FileDeleteTask();
        this.fileDeleteTask.start();
        NodeManager nodeManager = NodeManager.getInstance();
        nodeManager.initialize();
        this.sendStatusMsg((OutputStream)System.out, "8", sendProgress);
        ConfigurationManager configMgr = ConfigurationManager.getConfigurationManager();
        configMgr.cleanCollectionDirectories();
        this.sendStatusMsg((OutputStream)System.out, "9", sendProgress);
        Vector<String> collectionIds = configMgr.getCollectionIds((CollectionConfiguration.State)null);
        for (int i = 0; i < collectionIds.size(); ++i) {
            String collectionId = collectionIds.get(i);
            CollectionConfiguration collection = configMgr.getCollection(collectionId, (CollectionConfiguration.State)null);
            String directory = collection.getCrawlerDataDirectory(Constants.CrawlerType.Web);
            FileUtils.deleteFile(directory, DbLockFileName);
        }
        this.sendStatusMsg((OutputStream)System.out, "10", sendProgress);
        AuthenticationModule apiModule = AuthenticationManager.getInstance().getApiModule();
        if (!apiModule.doesPasswordExist()) {
            apiModule.generatePassword("admin", null);
        }
        this.sendStatusMsg((OutputStream)System.out, "11", sendProgress);
        String uimaDataPath = globalConfig.getUimaDataPath();
        String uimaDictionaries = uimaDataPath + File.separator + "*Lex.dic";
        DLT.init((String)uimaDictionaries);
        this.sendStatusMsg((OutputStream)System.out, "12", sendProgress);
        boolean useStellent = releaseInfo.getValueAsBoolean("System", "StellentEnabled", true);
        Properties transformProps = new Properties();
        transformProps.setProperty("useStellent", Boolean.toString(useStellent));
        this.stellentEnabled = useStellent;
        TransformationService.initialize(transformProps);
        this.sendStatusMsg((OutputStream)System.out, "13", sendProgress);
        this.taskPool = new TaskPool(7);
        String docQueueFileName = GlobalConfiguration.getConfiguration().getDocQueueFileName();
        this.documentQueue = this.createDocQueueFromDisk(globalConfig.getDocumentQueueSize(), docQueueFileName);
        this.cleanDocQueueDirectory();
        boolean nodeReplicationSupported = releaseInfo.getValueAsBoolean("System", "NodeReplicationSupported", false);
        if (nodeReplicationSupported) {
            DocumentQueueXmitServices.createServiceForQueue("mainDocQueue", this.documentQueue);
        }
        this.tokenizerManager = new TokenizerManager();
        this.sendStatusMsg((OutputStream)System.out, "14", sendProgress);
        this.createIndexer();
        this.indexerMonitor = new IndexerMonitor(this.documentIndexer);
        boolean startCrawlers = releaseInfo.getValueAsBoolean("System", "CrawlerSupport", true);
        if (startCrawlers) {
            this.globalCrawlerManager = GlobalCrawlerManagerFactory.newGlobalCrawlerManager();
            CrawlService[] crawlServices = CrawlServiceFactory.getInstance().getAllServices();
            for (int i = 0; i < crawlServices.length; ++i) {
                crawlServices[i].initialize();
            }
        }
        this.queryLogDicBuildTask = new QueryLogDictionaryBuildTask();
        this.queryLogDicBuilderThread = new Thread((Runnable)this.queryLogDicBuildTask, "QueryLogDictionaryBuilder");
        this.queryLogDicBuilderThread.setDaemon(true);
        this.queryLogDicBuilderThread.start();
        this.sendStatusMsg((OutputStream)System.out, "15", sendProgress);
        this.sendStatusMsg((OutputStream)System.out, "16", sendProgress);
        RemoteConfigurationNotificationService.getInstance().intialize();
        if (startJetty) {
            if (!this.useCustomServer()) {
                HttpListenerManager.startupHttpListener();
            } else {
                CustomServiceManager servMgr = CustomServiceManager.getInstance();
                servMgr.startService();
            }
        }
        if (globalConfig.isWindows()) {
            this.validateWindowsServicesValues();
        }
        this.sendStatusMsg((OutputStream)System.out, "17", sendProgress);
        this.documentIndexer.addListener(new IndexUpdateSearchableSynchronizer());
        this.linkerIndexer = new LinkerIndexer();
    }

    private boolean useCustomServer() throws ExtendedException {
        boolean use = false;
        ReleaseInfo relInfo = ReleaseInfo.getReleaseInfo();
        if (relInfo == null) {
            ReleaseInfo.initialize(null);
            relInfo = ReleaseInfo.getReleaseInfo();
        }
        use = relInfo.getValueAsBoolean("System", "UseCustomServer", false);
        return use;
    }

    private void validateWindowsServicesValues() {
        block4: {
            GlobalConfiguration globalConfig = GlobalConfiguration.getConfiguration();
            File servicesShutdownFile = new File(globalConfig.getLogPath(), ServicesShutdownFileName);
            if (servicesShutdownFile.exists()) {
                servicesShutdownFile.delete();
                if (Loggers.logger.isLoggable(Level.WARNING)) {
                    Message msg = new Message("G0163W.WINDOWS_SHUTDOWN_DID_NOT_FINISH");
                    Loggers.logger.log(Level.WARNING, msg);
                }
            }
            ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo();
            try {
                int windowsTimeoutValue = releaseInfo.getValueAsInt("System", "MinWindowsServicesWaitToKillServiceTimeout", 30000);
                this.getTaskPool().schedule(new WindowsRegistryValidationTask(windowsTimeoutValue));
            }
            catch (ExtendedException e) {
                if (!Loggers.logger.isLoggable(Level.SEVERE)) break block4;
                Loggers.logger.log(Level.WARNING, e);
            }
        }
    }

    private void sendStatusMsg(OutputStream os, int count, boolean sendStatus) {
        this.sendStatusMsg(os, String.valueOf(count), sendStatus);
    }

    private void sendStatusMsg(OutputStream os, String strCount, boolean sendStatus) {
        if (sendStatus && os != null) {
            try {
                os.write(StatusStep.getBytes("UTF-8"));
                os.write(strCount.getBytes("UTF-8"));
                os.write(" ".getBytes("UTF-8"));
                os.write(this.lineEnd.getBytes("UTF-8"));
                os.flush();
            }
            catch (UnsupportedEncodingException e) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void startDocumentPipeline(Vector<String> collectionIdsForWebCrawl, Vector<String> sitesForWebCrawl, boolean disableCrawling, boolean sendStatus, boolean preloadAndQueryCollections) throws Exception {
        File docQueueFile;
        Vector<String> collectionList;
        String collectionId;
        ConfigurationManager configManager;
        block16: {
            SettingsConfigurationManager settingsConfigMgr;
            SystemSettings systemSettings;
            CrawlerStateSnapshot crawlersState;
            block15: {
                configManager = ConfigurationManager.getConfigurationManager();
                collectionId = null;
                try {
                    if (collectionIdsForWebCrawl != null) {
                        for (int i = 0; i < collectionIdsForWebCrawl.size(); ++i) {
                            collectionId = collectionIdsForWebCrawl.elementAt(i).toString();
                            String site = sitesForWebCrawl.elementAt(i).toString();
                            boolean collectionCreated = this.createCollectionIfNotExists(collectionId);
                            boolean crawlspaceAdded = this.setBranchToCollection(collectionId, site);
                            if (!collectionCreated && !crawlspaceAdded) continue;
                            Message msg = new Message("G0112I.COLLECTION_DEFINED", collectionId, site);
                            System.out.println(msg.getFormattedTextWithDisplayKey());
                        }
                    }
                }
                catch (ExtendedException e1) {
                    Message msg = new Message("G0101E.ERROR_STARTUP_ACCESS_COLLECTION_FAILED", collectionId);
                    System.out.println(msg.getFormattedTextWithDisplayKey());
                    if (!Loggers.logger.isLoggable(Level.SEVERE)) break block15;
                    ExtendedException ee = new ExtendedException(msg, (Throwable)e1);
                    Loggers.logger.log(Level.SEVERE, ee);
                }
            }
            this.sendStatusMsg((OutputStream)System.out, "18", sendStatus);
            Vector<String> fullCollectionList = configManager.getCollectionIds((CollectionConfiguration.State)null);
            collectionList = configManager.getCollectionIds();
            for (int i = 0; i < fullCollectionList.size(); ++i) {
                collectionId = fullCollectionList.get(i).toString();
                CollectionConfiguration config = ConfigurationManager.getConfigurationManager().getCollection(collectionId, (CollectionConfiguration.State)null);
                GlobalSystem.cleanupLuceneLocksOnCollection(config);
            }
            if (!disableCrawling && (crawlersState = (systemSettings = (SystemSettings)(settingsConfigMgr = SettingsConfigurationManager.getConfigurationManager()).getSettings(SettingsConfigurationManager.SettingsType.SystemSettings)).getCrawlersState()) != null) {
                try {
                    crawlersState.restartCrawlers();
                }
                catch (ExtendedException e) {
                    e.printStackTrace();
                    if (!Loggers.logger.isLoggable(Level.SEVERE)) break block16;
                    Loggers.logger.log(Level.SEVERE, e);
                }
            }
        }
        this.sendStatusMsg((OutputStream)System.out, "19", sendStatus);
        if (collectionList.size() > 0 && preloadAndQueryCollections) {
            int maxDocs;
            ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo();
            boolean runPreloadQuery = releaseInfo.getValueAsBoolean("System", "RunPreloadIndexQuery", true);
            if (runPreloadQuery) {
                String foundCollectionId = null;
                for (int i = 0; i < collectionList.size() && foundCollectionId == null; ++i) {
                    collectionId = collectionList.get(i).toString();
                    CollectionConfiguration collection = configManager.getCollection(collectionId);
                    if (!collection.isEnabledForSearch()) continue;
                    foundCollectionId = collectionId;
                }
                if (foundCollectionId != null) {
                    this.getTaskPool().schedule(new QueryCollection(foundCollectionId));
                }
            }
            if ((maxDocs = releaseInfo.getValueAsInt("System", "Max.Documents", 500000)) > 0) {
                this.getTaskPool().schedule(new CountDocuments(maxDocs));
            }
        }
        if (this.allowIndexing) {
            this.dispatchIndexer();
        }
        if ((docQueueFile = new File(GlobalConfiguration.getConfiguration().getDocQueueFileName())).exists()) {
            docQueueFile.delete();
        }
        this.sendStatusMsg((OutputStream)System.out, "20", sendStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown(boolean exitJVMWhenFinished, boolean saveState, OutputStream os, Locale outputStreamLocale, boolean returnBeforeJettyIsClosed, boolean sendProgress) throws InterruptedException {
        if (this.shutdownInProgress) {
            return;
        }
        this.shutdownInProgress = true;
        Object object = this.shutdownWaitObject;
        synchronized (object) {
            ShutdownRunnable task = new ShutdownRunnable(exitJVMWhenFinished, saveState, os, outputStreamLocale, returnBeforeJettyIsClosed, sendProgress);
            Thread shutdownThread = new Thread((Runnable)task, "Shutdown_Thread");
            shutdownThread.start();
            this.shutdownWaitObject.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownImpl(boolean exitJVMWhenFinished, boolean saveState, OutputStream os, Locale streamLocale, boolean returnBeforeJettyIsClosed, boolean sendProgress) {
        boolean addShutdownTraceMsgs = false;
        try {
            addShutdownTraceMsgs = ReleaseInfo.getReleaseInfo().getValueAsBoolean("System", "AddShutdownTraceMsgs", false);
        }
        catch (ExtendedException e1) {
            // empty catch block
        }
        GlobalConfiguration globalConfig = GlobalConfiguration.getConfiguration();
        int currentStep = 0;
        int numCrawlerSteps = CrawlServiceFactory.getInstance().getAllServices().length;
        if (this.globalCrawlerManager != null) {
            ++numCrawlerSteps;
        }
        int totalSteps = 6 + numCrawlerSteps;
        if (sendProgress && os != null) {
            String shutdownNumSteps = StatusNumShutdownSteps + totalSteps;
            try {
                os.write(shutdownNumSteps.getBytes("UTF-8"));
                os.write(" ".getBytes("UTF-8"));
                os.write(this.lineEnd.getBytes("UTF-8"));
                os.flush();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.sendStatusMsg(os, ++currentStep, sendProgress);
        }
        boolean notifiedWaiters = false;
        try {
            Object lockObject;
            Message msg = null;
            msg = new Message("G0023I.SHUTDOWN_REQUEST");
            this.writeShutdownMsg(msg, os, streamLocale);
            if (Loggers.logger.isLoggable(Level.INFO)) {
                Loggers.logger.log(Level.INFO, msg);
            }
            Object object = lockObject = ConfigurationLock.getLockObj();
            synchronized (object) {
                block78: {
                    int docQueueDrainTimeInMillis;
                    boolean forceIndexersToCloseImmediately;
                    block77: {
                        block76: {
                            BackupManager.shutDownBackupAndRestore();
                            if (null != this.queryLogDicBuildTask) {
                                this.queryLogDicBuildTask.shutdownTask();
                                if (this.queryLogDicBuilderThread != null) {
                                    this.queryLogDicBuilderThread.interrupt();
                                    this.queryLogDicBuilderThread = null;
                                }
                            }
                            if (saveState) {
                                this.saveCollectionCrawlingState();
                            }
                            this.sendStatusMsg(os, ++currentStep, sendProgress);
                            CrawlService[] crawlServices = CrawlServiceFactory.getInstance().getAllServices();
                            for (int i = 0; i < crawlServices.length; ++i) {
                                block75: {
                                    Constants.CrawlerType crawlerType = crawlServices[i].getType();
                                    if (addShutdownTraceMsgs) {
                                        this.shutdownTraceMsg("Shutting down crawler : " + (Object)((Object)crawlerType));
                                    }
                                    try {
                                        crawlServices[i].shutdown();
                                    }
                                    catch (ExtendedException e) {
                                        msg = new Message("G0092W.ERROR_SHUTTING_DOWN_CRAWLER");
                                        this.writeShutdownMsg(msg, os, streamLocale);
                                        if (!Loggers.logger.isLoggable(Level.WARNING)) break block75;
                                        ExtendedException ee = new ExtendedException(msg, (Throwable)e);
                                        Loggers.logger.log(Level.WARNING, ee);
                                    }
                                }
                                if (addShutdownTraceMsgs) {
                                    this.shutdownTraceMsg("Crawler shutdown");
                                }
                                this.sendStatusMsg(os, ++currentStep, sendProgress);
                            }
                            if (this.globalCrawlerManager != null) {
                                try {
                                    this.globalCrawlerManager.terminate();
                                }
                                catch (ExtendedException e) {
                                    if (Loggers.logger.isLoggable(Level.SEVERE)) {
                                        Loggers.logger.log(Level.SEVERE, e);
                                    }
                                    e.printStackTrace();
                                }
                                this.globalCrawlerManager = null;
                                this.sendStatusMsg(os, ++currentStep, sendProgress);
                            }
                            try {
                                this.queryRuntimeStatistics.stop();
                            }
                            catch (ExtendedException e2) {
                                if (!Loggers.logger.isLoggable(Level.SEVERE)) break block76;
                                Loggers.logger.log(Level.SEVERE, e2);
                            }
                        }
                        this.queryRuntimeStatistics = null;
                        RemoteConfigurationNotificationService.getInstance().shutdown();
                        forceIndexersToCloseImmediately = false;
                        docQueueDrainTimeInMillis = 5000;
                        try {
                            docQueueDrainTimeInMillis = ReleaseInfo.getReleaseInfo().getValueAsInt("System", "DocQueueDrainTimeInMillis", -1);
                        }
                        catch (ExtendedException e) {
                            if (!Loggers.logger.isLoggable(Level.SEVERE)) break block77;
                            Loggers.logger.log(Level.SEVERE, e);
                        }
                    }
                    if (this.documentQueue != null && docQueueDrainTimeInMillis != 0 && this.indexManager.isRunning()) {
                        long lastInfoMsgTime = 0L;
                        boolean keepWaiting = true;
                        int initialDocCount = this.documentQueue.getCounter();
                        this.finishedDocCount = 0;
                        long startTime = System.currentTimeMillis();
                        DocumentIndexListener docIndexListener = new DocumentIndexListener();
                        this.documentIndexer.addListener(docIndexListener);
                        while (keepWaiting && this.documentQueue.getCounter() > 0) {
                            int remainingDocCount = initialDocCount - this.finishedDocCount;
                            long currentTime = System.currentTimeMillis();
                            if (currentTime > lastInfoMsgTime + 10000L) {
                                lastInfoMsgTime = currentTime;
                                msg = new Message("G0046I.SHUTDOWN_WAIT_ON_DOC_QUEUE", remainingDocCount);
                                this.writeShutdownMsg(msg, os, streamLocale);
                                if (Loggers.logger.isLoggable(Level.INFO)) {
                                    Loggers.logger.log(Level.INFO, msg);
                                }
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            if (docQueueDrainTimeInMillis <= 0) continue;
                            keepWaiting = System.currentTimeMillis() < startTime + (long)docQueueDrainTimeInMillis;
                        }
                        this.documentIndexer.removeListener(docIndexListener);
                    }
                    DocumentQueueXmitServices.shutdownServices();
                    this.sendStatusMsg(os, ++currentStep, sendProgress);
                    msg = new Message("G0051I.SHUTDOWN_STOPPING_INDEXERS");
                    this.writeShutdownMsg(msg, os, streamLocale);
                    if (Loggers.logger.isLoggable(Level.INFO)) {
                        Loggers.logger.log(Level.INFO, msg);
                    }
                    try {
                        if (this.documentQueue != null) {
                            forceIndexersToCloseImmediately = true;
                            ThreadNameLoggerFilter filter = new ThreadNameLoggerFilter("IndexerThread");
                            Loggers.logger.setFilter(filter);
                        }
                        if (this.indexManager.isRunning()) {
                            this.indexManager.stop(forceIndexersToCloseImmediately);
                            this.documentIndexer.shutdown();
                        }
                        msg = new Message("G0052I.SHUTDOWN_STOPPED_INDEXERS");
                        this.writeShutdownMsg(msg, os, streamLocale);
                        if (Loggers.logger.isLoggable(Level.INFO)) {
                            Loggers.logger.log(Level.INFO, msg);
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    this.sendStatusMsg(os, ++currentStep, sendProgress);
                    if (addShutdownTraceMsgs) {
                        this.shutdownTraceMsg("Writing doc queue with " + this.documentQueue.getCounter() + " docs in queue");
                    }
                    String fileName = GlobalConfiguration.getConfiguration().getDocQueueFileName();
                    this.writeDocQueueToDisk(this.documentQueue, fileName);
                    if (addShutdownTraceMsgs) {
                        this.shutdownTraceMsg("Doc queue shutdown complete");
                    }
                    if (this.taskPool != null) {
                        this.taskPool.shutdown();
                        this.taskPool = null;
                    }
                    this.sendStatusMsg(os, ++currentStep, sendProgress);
                    if (this.fileDeleteTask != null) {
                        try {
                            this.fileDeleteTask.stop();
                            this.fileDeleteTask = null;
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    NodeManager nodeManager = NodeManager.getInstance();
                    nodeManager.shutdown();
                    this.indexerMonitor = null;
                    try {
                        TransformationService.terminate();
                    }
                    catch (TransformationException e1) {
                        // empty catch block
                    }
                    this.sendStatusMsg(os, ++currentStep, sendProgress);
                    if (returnBeforeJettyIsClosed) {
                        Object e1 = this.shutdownWaitObject;
                        synchronized (e1) {
                            this.shutdownWaitObject.notify();
                            notifiedWaiters = true;
                        }
                        if (os != null && System.out != os) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                    if (HttpListenerManager.getSingleInstanceListenerServer() != null) {
                        msg = new Message("G0049I.HTTP_SERVER_STOPPING");
                        if (Loggers.logger.isLoggable(Level.INFO)) {
                            Loggers.logger.log(Level.INFO, msg);
                        }
                        HttpListenerManager.stopHttpListener();
                    }
                    try {
                        CustomServiceManager servMgr = CustomServiceManager.getInstance();
                        servMgr.stopService();
                    }
                    catch (ExtendedException ex) {
                        if (!Loggers.logger.isLoggable(Level.SEVERE)) break block78;
                        Loggers.logger.log(Level.WARNING, ex);
                    }
                }
                DocumentPipelineExtensionManager.getInstance().closeAllExtensions();
                if (this.userEventManager != null) {
                    this.userEventManager.shutdown();
                    this.userEventManager = null;
                }
                this.cleanDocQueueDirectory();
                if (this.metadataPluginClassLoader != null) {
                    this.metadataPluginClassLoader.clearMetadataPlugin();
                }
                String ourTempDir = globalConfig.getTempDirectory();
                FileUtils.removeDirectory(new File(ourTempDir));
                msg = new Message("G0025I.SHUTDOWN_COMPLETE");
                try {
                    if (Loggers.logger.isLoggable(Level.INFO)) {
                        Loggers.logger.log(Level.INFO, msg);
                    }
                    Loggers.getWrappedLogger().flush();
                    Loggers.getWrappedLogger().close();
                    Loggers.getWrappedQueryLogger().flush();
                    Loggers.getWrappedQueryLogger().close();
                    Loggers.getWrappedTracer().flush();
                    Loggers.getWrappedTracer().close();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                System.out.println(msg.getFormattedTextWithDisplayKey());
                singleInstance = null;
                if (exitJVMWhenFinished) {
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true");
                    }
                    catch (SQLException ignored) {
                        // empty catch block
                    }
                    System.exit(0);
                }
            }
        }
        finally {
            if (!notifiedWaiters) {
                Object object = this.shutdownWaitObject;
                synchronized (object) {
                    this.shutdownWaitObject.notify();
                }
            }
        }
    }

    private void shutdownTraceMsg(String string) {
        Message msg = new Message("G0002I.TRACE_MESSAGE", string);
        Loggers.logger.log(Level.INFO, msg);
    }

    private void saveCollectionCrawlingState() {
        block2: {
            try {
                SettingsConfigurationManager settingsConfigMgr = SettingsConfigurationManager.getConfigurationManager();
                SystemSettings systemSettings = (SystemSettings)settingsConfigMgr.getSettingsForUpdate(SettingsConfigurationManager.SettingsType.SystemSettings);
                ConfigurationManager configManager = ConfigurationManager.getConfigurationManager();
                Vector<String> collectionIds = configManager.getCollectionIds();
                CrawlerStateSnapshot crawlersState = CrawlerStateSnapshot.getSnapshotFor(collectionIds);
                systemSettings.setCrawlersState(crawlersState);
                settingsConfigMgr.updateStateObject(SettingsConfigurationManager.SettingsType.SystemSettings, systemSettings);
            }
            catch (Exception e1) {
                Message msg = new Message("G0071W.ERROR_SAVING_CRAWLER_STATE");
                System.out.println(msg.getFormattedTextWithDisplayKey());
                if (!Loggers.logger.isLoggable(Level.WARNING)) break block2;
                ExtendedException ee = new ExtendedException(msg, (Throwable)e1);
                Loggers.logger.log(Level.WARNING, ee);
            }
        }
    }

    private boolean createCollectionIfNotExists(String collectionId) throws ExtendedException {
        CollectionConfiguration collection = null;
        boolean somethingModified = false;
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        if (!configurationManager.collectionExists(collectionId)) {
            collection = CollectionConfiguration.createDefault();
            collection.setId(collectionId);
            configurationManager.createCollection(collection, true);
            somethingModified = true;
        }
        return somethingModified;
    }

    private boolean setBranchToCollection(String collectionId, String webCrawlPath) throws ExtendedException {
        boolean webBranchCreated = false;
        boolean createdCrawlspace = false;
        CollectionCrawlspaceConfigurationManager csMgr = this.getCollectionCrawlspaceConfigurationManager();
        CollectionCrawlspace cs = null;
        if (!csMgr.crawlspaceExists(collectionId)) {
            cs = csMgr.createDefaultCrawlspaceConfig();
            createdCrawlspace = true;
        } else {
            cs = csMgr.getCrawlspaceForUpdate(collectionId);
        }
        if (webCrawlPath != null && webCrawlPath.length() > 0) {
            WebCrawlspace webCs = cs.getWebCrawlspace();
            if (webCs == null) {
                webCs = new WebCrawlspace();
                cs.setWebCrawlspace(webCs);
            }
            webCs.getBranches().clear();
            webBranchCreated = this.createBranch(webCs.getBranches(), webCrawlPath, BranchType.Web);
        }
        if (createdCrawlspace) {
            csMgr.createCrawlspace(cs, collectionId);
        } else if (webBranchCreated) {
            csMgr.updateCrawlspace(collectionId, cs);
        }
        boolean somethingModified = false;
        if (createdCrawlspace || webBranchCreated) {
            csMgr.publish(collectionId);
            somethingModified = true;
        }
        return somethingModified;
    }

    private boolean createBranch(Vector branches, String branchRoot, BranchType branchType) {
        boolean branchAdded = false;
        boolean branchExists = false;
        if (branches != null) {
            for (int i = 0; i < branches.size() && !branchExists; ++i) {
                CrawlspaceBranch branch = (CrawlspaceBranch)branches.get(i);
                branchExists = branchRoot.equals(branch.getRoot());
            }
        }
        if (!branchExists) {
            CrawlspaceBranch branch = null;
            branch = branchType == BranchType.Web ? new WebCrawlspaceBranch() : new CrawlspaceBranch();
            branch.setRoot(branchRoot);
            branches.add(branch);
            branchAdded = true;
        }
        return branchAdded;
    }

    private void sendQueryToCollection(String collectionId) {
        block5: {
            String searchURL = HttpListenerManager.getSingleInstanceListenerServer().getSearchAppURL();
            if (searchURL != null && searchURL.length() > 0) {
                if (Loggers.tracer.isLoggable(Level.FINE)) {
                    Message msg = new Message("G0002I.TRACE_MESSAGE");
                    msg.addArgument("Sending query to preload index " + collectionId + " on " + searchURL);
                    Loggers.tracer.log(Level.FINE, msg);
                }
                String queryContext = ContextType.Search.getContextPath();
                String context = queryContext + "?query=IBM" + "&index=" + collectionId + "&start=0" + "&results=5" + "&log=false";
                int respCode = -1;
                try {
                    URL url = new URL(searchURL + context);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.connect();
                    respCode = connection.getResponseCode();
                    connection.disconnect();
                    if (Loggers.tracer.isLoggable(Level.FINE)) {
                        Message msg = new Message("G0002I.TRACE_MESSAGE");
                        msg.addArgument("Finished preload query.  Response code " + Integer.toString(respCode));
                        Loggers.tracer.log(Level.FINE, msg);
                    }
                }
                catch (Exception e) {
                    if (!Loggers.tracer.isLoggable(Level.FINE)) break block5;
                    Message msg = new Message("G0002I.TRACE_MESSAGE");
                    msg.addArgument("Preload query ended with an error " + e.toString());
                    Loggers.tracer.log(Level.FINE, msg);
                }
            }
        }
    }

    private static void cleanupLuceneLocksOnCollection(CollectionConfiguration collectionConfig) {
        GlobalSystem.cleanupLuceneLocksOnIndex(collectionConfig.getIndexPath(IndexDescriptor.IndexType.Text));
        String path = collectionConfig.getIndexPath(IndexDescriptor.IndexType.Crawl);
        if (path != null) {
            GlobalSystem.cleanupLuceneLocksOnIndex(path);
        }
    }

    private static void cleanupLuceneLocksOnIndex(String indexPath) {
        try {
            FSDirectory directory = FSDirectory.getDirectory((String)indexPath, (boolean)false);
            IndexReader.unlock((Directory)directory);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeShutdownMsg(Message msg, OutputStream os, Locale streamLocale) {
        if (os != null) {
            String strMsg = msg.getFormattedTextWithDisplayKey(streamLocale);
            try {
                os.write(strMsg.getBytes("UTF-8"));
                os.write(this.lineEnd.getBytes("UTF-8"));
                os.flush();
            }
            catch (UnsupportedEncodingException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private void setDatabaseEnvironmtnes() {
        String logPath;
        GlobalConfiguration configuration = GlobalConfiguration.getConfiguration();
        String string = logPath = configuration != null ? configuration.getLogPath() : null;
        if (logPath == null) {
            logPath = System.getProperty("java.io.tmpdir");
        }
        System.setProperty("derby.stream.error.file", logPath + File.separator + "derby.log");
        System.setProperty("derby.storage.pageCacheSize", "200");
        System.setProperty("derby.database.forceDatabaseLock", "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentQueueInterface createDocQueueFromDisk(int queueSize, String fileName) {
        DocumentQueue docQueue = null;
        File docQueueFile = new File(fileName);
        if (docQueueFile.exists()) {
            FileInputStream fis = null;
            Vector<ExtendedException> errors = new Vector<ExtendedException>();
            try {
                fis = new FileInputStream(docQueueFile);
                docQueue = DocumentQueue.loadFrom(queueSize, errors, fis);
            }
            catch (Exception e) {
                if (Loggers.logger.isLoggable(Level.SEVERE)) {
                    Message msg = new Message("G0155E.ERROR_READING_DOC_QUEUE", fileName);
                    ExtendedException ee = new ExtendedException(msg, (Throwable)e);
                    Loggers.logger.log(Level.SEVERE, ee);
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (errors.size() > 0 && Loggers.logger.isLoggable(Level.SEVERE)) {
                for (int i = 0; i < errors.size(); ++i) {
                    Loggers.logger.log(Level.SEVERE, errors.get(i));
                }
            }
        }
        if (docQueue == null) {
            docQueue = new DocumentQueue(queueSize);
        }
        return docQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocQueueToDisk(DocumentQueueInterface docQueue, String fileName) {
        if (docQueue != null && docQueue.getCounter() > 0 && docQueue instanceof DocumentQueue) {
            Message docQueueError = null;
            FileOutputStream fos = null;
            Exception docQueueException = null;
            try {
                fos = new FileOutputStream(fileName);
                ((DocumentQueue)docQueue).writeTo(fos);
            }
            catch (Exception e) {
                docQueueException = e;
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (docQueueException != null) {
                if (Loggers.logger.isLoggable(Level.SEVERE)) {
                    String docQueueContents = this.getDocQueueContentsAsString();
                    docQueueError = new Message("G0154E.ERROR_WRITING_DOC_QUEUE", fileName, docQueueContents);
                    ExtendedException ee = new ExtendedException(docQueueError, (Throwable)docQueueException);
                    Loggers.logger.log(Level.SEVERE, ee);
                }
                File f = new File(fileName);
                f.delete();
            }
        } else {
            File f = new File(fileName);
            f.delete();
        }
    }

    private String getDocQueueContentsAsString() {
        StringBuilder sb = new StringBuilder(1000);
        Vector<String> collectionIds = new Vector<String>();
        Vector<Boolean> docInBatchList = new Vector<Boolean>();
        Vector<String> docTypes = new Vector<String>();
        Vector<String> docURIs = new Vector<String>();
        this.documentQueue.getStatus(collectionIds, docInBatchList, docURIs, docTypes, null);
        for (int i = 0; i < docURIs.size(); ++i) {
            String uri = docURIs.get(i);
            if (uri == null || uri.length() <= 0) continue;
            sb.append(uri);
            sb.append(this.lineEnd);
        }
        return sb.toString();
    }

    private void cleanDocQueueDirectory() {
        GlobalConfiguration globalConfig = GlobalConfiguration.getConfiguration();
        File docQueueDirFile = new File(globalConfig.getDocQueueDirectory());
        Vector<String> collectionIds = new Vector<String>();
        Vector<Boolean> docInBatchList = new Vector<Boolean>();
        Vector<String> docTypes = new Vector<String>();
        Vector<String> docURIs = new Vector<String>();
        Vector<String> usedDataFiles = new Vector<String>();
        if (this.documentQueue != null) {
            this.documentQueue.getStatus(collectionIds, docInBatchList, docURIs, docTypes, usedDataFiles);
            for (int i = usedDataFiles.size() - 1; i >= 0; --i) {
                String fn = usedDataFiles.get(i);
                if (fn != null) continue;
                usedDataFiles.remove(i);
            }
        }
        FileFilter dataFileFilter = new FileFilter("IQQ", "DataBuffer");
        File[] dataFiles = docQueueDirFile.listFiles(dataFileFilter);
        for (int i = 0; i < dataFiles.length; ++i) {
            String fn = dataFiles[i].getAbsolutePath();
            if (usedDataFiles.contains(fn)) continue;
            dataFiles[i].delete();
        }
    }

    protected boolean isAllowIndexing() {
        return this.allowIndexing;
    }

    protected void setAllowIndexing(boolean startIndexer) {
        this.allowIndexing = startIndexer;
    }

    public final MetadataPluginClassLoader getMetadataPluginClassLoader() {
        if (this.metadataPluginClassLoader == null) {
            this.metadataPluginClassLoader = new MetadataPluginClassLoader();
        }
        return this.metadataPluginClassLoader;
    }

    class ShutdownRunnable
    implements Runnable {
        private boolean exitJVM = false;
        private boolean saveState = false;
        private OutputStream os = null;
        private Locale osLocale = null;
        private boolean returnBeforeJettyIsClosed = false;
        private boolean sendProgress = false;

        public ShutdownRunnable(boolean exitJVM, boolean saveState, OutputStream os, Locale outputStreamLocale, boolean returnBeforeJettyIsClosed, boolean sendProgress) {
            this.exitJVM = exitJVM;
            this.saveState = saveState;
            this.os = os;
            this.osLocale = outputStreamLocale;
            this.returnBeforeJettyIsClosed = returnBeforeJettyIsClosed;
            this.sendProgress = sendProgress;
        }

        public void run() {
            GlobalSystem.this.shutdownImpl(this.exitJVM, this.saveState, this.os, this.osLocale, this.returnBeforeJettyIsClosed, this.sendProgress);
        }
    }

    class CountDocuments
    implements Runnable {
        private int maxDocuments = 0;

        public CountDocuments(int maxDocs) {
            this.maxDocuments = maxDocs;
        }

        public void run() {
            if (this.maxDocuments <= 0) {
                return;
            }
            int origPriority = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(1);
            IndexerMonitor localIndexerMonitor = GlobalSystem.this.getIndexerMonitor();
            long totalDocCount = 0L;
            ConfigurationManager configManager = ConfigurationManager.getConfigurationManager();
            Vector<String> collectionList = configManager.getCollectionIds();
            for (int i = 0; i < collectionList.size(); ++i) {
                String collectionId = collectionList.get(i).toString();
                long collectionDocCount = 0L;
                try {
                    collectionDocCount = localIndexerMonitor.getNumberOfDocuments(collectionId);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                totalDocCount += collectionDocCount;
            }
            if (totalDocCount > (long)this.maxDocuments) {
                Message msg = new Message("G0116E.DOC_LIMIT_EXCEEDED", totalDocCount, this.maxDocuments);
                if (Loggers.logger.isLoggable(Level.SEVERE)) {
                    Loggers.logger.log(Level.SEVERE, msg);
                }
            }
            Thread.currentThread().setPriority(origPriority);
        }
    }

    class QueryCollection
    implements Runnable {
        String collectionId = null;

        public QueryCollection(String collectionId) {
            this.collectionId = collectionId;
        }

        public void run() {
            GlobalSystem.this.sendQueryToCollection(this.collectionId);
        }
    }

    class DocumentIndexListener
    implements DocumentIndexerListenerInterface {
        DocumentIndexListener() {
        }

        public void documentOperationSuccessful(String collectionId, BaseDocument document, DocumentIndexerListenerInterface.OperationType operation) {
            this.docFinished();
        }

        public synchronized void documentOperationFailed(String collectionId, BaseDocument document, DocumentIndexerListenerInterface.OperationType operation, ExtendedException exception) {
            this.docFinished();
        }

        public void indexOpened(String collectionId) {
        }

        public void indexClosed(String collectionId) {
        }

        public void configurationUpdated(String collectionId) {
        }

        public void indexQuiesced(String collectionId) {
        }

        private synchronized void docFinished() {
            GlobalSystem.this.finishedDocCount++;
        }

        public void asyncAnchorTextStarted() {
        }

        public void indexRebuild() {
        }

        public void indexUpdated(String collectionId) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum BranchType {
        Web;

    }
}

