/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.supa.server.messageClient.internal;

import com.ibm.teamz.supa.server.common.v1.IMessage;
import com.ibm.teamz.supa.server.common.v1.messages.IKeepAliveMessage;
import com.ibm.teamz.supa.server.messageClient.IMessageHandler;
import com.ibm.teamz.supa.server.messageClient.IThrowableHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SafeMessageHandler<T extends IMessage>
implements IMessageHandler<T> {
    private volatile IThrowableHandler throwableHandler;

    public SafeMessageHandler() {
    }

    public SafeMessageHandler(IThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }

    public IThrowableHandler getThrowableHandler() {
        return this.throwableHandler;
    }

    public void setThrowableHandler(IThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }

    @Override
    public final boolean handle(T message) {
        block5: {
            if (message == null) {
                return true;
            }
            IThrowableHandler handler = this.throwableHandler;
            try {
                if (!IKeepAliveMessage.class.isAssignableFrom(message.getClass())) break block5;
                return true;
            }
            catch (Throwable t) {
                if (handler != null) {
                    handler.handleThrowable(t, (IMessage)message);
                }
                return false;
            }
        }
        this.internalHandle(message);
        return true;
    }

    protected abstract void internalHandle(T var1);
}

