/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.supa.server.messageClient.internal;

import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.teamz.supa.server.common.v1.IMessage;
import com.ibm.teamz.supa.server.common.v1.ISUPAService;
import com.ibm.teamz.supa.server.internal.common.GenericServiceProvider;
import com.ibm.teamz.supa.server.messageClient.ISUPAServiceMessageClientLibrary;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SUPAServiceMessageClientLibrary
implements ISUPAServiceMessageClientLibrary {
    private final IClientLibraryContext context;
    private ISUPAService service;

    public SUPAServiceMessageClientLibrary(IClientLibraryContext context) {
        this.context = context;
    }

    protected IClientLibraryContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISUPAService getService() throws TeamRepositoryException {
        if (this.service != null) {
            return this.service;
        }
        SUPAServiceMessageClientLibrary sUPAServiceMessageClientLibrary = this;
        synchronized (sUPAServiceMessageClientLibrary) {
            if (this.service != null) {
                return this.service;
            }
            final ISUPAService supaService = (ISUPAService)this.context.getServiceInterface(ISUPAService.class);
            if (supaService == null) {
                throw new TeamRepositoryException("Unable to get ISUPAServerService");
            }
            this.service = (ISUPAService)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ISUPAService.class}, new InvocationHandler(){

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    String[] classNames = GenericServiceProvider.getClassNames((Method)method);
                    String stringArgs = GenericServiceProvider.encodeArgs((Object[])args);
                    String encResult = supaService.call(method.getName(), classNames, stringArgs);
                    return GenericServiceProvider.decodeObject((String)encResult);
                }
            });
        }
        return this.service;
    }

    public void login(int maxVersionSupported, String identifier) throws TeamRepositoryException {
        this.getService().login(maxVersionSupported, identifier);
    }

    public void logout() throws TeamRepositoryException {
        this.getService().logout();
    }

    public List<? extends IMessage> fetchAllAvailable() throws TeamRepositoryException {
        return this.getService().fetchAllAvailable();
    }

    public IMessage fetchNext() throws TeamRepositoryException {
        return this.getService().fetchNext();
    }

    public boolean isAvailable() throws TeamRepositoryException {
        return this.getService().isAvailable();
    }

    public void responseCompleted(long msgId, boolean processedOk) throws TeamRepositoryException {
        this.getService().responseCompleted(msgId, processedOk);
    }
}

