/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.supa.server.messageClient.internal;

import com.ibm.teamz.supa.server.common.v1.IMessage;
import com.ibm.teamz.supa.server.messageClient.IMessageHandler;
import com.ibm.teamz.supa.server.messageClient.internal.SafeMessageHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoutingMessageHandler
extends SafeMessageHandler<IMessage> {
    private Map<String, List<IMessageHandler<? extends IMessage>>> handlers = Collections.synchronizedMap(new HashMap());

    public synchronized <T extends IMessage> void registerHandler(Class<T> clazz, IMessageHandler<T> handler) {
        List<IMessageHandler<IMessage>> list = this.getHandlersList(clazz);
        if (list == null) {
            list = new ArrayList<IMessageHandler<IMessage>>();
            this.handlers.put(clazz.getName(), list);
        }
        list.add(handler);
    }

    public synchronized <T extends IMessage> void deregisterHandler(Class<T> clazz, IMessageHandler<T> handler) {
        List<IMessageHandler<IMessage>> list = this.getHandlersList(clazz);
        if (list != null) {
            list.remove(handler);
        }
    }

    private <T extends IMessage> List<IMessageHandler<? extends IMessage>> getHandlersList(Class<T> clazz) {
        String key = clazz.getName();
        List<IMessageHandler<? extends IMessage>> list = this.handlers.get(key);
        return list;
    }

    public synchronized <T extends IMessage> void deregisterAll(Class<T> clazz) {
        this.handlers.remove(clazz.getName());
    }

    public synchronized <T extends IMessage> void deregisterAll() {
        this.handlers.clear();
    }

    @Override
    public synchronized void internalHandle(IMessage message) {
        if (message == null) {
            return;
        }
        HashSet<Class<IMessage>> classes = new HashSet<Class<IMessage>>();
        this.getAllInterfaces(message.getClass(), classes);
        for (Class<IMessage> c : classes) {
            List<IMessageHandler<IMessage>> list = this.getHandlersList(c);
            if (list == null) continue;
            for (IMessageHandler<IMessage> handler : list) {
                handler.handle(message);
            }
        }
    }

    private void getAllInterfaces(Class clazz, Set<Class<IMessage>> classes) {
        Class<?>[] clazzes;
        Class<?>[] classArray = clazzes = clazz.getInterfaces();
        int n = clazzes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> nClass = classArray[n2];
            if (IMessage.class.isAssignableFrom(nClass) && classes.add(nClass)) {
                this.getAllInterfaces(nClass, classes);
            }
            ++n2;
        }
    }
}

