/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.supa.server.messageClient.internal;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.teamz.supa.server.common.v1.IMessage;
import com.ibm.teamz.supa.server.common.v1.ISUPAMessageService;
import com.ibm.teamz.supa.server.messageClient.IThrowableHandler;
import com.ibm.teamz.supa.server.messageClient.internal.ExecutorServiceMessageHandler;
import com.ibm.teamz.supa.server.messageClient.internal.MessageLoop;
import com.ibm.teamz.supa.server.messageClient.internal.RoutingMessageHandler;
import com.ibm.teamz.supa.server.messageClient.internal.RunnableMessageHandler;
import com.ibm.teamz.supa.server.messageClient.internal.RunnableMessageHandlerFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageRouter
extends RoutingMessageHandler {
    private MessageLoop messageLoop;
    private ExecutorServiceMessageHandler<IMessage> serviceHandler;
    private ISUPAMessageService messageService;
    private AtomicBoolean autoRespond;
    private Thread loopThread;

    public MessageRouter(ISUPAMessageService messageService) {
        this.messageService = messageService;
        this.messageLoop = new MessageLoop(messageService);
        this.autoRespond = new AtomicBoolean(false);
    }

    public boolean isAutoRespond() {
        return this.autoRespond.get();
    }

    public void setAutoRespond(boolean autoRespond) {
        this.autoRespond.set(autoRespond);
    }

    public boolean isBatchFetch() {
        return this.messageLoop.isBatchFetch();
    }

    public void setBatchFetch(boolean batchFetch) {
        this.messageLoop.setBatchFetch(batchFetch);
    }

    @Override
    public void setThrowableHandler(IThrowableHandler throwableHandler) {
        super.setThrowableHandler(throwableHandler);
        this.messageLoop.setThrowableHandler(throwableHandler);
    }

    private ExecutorServiceMessageHandler<IMessage> createServiceHandler() {
        ExecutorServiceMessageHandler<IMessage> result = new ExecutorServiceMessageHandler<IMessage>();
        ExecutorService execService = Executors.newCachedThreadPool(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread tResult = new Thread(r);
                tResult.setDaemon(true);
                return tResult;
            }
        });
        result.setExecService(execService);
        result.setHandlerFactory(new RunnableMessageHandlerFactory(){

            @Override
            public <T extends IMessage> RunnableMessageHandler<T> createHandler(T message) {
                return new RunnableMessageHandler<T>(message){

                    @Override
                    public boolean handle(T message) {
                        boolean result = MessageRouter.this.handle(message);
                        try {
                            if (MessageRouter.this.autoRespond.get()) {
                                MessageRouter.this.messageService.responseCompleted(message.getId().longValue(), result);
                            }
                        }
                        catch (TeamRepositoryException teamRepositoryException) {}
                        return result;
                    }
                };
            }
        });
        return result;
    }

    public boolean isRunning() {
        return this.loopThread != null && this.loopThread.isAlive();
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.loopThread = new Thread(this.messageLoop);
        this.loopThread.setName("MessageLoop");
        this.serviceHandler = this.createServiceHandler();
        this.messageLoop.deregisterAll();
        this.messageLoop.registerHandler(IMessage.class, this.serviceHandler);
        this.messageLoop.setActive(true);
        this.loopThread.setDaemon(true);
        this.loopThread.start();
    }

    public void startShutdown() {
        this.startShutdown(false);
    }

    public void startShutdown(boolean force) {
        this.messageLoop.setActive(false);
        if (this.serviceHandler != null) {
            ExecutorService service = this.serviceHandler.getExecService();
            if (force) {
                service.shutdownNow();
            } else {
                service.shutdown();
            }
        }
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) {
        if (this.serviceHandler == null) {
            return true;
        }
        ExecutorService execService = this.serviceHandler.getExecService();
        if (execService.isTerminated()) {
            return true;
        }
        try {
            return execService.awaitTermination(timeout, unit);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }
}

