/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.supa.server.messageClient.internal;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.teamz.supa.server.common.v1.IMessage;
import com.ibm.teamz.supa.server.common.v1.ISUPAMessageService;
import com.ibm.teamz.supa.server.messageClient.IThrowableHandler;
import com.ibm.teamz.supa.server.messageClient.internal.RoutingMessageHandler;
import java.util.List;

public class MessageLoop
extends RoutingMessageHandler
implements Runnable {
    private final ISUPAMessageService messageService;
    private volatile boolean batchFetch;
    private volatile boolean active;
    private boolean fastExitBatch;

    public MessageLoop(ISUPAMessageService messageService) {
        this.messageService = messageService;
        this.active = true;
        this.batchFetch = false;
        this.fastExitBatch = true;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isBatchFetch() {
        return this.batchFetch;
    }

    public void setBatchFetch(boolean batchFetch) {
        this.batchFetch = batchFetch;
    }

    public boolean isFastExitBatch() {
        return this.fastExitBatch;
    }

    public void setFastExitBatch(boolean fastExitBatch) {
        this.fastExitBatch = fastExitBatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.active) {
            try {
                if (this.batchFetch) {
                    List messages = this.messageService.fetchAllAvailable();
                    MessageLoop messageLoop = this;
                    synchronized (messageLoop) {
                        for (IMessage message : messages) {
                            if (this.fastExitBatch && !this.active) break;
                            this.loopHandle(message);
                        }
                        continue;
                    }
                }
                this.loopHandle(this.messageService.fetchNext());
            }
            catch (Throwable t) {
                this.handleThrowable(t);
            }
        }
    }

    private void loopHandle(IMessage message) throws TeamRepositoryException {
        try {
            try {
                this.handle(message);
                this.processedOk(message);
            }
            catch (Throwable t) {
                this.handleThrowable(t);
            }
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
    }

    private void handleThrowable(Throwable t) {
        IThrowableHandler handler = this.getThrowableHandler();
        if (handler != null) {
            handler.handleThrowable(t);
        }
    }

    protected void processedOk(IMessage message) throws TeamRepositoryException {
    }
}

