/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.teamz.supa.server.messageClient.internal;

import com.ibm.teamz.supa.server.common.v1.IMessage;
import com.ibm.teamz.supa.server.messageClient.IMessageHandler;
import com.ibm.teamz.supa.server.messageClient.internal.RunnableMessageHandlerFactory;
import java.util.concurrent.ExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorServiceMessageHandler<T extends IMessage>
implements IMessageHandler<T> {
    private ExecutorService execService;
    private RunnableMessageHandlerFactory handlerFactory;

    public ExecutorServiceMessageHandler() {
    }

    public ExecutorServiceMessageHandler(ExecutorService execService, RunnableMessageHandlerFactory handlerFactory) {
        this.execService = execService;
        this.handlerFactory = handlerFactory;
    }

    public ExecutorService getExecService() {
        return this.execService;
    }

    public void setExecService(ExecutorService execService) {
        this.execService = execService;
    }

    public RunnableMessageHandlerFactory getHandlerFactory() {
        return this.handlerFactory;
    }

    public void setHandlerFactory(RunnableMessageHandlerFactory handlerFactory) {
        this.handlerFactory = handlerFactory;
    }

    @Override
    public boolean handle(T message) {
        if (!this.execService.isShutdown()) {
            this.execService.submit(this.handlerFactory.createHandler(message));
        }
        return true;
    }
}

