/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.annotator.util.text.location;

import com.ibm.supa.annotator.util.text.location.CharOffsetLocation;
import com.ibm.supa.annotator.util.text.location.Interval;
import com.ibm.supa.annotator.util.text.location.Location;

public class IntervalImpl
implements Interval {
    private Location mStart;
    private Location mEnd;

    public static IntervalImpl createWithCharoffsets(int start, int end) {
        return new IntervalImpl(new CharOffsetLocation(start), new CharOffsetLocation(end));
    }

    public IntervalImpl(Location start, Location end) {
        this.mEnd = end;
        this.mStart = start;
    }

    public Location getStart() {
        return this.mStart;
    }

    public Location getEnd() {
        return this.mEnd;
    }

    public boolean fullIncludes(Interval otherInterval) {
        boolean result;
        boolean bl = result = this.mStart.before(otherInterval.getStart()) || this.mStart.equals(otherInterval.getStart());
        if (result) {
            result = this.mEnd.after(otherInterval.getEnd()) || this.mEnd.equals(otherInterval.getEnd());
        }
        return result;
    }

    public boolean intersects(Interval otherInterval) {
        if (this.mStart.after(otherInterval.getStart()) || this.mStart.equals(otherInterval.getStart())) {
            return this.mEnd.after(otherInterval.getEnd()) || this.mEnd.equals(otherInterval.getEnd());
        }
        return this.mEnd.before(otherInterval.getEnd()) || this.mEnd.equals(otherInterval.getEnd());
    }
}

