/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.annotator.util.text.location;

import com.ibm.supa.annotator.util.text.location.Location;

public class CharOffsetLocation
implements Location {
    private int mOffset;

    public CharOffsetLocation(int offset) {
        this.mOffset = offset;
    }

    public boolean after(Location loc) throws UnsupportedOperationException {
        if (!(loc instanceof CharOffsetLocation)) {
            throw new UnsupportedOperationException("Location is not of same type");
        }
        CharOffsetLocation otherLoc = (CharOffsetLocation)loc;
        return this.mOffset > otherLoc.getOffset();
    }

    public boolean before(Location loc) throws UnsupportedOperationException {
        if (!(loc instanceof CharOffsetLocation)) {
            throw new UnsupportedOperationException("Location is not of same type");
        }
        CharOffsetLocation otherLoc = (CharOffsetLocation)loc;
        return this.mOffset < otherLoc.getOffset();
    }

    public boolean equals(Location loc) throws UnsupportedOperationException {
        if (!(loc instanceof CharOffsetLocation)) {
            throw new UnsupportedOperationException("Location is not of same type");
        }
        CharOffsetLocation otherLoc = (CharOffsetLocation)loc;
        return this.mOffset == otherLoc.getOffset();
    }

    public int getOffset() {
        return this.mOffset;
    }
}

