/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.annotator.util;

import com.ibm.supa.annotator.annotators.AnnotatorExceptionUtil;
import com.ibm.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeEntryUtil {
    public static int amountOfGroupsInExpandedRuleExp(CharSequence ruleExp) {
        int amountOfGroups = 0;
        int characterClasseDepth = 0;
        int i = 0;
        while (i < ruleExp.length() - 1) {
            char curChar = ruleExp.charAt(i);
            if (curChar == '[' && !TypeEntryUtil.isEscaped(ruleExp, i)) {
                ++characterClasseDepth;
            }
            if (curChar == ']' && !TypeEntryUtil.isEscaped(ruleExp, i)) {
                --characterClasseDepth;
            }
            if (characterClasseDepth <= 0 && curChar == '(' && !TypeEntryUtil.isEscaped(ruleExp, i) && ruleExp.charAt(i + 1) != '+' && ruleExp.charAt(i + 1) != '?') {
                ++amountOfGroups;
            }
            ++i;
        }
        return amountOfGroups;
    }

    public static Pattern compileExpandedRule(String patternString) throws AnnotatorConfigurationException {
        Pattern pattern = null;
        if (patternString.indexOf("(++") == -1) {
            try {
                pattern = Pattern.compile(patternString);
                if (pattern.matcher("").matches()) {
                    throw AnnotatorExceptionUtil.getConf("regex matches empty string", patternString);
                }
            }
            catch (PatternSyntaxException e) {
                throw AnnotatorExceptionUtil.getConf("regex syntax error", (Object)patternString, (Exception)e);
            }
        }
        return pattern;
    }

    public static List<String> parseOPSConfigCommandToElements(String opsConfig) throws AnnotatorConfigurationException {
        if (opsConfig == null) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        Pattern typesAndLabelsP = Pattern.compile("\\[(.*?)(?<!')\\]");
        Pattern patternsP = Pattern.compile("\\[(.*)\\]");
        Matcher matcher = typesAndLabelsP.matcher(opsConfig);
        matcher.find();
        String typesConf = matcher.group(1);
        res.add(typesConf);
        matcher.find();
        String labelConf = matcher.group(1);
        res.add(labelConf);
        String opsConfigSuffix = opsConfig.substring(matcher.end(1));
        matcher = patternsP.matcher(opsConfigSuffix);
        matcher.find();
        String patternsConf = matcher.group(1);
        res.add(patternsConf);
        return res;
    }

    public static List<String> parseOPSTypeConfigToFeatureStructures(String opsTypeConfig) throws AnnotatorConfigurationException {
        if (opsTypeConfig == null) {
            return null;
        }
        if ((opsTypeConfig = opsTypeConfig.trim()).charAt(0) != '(' || opsTypeConfig.charAt(opsTypeConfig.length() - 1) != ')') {
            throw AnnotatorExceptionUtil.getConf("ops type config must start with ( and end with )");
        }
        ArrayList<String> res = new ArrayList<String>();
        Pattern featureStructureSep = Pattern.compile("\\((.*?)\\)");
        Matcher matcher = featureStructureSep.matcher(opsTypeConfig);
        while (matcher.find()) {
            res.add(matcher.group(1).trim());
        }
        return res;
    }

    public static String[] toStringArray(List<String> list) {
        return list == null ? null : list.toArray(new String[list.size()]);
    }

    public static Boolean[] toBooleanArray(List<Boolean> list) {
        return list == null ? null : list.toArray(new Boolean[list.size()]);
    }

    private static boolean isEscaped(CharSequence charSeq, int curCharIndex) {
        if (curCharIndex == 0) {
            return false;
        }
        int escapeCharCounter = 0;
        int i = curCharIndex - 1;
        while (i >= 0) {
            if (charSeq.charAt(i) == '\\') {
                ++escapeCharCounter;
            } else {
                return escapeCharCounter % 2 != 0;
            }
            --i;
        }
        return escapeCharCounter % 2 != 0;
    }
}

