/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.annotator.util;

import com.ibm.supa.type.InputDocInfo;
import com.ibm.uima.analysis_engine.annotator.AnnotatorContext;
import com.ibm.uima.analysis_engine.annotator.AnnotatorContextException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorInitializationException;
import com.ibm.uima.cas.CAS;
import com.ibm.uima.cas.CASException;
import com.ibm.uima.cas.FSIterator;
import com.ibm.uima.cas.FSMatchConstraint;
import com.ibm.uima.cas.FSTypeConstraint;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.jcas.impl.JCas;

public class AnnotatorUtil {
    public static InputDocInfo getInputDocInfo(JCas pCas) {
        FSIterator it = pCas.getJFSIndexRepository().getAnnotationIndex(InputDocInfo.type).iterator();
        if (it.hasNext()) {
            return (InputDocInfo)((Object)it.next());
        }
        return null;
    }

    public static boolean isAnyAnnotationExists(CAS aCas, String[] types) throws CASException {
        JCas jcas = aCas.getJCas();
        FSIterator iter = jcas.getJFSIndexRepository().getAnnotationIndex().iterator();
        FSTypeConstraint constraint = aCas.getConstraintFactory().createTypeConstraint();
        int i = 0;
        while (i < types.length) {
            constraint.add(types[i]);
            ++i;
        }
        FSIterator filteredIter = aCas.createFilteredIterator(iter, (FSMatchConstraint)constraint);
        return filteredIter.hasNext();
    }

    public static Boolean getBooleanConfigParamValue(AnnotatorContext ctx, String groupName, String paramName) throws AnnotatorContextException {
        Boolean result = (Boolean)ctx.getConfigParameterValue(groupName, paramName);
        if (result == null) {
            return Boolean.FALSE;
        }
        return result;
    }

    public static Type[][] namesToCASTypes(String annotatorClass, TypeSystem typeSystem, String[][] typeNames, boolean allowNullTypenames) throws AnnotatorInitializationException {
        Type[][] result = new Type[typeNames.length][];
        int i = 0;
        while (i < typeNames.length) {
            result[i] = AnnotatorUtil.namesToCASTypes(annotatorClass, typeSystem, typeNames[i], allowNullTypenames);
            ++i;
        }
        return result;
    }

    public static Type[] namesToCASTypes(String annotatorClass, TypeSystem typeSystem, String[] typeNames, boolean allowNullTypenames) throws AnnotatorInitializationException {
        if (typeNames == null) {
            return null;
        }
        Type[] result = new Type[typeNames.length];
        int i = 0;
        while (i < result.length) {
            result[i] = AnnotatorUtil.nameToCASType(annotatorClass, typeSystem, typeNames[i], allowNullTypenames);
            ++i;
        }
        return result;
    }

    public static Type nameToCASType(String annotatorClass, TypeSystem typeSystem, String typeName, boolean allowNullTypename) throws AnnotatorInitializationException {
        Type result = null;
        if (typeName == null) {
            if (allowNullTypename) {
                return null;
            }
        } else {
            result = typeSystem.getType(typeName);
        }
        if (result == null) {
            throw new AnnotatorInitializationException("annotator_ex_type_not_found", new Object[]{annotatorClass, typeName});
        }
        return result;
    }
}

