/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.annotator.annotators;

import com.ibm.supa.annotator.annotators.AnnotatorExceptionUtil;
import com.ibm.supa.annotator.annotators.TextInUse;
import com.ibm.supa.annotator.util.AnnotatorUtil;
import com.ibm.supa.annotator.util.TypeEntryUtil;
import com.ibm.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorContext;
import com.ibm.uima.analysis_engine.annotator.AnnotatorContextException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorInitializationException;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.TypeSystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class TypeEntry {
    public final PatternInfo[] mPatternsInfo;
    public final Type mCasType;
    public final boolean mRunTillNoAnnotationsAdded;
    public final Type mStartingCasType;
    public final LimittingCASType[] mLimittingCasTypes;
    public final StackInfo mStackInfo;
    public final FilteringCASType[] mFilteringCasTypes;
    public final boolean mFilterIsAncestorOfType;
    public final FilteringPattern[] mFilteringPatterns;
    public final PatternInfo mFirstScanPattern;
    public final String mSaveFilteredTextName;
    public final String mLoadFilteredTextName;
    public final boolean mRecalcScanPatterns;
    public final boolean mMultipleTypeMode;
    public final OnePassConfiguration mOnePassConfiguration;

    public TypeEntry(PatternInfo[] patternsInfo, Type casType, boolean runTillNoAnnotationsAdded, Type startingCasType, LimittingCASType[] limittingCasTypes, StackInfo stackInfo, FilteringCASType[] filteringCasTypes, boolean filterIsAncestorOfType, FilteringPattern[] filteringPatterns, PatternInfo firstScanPattern, String saveFilteredTextName, String loadFilteredTextName, boolean recalcScanPatterns, boolean multipleTypeMode, OnePassConfiguration onePassConfiguration) {
        this.mPatternsInfo = patternsInfo;
        this.mCasType = casType;
        this.mRunTillNoAnnotationsAdded = runTillNoAnnotationsAdded;
        this.mStartingCasType = startingCasType;
        this.mLimittingCasTypes = limittingCasTypes;
        this.mStackInfo = stackInfo;
        this.mFilteringCasTypes = filteringCasTypes;
        this.mFilterIsAncestorOfType = filterIsAncestorOfType;
        this.mFilteringPatterns = filteringPatterns;
        this.mFirstScanPattern = firstScanPattern;
        this.mSaveFilteredTextName = saveFilteredTextName;
        this.mLoadFilteredTextName = loadFilteredTextName;
        this.mRecalcScanPatterns = recalcScanPatterns;
        this.mMultipleTypeMode = multipleTypeMode;
        this.mOnePassConfiguration = onePassConfiguration;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory {
        private final Logger mLogger;
        private Builder[] mBuilders;

        public Factory(Logger logger, String pFileType, TypeSystem pTypeSystem, AnnotatorContext pCtx, File pBaseDir) throws AnnotatorConfigurationException, AnnotatorContextException, AnnotatorInitializationException {
            this.mLogger = logger;
            this.loadPatternConfig(pFileType, pCtx, pBaseDir);
            this.initTypeSystem(pTypeSystem);
            this.buildStackPatterns();
            this.buildFilteringPatterns();
            this.buildFirstScanPattern();
            this.buildOnePassConfiguration(pTypeSystem);
            this.checkEntriesValidity();
        }

        public TypeEntry[] buildTypeEntries() {
            TypeEntry[] result = new TypeEntry[this.mBuilders.length];
            int i = 0;
            while (i < result.length) {
                result[i] = this.mBuilders[i].build();
                ++i;
            }
            return result;
        }

        void initTypeSystem(TypeSystem pTypeSystem) throws AnnotatorInitializationException {
            int i = 0;
            while (i < this.mBuilders.length) {
                this.mBuilders[i].initTypeSystem(pTypeSystem);
                this.mBuilders[i].checkIfFilterIsAncestorOfType(pTypeSystem);
                ++i;
            }
        }

        void buildStackPatterns() throws AnnotatorConfigurationException {
            int i = 0;
            while (i < this.mBuilders.length) {
                if (this.mBuilders[i].needStack) {
                    this.mBuilders[i].buildStackPatterns();
                }
                ++i;
            }
        }

        void buildFilteringPatterns() throws AnnotatorConfigurationException {
            int i = 0;
            while (i < this.mBuilders.length) {
                this.mBuilders[i].buildFilteringPatterns();
                ++i;
            }
        }

        void buildFirstScanPattern() throws AnnotatorConfigurationException {
            int i = 0;
            while (i < this.mBuilders.length) {
                this.mBuilders[i].buildFirstScanPattern();
                ++i;
            }
        }

        void buildOnePassConfiguration(TypeSystem pTypeSystem) throws AnnotatorConfigurationException, AnnotatorInitializationException {
            int i = 0;
            while (i < this.mBuilders.length) {
                this.mBuilders[i].buildOnePassConfiguration(pTypeSystem);
                ++i;
            }
        }

        void checkEntriesValidity() throws AnnotatorConfigurationException {
            int i = 0;
            while (i < this.mBuilders.length) {
                this.mBuilders[i].checkEntryValidity(i);
                ++i;
            }
        }

        private void loadPatternConfig(String pFileType, AnnotatorContext pCtx, File pBaseDir) throws AnnotatorContextException, AnnotatorConfigurationException {
            String[] patternStrings = (String[])pCtx.getConfigParameterValue(pFileType, "Patterns");
            String[] typeNames = (String[])pCtx.getConfigParameterValue(pFileType, "TypeNames");
            String patternFile = (String)pCtx.getConfigParameterValue(pFileType, "PatternFile");
            if (patternStrings != null && (typeNames == null || typeNames.length != patternStrings.length)) {
                throw AnnotatorExceptionUtil.getConf("type pattern array length mismatch");
            }
            if (patternStrings != null && patternStrings.length > 0) {
                this.mBuilders = new Builder[patternStrings.length];
                int i = 0;
                while (i < this.mBuilders.length) {
                    this.mBuilders[i] = new Builder(typeNames[i], patternStrings[i]);
                    ++i;
                }
            } else {
                ArrayList<Builder> buildersArray = new ArrayList<Builder>();
                this.readPatternsFromFile(pFileType, pBaseDir, patternFile, buildersArray);
                this.mBuilders = buildersArray.toArray(new Builder[buildersArray.size()]);
            }
            if (this.mBuilders.length == 0) {
                this.mLogger.warning("No pattern configuration found for group " + pFileType);
            }
            int i = 0;
            while (i < this.mBuilders.length) {
                this.mBuilders[i].buildPatternsInfo();
                ++i;
            }
        }

        private void addRule(String name, String value, HashMap<String, String> rules) throws AnnotatorConfigurationException {
            int openParentheses = name.indexOf("[");
            int closeParentheses = name.indexOf("]");
            if (openParentheses != -1 && closeParentheses != -1) {
                String ruleName = name.substring(0, openParentheses);
                String ruleNumberStr = name.substring(openParentheses + 1, closeParentheses);
                int ruleNumberInt = Integer.parseInt(ruleNumberStr);
                ruleNumberStr = Integer.toString(--ruleNumberInt);
                String nextNameInValue = "+" + ruleName + "[" + ruleNumberStr + "]";
                if (value.indexOf(nextNameInValue) != -1) {
                    String recursiveRule = "\\(\\+T\\[" + ruleNumberStr + "\\]\\)";
                    value = this.expandRule(value, recursiveRule, rules);
                    this.expandRecursiveRule(name, value, ruleName, ruleNumberStr, rules);
                } else if (rules.put(name, value = Builder.expandPattern(value, rules)) != null) {
                    this.mLogger.info("Rule redefined -  +" + name + ":\t" + value);
                }
            } else if (rules.put(name, value = Builder.expandPattern(value, rules)) != null) {
                this.mLogger.info("Rule redefined -  +" + name + ":\t" + value);
            }
        }

        private String expandRule(String rule, String recursiveRule, HashMap<String, String> rules) throws AnnotatorConfigurationException {
            Pattern recursiveRulePattern = Pattern.compile(recursiveRule);
            String nextToExpand = rule;
            String expandedPattern = "";
            StringBuffer expandedToReturnBuf = new StringBuffer();
            int loopCounter = 0;
            int matcherStart = 0;
            int matcherEnd = 0;
            int end = rule.length();
            int lastRecursiveRule = 0;
            while (loopCounter < 10000) {
                Matcher matcher = recursiveRulePattern.matcher(nextToExpand);
                if (!matcher.find()) break;
                matcherStart = matcher.start();
                matcherEnd = matcher.end();
                lastRecursiveRule += matcherEnd;
                expandedPattern = Builder.expandPattern(nextToExpand.substring(0, matcherStart), rules);
                expandedToReturnBuf.append(expandedPattern);
                expandedToReturnBuf.append(nextToExpand.substring(matcher.start(), matcherEnd));
                nextToExpand = nextToExpand.substring(matcherEnd, nextToExpand.length());
                ++loopCounter;
            }
            if (lastRecursiveRule != end) {
                expandedPattern = Builder.expandPattern(rule.substring(lastRecursiveRule, end), rules);
                expandedToReturnBuf.append(expandedPattern);
                return expandedToReturnBuf.toString();
            }
            return expandedToReturnBuf.toString();
        }

        private void expandRecursiveRule(String name, String value, String ruleName, String ruleNumberStr, HashMap<String, String> rules) throws AnnotatorConfigurationException {
            int ruleNumberInt;
            HashMap<String, String> recursiveRuleMap = new HashMap<String, String>();
            recursiveRuleMap.put(name, value);
            int i = ruleNumberInt = Integer.parseInt(ruleNumberStr);
            while (i > 0) {
                name = String.valueOf(ruleName) + "[" + ruleNumberStr + "]";
                String currentNameInValue = "\\+" + ruleName + "\\[" + ruleNumberStr + "\\]";
                ruleNumberStr = Integer.toString(--ruleNumberInt);
                String nextNameInValue = "\\+" + ruleName + "\\[" + ruleNumberStr + "\\]";
                value = value.replaceAll(currentNameInValue, nextNameInValue);
                recursiveRuleMap.put(name, value);
                --i;
            }
            name = String.valueOf(ruleName) + "[" + ruleNumberStr + "]";
            if (rules.containsKey(name)) {
                recursiveRuleMap.put(name, rules.get(name));
            } else {
                recursiveRuleMap.put(name, " ");
            }
            i = 1;
            while (i < recursiveRuleMap.size()) {
                name = String.valueOf(ruleName) + "[" + Integer.toString(i) + "]";
                value = (String)recursiveRuleMap.get(name);
                value = Builder.expandPattern(value, recursiveRuleMap);
                recursiveRuleMap.put(name, value);
                ++i;
            }
            if (rules.put(name, (String)recursiveRuleMap.get(name)) != null) {
                this.mLogger.info("Rule redefined -  +" + name + ":\t" + value);
            }
        }

        private boolean checkName(String name) {
            Pattern namePattern = Pattern.compile("\\A[_a-zA-Z][_a-zA-Z0-9]*(\\[[0-9]+\\])?\\z");
            Matcher matcher = namePattern.matcher(name);
            return matcher.find();
        }

        private void readPatternsFromFile(String pFileType, File pBaseDir, String pPatternFile, ArrayList<Builder> pBuildersArray) throws AnnotatorConfigurationException {
            if (pPatternFile == null) {
                return;
            }
            String url = pPatternFile.trim();
            if (url.length() == 0) {
                return;
            }
            File urlFile = pBaseDir == null ? new File(url) : new File(pBaseDir, url);
            HashMap<String, String> rules = new HashMap<String, String>();
            BufferedReader reader = null;
            try {
                try {
                    Builder current = null;
                    reader = new BufferedReader(new FileReader(urlFile.getAbsolutePath()));
                    String line = reader.readLine();
                    boolean pushIncludeFlag = false;
                    boolean pushLineEncountered = false;
                    boolean multiLineComment = false;
                    int multiLineCommentOpenCloseCounter = 0;
                    while (line != null) {
                        if (!line.startsWith("#") && line.length() > 0 && !Character.isWhitespace(line.charAt(0))) {
                            if (multiLineComment) {
                                if (line.startsWith("--#")) {
                                    if (--multiLineCommentOpenCloseCounter < 0) {
                                        multiLineCommentOpenCloseCounter = 0;
                                    }
                                    if (multiLineCommentOpenCloseCounter == 0) {
                                        multiLineComment = false;
                                    }
                                }
                            } else if (!line.startsWith("--#")) {
                                if (line.startsWith("%") || line.startsWith("*") || line.startsWith("~") || line.startsWith("^")) {
                                    int index = line.indexOf(":");
                                    pushLineEncountered = false;
                                    current = index != -1 ? new Builder(line.substring(1, index).trim()) : new Builder(line.substring(1).trim());
                                    if (current.typeName.equals("MULTIPLE_TYPES_MODE")) {
                                        current.multipleTypeMode = true;
                                    }
                                    if (!current.multipleTypeMode && line.startsWith("^")) {
                                        throw AnnotatorExceptionUtil.getConf("Multiple types entries must start with ^", line);
                                    }
                                    pBuildersArray.add(current);
                                    if (index != -1) {
                                        String[] patternsTypeGroup = line.substring(index + 1).trim().split(",");
                                        int i = 0;
                                        while (i < patternsTypeGroup.length) {
                                            patternsTypeGroup[i] = patternsTypeGroup[i].trim();
                                            if (patternsTypeGroup[i].compareTo("") != 0) {
                                                current.typeGroupsForPatterns.add(new Integer(patternsTypeGroup[i]));
                                            } else {
                                                current.typeGroupsForPatterns.add(new Integer(1));
                                            }
                                            ++i;
                                        }
                                    }
                                    if (line.startsWith("*")) {
                                        current.runTillNoAnnotationsAdded = true;
                                        current.filteringTypeNames.add(current.typeName);
                                        current.filteringTypeReplacements.add("");
                                    }
                                    if (line.startsWith("~")) {
                                        current.runTillNoAnnotationsAdded = true;
                                        current.filteringTypeNames.add(current.typeName);
                                        current.filteringTypeReplacements.add(" ");
                                    }
                                } else if (line.startsWith("@")) {
                                    if (line.startsWith("@@")) {
                                        String featureGroupConfigStr;
                                        int colonLastIndex;
                                        int colonFirstIndex = line.indexOf(":");
                                        if (colonFirstIndex != (colonLastIndex = line.lastIndexOf(":"))) {
                                            if (colonFirstIndex == -1 || colonFirstIndex == line.length() - 1 || colonLastIndex == -1 || colonLastIndex == line.length() - 1) {
                                                throw AnnotatorExceptionUtil.getConf("badly formed feature group config", line);
                                            }
                                            String featureName = line.substring(2, colonFirstIndex).trim();
                                            featureGroupConfigStr = line.substring(colonFirstIndex + 1, colonLastIndex).trim();
                                            String filteredInstance = line.substring(colonLastIndex + 1).trim();
                                            current.featuresConfig.put(featureName, new EntryFeatureConfig(featureGroupConfigStr, TextInUse.FilteredInstance, filteredInstance));
                                        } else {
                                            if (colonFirstIndex == -1 || colonFirstIndex == line.length() - 1 || colonLastIndex == -1 || colonLastIndex == line.length() - 1) {
                                                throw AnnotatorExceptionUtil.getConf("badly formed feature group config", line);
                                            }
                                            String featureName = line.substring(2, colonFirstIndex).trim();
                                            featureGroupConfigStr = line.substring(colonFirstIndex + 1).trim();
                                            current.featuresConfig.put(featureName, new EntryFeatureConfig(featureGroupConfigStr, TextInUse.CurFiltered, null));
                                        }
                                    } else {
                                        int colonIndex = line.indexOf(":");
                                        if (colonIndex == -1 || colonIndex == line.length() - 1) {
                                            throw AnnotatorExceptionUtil.getConf("badly formed feature group config", line);
                                        }
                                        String featureName = line.substring(1, colonIndex).trim();
                                        String featureGroupConfigStr = line.substring(colonIndex + 1).trim();
                                        current.featuresConfig.put(featureName, new EntryFeatureConfig(featureGroupConfigStr, TextInUse.Original, null));
                                    }
                                } else if (line.startsWith("?")) {
                                    current.startingTypeName = line.substring(1).trim();
                                } else if (line.startsWith("FIRST_SCAN")) {
                                    Pattern commandP = Pattern.compile("FIRST_SCAN(?:\\(([0-9]+)\\))?:");
                                    Matcher commandM = commandP.matcher(line);
                                    commandM.find();
                                    String groupNum = new String("1");
                                    if (commandM.group(1) != null) {
                                        groupNum = line.substring(commandM.start(1), commandM.end(1));
                                    }
                                    line = line.replaceFirst("FIRST_SCAN(?:\\([0-9]+\\))?:\\s*", "");
                                    line = line.trim();
                                    current.firstScanCapturedGroup = new Integer(groupNum);
                                    current.firstScanPatternString = line;
                                } else if (line.startsWith("DON'T_RECALC_DYNAMIC_PATTERNS")) {
                                    current.recalcScanPatterns = false;
                                } else if (line.startsWith("ERASE_RANGE:")) {
                                    line = line.replaceFirst("ERASE_RANGE:\\s*", "");
                                    current.eraseStackRange = (line = line.trim()).equals("TRUE") ? true : (line.equals("FALSE") ? false : false);
                                } else if (line.startsWith("PUSH:")) {
                                    pushLineEncountered = true;
                                    line = line.replaceFirst("PUSH:\\s*", "");
                                    current.pushPatternString = line = line.trim();
                                    pushIncludeFlag = false;
                                } else if (line.startsWith("PUSH_INCLUDE:")) {
                                    pushLineEncountered = true;
                                    line = line.replaceFirst("PUSH_INCLUDE:\\s*", "");
                                    current.pushPatternString = line = line.trim();
                                    pushIncludeFlag = true;
                                } else if (line.startsWith("POP:")) {
                                    if (pushLineEncountered) {
                                        current.needStack = true;
                                    }
                                    line = line.replaceFirst("POP:\\s*", "");
                                    current.popPatternString = line = line.trim();
                                    current.rangingMethod = pushIncludeFlag ? StackInfo.RangingMethod.PushInclude_Pop : StackInfo.RangingMethod.Push_Pop;
                                } else if (line.startsWith("POP_INCLUDE:")) {
                                    if (pushLineEncountered) {
                                        current.needStack = true;
                                    }
                                    line = line.replaceFirst("POP_INCLUDE:\\s*", "");
                                    current.popPatternString = line = line.trim();
                                    current.rangingMethod = pushIncludeFlag ? StackInfo.RangingMethod.PushInclude_PopInclude : StackInfo.RangingMethod.Push_PopInclude;
                                } else if (line.startsWith("=") || line.startsWith("!")) {
                                    if (line.length() > 1) {
                                        Boolean limitsEntireInterval = Boolean.FALSE;
                                        if (line.charAt(1) == '&') {
                                            current.limitations.add(LimittingCASType.Limitation.INTERSECT);
                                            limitsEntireInterval = Boolean.TRUE;
                                        } else if (line.charAt(1) == '<') {
                                            current.limitations.add(LimittingCASType.Limitation.START);
                                        } else if (line.charAt(1) == '>') {
                                            current.limitations.add(LimittingCASType.Limitation.END);
                                        } else if (line.charAt(1) == '-') {
                                            current.limitations.add(LimittingCASType.Limitation.WITHIN);
                                        } else if (line.charAt(1) == '+') {
                                            current.limitations.add(LimittingCASType.Limitation.WITHOUT);
                                        } else {
                                            throw AnnotatorExceptionUtil.getConf("undefined limitation requested", line);
                                        }
                                        current.limittingTypeNames.add(line.substring(2).trim());
                                        current.limitInclusives.add(line.startsWith("="));
                                        current.limitsEntireIntervals.add(limitsEntireInterval);
                                    }
                                } else if (line.startsWith("-")) {
                                    int index = line.lastIndexOf(":");
                                    if (index == -1 || index == line.length() - 1) {
                                        throw AnnotatorExceptionUtil.getConf("badly formed filtering request", line);
                                    }
                                    String replacedCharStr = "";
                                    if (line.startsWith("--")) {
                                        String filterPatternString = line.substring(2, index).trim();
                                        replacedCharStr = line.substring(index + 1).trim();
                                        if (!replacedCharStr.startsWith("'") || !replacedCharStr.endsWith("'") || replacedCharStr.length() < 2 || replacedCharStr.length() > 3) {
                                            throw AnnotatorExceptionUtil.getConf("badly formed filtering pattern request", line);
                                        }
                                        replacedCharStr = replacedCharStr.length() == 3 ? replacedCharStr.substring(1, 2) : "";
                                        current.filteringPatternStrings.add(filterPatternString);
                                        current.filteringPatternReplacements.add(replacedCharStr);
                                    } else {
                                        String filterCASTypeName = line.substring(1, index).trim();
                                        replacedCharStr = line.substring(index + 1).trim();
                                        if (!replacedCharStr.startsWith("'") || !replacedCharStr.endsWith("'") || replacedCharStr.length() < 2 || replacedCharStr.length() > 3) {
                                            throw AnnotatorExceptionUtil.getConf("badly formed filtering Cas type request", line);
                                        }
                                        replacedCharStr = replacedCharStr.length() == 3 ? replacedCharStr.substring(1, 2) : "";
                                        current.filteringTypeNames.add(filterCASTypeName);
                                        current.filteringTypeReplacements.add(replacedCharStr);
                                    }
                                } else if (line.startsWith(">")) {
                                    if (current.saveFilteredTextName != null) {
                                        this.mLogger.warning("multiple > lines found for entry " + current.typeName);
                                    }
                                    current.saveFilteredTextName = line.substring(1);
                                } else if (line.startsWith("<")) {
                                    if (current.loadFilteredTextName != null) {
                                        this.mLogger.warning("multiple < lines found for entry " + current.typeName);
                                    }
                                    current.loadFilteredTextName = line.substring(1);
                                } else if (line.startsWith("+")) {
                                    int index = line.indexOf(":");
                                    if (index == -1 || index == line.length() - 1) {
                                        throw AnnotatorExceptionUtil.getConf("badly formed rule", line);
                                    }
                                    String name = line.substring(1, index).trim();
                                    String value = line.substring(index + 1).trim();
                                    if (!this.checkName(name)) {
                                        throw AnnotatorExceptionUtil.getConf("The following is not a proper rule name", name);
                                    }
                                    this.addRule(name, value, rules);
                                } else if (line.startsWith("OPS_CONFIG:")) {
                                    current.onePassOriginalConfigStr.add(line);
                                    List<String> conf = TypeEntryUtil.parseOPSConfigCommandToElements(line.substring("OPS_CONFIG:".length()));
                                    String typeConf = conf.get(0);
                                    String labelConf = conf.get(1);
                                    String patternConf = conf.get(2);
                                    if (patternConf.trim().equals("")) {
                                        throw AnnotatorExceptionUtil.getConf("must have a pattern in one pass config");
                                    }
                                    if (labelConf.trim().equals("") || labelConf.trim().equals("SKIP")) {
                                        labelConf = null;
                                    } else {
                                        int index = labelConf.indexOf(":");
                                        if (index == -1) {
                                            throw AnnotatorExceptionUtil.getConf("badly formed ops command", line);
                                        }
                                    }
                                    if (typeConf.trim().equals("") || typeConf.trim().equals("DON'T ANNOTATE")) {
                                        typeConf = null;
                                    } else {
                                        int index = typeConf.indexOf(":");
                                        if (index == -1) {
                                            throw AnnotatorExceptionUtil.getConf("badly formed ops command", line);
                                        }
                                    }
                                    current.onePassTypesConfig.add(typeConf);
                                    current.onePassPatternStringsConfig.add(patternConf);
                                    current.onePassLabelConfig.add(labelConf);
                                    pushLineEncountered = false;
                                    current.expandPatterns(rules);
                                } else {
                                    current.patternStrings.add(line);
                                    pushLineEncountered = false;
                                    current.expandPatterns(rules);
                                }
                            }
                        }
                        if (line.startsWith("#--")) {
                            multiLineComment = true;
                            ++multiLineCommentOpenCloseCounter;
                        }
                        line = reader.readLine();
                    }
                }
                catch (FileNotFoundException ex) {
                    throw AnnotatorExceptionUtil.getConf("err file not found", (Object)pFileType, urlFile.getAbsolutePath());
                }
                catch (IOException ex) {
                    throw AnnotatorExceptionUtil.getConf("err file read", (Object)pFileType, urlFile.getAbsolutePath());
                }
            }
            catch (Throwable throwable) {
                this.closeFile(url, reader);
                throw throwable;
            }
            this.closeFile(url, reader);
        }

        private void closeFile(String fileName, BufferedReader pReader) {
            if (pReader != null) {
                try {
                    pReader.close();
                }
                catch (Exception ex) {
                    this.mLogger.log(Level.WARNING, "Failed to close file " + fileName, ex);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Builder {
            private static final String Multiple_types_name = "MULTIPLE_TYPES_MODE";
            private static final int sMAX_REPLACEMENTS = 10000;
            private static final Pattern sRULE_EXPR_PATTERN = Pattern.compile("\\(\\+(?!\\+)(.*?)\\)");
            String typeName;
            String startingTypeName;
            ArrayList<String> limittingTypeNames;
            ArrayList<LimittingCASType.Limitation> limitations;
            ArrayList<Boolean> limitInclusives;
            ArrayList<Boolean> limitsEntireIntervals;
            ArrayList<String> filteringTypeNames;
            ArrayList<String> filteringTypeReplacements;
            ArrayList<String> filteringPatternStrings;
            ArrayList<String> filteringPatternReplacements;
            String firstScanPatternString;
            int firstScanCapturedGroup;
            ArrayList<String> patternStrings;
            HashMap<String, EntryFeatureConfig> featuresConfig;
            ArrayList<Integer> typeGroupsForPatterns;
            String pushPatternString;
            String popPatternString;
            StackInfo.RangingMethod rangingMethod;
            boolean eraseStackRange;
            boolean needStack;
            String saveFilteredTextName;
            String loadFilteredTextName;
            List<String> onePassOriginalConfigStr;
            List<String> onePassTypesConfig;
            List<String> onePassPatternStringsConfig;
            List<String> onePassLabelConfig;
            boolean runTillNoAnnotationsAdded;
            boolean multipleTypeMode;
            Type casType;
            PatternInfo[] patternsInfo;
            Type startingCasType;
            Type[] nonIntersectingCasTypes;
            LimittingCASType[] limittingCasTypes;
            StackInfo stackInfo;
            FilteringCASType[] filteringCasTypes;
            boolean filterIsAncestorOfType;
            boolean recalcScanPatterns;
            OnePassConfiguration onePassConfiguration;
            FilteringPattern[] filteringPatterns;
            PatternInfo firstScanPatternInfo;
            Pattern pushPattern;
            Pattern popPattern;

            Builder(String typeName) {
                this(typeName, null);
            }

            Builder(String typeName, String pattern) {
                this.typeName = typeName;
                this.patternStrings = new ArrayList();
                this.featuresConfig = new HashMap();
                this.typeGroupsForPatterns = new ArrayList();
                if (pattern != null) {
                    this.patternStrings.add(pattern);
                }
                this.startingTypeName = null;
                this.needStack = false;
                this.limittingTypeNames = new ArrayList();
                this.limitations = new ArrayList();
                this.limitInclusives = new ArrayList();
                this.limitsEntireIntervals = new ArrayList();
                this.filteringTypeNames = new ArrayList();
                this.filteringTypeReplacements = new ArrayList();
                this.filterIsAncestorOfType = false;
                this.recalcScanPatterns = true;
                this.multipleTypeMode = false;
                this.onePassOriginalConfigStr = new ArrayList<String>();
                this.onePassTypesConfig = new ArrayList<String>();
                this.onePassPatternStringsConfig = new ArrayList<String>();
                this.onePassLabelConfig = new ArrayList<String>();
                this.filteringPatternStrings = new ArrayList();
                this.filteringPatternReplacements = new ArrayList();
                this.firstScanPatternString = null;
            }

            void expandPatterns(HashMap<String, String> rules) throws AnnotatorConfigurationException {
                if (this.patternStrings.size() == 0 && !this.multipleTypeMode) {
                    throw AnnotatorExceptionUtil.getConf("err type with no patterns", this.typeName);
                }
                int i = 0;
                while (i < this.patternStrings.size()) {
                    this.patternStrings.set(i, Builder.expandPattern(this.patternStrings.get(i), rules));
                    ++i;
                }
                i = 0;
                while (i < this.filteringPatternStrings.size()) {
                    this.filteringPatternStrings.set(i, Builder.expandPattern(this.filteringPatternStrings.get(i), rules));
                    ++i;
                }
                if (this.onePassPatternStringsConfig != null) {
                    i = 0;
                    while (i < this.onePassPatternStringsConfig.size()) {
                        this.onePassPatternStringsConfig.set(i, Builder.expandPattern(this.onePassPatternStringsConfig.get(i), rules));
                        ++i;
                    }
                }
                if (this.needStack) {
                    this.pushPatternString = Builder.expandPattern(this.pushPatternString, rules);
                    this.popPatternString = Builder.expandPattern(this.popPatternString, rules);
                }
                if (this.firstScanPatternString != null) {
                    this.firstScanPatternString = Builder.expandPattern(this.firstScanPatternString, rules);
                }
            }

            private static String expandPattern(String pattern, HashMap<String, String> rules) throws AnnotatorConfigurationException {
                String temp = pattern;
                StringBuffer sBuf = new StringBuffer();
                int loopCounter = 0;
                while (loopCounter < 10000) {
                    Matcher matcher = sRULE_EXPR_PATTERN.matcher(temp);
                    if (!matcher.find()) {
                        return temp;
                    }
                    String name = matcher.group(1);
                    String value = rules.get(name);
                    if (value == null) {
                        throw AnnotatorExceptionUtil.getConf("undefined rule found in pattern", (Object)name, pattern);
                    }
                    sBuf.append(temp.substring(0, matcher.start())).append(value).append(temp.substring(matcher.end()));
                    temp = sBuf.toString();
                    sBuf.delete(0, sBuf.length());
                    ++loopCounter;
                }
                throw AnnotatorExceptionUtil.getConf("too many replacements in pattern", pattern);
            }

            void buildOnePassConfiguration(TypeSystem pTypeSystem) throws AnnotatorConfigurationException, AnnotatorInitializationException {
                if (!this.multipleTypeMode) {
                    return;
                }
                int opcSize = this.onePassPatternStringsConfig.size();
                PatternInfo[] patternInfos = new PatternInfo[opcSize];
                List[] labelsConfig = new List[opcSize];
                int i = 0;
                while (i < opcSize) {
                    String curPattern = this.onePassPatternStringsConfig.get(i);
                    PatternPair pattern = new PatternPair(null, curPattern);
                    Integer amountOfGroupsInPattern = TypeEntryUtil.amountOfGroupsInExpandedRuleExp(curPattern);
                    String typesConf = this.onePassTypesConfig.get(i);
                    PatternInfo.FeatureStructure[] featureStructures = null;
                    if (typesConf != null) {
                        List<String> featureStructuresStr = TypeEntryUtil.parseOPSTypeConfigToFeatureStructures(typesConf);
                        featureStructures = new PatternInfo.FeatureStructure[featureStructuresStr.size()];
                        int k = 0;
                        while (k < featureStructuresStr.size()) {
                            String curFS = featureStructuresStr.get(k);
                            HashMap<String, PatternInfo.FeatureStructure.FeatureConfig> featuresConfig = new HashMap<String, PatternInfo.FeatureStructure.FeatureConfig>();
                            Integer typeGroupNum = null;
                            String[] typesConfElements = curFS.trim().split(" +");
                            String typeElement = typesConfElements[0];
                            String[] typeGroupPair = typeElement.split(":");
                            Type currenCasType = AnnotatorUtil.nameToCASType(this.getClass().getName(), pTypeSystem, typeGroupPair[0], true);
                            if (typeGroupPair.length != 2) {
                                throw AnnotatorExceptionUtil.getConf("badly formed one pass config", this.onePassOriginalConfigStr.get(i));
                            }
                            typeGroupNum = new Integer(typeGroupPair[1]);
                            if (typeGroupNum < 0 || typeGroupNum > amountOfGroupsInPattern) {
                                throw AnnotatorExceptionUtil.getConf("badly formed one pass config - group config problem in " + typeElement + " in " + this.onePassOriginalConfigStr.get(i));
                            }
                            int j = 1;
                            while (j < typesConfElements.length) {
                                String featureElement = typesConfElements[j];
                                String[] featureGroupPair = featureElement.split(":");
                                if (featureGroupPair.length != 2) {
                                    throw AnnotatorExceptionUtil.getConf("badly formed one pass config", this.onePassOriginalConfigStr.get(i));
                                }
                                Integer featureGroupNum = new Integer(featureGroupPair[1].trim());
                                if (featureGroupNum < 0 || featureGroupNum > amountOfGroupsInPattern) {
                                    throw AnnotatorExceptionUtil.getConf("badly formed one pass config - group config problem in " + featureElement + " in " + this.onePassOriginalConfigStr.get(i));
                                }
                                PatternInfo.FeatureStructure.FeatureConfig featureConfig = new PatternInfo.FeatureStructure.FeatureConfig(featureGroupNum, TextInUse.Original, null);
                                featuresConfig.put(featureGroupPair[0].trim(), featureConfig);
                                ++j;
                            }
                            featureStructures[k] = new PatternInfo.FeatureStructure(currenCasType, typeGroupNum, featuresConfig);
                            ++k;
                        }
                    }
                    patternInfos[i] = new PatternInfo(pattern, featureStructures);
                    String labelsConfStr = this.onePassLabelConfig.get(i);
                    ArrayList<OnePassConfiguration.LabelConfig> labelsConf = null;
                    if (labelsConfStr != null) {
                        String[] labelConfElements = labelsConfStr.trim().split("(?<!') +");
                        if (labelConfElements.length > 0) {
                            labelsConf = new ArrayList<OnePassConfiguration.LabelConfig>();
                        }
                        int j = 0;
                        while (j < labelConfElements.length) {
                            String label = labelConfElements[j].trim();
                            Integer labelGroup = null;
                            if (label != null) {
                                String[] labelGroupPair = label.split(":");
                                if (labelGroupPair.length != 2) {
                                    throw AnnotatorExceptionUtil.getConf("badly formed one pass config", this.onePassOriginalConfigStr.get(i));
                                }
                                label = labelGroupPair[0].trim();
                                if (label.length() > 3 || label.length() < 2) {
                                    throw AnnotatorExceptionUtil.getConf("badly formed one pass config", this.onePassOriginalConfigStr.get(i));
                                }
                                if (label.length() == 2) {
                                    if (label.charAt(0) != '\'' || label.charAt(1) != '\'') {
                                        throw AnnotatorExceptionUtil.getConf("badly formed one pass config", this.onePassOriginalConfigStr.get(i));
                                    }
                                    label = "";
                                } else {
                                    if (label.charAt(0) != '\'' || label.charAt(2) != '\'') {
                                        throw AnnotatorExceptionUtil.getConf("badly formed one pass config", this.onePassOriginalConfigStr.get(i));
                                    }
                                    label = label.substring(1, 2);
                                }
                                Integer labelGroupNum = new Integer(labelGroupPair[1].trim());
                                if (labelGroupNum < 0 || labelGroupNum > amountOfGroupsInPattern) {
                                    throw AnnotatorExceptionUtil.getConf("badly formed one pass config - group config problem in " + this.onePassLabelConfig.get(i) + " in " + this.onePassOriginalConfigStr.get(i));
                                }
                                labelGroup = labelGroupNum;
                            }
                            labelsConf.add(new OnePassConfiguration.LabelConfig(label, labelGroup));
                            ++j;
                        }
                    }
                    labelsConfig[i] = labelsConf;
                    ++i;
                }
                this.onePassConfiguration = new OnePassConfiguration(patternInfos, labelsConfig);
            }

            void checkEntryValidity(int entryNum) throws AnnotatorConfigurationException {
                if (this.multipleTypeMode && this.casType != null) {
                    throw AnnotatorExceptionUtil.getConf("Entry configuration conflict - ... (In Entry = " + entryNum + ")");
                }
                if (this.runTillNoAnnotationsAdded && this.saveFilteredTextName != null) {
                    throw AnnotatorExceptionUtil.getConf("Entry configuration conflict - Can not save a filter instance if in filtering cas type mode. (In Entry = " + entryNum + ")");
                }
                if (this.runTillNoAnnotationsAdded && this.multipleTypeMode) {
                    throw AnnotatorExceptionUtil.getConf("Entry configuration conflict - Can not be in multiple type mode while in filtering cas type mode (In Entry = " + entryNum + ")");
                }
                if (this.multipleTypeMode) {
                    LimittingCASType[] limittingCASTypeArray = this.limittingCasTypes;
                    int n = this.limittingCasTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        LimittingCASType curLimit = limittingCASTypeArray[n2];
                        if (!curLimit.mLimitsEntireInterval) {
                            throw AnnotatorExceptionUtil.getConf("Entry configuration conflict - Multiple type mode entry can not have non ranging limitations on the annotations. (In Entry = " + entryNum + ")");
                        }
                        ++n2;
                    }
                }
            }

            void buildPatternsInfo() throws AnnotatorConfigurationException {
                if (this.typeGroupsForPatterns.size() > this.patternStrings.size()) {
                    throw AnnotatorExceptionUtil.getConf("too much group nums in type line");
                }
                this.patternsInfo = new PatternInfo[this.patternStrings.size()];
                int i = 0;
                while (i < this.patternStrings.size()) {
                    String patternString = this.patternStrings.get(i);
                    Pattern pattern = TypeEntryUtil.compileExpandedRule(patternString);
                    HashMap<String, PatternInfo.FeatureStructure.FeatureConfig> featuresConfigForPattern = new HashMap<String, PatternInfo.FeatureStructure.FeatureConfig>();
                    Iterator<String> itFVM = this.featuresConfig.keySet().iterator();
                    while (itFVM.hasNext()) {
                        String featureName = new String(itFVM.next());
                        String GroupConfig = new String(this.featuresConfig.get(featureName).getFeatureGroupNums());
                        String[] GroupConfigByPattern = GroupConfig.split(",");
                        if (GroupConfigByPattern.length != this.patternStrings.size()) {
                            throw AnnotatorExceptionUtil.getConf("feature group config doesn't match amount of patterns", featureName);
                        }
                        if (i >= GroupConfigByPattern.length) continue;
                        GroupConfigByPattern[i] = GroupConfigByPattern[i].trim();
                        if (GroupConfigByPattern[i].compareTo("") == 0) {
                            throw AnnotatorExceptionUtil.getConf("badly formed feature group config line", featureName);
                        }
                        featuresConfigForPattern.put(featureName, new PatternInfo.FeatureStructure.FeatureConfig(new Integer(GroupConfigByPattern[i]), this.featuresConfig.get(featureName).getFeatureBaseText(), this.featuresConfig.get(featureName).getFilteredTextInstance()));
                    }
                    this.patternsInfo[i] = i < this.typeGroupsForPatterns.size() ? new PatternInfo(new PatternPair(pattern, patternString), new PatternInfo.FeatureStructure(this.casType, this.typeGroupsForPatterns.get(i), featuresConfigForPattern)) : new PatternInfo(new PatternPair(pattern, patternString), new PatternInfo.FeatureStructure(this.casType, new Integer(1), featuresConfigForPattern));
                    ++i;
                }
            }

            void buildStackPatterns() throws AnnotatorConfigurationException {
                this.pushPattern = TypeEntryUtil.compileExpandedRule(this.pushPatternString);
                this.popPattern = TypeEntryUtil.compileExpandedRule(this.popPatternString);
                Pattern bothPatterns = null;
                String bothPatternsStr = new String("(?:" + this.pushPatternString + ")" + "|" + "(?:" + this.popPatternString + ")");
                if (this.pushPattern != null && this.popPattern != null) {
                    try {
                        bothPatterns = Pattern.compile(bothPatternsStr);
                        if (bothPatterns.matcher("").matches()) {
                            throw AnnotatorExceptionUtil.getConf("regex matches empty string", bothPatterns.pattern());
                        }
                    }
                    catch (PatternSyntaxException e) {
                        throw AnnotatorExceptionUtil.getConf("regex syntax error", (Object)bothPatterns.pattern(), (Exception)e);
                    }
                }
                this.stackInfo = new StackInfo(new PatternPair(this.pushPattern, this.pushPatternString), new PatternPair(this.popPattern, this.popPatternString), new PatternPair(bothPatterns, bothPatternsStr), this.rangingMethod, this.eraseStackRange);
            }

            void buildFilteringPatterns() throws AnnotatorConfigurationException {
                Pattern[] tempFilteringPatterns = new Pattern[this.filteringPatternStrings.size()];
                int i = 0;
                while (i < this.filteringPatternStrings.size()) {
                    String filteringPatternString = this.filteringPatternStrings.get(i);
                    tempFilteringPatterns[i] = TypeEntryUtil.compileExpandedRule(filteringPatternString);
                    ++i;
                }
                String[] filterReplacements = TypeEntryUtil.toStringArray(this.filteringPatternReplacements);
                this.filteringPatterns = new FilteringPattern[tempFilteringPatterns.length];
                int i2 = 0;
                while (i2 < this.filteringPatterns.length) {
                    this.filteringPatterns[i2] = new FilteringPattern(new PatternPair(tempFilteringPatterns[i2], this.filteringPatternStrings.get(i2)), filterReplacements[i2]);
                    ++i2;
                }
            }

            void buildFirstScanPattern() throws AnnotatorConfigurationException {
                if (this.firstScanPatternString != null) {
                    Pattern firstScanPattern = TypeEntryUtil.compileExpandedRule(this.firstScanPatternString);
                    PatternPair firstScanPatternPair = new PatternPair(firstScanPattern, this.firstScanPatternString);
                    this.firstScanPatternInfo = new PatternInfo(firstScanPatternPair, new PatternInfo.FeatureStructure(null, this.firstScanCapturedGroup, null));
                } else {
                    this.firstScanPatternInfo = null;
                }
            }

            void initTypeSystem(TypeSystem pTypeSystem) throws AnnotatorInitializationException {
                this.casType = !this.typeName.equals(Multiple_types_name) ? AnnotatorUtil.nameToCASType(this.getClass().getName(), pTypeSystem, this.typeName, false) : null;
                this.startingCasType = AnnotatorUtil.nameToCASType(this.getClass().getName(), pTypeSystem, this.startingTypeName, true);
                String[] names = TypeEntryUtil.toStringArray(this.limittingTypeNames);
                Type[] types = AnnotatorUtil.namesToCASTypes(this.getClass().getName(), pTypeSystem, names, false);
                this.limittingCasTypes = new LimittingCASType[types.length];
                int i = 0;
                while (i < this.limittingCasTypes.length) {
                    this.limittingCasTypes[i] = new LimittingCASType(types[i], this.limitations.get(i), this.limitInclusives.get(i), this.limitsEntireIntervals.get(i));
                    ++i;
                }
                names = TypeEntryUtil.toStringArray(this.filteringTypeNames);
                String[] filterReplacements = TypeEntryUtil.toStringArray(this.filteringTypeReplacements);
                types = AnnotatorUtil.namesToCASTypes(this.getClass().getName(), pTypeSystem, names, false);
                this.filteringCasTypes = new FilteringCASType[types.length];
                int i2 = 0;
                while (i2 < this.filteringCasTypes.length) {
                    this.filteringCasTypes[i2] = new FilteringCASType(types[i2], filterReplacements[i2]);
                    ++i2;
                }
            }

            void checkIfFilterIsAncestorOfType(TypeSystem pTypeSystem) {
                if (this.casType == null) {
                    return;
                }
                int i = 0;
                while (i < this.filteringCasTypes.length) {
                    this.filterIsAncestorOfType = pTypeSystem.subsumes(this.filteringCasTypes[i].getType(), this.casType);
                    if (this.filterIsAncestorOfType) {
                        return;
                    }
                    ++i;
                }
            }

            private TypeEntry build() {
                return new TypeEntry(this.patternsInfo, this.casType, this.runTillNoAnnotationsAdded, this.startingCasType, this.limittingCasTypes, this.stackInfo, this.filteringCasTypes, this.filterIsAncestorOfType, this.filteringPatterns, this.firstScanPatternInfo, this.saveFilteredTextName, this.loadFilteredTextName, this.recalcScanPatterns, this.multipleTypeMode, this.onePassConfiguration);
            }
        }

        private class EntryFeatureConfig {
            private final String mFeatureGroupNums;
            private final TextInUse mFeatureBaseText;
            private final String mFilteredTextInstance;

            public EntryFeatureConfig(String featureGroupNums, TextInUse featureBaseText, String filteredTextInstance) {
                this.mFeatureGroupNums = featureGroupNums;
                this.mFeatureBaseText = featureBaseText;
                this.mFilteredTextInstance = filteredTextInstance;
            }

            public TextInUse getFeatureBaseText() {
                return this.mFeatureBaseText;
            }

            public String getFeatureGroupNums() {
                return this.mFeatureGroupNums;
            }

            public String getFilteredTextInstance() {
                return this.mFilteredTextInstance;
            }
        }
    }

    static class FilteringCASType {
        private final Type mType;
        private final String mFilterRepresentor;

        public FilteringCASType(Type type, String filterRepresentor) {
            this.mType = type;
            this.mFilterRepresentor = filterRepresentor;
        }

        public Type getType() {
            return this.mType;
        }

        public String replaceWith() {
            return this.mFilterRepresentor;
        }
    }

    static class FilteringPattern {
        private final PatternPair mPattern;
        private final String mFilterRepresentor;

        public FilteringPattern(PatternPair pattern, String filterRepresentor) {
            this.mPattern = pattern;
            this.mFilterRepresentor = filterRepresentor;
        }

        public String replaceWith() {
            return this.mFilterRepresentor;
        }

        public PatternPair getPatternPair() {
            return this.mPattern;
        }
    }

    static class LimittingCASType {
        private final Type mType;
        private final Limitation mLimitation;
        private final boolean mInclusive;
        private final boolean mLimitsEntireInterval;

        public LimittingCASType(Type type, Limitation limitation, boolean inclusive, boolean limitsEntireInterval) {
            this.mType = type;
            this.mLimitation = limitation;
            this.mInclusive = inclusive;
            this.mLimitsEntireInterval = limitsEntireInterval;
        }

        public Type getType() {
            return this.mType;
        }

        public boolean isInclusive() {
            return this.mInclusive;
        }

        public Limitation getLimitation() {
            return this.mLimitation;
        }

        public boolean limitsEntireInterval() {
            return this.mLimitsEntireInterval;
        }

        public boolean excludes(int start, int end, int otherStart, int otherEnd) {
            return LimittingCASType.excludes(this.mLimitation, this.mInclusive, start, end, otherStart, otherEnd);
        }

        private static boolean excludes(Limitation limitation, boolean inclusive, int start, int end, int otherStart, int otherEnd) {
            boolean result = LimittingCASType.isExcludedBy(limitation, start, end, otherStart, otherEnd);
            if (inclusive) {
                result = !result;
            }
            return result;
        }

        private static boolean isExcludedBy(Limitation limitation, int start, int end, int otherStart, int otherEnd) {
            if (limitation == Limitation.START) {
                return otherStart <= start && start < otherEnd;
            }
            if (limitation == Limitation.END) {
                return otherStart < end && end <= otherEnd;
            }
            if (limitation == Limitation.WITHIN) {
                return LimittingCASType.isExcludedBy(Limitation.START, start, end, otherStart, otherEnd) && LimittingCASType.isExcludedBy(Limitation.END, start, end, otherStart, otherEnd);
            }
            if (limitation == Limitation.WITHOUT) {
                return LimittingCASType.isExcludedBy(Limitation.WITHIN, otherStart, otherEnd, start, end);
            }
            throw new IllegalArgumentException("Unknown limitation type " + limitation);
        }

        static final class Limitation {
            static final Limitation INTERSECT = new Limitation();
            static final Limitation START = new Limitation();
            static final Limitation END = new Limitation();
            static final Limitation WITHIN = new Limitation();
            static final Limitation WITHOUT = new Limitation();

            private Limitation() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OnePassConfiguration {
        private final PatternPair catenatedPattern;
        private final Integer amountOfTotalGroups;
        private final List<LabelConfig>[] labelsConfs;
        private final PatternInfo[] patternsInfo;
        private final HashMap<Integer, Integer> captureGroupToPatternIndex;
        private final Set<Type> types;

        public OnePassConfiguration(PatternInfo[] patterns, List<LabelConfig>[] labelsConfs) throws AnnotatorConfigurationException {
            this.labelsConfs = labelsConfs;
            this.patternsInfo = patterns;
            Integer amountOfGroups = 0;
            StringBuffer catenatedPatternStr = new StringBuffer();
            this.captureGroupToPatternIndex = new HashMap();
            this.captureGroupToPatternIndex.put(1, 0);
            this.types = new HashSet<Type>();
            int i = 0;
            while (i < this.patternsInfo.length) {
                PatternInfo.FeatureStructure[] featureStructures = patterns[i].getFeatureStructures();
                if (featureStructures != null) {
                    PatternInfo.FeatureStructure[] featureStructureArray = featureStructures;
                    int n = featureStructures.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PatternInfo.FeatureStructure curFS = featureStructureArray[n2];
                        this.types.add(curFS.getCasType());
                        ++n2;
                    }
                }
                catenatedPatternStr.append("((?-ism)");
                catenatedPatternStr.append(patterns[i].getPatternPair().getPatternStr());
                catenatedPatternStr.append(")|");
                amountOfGroups = amountOfGroups + patterns[i].getAmountOfGroups() + 1;
                this.captureGroupToPatternIndex.put(amountOfGroups + 1, i + 1);
                ++i;
            }
            catenatedPatternStr.deleteCharAt(catenatedPatternStr.length() - 1);
            String patternString = catenatedPatternStr.toString();
            this.catenatedPattern = new PatternPair(TypeEntryUtil.compileExpandedRule(patternString), patternString);
            this.amountOfTotalGroups = amountOfGroups;
        }

        public PatternPair getCatenatedPattern() {
            return this.catenatedPattern;
        }

        public Integer getAmountOfTotalGroups() {
            return this.amountOfTotalGroups;
        }

        public Integer firstCapturingGroupToIndex(Integer group) {
            return this.captureGroupToPatternIndex.get(group);
        }

        public List<LabelConfig> getLabelConfig(int index) {
            return this.labelsConfs[index];
        }

        public PatternInfo getPatternsInfo(int index) {
            return this.patternsInfo[index];
        }

        public Set<Type> getTypes() {
            return this.types;
        }

        static class LabelConfig {
            String label;
            Integer labelGroup;

            public LabelConfig(String label, Integer labelGroup) {
                this.label = label;
                this.labelGroup = labelGroup;
            }

            public String getLabel() {
                return this.label;
            }

            public Integer getLabelGroup() {
                return this.labelGroup;
            }
        }
    }

    static class PatternInfo {
        private final Integer amountOfGroups;
        private final PatternPair pattern;
        private final FeatureStructure[] featureStructures;

        public PatternInfo(PatternPair pattern, FeatureStructure ... featureStructures) throws AnnotatorConfigurationException {
            this.pattern = pattern;
            this.featureStructures = featureStructures;
            this.amountOfGroups = TypeEntryUtil.amountOfGroupsInExpandedRuleExp(this.pattern.getPatternStr());
        }

        public PatternPair getPatternPair() {
            return this.pattern;
        }

        public Integer getAmountOfGroups() {
            return this.amountOfGroups;
        }

        public FeatureStructure[] getFeatureStructures() {
            return this.featureStructures;
        }

        public FeatureStructure getFirstFeatureStructure() {
            if (this.featureStructures == null) {
                return null;
            }
            if (this.featureStructures.length == 0) {
                return null;
            }
            return this.featureStructures[0];
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class FeatureStructure {
            private final Type casType;
            private final Integer typeGroupNum;
            private final HashMap<String, FeatureConfig> featuresConfig;

            public FeatureStructure(Type casType, Integer typeGroupNum, HashMap<String, FeatureConfig> featuresConfig) {
                this.casType = casType;
                this.typeGroupNum = typeGroupNum;
                this.featuresConfig = featuresConfig;
            }

            public Type getCasType() {
                return this.casType;
            }

            public HashMap<String, FeatureConfig> getFeaturesConfig() {
                return this.featuresConfig;
            }

            public Integer getTypeGroupNum() {
                return this.typeGroupNum;
            }

            static class FeatureConfig {
                private final Integer mFeatureGroupNum;
                private final TextInUse mFeatureBaseText;
                private final String mFilteredTextInstance;

                public FeatureConfig(Integer featureGroupNum, TextInUse featureBaseText, String filteredTextInstance) {
                    this.mFeatureGroupNum = featureGroupNum;
                    this.mFeatureBaseText = featureBaseText;
                    this.mFilteredTextInstance = filteredTextInstance;
                }

                public TextInUse getFeatureBaseText() {
                    return this.mFeatureBaseText;
                }

                public Integer getFeatureGroupNum() {
                    return this.mFeatureGroupNum;
                }

                public String getFilteredTextInstance() {
                    return this.mFilteredTextInstance;
                }
            }
        }
    }

    static class PatternPair {
        private final Pattern pattern;
        private final String patternStr;

        public PatternPair(Pattern pattern, String patternStr) {
            this.patternStr = patternStr;
            this.pattern = pattern;
        }

        public boolean needsDynamicPatternExpansion() {
            return this.pattern == null;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public String getPatternStr() {
            return this.patternStr;
        }
    }

    static class StackInfo {
        private final PatternPair mPushPattern;
        private final PatternPair mPopPattern;
        private final PatternPair mBothPatterns;
        private final RangingMethod mRangingMethod;
        private final boolean mEraseRange;

        public StackInfo(PatternPair pushPattern, PatternPair popPattern, PatternPair bothPatterns, RangingMethod rangingMethod, boolean eraseRange) {
            this.mPushPattern = pushPattern;
            this.mPopPattern = popPattern;
            this.mBothPatterns = bothPatterns;
            this.mRangingMethod = rangingMethod;
            this.mEraseRange = eraseRange;
        }

        public RangingMethod getRangingMethod() {
            return this.mRangingMethod;
        }

        public boolean getEraseRangeFlag() {
            return this.mEraseRange;
        }

        public PatternPair getPushPatternPair() {
            return this.mPushPattern;
        }

        public PatternPair getPopPatternPair() {
            return this.mPopPattern;
        }

        public PatternPair getBothPatternPair() {
            return this.mBothPatterns;
        }

        static final class RangingMethod {
            static final RangingMethod Push_Pop = new RangingMethod();
            static final RangingMethod PushInclude_Pop = new RangingMethod();
            static final RangingMethod Push_PopInclude = new RangingMethod();
            static final RangingMethod PushInclude_PopInclude = new RangingMethod();

            private RangingMethod() {
            }
        }
    }
}

