/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.annotator.annotators;

import com.ibm.supa.annotator.annotators.AnnotatorExceptionUtil;
import com.ibm.supa.annotator.annotators.BlockAnnotator;
import com.ibm.supa.annotator.annotators.ConfigurationInfo;
import com.ibm.supa.annotator.annotators.FileTypeGroupConfig;
import com.ibm.supa.annotator.annotators.FilteredText;
import com.ibm.supa.annotator.annotators.IntervalCombiner;
import com.ibm.supa.annotator.annotators.MatchInfo;
import com.ibm.supa.annotator.annotators.TextInUse;
import com.ibm.supa.annotator.annotators.TypeEntry;
import com.ibm.supa.annotator.util.AnnotatorUtil;
import com.ibm.supa.annotator.util.LogUtil;
import com.ibm.supa.annotator.util.intervals.Intervals;
import com.ibm.supa.annotator.util.text.location.Interval;
import com.ibm.supa.annotator.util.text.location.IntervalImpl;
import com.ibm.uima.analysis_engine.ResultSpecification;
import com.ibm.uima.analysis_engine.TypeOrFeature;
import com.ibm.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorContext;
import com.ibm.uima.analysis_engine.annotator.AnnotatorInitializationException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorProcessException;
import com.ibm.uima.analysis_engine.annotator.Annotator_ImplBase;
import com.ibm.uima.analysis_engine.annotator.TextAnnotator;
import com.ibm.uima.cas.CASException;
import com.ibm.uima.cas.FSIterator;
import com.ibm.uima.cas.FSMatchConstraint;
import com.ibm.uima.cas.FSTypeConstraint;
import com.ibm.uima.cas.Feature;
import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.cas.text.AnnotationFS;
import com.ibm.uima.cas.text.AnnotationIndex;
import com.ibm.uima.cas.text.TCAS;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SupaBaseAnnotator
extends Annotator_ImplBase
implements TextAnnotator {
    private static final int TIMEOUT_TO_END_FIND_SCAN = 10000;
    private Timer findExecutionTimer = new Timer();
    private static Logger sLogger = Logger.getLogger(LogUtil.getLogName(BlockAnnotator.class));
    private Map<CharSequence, FileTypeGroupConfig> mFileTypeGroupConfigMap;
    private Map<String, FilteredText> mFilteredTextInstances;
    private Map<Integer, Map<String, Pattern>> mDynamicPatterns;
    private final ConfigurationInfo configInfo;

    public SupaBaseAnnotator(ConfigurationInfo configInfo) {
        this.configInfo = configInfo;
    }

    protected boolean inAnnotation(TCAS aTCAS, Type annotationType, int pos) {
        return this.getEndAnnotationPosition(aTCAS, annotationType, pos) != -1;
    }

    protected int getEndAnnotationPosition(TCAS aTCAS, Type annotationType, int pos) {
        AnnotationIndex idx = (AnnotationIndex)aTCAS.getAnnotationIndex();
        FSIterator it = idx.iterator();
        FSTypeConstraint constraint = aTCAS.getConstraintFactory().createTypeConstraint();
        constraint.add(annotationType);
        int result = -1;
        it = aTCAS.createFilteredIterator(it, (FSMatchConstraint)constraint);
        while (it.isValid()) {
            AnnotationFS fs = (AnnotationFS)it.get();
            if (fs.getBegin() <= pos && pos < fs.getEnd()) {
                result = Math.max(result, fs.getEnd());
            }
            it.moveToNext();
        }
        return result;
    }

    public final void process(TCAS aTCAS, ResultSpecification aResultSpec) throws AnnotatorProcessException {
        this.mFilteredTextInstances = new HashMap<String, FilteredText>();
        this.mDynamicPatterns = new HashMap<Integer, Map<String, Pattern>>();
        FileTypeGroupConfig[] cfgs = null;
        try {
            cfgs = this.getConfigurations(aTCAS);
            if (cfgs == null || cfgs.length == 0) {
                StringBuilder sBuf = new StringBuilder();
                List<CharSequence> fileTypes = this.configInfo.getFileTypes(aTCAS);
                if (fileTypes.isEmpty()) {
                    sBuf.append("No file types found");
                } else {
                    sBuf.append("File types (");
                    for (CharSequence seq : fileTypes) {
                        sBuf.append(seq).append(", ");
                    }
                    sBuf.setCharAt(sBuf.length() - 2, ')');
                    sBuf.append("are not supported and the file will not be analyzed");
                }
                sLogger.config(sBuf.toString());
                return;
            }
        }
        catch (Exception e) {
            throw new AnnotatorProcessException((Throwable)e);
        }
        FileTypeGroupConfig[] fileTypeGroupConfigArray = cfgs;
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            FileTypeGroupConfig cfg = fileTypeGroupConfigArray[n2];
            if (cfg != null) {
                this.subProcess(aTCAS, aResultSpec, cfg);
            }
            ++n2;
        }
    }

    protected void saveFilteredTextInstance(TypeEntry typeEntry, FilteredText text) {
        this.mFilteredTextInstances.put(typeEntry.mSaveFilteredTextName, text);
    }

    protected abstract void subProcess(TCAS var1, ResultSpecification var2, FileTypeGroupConfig var3) throws AnnotatorProcessException;

    protected FilteredText getFilteredText(TypeEntry typeEntry, TCAS aTCAS) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        FilteredText result = null;
        boolean loadedInstance = false;
        if (typeEntry.mLoadFilteredTextName != null) {
            result = this.mFilteredTextInstances.get(typeEntry.mLoadFilteredTextName);
            loadedInstance = true;
        }
        if (result == null) {
            result = new FilteredText(aTCAS.getDocumentText());
        }
        if (typeEntry.mFilteringPatterns.length > 0) {
            result.filter();
        }
        AnnotationIndex idx = (AnnotationIndex)aTCAS.getAnnotationIndex();
        int i = 0;
        while (i < typeEntry.mFilteringCasTypes.length) {
            FSTypeConstraint constraint = aTCAS.getConstraintFactory().createTypeConstraint();
            constraint.add(typeEntry.mFilteringCasTypes[i].getType());
            FSIterator it = idx.iterator();
            it = aTCAS.createFilteredIterator(it, (FSMatchConstraint)constraint);
            while (it.isValid()) {
                block13: {
                    AnnotationFS fs;
                    block12: {
                        fs = (AnnotationFS)it.get();
                        if (!loadedInstance) break block12;
                        if (result.containsInterval(fs.getBegin(), fs.getEnd(), typeEntry.mFilteringCasTypes[i].replaceWith())) break block13;
                        result = (FilteredText)result.clone();
                        loadedInstance = false;
                    }
                    result.addInterval(fs.getBegin(), fs.getEnd(), typeEntry.mFilteringCasTypes[i].replaceWith());
                }
                it.moveToNext();
            }
            ++i;
        }
        i = 0;
        while (i < typeEntry.mFilteringPatterns.length) {
            ArrayList<MatchInfo> matchs = new ArrayList<MatchInfo>();
            String subText = result.getFilteredText();
            Pattern pattern = this.getPattern(aTCAS, typeEntry, typeEntry.mFilteringPatterns[i].getPatternPair(), result);
            this.matchPattern(null, result, subText, 0, subText.length(), pattern, 1, null, false, false, matchs);
            for (MatchInfo match : matchs) {
                int annotStart = match.getInterval().getStart().getOffset();
                int annotEnd = match.getInterval().getEnd().getOffset();
                if (loadedInstance) {
                    if (result.containsInterval(annotStart, annotEnd, typeEntry.mFilteringPatterns[i].replaceWith())) continue;
                    result = (FilteredText)result.clone();
                    loadedInstance = false;
                }
                result.addInterval(annotStart, annotEnd, typeEntry.mFilteringPatterns[i].replaceWith());
            }
            ++i;
        }
        if (typeEntry.mFilterIsAncestorOfType && loadedInstance) {
            result = (FilteredText)result.clone();
        }
        return result;
    }

    protected List<MatchInfo> getLimittedRanges(List<MatchInfo> matchesToAnnotate, TypeEntry.LimittingCASType[] limittingTypes, boolean skipEntireIntervalLimitations, TCAS aTCAS) {
        if (limittingTypes == null || matchesToAnnotate.isEmpty()) {
            return matchesToAnnotate;
        }
        List<MatchInfo> result = matchesToAnnotate;
        int i = 0;
        while (i < limittingTypes.length) {
            if (!limittingTypes[i].limitsEntireInterval() || !skipEntireIntervalLimitations) {
                result = this.getLimittedRanges(result, limittingTypes[i], aTCAS);
            }
            ++i;
        }
        return result;
    }

    private List<MatchInfo> getLimittedRanges(List<MatchInfo> matchesToAnnotate, TypeEntry.LimittingCASType limittingType, TCAS aTCAS) {
        if (limittingType == null || matchesToAnnotate.isEmpty()) {
            return matchesToAnnotate;
        }
        List<MatchInfo> result = matchesToAnnotate;
        AnnotationIndex idx = (AnnotationIndex)aTCAS.getAnnotationIndex();
        FSIterator it = idx.iterator();
        FSTypeConstraint constraint = aTCAS.getConstraintFactory().createTypeConstraint();
        constraint.add(limittingType.getType());
        ArrayList<MatchInfo> nextResult = new ArrayList<MatchInfo>();
        it = aTCAS.createFilteredIterator(it, (FSMatchConstraint)constraint);
        while (it.isValid()) {
            AnnotationFS fs = (AnnotationFS)it.get();
            for (MatchInfo matchInfo : result) {
                int end;
                int begin = matchInfo.getInterval().getStart().getOffset();
                if (limittingType.excludes(begin, end = matchInfo.getInterval().getEnd().getOffset(), fs.getBegin(), fs.getEnd())) continue;
                nextResult.add(matchInfo);
            }
            if (!limittingType.isInclusive()) {
                result = nextResult;
                nextResult = new ArrayList();
            }
            it.moveToNext();
        }
        if (limittingType.isInclusive()) {
            result = nextResult;
        }
        return result;
    }

    private List<Interval> getRangesWithStartingAnnotation(List<Interval> ranges, Type startingType, TCAS aTCAS) {
        if (startingType == null || ranges.isEmpty()) {
            return ranges;
        }
        ArrayList<Interval> result = new ArrayList<Interval>();
        AnnotationIndex idx = (AnnotationIndex)aTCAS.getAnnotationIndex();
        FSIterator it = idx.iterator();
        FSTypeConstraint constraint = aTCAS.getConstraintFactory().createTypeConstraint();
        constraint.add(startingType);
        Iterator<Interval> rangeIt = ranges.iterator();
        Interval currentInterval = rangeIt.next();
        int begin = currentInterval.getStart().getOffset();
        int end = currentInterval.getEnd().getOffset();
        int lastStartPos = -1;
        it = aTCAS.createFilteredIterator(it, (FSMatchConstraint)constraint);
        block0: while (it.isValid()) {
            AnnotationFS fs = (AnnotationFS)it.get();
            while (fs.getBegin() >= begin) {
                if (fs.getBegin() < end) {
                    if (begin == lastStartPos) break;
                    result.add(IntervalImpl.createWithCharoffsets(fs.getBegin(), end));
                    lastStartPos = fs.getBegin();
                    break;
                }
                if (!rangeIt.hasNext()) break block0;
                currentInterval = rangeIt.next();
                begin = currentInterval.getStart().getOffset();
                end = currentInterval.getEnd().getOffset();
            }
            it.moveToNext();
        }
        return result;
    }

    protected List<Interval> getRangesToAnnotate(TypeEntry typeEntry, Type[] containingTypes, boolean isSkipSubAnnotations, TCAS aTCAS) throws CASException, AnnotatorConfigurationException {
        ArrayList<Interval> inIntervalList = this.getRanges(typeEntry, containingTypes, true, true, isSkipSubAnnotations, aTCAS);
        ArrayList<Interval> exIntervalList = this.getRanges(typeEntry, null, false, false, isSkipSubAnnotations, aTCAS);
        IntervalCombiner exIntervals = new IntervalCombiner();
        for (Interval interval : exIntervalList) {
            exIntervals.addInterval(interval);
        }
        exIntervals.combine();
        List<Interval> result = inIntervalList;
        if (!exIntervals.isEmpty()) {
            ArrayList<IntervalCombiner.CombinedInterval> excluded = exIntervals.toArrayList();
            result = new ArrayList();
            int firstExIndex = 0;
            int i = 0;
            while (i < inIntervalList.size()) {
                Interval inRange = (Interval)inIntervalList.get(i);
                int firstOverlapIndex = this.getOverlapIndex(inRange, excluded, firstExIndex, inIntervalList);
                if (firstOverlapIndex == -1) {
                    result.add(inRange);
                } else {
                    firstExIndex = firstOverlapIndex;
                }
                ++i;
            }
        }
        if (typeEntry != null) {
            result = this.getRangesWithStartingAnnotation(result, typeEntry.mStartingCasType, aTCAS);
        }
        return result;
    }

    private int getOverlapIndex(Interval inRange, ArrayList<IntervalCombiner.CombinedInterval> excluded, int firstExIndex, List<Interval> incompleteIntervalList) {
        int inStart = inRange.getStart().getOffset();
        int inEnd = inRange.getEnd().getOffset();
        int result = -1;
        int j = firstExIndex;
        int count = 0;
        while (count < excluded.size()) {
            IntervalCombiner.CombinedInterval exRange = excluded.get(j);
            if (inStart < exRange.getEnd() && exRange.getStart() < inEnd) {
                if (inStart < exRange.getStart()) {
                    incompleteIntervalList.add(IntervalImpl.createWithCharoffsets(inStart, exRange.getStart()));
                }
                if (exRange.getEnd() < inEnd) {
                    incompleteIntervalList.add(IntervalImpl.createWithCharoffsets(exRange.getEnd(), inEnd));
                }
                result = j;
                break;
            }
            j = (j + 1) % excluded.size();
            ++count;
        }
        return result;
    }

    private ArrayList<Interval> getRanges(TypeEntry typeEntry, Type[] containingTypes, boolean inclusives, boolean conjoin, boolean isSkipSubAnnotations, TCAS aTCAS) throws CASException {
        int i;
        ArrayList<Interval> ranges = new ArrayList<Interval>();
        AnnotationIndex idx = (AnnotationIndex)aTCAS.getAnnotationIndex();
        FSIterator iterator = idx.iterator();
        FSMatchConstraint constraint = null;
        if (typeEntry != null) {
            TypeEntry.LimittingCASType[] limittingTypes = typeEntry.mLimittingCasTypes;
            i = 0;
            while (i < limittingTypes.length) {
                if (limittingTypes[i].limitsEntireInterval() && limittingTypes[i].isInclusive() && inclusives || !limittingTypes[i].isInclusive() && !inclusives) {
                    Type type = limittingTypes[i].getType();
                    constraint = this.accumulateConstraint(constraint, type, conjoin, aTCAS);
                }
                ++i;
            }
        }
        if (containingTypes != null) {
            FSMatchConstraint containingConstraint = null;
            i = 0;
            while (i < containingTypes.length) {
                containingConstraint = this.accumulateConstraint(containingConstraint, containingTypes[i], false, aTCAS);
                ++i;
            }
            constraint = this.accumulateConstraint(constraint, containingConstraint, conjoin, aTCAS);
        }
        if (constraint == null) {
            if (inclusives) {
                ranges.add(IntervalImpl.createWithCharoffsets(0, aTCAS.getDocumentText().length()));
            }
            return ranges;
        }
        iterator = aTCAS.createFilteredIterator(iterator, constraint);
        while (iterator.isValid()) {
            AnnotationFS fs = (AnnotationFS)iterator.get();
            ranges.addAll(this.getSubRangesToAnnotate(isSkipSubAnnotations, idx, fs));
            iterator.moveToNext();
        }
        return ranges;
    }

    private FSMatchConstraint accumulateConstraint(FSMatchConstraint constraint, Type type, boolean conjoin, TCAS aTCAS) {
        FSTypeConstraint temp = aTCAS.getConstraintFactory().createTypeConstraint();
        temp.add(type);
        return this.accumulateConstraint((FSMatchConstraint)temp, constraint, conjoin, aTCAS);
    }

    private FSMatchConstraint accumulateConstraint(FSMatchConstraint a, FSMatchConstraint b, boolean conjoin, TCAS aTCAS) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (conjoin) {
            return aTCAS.getConstraintFactory().and(a, b);
        }
        return aTCAS.getConstraintFactory().or(a, b);
    }

    private List<IntervalImpl> getSubRangesToAnnotate(boolean isSkipSubAnnotations, AnnotationIndex idx, AnnotationFS fs) {
        ArrayList<IntervalImpl> result = new ArrayList<IntervalImpl>();
        if (!isSkipSubAnnotations) {
            result.add(IntervalImpl.createWithCharoffsets(fs.getBegin(), fs.getEnd()));
            return result;
        }
        int marker = fs.getBegin();
        FSIterator iter = idx.subiterator(fs, true, true);
        while (iter.isValid()) {
            AnnotationFS subFS = (AnnotationFS)iter.get();
            if (subFS.getBegin() > marker) {
                result.add(IntervalImpl.createWithCharoffsets(marker, subFS.getBegin()));
            }
            if (subFS.getEnd() > marker) {
                marker = subFS.getEnd();
            }
            iter.moveToNext();
        }
        if (marker < fs.getEnd()) {
            result.add(IntervalImpl.createWithCharoffsets(marker, fs.getEnd()));
        }
        return result;
    }

    protected FileTypeGroupConfig getFileTypeGroupConfig(CharSequence pFileType, TypeSystem pTypeSystem, File baseDir) throws AnnotatorConfigurationException {
        FileTypeGroupConfig result = this.mFileTypeGroupConfigMap.get(pFileType);
        if (result == null) {
            String[] allTypes = this.getContext().getConfigurationGroupNames();
            int i = 0;
            while (i < allTypes.length) {
                if (allTypes[i].equals(pFileType)) {
                    result = new FileTypeGroupConfig(pFileType.toString(), pTypeSystem, this.getContext(), baseDir);
                    this.mFileTypeGroupConfigMap.put(pFileType, result);
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public void typeSystemInit(TypeSystem aTypeSystem) throws AnnotatorInitializationException {
        for (FileTypeGroupConfig cfg : this.mFileTypeGroupConfigMap.values()) {
            cfg.initTypeSystem(aTypeSystem);
        }
    }

    public void initialize(AnnotatorContext aContext) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        super.initialize(aContext);
        this.mFileTypeGroupConfigMap = new HashMap<CharSequence, FileTypeGroupConfig>();
    }

    protected List<Type> createResultTypes(ResultSpecification aResultSpec, TypeSystem typeSystem) {
        TypeOrFeature[] resultTypesOrFeatures = aResultSpec.getResultTypesAndFeatures();
        ArrayList<Type> resultTypes = new ArrayList<Type>();
        int i = 0;
        while (i < resultTypesOrFeatures.length) {
            if (resultTypesOrFeatures[i].isType()) {
                resultTypes.add(typeSystem.getType(resultTypesOrFeatures[i].getName()));
            }
            ++i;
        }
        return resultTypes;
    }

    protected boolean resultIncludesType(TypeSystem typeSystem, List<Type> resultTypes, Type type) {
        boolean includes = false;
        for (Type resultType : resultTypes) {
            if (!typeSystem.subsumes(resultType, type)) continue;
            includes = true;
            break;
        }
        return includes;
    }

    protected FileTypeGroupConfig[] getConfigurations(TCAS aTCAS) throws CASException, AnnotatorConfigurationException {
        List<CharSequence> fileTypes = this.configInfo.getFileTypes(aTCAS);
        TypeSystem typeSystem = aTCAS.getTypeSystem();
        File baseDir = this.configInfo.getBaseDir(aTCAS);
        FileTypeGroupConfig[] result = new FileTypeGroupConfig[fileTypes.size()];
        int i = 0;
        for (CharSequence fileType : fileTypes) {
            result[i++] = this.getFileTypeGroupConfig(fileType, typeSystem, baseDir);
        }
        return result;
    }

    private void matchNestedPatterns(TCAS aTCAS, TypeEntry typeEntry, FilteredText textForScan, String subText, int startPos, int endPos, Pattern firstScanPattern, int firstScanCaptureGroup, TypeEntry.PatternInfo[] patternsInfo, Pattern[] mainPatterns, boolean matchStartOnly, boolean isAnnotateEntireContainingAnnotation, List<MatchInfo> matchesToAnnotate, List<FilteredText.FilterInfo> filtersInfo) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        ArrayList<MatchInfo> firstScanMatches = new ArrayList<MatchInfo>();
        this.matchPattern(null, textForScan, subText, startPos, endPos, firstScanPattern, firstScanCaptureGroup, null, matchStartOnly, isAnnotateEntireContainingAnnotation, firstScanMatches);
        for (MatchInfo matchInfo : firstScanMatches) {
            Interval intervalOnOriginalText;
            Interval interval = matchInfo.getInterval();
            int annotStart = interval.getStart().getOffset();
            int annotEnd = interval.getEnd().getOffset();
            if ((annotStart = textForScan.getFilteredPos(annotStart)) == -1) {
                annotStart = textForScan.getFloorPos() + 1;
            } else if (textForScan.onAReplacedCharFilteredInterval() && !textForScan.atTheStartOfTheFilteredInterval()) {
                ++annotStart;
            }
            annotEnd = textForScan.getFilteredPos(annotEnd);
            if (annotEnd == -1) {
                annotEnd = textForScan.getFloorPos() + 1;
            }
            String subSubText = textForScan.getFilteredText().substring(annotStart, annotEnd);
            FilteredText newText = new FilteredText(subSubText);
            newText.filter();
            ArrayList<MatchInfo> matchesFound = new ArrayList<MatchInfo>();
            ArrayList<FilteredText.FilterInfo> matchesFoundForFilter = new ArrayList<FilteredText.FilterInfo>();
            this.matchFinalScanPhase(aTCAS, typeEntry, newText, subSubText, 0, subSubText.length(), matchStartOnly, isAnnotateEntireContainingAnnotation, patternsInfo, mainPatterns, matchesFound, matchesFoundForFilter);
            for (MatchInfo curMatch : matchesFound) {
                intervalOnOriginalText = textForScan.convertToUnfilteredPos(curMatch.getInterval(), annotStart);
                HashMap<String, MatchInfo.FeatureValueRepresentor> curFeatureValuesMap = curMatch.getFeatureValuesMap();
                HashMap<String, MatchInfo.FeatureValueRepresentor> convertedFeatureValuesMap = null;
                if (curFeatureValuesMap != null) {
                    convertedFeatureValuesMap = new HashMap<String, MatchInfo.FeatureValueRepresentor>();
                    for (Map.Entry<String, MatchInfo.FeatureValueRepresentor> featureEntry : curFeatureValuesMap.entrySet()) {
                        String featureName = new String(featureEntry.getKey());
                        Interval featureIntervalOnFilteredText = featureEntry.getValue().getInterval();
                        Interval featureIntervalOnOriginalText = textForScan.convertToUnfilteredPos(featureIntervalOnFilteredText, annotStart);
                        convertedFeatureValuesMap.put(featureName, new MatchInfo.FeatureValueRepresentor(featureIntervalOnOriginalText, featureEntry.getValue().getBaseText(), featureEntry.getValue().getFilteredTextInstance()));
                    }
                }
                matchesToAnnotate.add(new MatchInfo(curMatch.getCasType(), intervalOnOriginalText, convertedFeatureValuesMap));
            }
            for (FilteredText.FilterInfo curMatchForFilter : matchesFoundForFilter) {
                intervalOnOriginalText = textForScan.convertToUnfilteredPos(curMatchForFilter.getInterval(), annotStart);
                filtersInfo.add(new FilteredText.FilterInfo(intervalOnOriginalText, curMatchForFilter.getRepresentor()));
            }
        }
    }

    protected void matchFinalScanPhase(TCAS aTCAS, TypeEntry typeEntry, FilteredText textForScan, String subText, int startPos, int endPos, boolean matchStartOnly, boolean isAnnotateEntireContainingAnnotation, TypeEntry.PatternInfo[] patternsInfo, Pattern[] patterns, List<MatchInfo> matchesToAnnotate, List<FilteredText.FilterInfo> filtersInfo) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        if (!typeEntry.mMultipleTypeMode) {
            int k = 0;
            while (k < patternsInfo.length) {
                this.matchPattern(typeEntry.mCasType, textForScan, subText, startPos, endPos, patterns[k], patternsInfo[k].getFirstFeatureStructure().getTypeGroupNum(), patternsInfo[k].getFirstFeatureStructure().getFeaturesConfig(), matchStartOnly, isAnnotateEntireContainingAnnotation, matchesToAnnotate);
                ++k;
            }
        } else {
            this.matchOnePassPattern(aTCAS, typeEntry, textForScan, subText, startPos, endPos, matchStartOnly, typeEntry.mOnePassConfiguration, matchesToAnnotate, filtersInfo);
        }
    }

    protected void matchOnePassPattern(TCAS aTCAS, TypeEntry typeEntry, FilteredText text, String subText, int startPos, int endPos, boolean matchStartOnly, TypeEntry.OnePassConfiguration onePassConfiguration, List<MatchInfo> matchesToAnnotate, List<FilteredText.FilterInfo> filtersInfo) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        Pattern onePassPattern = this.getPattern(aTCAS, typeEntry, onePassConfiguration.getCatenatedPattern(), text);
        int pos = 0;
        Matcher matcher = onePassPattern.matcher(subText);
        boolean loop = true;
        while (pos >= 0 && pos < subText.length() && loop) {
            if (matchStartOnly) {
                loop = false;
                if (this.LookingAtWithATimeOut(matcher) != FindStatus.MATCH) {
                    break;
                }
            } else if (this.findWithATimeOut(matcher, pos) != FindStatus.MATCH) break;
            int i = 1;
            while (i <= onePassConfiguration.getAmountOfTotalGroups()) {
                if (matcher.group(i) != null) {
                    TypeEntry.PatternInfo patternInfo;
                    TypeEntry.PatternInfo.FeatureStructure[] featureStructures;
                    Integer patternindex = onePassConfiguration.firstCapturingGroupToIndex(i);
                    List<TypeEntry.OnePassConfiguration.LabelConfig> labelsConf = onePassConfiguration.getLabelConfig(patternindex);
                    if (labelsConf != null) {
                        for (TypeEntry.OnePassConfiguration.LabelConfig curLabelConf : labelsConf) {
                            String label = curLabelConf.getLabel();
                            int labelGroup = curLabelConf.getLabelGroup() + i;
                            Interval intervalOnOriginalText = this.getMatchOnOriginalText(startPos, labelGroup, matcher, text);
                            if (intervalOnOriginalText == null) continue;
                            filtersInfo.add(new FilteredText.FilterInfo(intervalOnOriginalText, label));
                        }
                    }
                    if ((featureStructures = (patternInfo = onePassConfiguration.getPatternsInfo(patternindex)).getFeatureStructures()) == null) break;
                    TypeEntry.PatternInfo.FeatureStructure[] featureStructureArray = featureStructures;
                    int n = featureStructures.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TypeEntry.PatternInfo.FeatureStructure curFS = featureStructureArray[n2];
                        Type casType = curFS.getCasType();
                        int typeGroup = curFS.getTypeGroupNum() + i;
                        Interval intervalOnOriginalText = this.getMatchOnOriginalText(startPos, typeGroup, matcher, text);
                        HashMap<String, TypeEntry.PatternInfo.FeatureStructure.FeatureConfig> featuresConfig = curFS.getFeaturesConfig();
                        HashMap<String, MatchInfo.FeatureValueRepresentor> featureValuesMap = null;
                        if (featuresConfig != null && !featuresConfig.isEmpty()) {
                            featureValuesMap = new HashMap<String, MatchInfo.FeatureValueRepresentor>();
                            for (Map.Entry<String, TypeEntry.PatternInfo.FeatureStructure.FeatureConfig> fgc : featuresConfig.entrySet()) {
                                String featureName = new String(fgc.getKey());
                                int groupNum = fgc.getValue().getFeatureGroupNum() + i;
                                TextInUse baseText = null;
                                String filteredInstanceForFeature = null;
                                Interval intervalOnOriginalTextForFetures = this.getMatchOnOriginalText(startPos, groupNum, matcher, text);
                                if (intervalOnOriginalTextForFetures == null) continue;
                                baseText = fgc.getValue().getFeatureBaseText();
                                filteredInstanceForFeature = fgc.getValue().getFilteredTextInstance();
                                featureValuesMap.put(featureName, new MatchInfo.FeatureValueRepresentor(intervalOnOriginalTextForFetures, baseText, filteredInstanceForFeature));
                            }
                        }
                        if (intervalOnOriginalText != null) {
                            matchesToAnnotate.add(new MatchInfo(casType, intervalOnOriginalText, featureValuesMap));
                        }
                        ++n2;
                    }
                    break;
                }
                ++i;
            }
            pos = matcher.end(0) - startPos;
        }
    }

    private Interval getMatchOnOriginalText(int filteredOffSet, int group, Matcher matcher, FilteredText text) {
        if (matcher.group(group) == null) {
            return null;
        }
        int annotStart = filteredOffSet + matcher.start(group);
        int annotEnd = filteredOffSet + matcher.end(group);
        if (annotEnd <= annotStart) {
            return null;
        }
        IntervalImpl intervalOnFilteredText = IntervalImpl.createWithCharoffsets(annotStart, annotEnd);
        Interval intervalOnOriginalText = text.convertToUnfilteredPos(intervalOnFilteredText, 0);
        return intervalOnOriginalText;
    }

    protected void matchPattern(Type casType, FilteredText text, String subText, int startPos, int endPos, Pattern pattern, int mainGroupNum, HashMap<String, TypeEntry.PatternInfo.FeatureStructure.FeatureConfig> featuresConfig, boolean matchStartOnly, boolean isAnnotateEntireContainingAnnotation, List<MatchInfo> matchesToAnnotate) {
        HashMap<String, MatchInfo.FeatureValueRepresentor> featureValuesMap = null;
        int pos = 0;
        Matcher matcher = pattern.matcher(subText);
        boolean loop = true;
        while (pos >= 0 && pos < subText.length() && loop) {
            int annotEnd;
            int annotStart;
            if (matchStartOnly) {
                loop = false;
                if (this.LookingAtWithATimeOut(matcher) != FindStatus.MATCH) {
                    break;
                }
            } else if (this.findWithATimeOut(matcher, pos) != FindStatus.MATCH) break;
            if (isAnnotateEntireContainingAnnotation) {
                annotStart = startPos;
                annotEnd = endPos;
            } else {
                int groupLoc = 0;
                if (matcher.groupCount() >= mainGroupNum && matcher.start(1) != -1) {
                    groupLoc = mainGroupNum;
                }
                annotStart = startPos + matcher.start(groupLoc);
                annotEnd = startPos + matcher.end(groupLoc);
                if (featuresConfig != null && !featuresConfig.isEmpty()) {
                    featureValuesMap = new HashMap<String, MatchInfo.FeatureValueRepresentor>();
                    for (Map.Entry<String, TypeEntry.PatternInfo.FeatureStructure.FeatureConfig> fgc : featuresConfig.entrySet()) {
                        String featureName = new String(fgc.getKey());
                        int groupNum = fgc.getValue().getFeatureGroupNum();
                        Interval featureValue = null;
                        TextInUse baseText = null;
                        String filteredInstanceForFeature = null;
                        if (matcher.group(groupNum) != null && matcher.end(groupNum) > matcher.start(groupNum)) {
                            IntervalImpl featureIntervalOnFilteredText = IntervalImpl.createWithCharoffsets(matcher.start(groupNum), matcher.end(groupNum));
                            featureValue = text.convertToUnfilteredPos(featureIntervalOnFilteredText, startPos);
                            baseText = fgc.getValue().getFeatureBaseText();
                            filteredInstanceForFeature = fgc.getValue().getFilteredTextInstance();
                        }
                        featureValuesMap.put(featureName, new MatchInfo.FeatureValueRepresentor(featureValue, baseText, filteredInstanceForFeature));
                    }
                }
            }
            IntervalImpl intervalOnFilteredText = IntervalImpl.createWithCharoffsets(annotStart, annotEnd);
            Interval intervalOnOriginalText = text.convertToUnfilteredPos(intervalOnFilteredText, 0);
            if (annotEnd > annotStart) {
                if (featuresConfig != null) {
                    matchesToAnnotate.add(new MatchInfo(casType, intervalOnOriginalText, featureValuesMap));
                } else {
                    matchesToAnnotate.add(new MatchInfo(casType, intervalOnOriginalText, null));
                }
            }
            pos = annotEnd - startPos;
            featureValuesMap = null;
        }
    }

    private void matchPatternsUsingStackRanging(TCAS aTCAS, FilteredText text, String subText, int startPos, int endPos, TypeEntry typeEntry, TypeEntry.PatternInfo firstScanPatternInfo, Pattern firstScanPattern, TypeEntry.PatternInfo[] patternsInfo, Pattern[] mainPatterns, TypeEntry.StackInfo stackInfo, boolean matchStartOnly, boolean isAnnotateEntireContainingAnnotation, List<MatchInfo> matchesToAnnotate, List<FilteredText.FilterInfo> filtersInfo) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        ArrayList rangeByStackDepth = new ArrayList();
        Stack<Integer> patternStack = new Stack<Integer>();
        int stackDepth = 0;
        int groupNum = 0;
        int continueSearchPos = 0;
        int rangeStartPos = 0;
        int rangeEndPos = 0;
        int pos = 0;
        ArrayList<MatchInfo> matchesFound = new ArrayList<MatchInfo>();
        ArrayList<FilteredText.FilterInfo> matchesFoundForFilter = new ArrayList<FilteredText.FilterInfo>();
        Pattern pPushRegex = this.getPattern(aTCAS, typeEntry, stackInfo.getPushPatternPair(), text);
        Pattern pPopRegex = this.getPattern(aTCAS, typeEntry, stackInfo.getPopPatternPair(), text);
        Pattern pBothRegex = this.getPattern(aTCAS, typeEntry, stackInfo.getBothPatternPair(), text);
        boolean eraseRange = stackInfo.getEraseRangeFlag();
        TypeEntry.StackInfo.RangingMethod stackRangingMethod = stackInfo.getRangingMethod();
        Matcher mBothRegex = pBothRegex.matcher(subText);
        Matcher mPushRegex = pPushRegex.matcher(subText);
        Matcher mPopRegex = pPopRegex.matcher(subText);
        while (this.findWithATimeOut(mBothRegex, pos) == FindStatus.MATCH) {
            if (this.findWithATimeOut(mPushRegex, pos) == FindStatus.MATCH && mPushRegex.start() == mBothRegex.start() && mPushRegex.end() == mBothRegex.end()) {
                ++stackDepth;
                int n = groupNum = mPushRegex.groupCount() < 1 ? 0 : 1;
                if (stackRangingMethod == TypeEntry.StackInfo.RangingMethod.PushInclude_Pop || stackRangingMethod == TypeEntry.StackInfo.RangingMethod.PushInclude_PopInclude) {
                    patternStack.push(new Integer(mPushRegex.start(groupNum)));
                }
                if (stackRangingMethod == TypeEntry.StackInfo.RangingMethod.Push_Pop || stackRangingMethod == TypeEntry.StackInfo.RangingMethod.Push_PopInclude) {
                    patternStack.push(new Integer(mPushRegex.end(groupNum)));
                }
                continueSearchPos = mPushRegex.end(groupNum);
                if (eraseRange && stackDepth > 1 && rangeByStackDepth.size() < stackDepth - 1) {
                    rangeByStackDepth.add(stackDepth - 2, new ArrayList());
                }
            } else {
                Interval intervalOnOriginalText;
                int annotEnd;
                if (this.findWithATimeOut(mPopRegex, pos) != FindStatus.MATCH || mPopRegex.start() != mBothRegex.start() || mPopRegex.end() != mBothRegex.end()) break;
                if (--stackDepth < 0) {
                    pos = mPopRegex.end();
                    stackDepth = 0;
                    continue;
                }
                rangeStartPos = (Integer)patternStack.pop();
                int n = groupNum = mPopRegex.groupCount() < 1 ? 0 : 1;
                if (stackRangingMethod == TypeEntry.StackInfo.RangingMethod.Push_Pop || stackRangingMethod == TypeEntry.StackInfo.RangingMethod.PushInclude_Pop) {
                    rangeEndPos = mPopRegex.start(groupNum);
                }
                if (stackRangingMethod == TypeEntry.StackInfo.RangingMethod.Push_PopInclude || stackRangingMethod == TypeEntry.StackInfo.RangingMethod.PushInclude_PopInclude) {
                    rangeEndPos = mPopRegex.end(groupNum);
                }
                continueSearchPos = mPopRegex.end(groupNum);
                if (eraseRange && stackDepth > 0) {
                    IntervalImpl curRange = IntervalImpl.createWithCharoffsets(rangeStartPos, rangeEndPos);
                    ((ArrayList)rangeByStackDepth.get(stackDepth - 1)).add(curRange);
                }
                String subSubText = subText.substring(rangeStartPos, rangeEndPos);
                FilteredText newText = new FilteredText(subSubText);
                newText.filter();
                if (eraseRange && rangeByStackDepth.size() > stackDepth) {
                    List upperLevelRanges = (List)rangeByStackDepth.get(stackDepth);
                    for (Interval curRange : upperLevelRanges) {
                        int removeStart = curRange.getStart().getOffset() - rangeStartPos;
                        int removeEnd = curRange.getEnd().getOffset() - rangeStartPos;
                        newText.addInterval(removeStart, removeEnd, "");
                    }
                    newText.filter();
                    subSubText = newText.getFilteredText();
                    rangeByStackDepth.remove(stackDepth);
                }
                matchesFound.clear();
                matchesFoundForFilter.clear();
                if (firstScanPatternInfo == null) {
                    this.matchFinalScanPhase(aTCAS, typeEntry, newText, subSubText, 0, subSubText.length(), matchStartOnly, isAnnotateEntireContainingAnnotation, patternsInfo, mainPatterns, matchesFound, matchesFoundForFilter);
                } else if (firstScanPatternInfo != null) {
                    this.matchNestedPatterns(aTCAS, typeEntry, newText, subSubText, 0, subSubText.length(), firstScanPattern, firstScanPatternInfo.getFirstFeatureStructure().getTypeGroupNum(), patternsInfo, mainPatterns, matchStartOnly, isAnnotateEntireContainingAnnotation, matchesFound, matchesFoundForFilter);
                }
                for (MatchInfo curMatch : matchesFound) {
                    int annotStart = curMatch.getInterval().getStart().getOffset() + rangeStartPos;
                    annotEnd = curMatch.getInterval().getEnd().getOffset() + rangeStartPos;
                    IntervalImpl intervalOnFilteredText = IntervalImpl.createWithCharoffsets(annotStart, annotEnd);
                    intervalOnOriginalText = text.convertToUnfilteredPos(intervalOnFilteredText, startPos);
                    HashMap<String, MatchInfo.FeatureValueRepresentor> curFeatureValuesMap = curMatch.getFeatureValuesMap();
                    HashMap<String, MatchInfo.FeatureValueRepresentor> convertedFeatureValuesMap = null;
                    if (curFeatureValuesMap != null) {
                        convertedFeatureValuesMap = new HashMap<String, MatchInfo.FeatureValueRepresentor>();
                        for (Map.Entry<String, MatchInfo.FeatureValueRepresentor> featureEntry : curFeatureValuesMap.entrySet()) {
                            String featureName = new String(featureEntry.getKey());
                            Interval featureIntervalOnFilteredText = featureEntry.getValue().getInterval();
                            Interval featureIntervalOnOriginalText = text.convertToUnfilteredPos(featureIntervalOnFilteredText, startPos + rangeStartPos);
                            convertedFeatureValuesMap.put(featureName, new MatchInfo.FeatureValueRepresentor(featureIntervalOnOriginalText, featureEntry.getValue().getBaseText(), featureEntry.getValue().getFilteredTextInstance()));
                        }
                    }
                    matchesToAnnotate.add(new MatchInfo(curMatch.getCasType(), intervalOnOriginalText, convertedFeatureValuesMap));
                }
                for (FilteredText.FilterInfo curMatchForFilter : matchesFoundForFilter) {
                    int annotStart = curMatchForFilter.getStart() + rangeStartPos;
                    annotEnd = curMatchForFilter.getEnd() + rangeStartPos;
                    IntervalImpl intervalOnFilteredText = IntervalImpl.createWithCharoffsets(annotStart, annotEnd);
                    intervalOnOriginalText = text.convertToUnfilteredPos(intervalOnFilteredText, startPos);
                    filtersInfo.add(new FilteredText.FilterInfo(intervalOnOriginalText, curMatchForFilter.getRepresentor()));
                }
            }
            pos = continueSearchPos;
        }
    }

    protected Pattern getPattern(TCAS aTCAS, TypeEntry typeEntry, TypeEntry.PatternPair patternPair, FilteredText curFilteredText) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        if (patternPair == null) {
            return null;
        }
        if (patternPair.needsDynamicPatternExpansion()) {
            return this.expandPatternWithCasAnnotation(aTCAS, typeEntry, patternPair.getPatternStr(), curFilteredText);
        }
        return patternPair.getPattern();
    }

    protected Pattern expandPatternWithCasAnnotation(TCAS aTCAS, TypeEntry typeEntry, String patternStr, FilteredText curFilteredText) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        Pattern recordedPattern;
        Map<String, Pattern> value;
        if (!typeEntry.mRecalcScanPatterns && (value = this.mDynamicPatterns.get(typeEntry.hashCode())) != null && (recordedPattern = value.get(patternStr)) != null) {
            return recordedPattern;
        }
        String originalPatternStr = patternStr;
        boolean typeOnOriginalText = true;
        Pattern pCasType = Pattern.compile("(?:\\(\\+\\+)(.+?)(?:\\))");
        String sCasTypeAndFeature = null;
        String sCasType = null;
        String sCasTypeFeature = null;
        Matcher mCasType = pCasType.matcher(patternStr);
        while (mCasType.find()) {
            sCasTypeAndFeature = patternStr.substring(mCasType.start(1), mCasType.end(1));
            if (sCasTypeAndFeature.trim().startsWith("+")) {
                typeOnOriginalText = false;
                sCasTypeAndFeature = sCasTypeAndFeature.substring(1);
            } else {
                typeOnOriginalText = true;
            }
            sCasTypeAndFeature = sCasTypeAndFeature.trim();
            int index = sCasTypeAndFeature.indexOf(":");
            if (index != -1) {
                sCasTypeFeature = sCasTypeAndFeature.substring(index + 1);
                sCasType = sCasTypeAndFeature.substring(0, index);
            } else {
                sCasType = sCasTypeAndFeature;
            }
            Type tCasType = AnnotatorUtil.nameToCASType(((Object)((Object)this)).getClass().getName(), aTCAS.getTypeSystem(), sCasType, false);
            Feature tCasTypeFeature = tCasType.getFeatureByBaseName(sCasTypeFeature);
            String replacedCasTypePhrase = typeOnOriginalText ? new StringBuffer().append("(++").append(sCasTypeAndFeature).append(")").toString() : new StringBuffer().append("(+++").append(sCasTypeAndFeature).append(")").toString();
            String AlternationStr = this.typeToAlternationOfAnnotation(aTCAS, tCasType, tCasTypeFeature, curFilteredText, typeOnOriginalText);
            Pattern checkPattern = Pattern.compile(AlternationStr);
            if (checkPattern.matcher("").matches()) {
                AlternationStr = new String("(?:\\zuu)");
            }
            patternStr = patternStr.replace(replacedCasTypePhrase, AlternationStr);
            mCasType = pCasType.matcher(patternStr);
        }
        Pattern pattern = Pattern.compile(patternStr);
        if (pattern.matcher("").matches()) {
            throw AnnotatorExceptionUtil.getConf("regex matches empty string", patternStr);
        }
        if (!typeEntry.mRecalcScanPatterns) {
            Pattern recordedPattern2;
            Map<String, Pattern> value2 = this.mDynamicPatterns.get(typeEntry.hashCode());
            if (value2 == null) {
                value2 = new HashMap<String, Pattern>();
            }
            if ((recordedPattern2 = value2.get(originalPatternStr)) == null) {
                value2.put(originalPatternStr, pattern);
                this.mDynamicPatterns.put(typeEntry.hashCode(), value2);
            }
        }
        return pattern;
    }

    private String typeToAlternationOfAnnotation(TCAS aTCAS, Type aType, Feature aFeature, FilteredText curFilteredText, boolean typeOnOriginalText) {
        AnnotationIndex idx = (AnnotationIndex)aTCAS.getAnnotationIndex();
        String DocText = aTCAS.getDocumentText();
        FSTypeConstraint constraint = aTCAS.getConstraintFactory().createTypeConstraint();
        constraint.add(aType);
        FSIterator it = idx.iterator();
        HashSet<String> alternationElements = new HashSet<String>();
        it = aTCAS.createFilteredIterator(it, (FSMatchConstraint)constraint);
        while (it.isValid()) {
            AnnotationFS fs = (AnnotationFS)it.get();
            String subText = null;
            if (aFeature == null) {
                if (typeOnOriginalText) {
                    subText = DocText.substring(fs.getBegin(), fs.getEnd());
                } else {
                    int filteredStart = curFilteredText.getFilteredPos(fs.getBegin());
                    int filteredEnd = curFilteredText.getFilteredPos(fs.getEnd());
                    if (filteredStart != -1 && filteredEnd != -1) {
                        subText = curFilteredText.getFilteredText().substring(filteredStart, filteredEnd);
                    }
                }
            } else {
                subText = fs.getFeatureValueAsString(aFeature);
            }
            if (subText != null && !subText.trim().equals("")) {
                alternationElements.add(subText);
            }
            it.moveToNext();
        }
        HashMap<String, HashSet<String>> optAlternationElements = this.optimizeAlternation(alternationElements);
        StringBuffer res = new StringBuffer();
        res.append("(?:");
        boolean noAltarnationElements = true;
        for (Map.Entry<String, HashSet<String>> optAltElem : optAlternationElements.entrySet()) {
            String key = new String(optAltElem.getKey());
            HashSet<String> vals = optAltElem.getValue();
            key = this.putSlashOnRegeXSpecialChars(key);
            res.append(key).append("(?:");
            for (String valsStr : vals) {
                valsStr = this.putSlashOnRegeXSpecialChars(valsStr);
                res.append(valsStr).append("|");
            }
            res.deleteCharAt(res.length() - 1).append(")|");
            noAltarnationElements = false;
        }
        if (!noAltarnationElements) {
            res.deleteCharAt(res.length() - 1).append(")");
        } else if (noAltarnationElements) {
            res.append(")");
        }
        String resStr = res.toString();
        return resStr;
    }

    private HashMap<String, HashSet<String>> optimizeAlternation(HashSet<String> allStr) {
        HashMap<String, HashSet<String>> chars = new HashMap<String, HashSet<String>>();
        HashSet<Object> allStrRelevantToFirstChar = new HashSet();
        for (String alternationElement : allStr) {
            String firstChar = alternationElement.substring(0, 1);
            String alternationElementMinusFirstChar = alternationElement.substring(1);
            allStrRelevantToFirstChar = chars.get(firstChar);
            if (allStrRelevantToFirstChar == null) {
                allStrRelevantToFirstChar = new HashSet();
            }
            allStrRelevantToFirstChar.add(alternationElementMinusFirstChar);
            chars.put(firstChar, allStrRelevantToFirstChar);
        }
        return chars;
    }

    private String putSlashOnRegeXSpecialChars(String str) {
        str = str.replace("\\", "\\\\");
        str = str.replace("[", "\\[");
        str = str.replace("^", "\\^");
        str = str.replace("{", "\\{");
        str = str.replace("}", "\\}");
        str = str.replace("$", "\\$");
        str = str.replace(".", "\\.");
        str = str.replace("|", "\\|");
        str = str.replace("?", "\\?");
        str = str.replace("*", "\\*");
        str = str.replace("+", "\\+");
        str = str.replace("(", "\\(");
        str = str.replace(")", "\\)");
        return str;
    }

    protected List<MatchInfo> matchPatterns(TCAS aTCAS, FilteredText text, int startPos, int endPos, TypeEntry typeEntry, boolean isAnnotateEntireContainingAnnotation, List<FilteredText.FilterInfo> filtersInfo) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        return this.matchPatterns(aTCAS, text, startPos, endPos, typeEntry, typeEntry.mFirstScanPattern, typeEntry.mPatternsInfo, typeEntry.mStackInfo, typeEntry.mStartingCasType != null, isAnnotateEntireContainingAnnotation, filtersInfo);
    }

    protected List<MatchInfo> matchPatterns(TCAS aTCAS, FilteredText text, int startPos, int endPos, TypeEntry typeEntry, TypeEntry.PatternInfo firstScanPatternInfo, TypeEntry.PatternInfo[] patternsInfo, TypeEntry.StackInfo stackInfo, boolean matchStartOnly, boolean isAnnotateEntireContainingAnnotation, List<FilteredText.FilterInfo> filtersInfo) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        ArrayList<MatchInfo> matchesToAnnotate = new ArrayList<MatchInfo>();
        String subText = text.getFilteredText().substring(startPos, endPos);
        Pattern[] mainPatterns = new Pattern[patternsInfo.length];
        int k = 0;
        while (k < patternsInfo.length) {
            mainPatterns[k] = this.getPattern(aTCAS, typeEntry, patternsInfo[k].getPatternPair(), text);
            ++k;
        }
        Pattern firstScanPattern = null;
        if (firstScanPatternInfo != null) {
            firstScanPattern = this.getPattern(aTCAS, typeEntry, firstScanPatternInfo.getPatternPair(), text);
        }
        if (stackInfo != null) {
            this.matchPatternsUsingStackRanging(aTCAS, text, subText, startPos, endPos, typeEntry, firstScanPatternInfo, firstScanPattern, patternsInfo, mainPatterns, stackInfo, matchStartOnly, isAnnotateEntireContainingAnnotation, matchesToAnnotate, filtersInfo);
        } else if (stackInfo == null) {
            if (firstScanPatternInfo != null) {
                this.matchNestedPatterns(aTCAS, typeEntry, text, subText, startPos, endPos, firstScanPattern, firstScanPatternInfo.getFirstFeatureStructure().getTypeGroupNum(), patternsInfo, mainPatterns, matchStartOnly, isAnnotateEntireContainingAnnotation, matchesToAnnotate, filtersInfo);
            } else if (firstScanPatternInfo == null) {
                this.matchFinalScanPhase(aTCAS, typeEntry, text, subText, startPos, endPos, matchStartOnly, isAnnotateEntireContainingAnnotation, patternsInfo, mainPatterns, matchesToAnnotate, filtersInfo);
            }
        }
        this.findExecutionTimer.purge();
        return matchesToAnnotate;
    }

    protected int addAnnotationsToCAS(TCAS aTCAS, List<MatchInfo> matchesToAnnotate, TypeEntry typeEntry, FilteredText text, boolean isCheckIntervals, Intervals intervals) {
        int result = 0;
        for (MatchInfo matchInfo : matchesToAnnotate) {
            Interval interval = matchInfo.getInterval();
            int annotStart = interval.getStart().getOffset();
            int annotEnd = interval.getEnd().getOffset();
            if (isCheckIntervals) {
                if (intervals.checkInterval(interval) == 1) continue;
                intervals.add(interval);
            }
            AnnotationFS fs = aTCAS.createAnnotation(typeEntry.mCasType, annotStart, annotEnd);
            HashMap<String, MatchInfo.FeatureValueRepresentor> featuresValuesMapping = matchInfo.getFeatureValuesMap();
            if (featuresValuesMapping != null) {
                for (Map.Entry<String, MatchInfo.FeatureValueRepresentor> featureEntry : featuresValuesMapping.entrySet()) {
                    String featureName = new String(featureEntry.getKey());
                    Interval featureValue = featureEntry.getValue().getInterval();
                    TextInUse baseText = featureEntry.getValue().getBaseText();
                    String filteredTextForFeatureValueUse = featureEntry.getValue().getFilteredTextInstance();
                    String featureValueStr = "";
                    if (featureValue == null) {
                        featureValueStr = "";
                    } else if (baseText.equals((Object)TextInUse.Original)) {
                        featureValueStr = text.getText().substring(featureValue.getStart().getOffset(), featureValue.getEnd().getOffset());
                        featureValueStr = featureValueStr.trim();
                    } else if (baseText.equals((Object)TextInUse.CurFiltered)) {
                        int filteredStart = text.getFilteredPos(featureValue.getStart().getOffset());
                        int filteredEnd = text.getFilteredPos(featureValue.getEnd().getOffset());
                        if (filteredStart != -1 && filteredEnd != -1) {
                            featureValueStr = text.getFilteredText().substring(filteredStart, filteredEnd);
                            featureValueStr = featureValueStr.trim();
                        }
                    } else if (baseText.equals((Object)TextInUse.FilteredInstance)) {
                        FilteredText filteredTextForFeatureValue = this.mFilteredTextInstances.get(filteredTextForFeatureValueUse);
                        int filteredStart = filteredTextForFeatureValue.getFilteredPos(featureValue.getStart().getOffset());
                        int filteredEnd = filteredTextForFeatureValue.getFilteredPos(featureValue.getEnd().getOffset());
                        if (filteredStart != -1 && filteredEnd != -1) {
                            featureValueStr = filteredTextForFeatureValue.getFilteredText().substring(filteredStart, filteredEnd);
                            featureValueStr = featureValueStr.trim();
                        }
                    }
                    if (featureValueStr == null || featureValueStr.trim().equals("")) continue;
                    fs.setFeatureValueFromString(typeEntry.mCasType.getFeatureByBaseName(featureName), featureValueStr);
                }
            }
            aTCAS.getIndexRepository().addFS((FeatureStructure)fs);
            if (typeEntry.mFilterIsAncestorOfType && !typeEntry.mRunTillNoAnnotationsAdded) {
                text.addInterval(annotStart, annotEnd, "");
            }
            if (typeEntry.mFilterIsAncestorOfType && typeEntry.mRunTillNoAnnotationsAdded) {
                String representor = "";
                int i = 0;
                while (i < typeEntry.mFilteringCasTypes.length) {
                    if (typeEntry.mFilteringCasTypes[i].getType().equals(typeEntry.mCasType)) {
                        representor = typeEntry.mFilteringCasTypes[i].replaceWith();
                        break;
                    }
                    ++i;
                }
                text.addInterval(annotStart, annotEnd, representor);
            }
            ++result;
        }
        return result;
    }

    protected int addAnnotationsToCAS(TCAS aTCAS, List<MatchInfo> matchesToAnnotate, FilteredText text, boolean isCheckIntervals, Intervals intervals) {
        int result = 0;
        for (MatchInfo matchInfo : matchesToAnnotate) {
            if (matchInfo.getCasType() == null) continue;
            Interval interval = matchInfo.getInterval();
            int annotStart = interval.getStart().getOffset();
            int annotEnd = interval.getEnd().getOffset();
            if (isCheckIntervals) {
                if (intervals.checkInterval(interval) == 1) continue;
                intervals.add(interval);
            }
            AnnotationFS fs = aTCAS.createAnnotation(matchInfo.getCasType(), annotStart, annotEnd);
            HashMap<String, MatchInfo.FeatureValueRepresentor> featuresValuesMapping = matchInfo.getFeatureValuesMap();
            if (featuresValuesMapping != null) {
                for (Map.Entry<String, MatchInfo.FeatureValueRepresentor> featureEntry : featuresValuesMapping.entrySet()) {
                    String featureName = new String(featureEntry.getKey());
                    Interval featureValue = featureEntry.getValue().getInterval();
                    TextInUse baseText = featureEntry.getValue().getBaseText();
                    String filteredTextForFeatureValueUse = featureEntry.getValue().getFilteredTextInstance();
                    String featureValueStr = "";
                    if (featureValue == null) {
                        featureValueStr = "";
                    } else if (baseText.equals((Object)TextInUse.Original)) {
                        featureValueStr = text.getText().substring(featureValue.getStart().getOffset(), featureValue.getEnd().getOffset());
                        featureValueStr = featureValueStr.trim();
                    } else if (baseText.equals((Object)TextInUse.CurFiltered)) {
                        int filteredStart = text.getFilteredPos(featureValue.getStart().getOffset());
                        int filteredEnd = text.getFilteredPos(featureValue.getEnd().getOffset());
                        if (filteredStart != -1 && filteredEnd != -1) {
                            featureValueStr = text.getFilteredText().substring(filteredStart, filteredEnd);
                            featureValueStr = featureValueStr.trim();
                        }
                    } else if (baseText.equals((Object)TextInUse.FilteredInstance)) {
                        FilteredText filteredTextForFeatureValue = this.mFilteredTextInstances.get(filteredTextForFeatureValueUse);
                        int filteredStart = filteredTextForFeatureValue.getFilteredPos(featureValue.getStart().getOffset());
                        int filteredEnd = filteredTextForFeatureValue.getFilteredPos(featureValue.getEnd().getOffset());
                        if (filteredStart != -1 && filteredEnd != -1) {
                            featureValueStr = filteredTextForFeatureValue.getFilteredText().substring(filteredStart, filteredEnd);
                            featureValueStr = featureValueStr.trim();
                        }
                    }
                    if (featureValueStr == null || featureValueStr.trim().equals("")) continue;
                    fs.setFeatureValueFromString(matchInfo.getCasType().getFeatureByBaseName(featureName), featureValueStr);
                }
            }
            aTCAS.getIndexRepository().addFS((FeatureStructure)fs);
            ++result;
        }
        return result;
    }

    private FindStatus findWithATimeOut(final Matcher m, int startPos) {
        class TimeOutFlag {
            private volatile boolean timeOutFlag = false;

            public boolean isTimeOut() {
                return this.timeOutFlag;
            }

            public void setTimeOutFlag(boolean flag) {
                this.timeOutFlag = flag;
            }
        }
        final TimeOutFlag objTimeOutFlag = new TimeOutFlag();
        objTimeOutFlag.setTimeOutFlag(false);
        TimerTask ts = new TimerTask(){
            {
            }

            public void run() {
                objTimeOutFlag.setTimeOutFlag(true);
                m.reset("");
            }
        };
        this.findExecutionTimer.schedule(ts, 10000L);
        boolean findRetVal = false;
        boolean boolTimeOutFlag = false;
        try {
            findRetVal = m.find(startPos);
            boolTimeOutFlag = objTimeOutFlag.isTimeOut();
            ts.cancel();
        }
        catch (Exception e) {
            ts.cancel();
            return FindStatus.ERROR;
        }
        if (boolTimeOutFlag) {
            return FindStatus.TIMEOUT;
        }
        if (!findRetVal) {
            return FindStatus.NO_MATCH;
        }
        return FindStatus.MATCH;
    }

    private FindStatus LookingAtWithATimeOut(final Matcher m) {
        class TimeOutFlag {
            private volatile boolean timeOutFlag = false;

            public boolean isTimeOut() {
                return this.timeOutFlag;
            }

            public void setTimeOutFlag(boolean flag) {
                this.timeOutFlag = flag;
            }
        }
        final TimeOutFlag objTimeOutFlag = new TimeOutFlag();
        objTimeOutFlag.setTimeOutFlag(false);
        TimerTask ts = new TimerTask(){
            {
            }

            public void run() {
                objTimeOutFlag.setTimeOutFlag(true);
                m.reset("");
            }
        };
        this.findExecutionTimer.schedule(ts, 10000L);
        boolean findRetVal = false;
        boolean boolTimeOutFlag = false;
        try {
            findRetVal = m.lookingAt();
            boolTimeOutFlag = objTimeOutFlag.isTimeOut();
            ts.cancel();
        }
        catch (Exception e) {
            ts.cancel();
            return FindStatus.ERROR;
        }
        if (boolTimeOutFlag) {
            return FindStatus.TIMEOUT;
        }
        if (!findRetVal) {
            return FindStatus.NO_MATCH;
        }
        return FindStatus.MATCH;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FindStatus {
        MATCH,
        NO_MATCH,
        TIMEOUT,
        ERROR;

    }
}

