/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.annotator.annotators;

import com.ibm.supa.annotator.annotators.BlockPositions;
import com.ibm.supa.annotator.annotators.ConfigurationInfo;
import com.ibm.supa.annotator.annotators.DefaultConfigurationInfo;
import com.ibm.supa.annotator.annotators.FileTypeGroupConfig;
import com.ibm.supa.annotator.annotators.FilteredText;
import com.ibm.supa.annotator.annotators.IBlockTitleClassifier;
import com.ibm.supa.annotator.annotators.LearningBlockTitleClassiifier;
import com.ibm.supa.annotator.annotators.MatchInfo;
import com.ibm.supa.annotator.annotators.SupaBaseAnnotator;
import com.ibm.supa.annotator.annotators.TypeEntry;
import com.ibm.supa.annotator.util.text.VisualTextUtil;
import com.ibm.supa.annotator.util.text.location.CharOffsetLocation;
import com.ibm.supa.annotator.util.text.location.Interval;
import com.ibm.uima.analysis_engine.ResultSpecification;
import com.ibm.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorInitializationException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorProcessException;
import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.text.AnnotationFS;
import com.ibm.uima.cas.text.TCAS;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockAnnotator
extends SupaBaseAnnotator {
    private static Pattern sFirstLetterPattern = Pattern.compile("(?:\\s|^)([_a-zA-Z])");
    private int mTabWidth;
    private IBlockTitleClassifier mBlockTitleClassifier;
    private int mNumSplitBlockPasses;
    private boolean mAutoResetClassifier;
    private int _startingCharPos;
    private int _startBlockPos;
    private int _endBlockPos;

    public BlockAnnotator() {
        this(DefaultConfigurationInfo.INSTANCE);
    }

    protected BlockAnnotator(ConfigurationInfo configInfo) {
        this(4, 1, new LearningBlockTitleClassiifier(10), true, configInfo);
    }

    public BlockAnnotator(int tabWidth, int numSplitBlockPasses, IBlockTitleClassifier blockTitleClassifier, boolean autoResetClassifier) {
        this(tabWidth, numSplitBlockPasses, blockTitleClassifier, autoResetClassifier, DefaultConfigurationInfo.INSTANCE);
    }

    protected BlockAnnotator(int tabWidth, int numSplitBlockPasses, IBlockTitleClassifier blockTitleClassifier, boolean autoResetClassifier, ConfigurationInfo configInfo) {
        super(configInfo);
        this.mTabWidth = tabWidth;
        this.mNumSplitBlockPasses = numSplitBlockPasses;
        this.mBlockTitleClassifier = blockTitleClassifier;
        this.mAutoResetClassifier = autoResetClassifier;
    }

    public int getNumSplitBlockPasses() {
        return this.mNumSplitBlockPasses;
    }

    public void setNumSplitBlockPasses(int numSplitBlockPasses) {
        this.mNumSplitBlockPasses = numSplitBlockPasses;
    }

    public int getTabWidth() {
        return this.mTabWidth;
    }

    public void setTabWidth(int tabWidth) {
        this.mTabWidth = tabWidth;
    }

    public boolean autoResetsClassifier() {
        return this.mAutoResetClassifier;
    }

    public void setAutoResetClassifier(boolean enabled) {
        this.mAutoResetClassifier = enabled;
    }

    public void resetClassifier() {
        this.mBlockTitleClassifier.reset();
    }

    @Override
    public void subProcess(TCAS aTCAS, ResultSpecification aResultSpec, FileTypeGroupConfig cfg) throws AnnotatorProcessException {
        try {
            String docText = aTCAS.getDocumentText();
            List<Interval> intervals = this.getRangesToAnnotate(null, cfg.getContainingAnnotationCASTypes(), cfg.isSkipSubAnnotations(), aTCAS);
            this.annotate(aTCAS, this.process(docText, intervals), cfg, docText);
        }
        catch (Exception e) {
            throw new AnnotatorProcessException((Throwable)e);
        }
    }

    private void annotate(TCAS aTCAS, List<BlockPositions> blocks, FileTypeGroupConfig cfg, String docText) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        Type blockType = aTCAS.getTypeSystem().getType("com.ibm.supa.type.Block");
        for (BlockPositions pos : blocks) {
            AnnotationFS fs = aTCAS.createAnnotation(blockType, pos.start, pos.end);
            if (pos.blockTitleLength != -1) {
                fs.setFeatureValueFromString(blockType.getFeatureByBaseName("Title"), docText.substring(pos.start, pos.start + pos.blockTitleLength));
            }
            aTCAS.getIndexRepository().addFS((FeatureStructure)fs);
        }
        TypeEntry[] typeEntries = cfg.getTypeEntries();
        int i = 0;
        while (i < typeEntries.length) {
            FilteredText text = this.getFilteredText(typeEntries[i], aTCAS);
            text.filter();
            List<MatchInfo> matchesToAnnotate = new ArrayList<MatchInfo>();
            for (BlockPositions pos : blocks) {
                matchesToAnnotate.addAll(this.getMatches(pos, text, typeEntries[i], aTCAS));
            }
            matchesToAnnotate = this.getLimittedRanges(matchesToAnnotate, typeEntries[i].mLimittingCasTypes, false, aTCAS);
            this.addAnnotationsToCAS(aTCAS, matchesToAnnotate, typeEntries[i], text, false, null);
            this.saveFilteredTextInstance(typeEntries[i], text);
            ++i;
        }
    }

    private List<MatchInfo> getMatches(BlockPositions pos, FilteredText text, TypeEntry typeEntry, TCAS aTCAS) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        List<MatchInfo> result = new ArrayList<MatchInfo>();
        int startPos = text.getFilteredPos(pos.start);
        if (startPos == -1) {
            return result;
        }
        int endPos = text.getNearestFilteredPos(pos.end);
        if (startPos >= endPos) {
            return result;
        }
        if (typeEntry.mLimittingCasTypes.length == 0) {
            result = this.matchPatterns(aTCAS, text, startPos, endPos, typeEntry, false, null);
        } else {
            if (typeEntry.mPatternsInfo.length <= 1) {
                return result;
            }
            ArrayList<MatchInfo> intervals = new ArrayList<MatchInfo>();
            int endTitlePos = text.getNearestFilteredPos(pos.start + pos.blockTitleLength);
            if (startPos >= endTitlePos) {
                return result;
            }
            String subText = text.getFilteredText().substring(startPos, endTitlePos);
            TypeEntry.PatternInfo patternInfo = typeEntry.mPatternsInfo[0];
            Pattern mainPattern = this.getPattern(aTCAS, typeEntry, patternInfo.getPatternPair(), text);
            TypeEntry.PatternInfo.FeatureStructure pfs = patternInfo.getFirstFeatureStructure();
            this.matchPattern(typeEntry.mCasType, text, subText, startPos, endPos, mainPattern, pfs.getTypeGroupNum(), pfs.getFeaturesConfig(), true, true, intervals);
            if (intervals.size() == 0) {
                return result;
            }
            TypeEntry.PatternInfo[] patternsInfo = new TypeEntry.PatternInfo[typeEntry.mPatternsInfo.length - 1];
            System.arraycopy(typeEntry.mPatternsInfo, 1, patternsInfo, 0, patternsInfo.length);
            if (this.shouldIgnoreBlockTitle(typeEntry.mLimittingCasTypes)) {
                if (endTitlePos >= endPos) {
                    return result;
                }
                startPos = endTitlePos;
            }
            result = this.matchPatterns(aTCAS, text, startPos, endPos, typeEntry, null, patternsInfo, null, typeEntry.mStartingCasType != null, false, null);
        }
        return this.filterEmptyResults(result, text);
    }

    private List<MatchInfo> filterEmptyResults(List<MatchInfo> result, FilteredText text) {
        ArrayList<MatchInfo> filteredResult = new ArrayList<MatchInfo>();
        for (MatchInfo matchInfo : result) {
            int blockStartPos = text.getFilteredPos(matchInfo.getInterval().getStart().getOffset());
            if (blockStartPos == -1) {
                blockStartPos = text.getFloorPos() + 1;
            } else if (text.onAReplacedCharFilteredInterval() && !text.atTheStartOfTheFilteredInterval()) {
                ++blockStartPos;
            }
            int blockEndPos = text.getFilteredPos(matchInfo.getInterval().getEnd().getOffset());
            if (blockEndPos == -1) {
                blockEndPos = text.getFloorPos() + 1;
            }
            String blockStr = text.getFilteredText().substring(blockStartPos, blockEndPos);
            Pattern word = Pattern.compile("[a-zA-Z_0-9]+");
            Matcher textM = word.matcher(blockStr);
            if (!textM.find()) continue;
            filteredResult.add(matchInfo);
        }
        return filteredResult;
    }

    private boolean shouldIgnoreBlockTitle(TypeEntry.LimittingCASType[] types) {
        int i = 0;
        while (i < types.length) {
            if (types[i].isInclusive() && types[i].getLimitation() == TypeEntry.LimittingCASType.Limitation.END && types[i].getType().toString().equals("com.ibm.supa.type.Block")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private List<BlockPositions> process(String docText, Iterable<Interval> ranges) {
        int endPos;
        int startPos;
        LinkedList<BlockPositions> blocks = new LinkedList<BlockPositions>();
        LinkedList<Interval> unusedRanges = new LinkedList<Interval>();
        for (Interval range : ranges) {
            startPos = ((CharOffsetLocation)range.getStart()).getOffset();
            endPos = ((CharOffsetLocation)range.getEnd()).getOffset();
            int numBlocks = blocks.size();
            this.addAllNestedBlocks(blocks, docText, startPos, endPos);
            if (blocks.size() != numBlocks) continue;
            unusedRanges.add(range);
        }
        int i = 0;
        while (i < this.mNumSplitBlockPasses) {
            this.splitBlocks(blocks, docText);
            ++i;
        }
        for (Interval range : unusedRanges) {
            startPos = ((CharOffsetLocation)range.getStart()).getOffset();
            endPos = ((CharOffsetLocation)range.getEnd()).getOffset();
            int lineStartPos = startPos;
            while (lineStartPos != -1 && lineStartPos < endPos) {
                int nextLineStartPos = VisualTextUtil.getNextLineStartPos(docText, lineStartPos);
                int startCharPos = this.getPossibleStartingCharPos(docText, lineStartPos, lineStartPos, endPos);
                if (startCharPos != -1) {
                    String line;
                    int titleLength;
                    int endLinePos = endPos;
                    if (nextLineStartPos >= 0) {
                        endLinePos = Math.min(endLinePos, nextLineStartPos);
                    }
                    if (startCharPos < endLinePos && (titleLength = this.mBlockTitleClassifier.getBlockTitleLength(line = docText.substring(startCharPos, endLinePos), false)) != -1) {
                        int visualOffset = VisualTextUtil.getVisualOffset(docText, this.mTabWidth, startCharPos);
                        blocks.add(new BlockPositions(startCharPos, endLinePos, visualOffset, titleLength));
                    }
                }
                lineStartPos = nextLineStartPos;
            }
        }
        if (this.mAutoResetClassifier) {
            this.resetClassifier();
        }
        return blocks;
    }

    private void splitBlocks(List<BlockPositions> blocks, String text) {
        ListIterator<BlockPositions> it = blocks.listIterator();
        while (it.hasNext()) {
            BlockPositions curr = it.next();
            int lineStartPos = curr.start;
            boolean firstLine = true;
            LinkedList<BlockPositions> newBlocks = new LinkedList<BlockPositions>();
            boolean currIsNew = false;
            while (lineStartPos != -1 && lineStartPos < curr.end && (firstLine || this.isFirstLevelBlockLine(text, lineStartPos, curr.end, curr.visualOffset))) {
                int titleLength;
                int startCharPos = this.getPossibleStartingCharPos(text, lineStartPos, lineStartPos, curr.end);
                if (!(startCharPos < 0 || (titleLength = this.mBlockTitleClassifier.getBlockTitleLength(text.substring(startCharPos, curr.end), false)) == -1 || firstLine && curr.blockTitleLength != -1)) {
                    if (firstLine) {
                        curr = new BlockPositions(curr.start, curr.end, curr.visualOffset, titleLength);
                        newBlocks.addLast(curr);
                    } else {
                        if (currIsNew) {
                            newBlocks.removeLast();
                        }
                        newBlocks.addLast(new BlockPositions(curr.start, startCharPos, curr.visualOffset, curr.blockTitleLength));
                        curr = new BlockPositions(startCharPos, curr.end, curr.visualOffset, titleLength);
                        newBlocks.addLast(curr);
                    }
                    currIsNew = true;
                }
                firstLine = false;
                lineStartPos = VisualTextUtil.getNextLineStartPos(text, lineStartPos);
            }
            if (newBlocks.isEmpty()) continue;
            it.remove();
            while (!newBlocks.isEmpty()) {
                it.add((BlockPositions)newBlocks.remove(0));
            }
        }
    }

    private void addAllNestedBlocks(List<BlockPositions> blocks, String docText, int startPos, int endPos) {
        int nextStartPos = startPos;
        while (nextStartPos != -1 && nextStartPos < endPos) {
            nextStartPos = this.addNestedBlock(blocks, docText, nextStartPos, endPos);
        }
    }

    private int addNestedBlock(List<BlockPositions> blocks, String docText, int startPos, int endPos) {
        BlockPositions block = this.getOuterBlock(docText, startPos, endPos);
        if (block == null) {
            return -1;
        }
        blocks.add(block);
        int nextStart = VisualTextUtil.getNextLineStartPos(docText, this._startingCharPos);
        if (block.blockTitleLength != -1) {
            nextStart = Math.max(nextStart, block.start + block.blockTitleLength + 1);
        }
        this.addAllNestedBlocks(blocks, docText, nextStart, this._endBlockPos);
        return this._endBlockPos;
    }

    private BlockPositions getOuterBlock(String text, int startPos, int endPos) {
        int visualOffset;
        int possibleStartingCharPos;
        block3: {
            int nextLineStartPos;
            int lineStartPos = VisualTextUtil.getLineStartPos(text, startPos);
            possibleStartingCharPos = this.getPossibleStartingCharPos(text, lineStartPos, startPos, endPos);
            if (possibleStartingCharPos == -1) {
                return null;
            }
            do {
                if ((nextLineStartPos = VisualTextUtil.getNextLineStartPos(text, possibleStartingCharPos)) == -1 || nextLineStartPos >= endPos) {
                    return null;
                }
                visualOffset = VisualTextUtil.getVisualOffset(text, this.mTabWidth, possibleStartingCharPos);
                if (this.isValidInternalBlockLine(text, nextLineStartPos, endPos, visualOffset)) break block3;
            } while ((possibleStartingCharPos = this.getPossibleStartingCharPos(text, lineStartPos = nextLineStartPos, lineStartPos, endPos)) != -1);
            return null;
        }
        this._startingCharPos = possibleStartingCharPos;
        this._endBlockPos = this.getEndBlockPos(text, this._startingCharPos, visualOffset, endPos);
        this._startBlockPos = this.getStartBlockPos(text, this._startingCharPos, visualOffset, startPos);
        return new BlockPositions(this._startBlockPos, this._endBlockPos, visualOffset, text, this.mBlockTitleClassifier);
    }

    private boolean isValidInternalBlockLine(String text, int lineStartPos, int endPos, int visualOffset) {
        if (!this.isWhitespaceAt(text, lineStartPos, endPos, visualOffset)) {
            return false;
        }
        int nextLinePos = VisualTextUtil.getNextLineStartPos(text, lineStartPos);
        int possibleStartCharPos = this.getPossibleStartingCharPos(text, lineStartPos, lineStartPos, endPos);
        if (nextLinePos != -1 && (possibleStartCharPos == -1 || possibleStartCharPos > nextLinePos)) {
            return true;
        }
        return VisualTextUtil.getVisualOffset(text, this.mTabWidth, possibleStartCharPos) > visualOffset;
    }

    private boolean isFirstLevelBlockLine(String text, int lineStartPos, int endPos, int visualOffset) {
        if (this.isWhitespaceAt(text, lineStartPos, endPos, visualOffset)) {
            return false;
        }
        int nextLinePos = VisualTextUtil.getNextLineStartPos(text, lineStartPos);
        if (nextLinePos >= endPos) {
            return false;
        }
        int possibleStartCharPos = this.getPossibleStartingCharPos(text, lineStartPos, lineStartPos, endPos);
        if (nextLinePos != -1 && (possibleStartCharPos == -1 || possibleStartCharPos > nextLinePos)) {
            return true;
        }
        return VisualTextUtil.getVisualOffset(text, this.mTabWidth, possibleStartCharPos) == visualOffset;
    }

    private int getStartBlockPos(String text, int startingCharPos, int visualOffset, int startPos) {
        int startLoc;
        int nextStartingCharPos;
        int lineStartPos;
        int result = startingCharPos;
        int endMatchPos = startingCharPos;
        while ((lineStartPos = VisualTextUtil.getPrevLineStartPos(text, result)) != -1 && (nextStartingCharPos = this.getPossibleStartingCharPos(text, lineStartPos, startLoc = Math.max(lineStartPos, startPos), endMatchPos)) != -1 && nextStartingCharPos != result && nextStartingCharPos >= startPos && VisualTextUtil.getVisualOffset(text, this.mTabWidth, nextStartingCharPos) == visualOffset) {
            result = nextStartingCharPos;
        }
        return result;
    }

    private int getEndBlockPos(String text, int startingCharPos, int visualOffset, int endPos) {
        int lineStartPos = VisualTextUtil.getNextLineStartPos(text, startingCharPos);
        while (lineStartPos != -1 && lineStartPos < endPos && this.isValidInternalBlockLine(text, lineStartPos, endPos, visualOffset)) {
            lineStartPos = VisualTextUtil.getNextLineStartPos(text, lineStartPos);
        }
        if (lineStartPos == -1 || lineStartPos >= endPos) {
            return endPos;
        }
        return lineStartPos;
    }

    private boolean isWhitespaceAt(String text, int lineStartPos, int endPos, int visualOffset) {
        int pos = VisualTextUtil.getPosition(text, this.mTabWidth, lineStartPos, endPos, visualOffset);
        if (pos == -1) {
            return false;
        }
        return Character.isWhitespace(text.charAt(pos));
    }

    private int getPossibleStartingCharPos(String text, int lineStartPos, int startPos, int endPos) {
        Matcher matcher = sFirstLetterPattern.matcher(text.substring(lineStartPos, endPos));
        int adjStartPos = startPos - lineStartPos;
        int adjEndPos = endPos - lineStartPos;
        do {
            if (matcher.find()) continue;
            return -1;
        } while (matcher.start(1) < adjStartPos);
        if (matcher.start(1) >= adjEndPos) {
            return -1;
        }
        return lineStartPos + matcher.start(1);
    }
}

