/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.util.rb_trees;

import com.ibm.uima.util.BinaryTree;
import com.ibm.uima.util.rb_trees.RBTNode;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RedBlackTree {
    RBTNode root = null;
    int size = 0;

    public final int size() {
        return this.size;
    }

    public final void clear() {
        this.root = null;
        this.size = 0;
    }

    public final boolean containsKey(int n) {
        return RBTNode.find(this.root, n) != null;
    }

    public final boolean containsValue(Object object) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (object != iterator.next()) continue;
            return true;
        }
        return false;
    }

    public final boolean put(int n, Object object) {
        if (this.put(new RBTNode(n, object))) {
            ++this.size;
            return true;
        }
        return false;
    }

    public final Object remove(int n) {
        RBTNode rBTNode = RBTNode.find(this.root, n);
        Object object = null;
        if (rBTNode != null) {
            object = rBTNode.element;
            --this.size;
            RBTNode.delete(this, rBTNode);
        }
        return object;
    }

    public final Object get(int n) {
        if (this.root == null) {
            return null;
        }
        RBTNode rBTNode = RBTNode.find(this.root, n);
        if (rBTNode == null) {
            return null;
        }
        return rBTNode.element;
    }

    public final boolean isEmpty() {
        return this.root == null;
    }

    public final int[] keySet() {
        int[] nArray = new int[this.size];
        if (this.root != null) {
            this.root.keys(0, nArray);
        }
        return nArray;
    }

    private final boolean put(RBTNode rBTNode) {
        return RBTNode.insert(this, rBTNode);
    }

    public final Object getFirst() {
        return this.getFirstNode().element;
    }

    private final RBTNode getFirstNode() {
        if (this.root == null) {
            return null;
        }
        RBTNode rBTNode = this.root;
        while (rBTNode.left != null) {
            rBTNode = rBTNode.left;
        }
        return rBTNode;
    }

    public Iterator iterator() {
        return new RBTIterator(this);
    }

    public BinaryTree getBinaryTree() {
        if (this.root == null) {
            return null;
        }
        BinaryTree binaryTree = new BinaryTree();
        this.root.getBinaryTree(binaryTree);
        return binaryTree;
    }

    public void printKeys() {
        if (this.root != null) {
            this.root.printKeys(0);
        }
        System.out.println("Size: " + this.size);
    }

    public static void main(String[] stringArray) {
        int n;
        RedBlackTree redBlackTree = new RedBlackTree();
        redBlackTree.put(1, "a");
        redBlackTree.printKeys();
        System.out.println("");
        redBlackTree.put(2, "b");
        redBlackTree.printKeys();
        System.out.println("");
        redBlackTree.put(3, "c");
        redBlackTree.printKeys();
        System.out.println("");
        redBlackTree.put(4, "d");
        redBlackTree.printKeys();
        System.out.println("");
        redBlackTree.put(5, "e");
        redBlackTree.printKeys();
        System.out.println("");
        redBlackTree.put(6, "f");
        redBlackTree.printKeys();
        System.out.println("");
        redBlackTree.put(7, "g");
        redBlackTree.printKeys();
        System.out.println("");
        redBlackTree.put(8, "h");
        redBlackTree.printKeys();
        System.out.println("");
        redBlackTree.put(9, "i");
        redBlackTree.printKeys();
        System.out.println("");
        redBlackTree.put(10, "j");
        redBlackTree.printKeys();
        System.out.println("");
        redBlackTree.put(3, "k");
        redBlackTree.printKeys();
        System.out.println("");
        int[] nArray = redBlackTree.keySet();
        System.out.print("[");
        for (n = 0; n < nArray.length; ++n) {
            if (n != 0) {
                System.out.print(",");
            }
            System.out.print(nArray[n]);
        }
        System.out.println("]");
        redBlackTree.remove(1);
        redBlackTree.printKeys();
        System.out.println("");
        redBlackTree.remove(2);
        redBlackTree.printKeys();
        System.out.println("");
        redBlackTree.remove(3);
        redBlackTree.printKeys();
        System.out.println("");
        redBlackTree.remove(4);
        redBlackTree.printKeys();
        System.out.println("");
        redBlackTree.remove(5);
        redBlackTree.printKeys();
        System.out.println("");
        redBlackTree.remove(6);
        redBlackTree.printKeys();
        System.out.println("");
        nArray = redBlackTree.keySet();
        System.out.print("[");
        for (n = 0; n < nArray.length; ++n) {
            if (n != 0) {
                System.out.print(",");
            }
            System.out.print(nArray[n]);
        }
        System.out.println("]");
    }

    private static class RBTIterator
    implements Iterator {
        RBTNode current;

        RBTIterator(RedBlackTree redBlackTree) {
            this.current = redBlackTree.getFirstNode();
        }

        public boolean hasNext() {
            return this.current != null;
        }

        public Object next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Object object = this.current.element;
            this.current = this.current.successor();
            return object;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

