/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.util.rb_trees;

import com.ibm.uima.util.BinaryTree;
import com.ibm.uima.util.rb_trees.RBTKeyValuePair;
import com.ibm.uima.util.rb_trees.RedBlackTree;

class RBTNode {
    private static final boolean RED = true;
    private static final boolean BLACK = false;
    private int key;
    private boolean color;
    private RBTNode parent;
    RBTNode left;
    RBTNode right;
    Object element;
    private static final int indentInc = 2;

    private RBTNode(int n, boolean bl, RBTNode rBTNode, RBTNode rBTNode2, RBTNode rBTNode3, Object object) {
        this.key = n;
        this.color = bl;
        this.parent = rBTNode;
        this.left = rBTNode2;
        this.right = rBTNode3;
        this.element = object;
    }

    RBTNode(int n, Object object) {
        this(n, false, null, null, null, object);
    }

    static final RBTNode find(RBTNode rBTNode, int n) {
        while (rBTNode != null && rBTNode.key != n) {
            if (n < rBTNode.key) {
                rBTNode = rBTNode.left;
                continue;
            }
            rBTNode = rBTNode.right;
        }
        return rBTNode;
    }

    final RBTNode successor() {
        RBTNode rBTNode = this;
        if (rBTNode.right != null) {
            rBTNode = rBTNode.right;
            while (rBTNode.left != null) {
                rBTNode = rBTNode.left;
            }
            return rBTNode;
        }
        RBTNode rBTNode2 = rBTNode.parent;
        while (rBTNode2 != null && rBTNode == rBTNode2.right) {
            rBTNode = rBTNode2;
            rBTNode2 = rBTNode.parent;
        }
        return rBTNode2;
    }

    static final boolean insert(RedBlackTree redBlackTree, RBTNode rBTNode) {
        if (!RBTNode.treeInsert(redBlackTree, rBTNode)) {
            return false;
        }
        rBTNode.color = true;
        while (rBTNode != redBlackTree.root && rBTNode.parent.color) {
            RBTNode rBTNode2;
            if (rBTNode.parent == rBTNode.parent.parent.left) {
                rBTNode2 = rBTNode.parent.parent.right;
                if (RBTNode.colorOf(rBTNode2)) {
                    rBTNode.parent.color = false;
                    RBTNode.setColor(rBTNode2, false);
                    rBTNode.parent.parent.color = true;
                    rBTNode = rBTNode.parent.parent;
                    continue;
                }
                if (rBTNode == rBTNode.parent.right) {
                    rBTNode = rBTNode.parent;
                    rBTNode.leftRotate(redBlackTree);
                }
                rBTNode.parent.color = false;
                rBTNode.parent.parent.color = true;
                rBTNode.parent.parent.rightRotate(redBlackTree);
                continue;
            }
            rBTNode2 = rBTNode.parent.parent.left;
            if (RBTNode.colorOf(rBTNode2)) {
                rBTNode.parent.color = false;
                RBTNode.setColor(rBTNode2, false);
                rBTNode.parent.parent.color = true;
                rBTNode = rBTNode.parent.parent;
                continue;
            }
            if (rBTNode == rBTNode.parent.left) {
                rBTNode = rBTNode.parent;
                rBTNode.rightRotate(redBlackTree);
            }
            rBTNode.parent.color = false;
            rBTNode.parent.parent.color = true;
            rBTNode.parent.parent.leftRotate(redBlackTree);
        }
        redBlackTree.root.color = false;
        return true;
    }

    private static final boolean treeInsert(RedBlackTree redBlackTree, RBTNode rBTNode) {
        RBTNode rBTNode2 = null;
        RBTNode rBTNode3 = redBlackTree.root;
        while (rBTNode3 != null) {
            rBTNode2 = rBTNode3;
            if (rBTNode.key < rBTNode3.key) {
                rBTNode3 = rBTNode3.left;
                continue;
            }
            if (rBTNode.key > rBTNode3.key) {
                rBTNode3 = rBTNode3.right;
                continue;
            }
            rBTNode3.element = rBTNode.element;
            return false;
        }
        rBTNode.parent = rBTNode2;
        if (rBTNode2 == null) {
            redBlackTree.root = rBTNode;
        } else if (rBTNode.key < rBTNode2.key) {
            rBTNode2.left = rBTNode;
        } else {
            rBTNode2.right = rBTNode;
        }
        return true;
    }

    private final void leftRotate(RedBlackTree redBlackTree) {
        RBTNode rBTNode = this.right;
        this.right = rBTNode.left;
        if (rBTNode.left != null) {
            rBTNode.left.parent = this;
        }
        rBTNode.parent = this.parent;
        if (this.parent == null) {
            redBlackTree.root = rBTNode;
        } else if (this == this.parent.left) {
            this.parent.left = rBTNode;
        } else {
            this.parent.right = rBTNode;
        }
        rBTNode.left = this;
        this.parent = rBTNode;
    }

    private final void rightRotate(RedBlackTree redBlackTree) {
        RBTNode rBTNode = this.left;
        this.left = rBTNode.right;
        if (rBTNode.right != null) {
            rBTNode.right.parent = this;
        }
        rBTNode.parent = this.parent;
        if (this.parent == null) {
            redBlackTree.root = rBTNode;
        } else if (this == this.parent.right) {
            this.parent.right = rBTNode;
        } else {
            this.parent.left = rBTNode;
        }
        rBTNode.right = this;
        this.parent = rBTNode;
    }

    static final void delete(RedBlackTree redBlackTree, RBTNode rBTNode) {
        RBTNode rBTNode2 = null;
        RBTNode rBTNode3 = rBTNode.left == null || rBTNode.right == null ? rBTNode : rBTNode.successor();
        RBTNode rBTNode4 = rBTNode3.left != null ? rBTNode3.left : rBTNode3.right;
        if (rBTNode4 != null) {
            rBTNode4.parent = rBTNode3.parent;
        } else {
            rBTNode2 = rBTNode3.parent;
        }
        if (rBTNode3.parent == null) {
            redBlackTree.root = rBTNode4;
        } else if (rBTNode3 == rBTNode3.parent.left) {
            rBTNode3.parent.left = rBTNode4;
        } else {
            rBTNode3.parent.right = rBTNode4;
        }
        if (rBTNode3 != rBTNode) {
            rBTNode.key = rBTNode3.key;
            rBTNode.element = rBTNode3.element;
        }
        if (!rBTNode3.color) {
            if (rBTNode4 == null) {
                RBTNode.deleteFixupNull(redBlackTree, rBTNode2);
            } else {
                RBTNode.deleteFixup(redBlackTree, rBTNode4);
            }
        }
    }

    private static final void deleteFixup(RedBlackTree redBlackTree, RBTNode rBTNode) {
        while (rBTNode != redBlackTree.root && !rBTNode.color) {
            RBTNode rBTNode2;
            if (rBTNode == rBTNode.parent.left) {
                rBTNode2 = rBTNode.parent.right;
                if (rBTNode2.color) {
                    rBTNode2.color = false;
                    rBTNode.parent.color = true;
                    rBTNode.parent.leftRotate(redBlackTree);
                    rBTNode2 = rBTNode.parent.right;
                }
                if (!RBTNode.colorOf(RBTNode.leftOf(rBTNode2)) && !RBTNode.colorOf(RBTNode.rightOf(rBTNode2))) {
                    rBTNode2.color = true;
                    rBTNode = rBTNode.parent;
                    continue;
                }
                if (!RBTNode.colorOf(RBTNode.rightOf(rBTNode2))) {
                    rBTNode2.color = true;
                    rBTNode2.rightRotate(redBlackTree);
                    rBTNode2 = rBTNode.parent.right;
                }
                rBTNode2.color = rBTNode.parent.color;
                rBTNode.parent.color = false;
                if (rBTNode2.right != null) {
                    rBTNode2.right.color = false;
                }
                rBTNode.parent.leftRotate(redBlackTree);
                rBTNode = redBlackTree.root;
                continue;
            }
            rBTNode2 = rBTNode.parent.left;
            if (rBTNode2.color) {
                rBTNode2.color = false;
                rBTNode.parent.color = true;
                rBTNode.parent.rightRotate(redBlackTree);
                rBTNode2 = rBTNode.parent.left;
            }
            if (!RBTNode.colorOf(RBTNode.rightOf(rBTNode2)) && !RBTNode.colorOf(RBTNode.leftOf(rBTNode2))) {
                rBTNode2.color = true;
                rBTNode = rBTNode.parent;
                continue;
            }
            if (!RBTNode.colorOf(RBTNode.leftOf(rBTNode2))) {
                rBTNode2.color = true;
                rBTNode2.leftRotate(redBlackTree);
                rBTNode2 = rBTNode.parent.left;
            }
            rBTNode2.color = rBTNode.parent.color;
            rBTNode.parent.color = false;
            if (rBTNode2.left != null) {
                rBTNode2.left.color = false;
            }
            rBTNode.parent.rightRotate(redBlackTree);
            rBTNode = redBlackTree.root;
        }
        rBTNode.color = false;
    }

    private static final void deleteFixupNull(RedBlackTree redBlackTree, RBTNode rBTNode) {
        RBTNode rBTNode2;
        if (rBTNode == null) {
            return;
        }
        if (rBTNode.left == null) {
            rBTNode2 = rBTNode.right;
            if (rBTNode2.color) {
                rBTNode2.color = false;
                rBTNode.color = true;
                rBTNode.leftRotate(redBlackTree);
                rBTNode2 = rBTNode.right;
            }
            if (!RBTNode.colorOf(RBTNode.leftOf(rBTNode2)) && !RBTNode.colorOf(RBTNode.rightOf(rBTNode2))) {
                rBTNode2.color = true;
            } else {
                if (!RBTNode.colorOf(RBTNode.rightOf(rBTNode2))) {
                    rBTNode2.color = true;
                    rBTNode2.rightRotate(redBlackTree);
                    rBTNode2 = rBTNode.right;
                }
                rBTNode2.color = rBTNode.color;
                rBTNode.color = false;
                if (rBTNode2.right != null) {
                    rBTNode2.right.color = false;
                }
                rBTNode.leftRotate(redBlackTree);
                rBTNode = redBlackTree.root;
            }
        } else {
            rBTNode2 = rBTNode.left;
            if (rBTNode2.color) {
                rBTNode2.color = false;
                rBTNode.color = true;
                rBTNode.rightRotate(redBlackTree);
                rBTNode2 = rBTNode.left;
            }
            if (!RBTNode.colorOf(RBTNode.rightOf(rBTNode2)) && !RBTNode.colorOf(RBTNode.leftOf(rBTNode2))) {
                rBTNode2.color = true;
            } else {
                if (!RBTNode.colorOf(RBTNode.leftOf(rBTNode2))) {
                    rBTNode2.color = true;
                    rBTNode2.leftRotate(redBlackTree);
                    rBTNode2 = rBTNode.left;
                }
                rBTNode2.color = rBTNode.color;
                rBTNode.color = false;
                if (rBTNode2.left != null) {
                    rBTNode2.left.color = false;
                }
                rBTNode.rightRotate(redBlackTree);
                rBTNode = redBlackTree.root;
            }
        }
        while (rBTNode != redBlackTree.root && !rBTNode.color) {
            if (rBTNode == rBTNode.parent.left) {
                rBTNode2 = rBTNode.parent.right;
                if (rBTNode2.color) {
                    rBTNode2.color = false;
                    rBTNode.parent.color = true;
                    rBTNode.parent.leftRotate(redBlackTree);
                    rBTNode2 = rBTNode.parent.right;
                }
                if (!RBTNode.colorOf(RBTNode.leftOf(rBTNode2)) && !RBTNode.colorOf(RBTNode.rightOf(rBTNode2))) {
                    rBTNode2.color = true;
                    rBTNode = rBTNode.parent;
                    continue;
                }
                if (!RBTNode.colorOf(RBTNode.rightOf(rBTNode2))) {
                    rBTNode2.color = true;
                    rBTNode2.rightRotate(redBlackTree);
                    rBTNode2 = rBTNode.parent.right;
                }
                rBTNode2.color = rBTNode.parent.color;
                rBTNode.parent.color = false;
                if (rBTNode2.right != null) {
                    rBTNode2.right.color = false;
                }
                rBTNode.parent.leftRotate(redBlackTree);
                rBTNode = redBlackTree.root;
                continue;
            }
            rBTNode2 = rBTNode.parent.left;
            if (rBTNode2.color) {
                rBTNode2.color = false;
                rBTNode.parent.color = true;
                rBTNode.parent.rightRotate(redBlackTree);
                rBTNode2 = rBTNode.parent.left;
            }
            if (!RBTNode.colorOf(RBTNode.rightOf(rBTNode2)) && !RBTNode.colorOf(RBTNode.leftOf(rBTNode2))) {
                rBTNode2.color = true;
                rBTNode = rBTNode.parent;
                continue;
            }
            if (!RBTNode.colorOf(RBTNode.leftOf(rBTNode2))) {
                rBTNode2.color = true;
                rBTNode2.leftRotate(redBlackTree);
                rBTNode2 = rBTNode.parent.left;
            }
            rBTNode2.color = rBTNode.parent.color;
            rBTNode.parent.color = false;
            if (rBTNode2.left != null) {
                rBTNode2.left.color = false;
            }
            rBTNode.parent.rightRotate(redBlackTree);
            rBTNode = redBlackTree.root;
        }
        rBTNode.color = false;
    }

    int keys(int n, int[] nArray) {
        int n2 = n;
        if (this.left != null) {
            n2 = this.left.keys(n2, nArray);
        }
        nArray[n2] = this.key;
        ++n2;
        if (this.right != null) {
            n2 = this.right.keys(n2, nArray);
        }
        return n2;
    }

    private static final boolean colorOf(RBTNode rBTNode) {
        return rBTNode == null ? false : rBTNode.color;
    }

    private static final void setColor(RBTNode rBTNode, boolean bl) {
        if (rBTNode != null) {
            rBTNode.color = bl;
        }
    }

    private static final RBTNode leftOf(RBTNode rBTNode) {
        return rBTNode == null ? null : rBTNode.left;
    }

    private static final RBTNode rightOf(RBTNode rBTNode) {
        return rBTNode == null ? null : rBTNode.right;
    }

    public void printKeys(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(' ');
        }
        System.out.print(this.key);
        System.out.print(":");
        if (this.color) {
            System.out.println("red");
        } else {
            System.out.println("black");
        }
        n += 2;
        if (this.left != null) {
            this.left.printKeys(n);
        }
        if (this.right != null) {
            this.right.printKeys(n);
        }
    }

    public void printElements(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(' ');
        }
        System.out.println(this.element.toString());
        n += 2;
        if (this.left != null) {
            this.left.printElements(n);
        }
        if (this.right != null) {
            this.right.printElements(n);
        }
    }

    void getBinaryTree(BinaryTree binaryTree) {
        BinaryTree binaryTree2;
        binaryTree.setValue(new RBTKeyValuePair(this.key, this.element));
        if (this.left != null) {
            binaryTree2 = binaryTree.newLeftDtr();
            this.left.getBinaryTree(binaryTree2);
        }
        if (this.right != null) {
            binaryTree2 = binaryTree.newRightDtr();
            this.right.getBinaryTree(binaryTree2);
        }
    }
}

