/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.util.rb_trees;

import com.ibm.uima.util.rb_trees.IntRBTNode;
import java.util.NoSuchElementException;

public class IntRedBlackTree {
    IntRBTNode root = null;
    int size = 0;

    public final int size() {
        return this.size;
    }

    public final void clear() {
        this.root = null;
        this.size = 0;
    }

    public final boolean containsKey(int n) {
        return IntRBTNode.find(this.root, n) != null;
    }

    public final boolean containsValue(int n) {
        IntRBTIterator intRBTIterator = this.iterator();
        while (intRBTIterator.hasNext()) {
            if (n != intRBTIterator.next()) continue;
            return true;
        }
        return false;
    }

    public final boolean put(int n, int n2) {
        if (this.put(new IntRBTNode(n, n2))) {
            ++this.size;
            return true;
        }
        return false;
    }

    public final int remove(int n) throws NoSuchElementException {
        int n2;
        IntRBTNode intRBTNode = IntRBTNode.find(this.root, n);
        if (intRBTNode != null) {
            n2 = intRBTNode.element;
            --this.size;
        } else {
            throw new NoSuchElementException();
        }
        IntRBTNode.delete(this, intRBTNode);
        return n2;
    }

    public final int get(int n) throws NoSuchElementException {
        if (this.root == null) {
            throw new NoSuchElementException();
        }
        IntRBTNode intRBTNode = IntRBTNode.find(this.root, n);
        if (intRBTNode == null) {
            throw new NoSuchElementException();
        }
        return intRBTNode.element;
    }

    public final boolean isEmpty() {
        return this.root == null;
    }

    public final int[] keySet() {
        int[] nArray = new int[this.size];
        if (this.root != null) {
            this.root.keys(0, nArray);
        }
        return nArray;
    }

    private final boolean put(IntRBTNode intRBTNode) {
        return IntRBTNode.insert(this, intRBTNode);
    }

    public final int getFirst() {
        return this.getFirstNode().element;
    }

    private final IntRBTNode getFirstNode() {
        if (this.root == null) {
            return null;
        }
        IntRBTNode intRBTNode = this.root;
        while (intRBTNode.left != null) {
            intRBTNode = intRBTNode.left;
        }
        return intRBTNode;
    }

    public IntRBTIterator iterator() {
        return new IntRBTIterator(this);
    }

    public void printKeys() {
        if (this.root != null) {
            this.root.printKeys(0);
        }
        System.out.println("Size: " + this.size);
    }

    public int[] toArray(int n) {
        if (this.root == null) {
            return new int[0];
        }
        return this.root.toArray(n);
    }

    public static class IntRBTIterator {
        IntRBTNode current;

        IntRBTIterator(IntRedBlackTree intRedBlackTree) {
            this.current = intRedBlackTree.getFirstNode();
        }

        public boolean hasNext() {
            return this.current != null;
        }

        public int next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            int n = this.current.element;
            this.current = this.current.successor();
            return n;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

