/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.util.rb_trees;

import com.ibm.uima.util.IntStack;
import com.ibm.uima.util.IntVector;
import com.ibm.uima.util.rb_trees.IntRedBlackTree;
import java.util.Stack;

class IntRBTNode {
    private static final boolean RED = true;
    private static final boolean BLACK = false;
    private int key;
    private boolean color;
    private IntRBTNode parent;
    IntRBTNode left;
    IntRBTNode right;
    int element;
    private static final int indentInc = 2;

    private IntRBTNode(int n, boolean bl, IntRBTNode intRBTNode, IntRBTNode intRBTNode2, IntRBTNode intRBTNode3, int n2) {
        this.key = n;
        this.color = bl;
        this.parent = intRBTNode;
        this.left = intRBTNode2;
        this.right = intRBTNode3;
        this.element = n2;
    }

    IntRBTNode(int n, int n2) {
        this(n, false, null, null, null, n2);
    }

    static final IntRBTNode find(IntRBTNode intRBTNode, int n) {
        while (intRBTNode != null && intRBTNode.key != n) {
            if (n < intRBTNode.key) {
                intRBTNode = intRBTNode.left;
                continue;
            }
            intRBTNode = intRBTNode.right;
        }
        return intRBTNode;
    }

    final IntRBTNode successor() {
        IntRBTNode intRBTNode = this;
        if (intRBTNode.right != null) {
            intRBTNode = intRBTNode.right;
            while (intRBTNode.left != null) {
                intRBTNode = intRBTNode.left;
            }
            return intRBTNode;
        }
        IntRBTNode intRBTNode2 = intRBTNode.parent;
        while (intRBTNode2 != null && intRBTNode == intRBTNode2.right) {
            intRBTNode = intRBTNode2;
            intRBTNode2 = intRBTNode.parent;
        }
        return intRBTNode2;
    }

    static final boolean insert(IntRedBlackTree intRedBlackTree, IntRBTNode intRBTNode) {
        if (!IntRBTNode.treeInsert(intRedBlackTree, intRBTNode)) {
            return false;
        }
        intRBTNode.color = true;
        while (intRBTNode != intRedBlackTree.root && intRBTNode.parent.color) {
            IntRBTNode intRBTNode2;
            if (intRBTNode.parent == intRBTNode.parent.parent.left) {
                intRBTNode2 = intRBTNode.parent.parent.right;
                if (IntRBTNode.colorOf(intRBTNode2)) {
                    intRBTNode.parent.color = false;
                    IntRBTNode.setColor(intRBTNode2, false);
                    intRBTNode.parent.parent.color = true;
                    intRBTNode = intRBTNode.parent.parent;
                    continue;
                }
                if (intRBTNode == intRBTNode.parent.right) {
                    intRBTNode = intRBTNode.parent;
                    intRBTNode.leftRotate(intRedBlackTree);
                }
                intRBTNode.parent.color = false;
                intRBTNode.parent.parent.color = true;
                intRBTNode.parent.parent.rightRotate(intRedBlackTree);
                continue;
            }
            intRBTNode2 = intRBTNode.parent.parent.left;
            if (IntRBTNode.colorOf(intRBTNode2)) {
                intRBTNode.parent.color = false;
                IntRBTNode.setColor(intRBTNode2, false);
                intRBTNode.parent.parent.color = true;
                intRBTNode = intRBTNode.parent.parent;
                continue;
            }
            if (intRBTNode == intRBTNode.parent.left) {
                intRBTNode = intRBTNode.parent;
                intRBTNode.rightRotate(intRedBlackTree);
            }
            intRBTNode.parent.color = false;
            intRBTNode.parent.parent.color = true;
            intRBTNode.parent.parent.leftRotate(intRedBlackTree);
        }
        intRedBlackTree.root.color = false;
        return true;
    }

    private static final boolean treeInsert(IntRedBlackTree intRedBlackTree, IntRBTNode intRBTNode) {
        IntRBTNode intRBTNode2 = null;
        IntRBTNode intRBTNode3 = intRedBlackTree.root;
        while (intRBTNode3 != null) {
            intRBTNode2 = intRBTNode3;
            if (intRBTNode.key < intRBTNode3.key) {
                intRBTNode3 = intRBTNode3.left;
                continue;
            }
            if (intRBTNode.key > intRBTNode3.key) {
                intRBTNode3 = intRBTNode3.right;
                continue;
            }
            intRBTNode3.element = intRBTNode.element;
            return false;
        }
        intRBTNode.parent = intRBTNode2;
        if (intRBTNode2 == null) {
            intRedBlackTree.root = intRBTNode;
        } else if (intRBTNode.key < intRBTNode2.key) {
            intRBTNode2.left = intRBTNode;
        } else {
            intRBTNode2.right = intRBTNode;
        }
        return true;
    }

    private final void leftRotate(IntRedBlackTree intRedBlackTree) {
        IntRBTNode intRBTNode = this.right;
        this.right = intRBTNode.left;
        if (intRBTNode.left != null) {
            intRBTNode.left.parent = this;
        }
        intRBTNode.parent = this.parent;
        if (this.parent == null) {
            intRedBlackTree.root = intRBTNode;
        } else if (this == this.parent.left) {
            this.parent.left = intRBTNode;
        } else {
            this.parent.right = intRBTNode;
        }
        intRBTNode.left = this;
        this.parent = intRBTNode;
    }

    private final void rightRotate(IntRedBlackTree intRedBlackTree) {
        IntRBTNode intRBTNode = this.left;
        this.left = intRBTNode.right;
        if (intRBTNode.right != null) {
            intRBTNode.right.parent = this;
        }
        intRBTNode.parent = this.parent;
        if (this.parent == null) {
            intRedBlackTree.root = intRBTNode;
        } else if (this == this.parent.right) {
            this.parent.right = intRBTNode;
        } else {
            this.parent.left = intRBTNode;
        }
        intRBTNode.right = this;
        this.parent = intRBTNode;
    }

    static final void delete(IntRedBlackTree intRedBlackTree, IntRBTNode intRBTNode) {
        IntRBTNode intRBTNode2 = null;
        IntRBTNode intRBTNode3 = intRBTNode.left == null || intRBTNode.right == null ? intRBTNode : intRBTNode.successor();
        IntRBTNode intRBTNode4 = intRBTNode3.left != null ? intRBTNode3.left : intRBTNode3.right;
        if (intRBTNode4 != null) {
            intRBTNode4.parent = intRBTNode3.parent;
        } else {
            intRBTNode2 = intRBTNode3.parent;
        }
        if (intRBTNode3.parent == null) {
            intRedBlackTree.root = intRBTNode4;
        } else if (intRBTNode3 == intRBTNode3.parent.left) {
            intRBTNode3.parent.left = intRBTNode4;
        } else {
            intRBTNode3.parent.right = intRBTNode4;
        }
        if (intRBTNode3 != intRBTNode) {
            intRBTNode.key = intRBTNode3.key;
            intRBTNode.element = intRBTNode3.element;
        }
        if (!intRBTNode3.color) {
            if (intRBTNode4 == null) {
                IntRBTNode.deleteFixupNull(intRedBlackTree, intRBTNode2);
            } else {
                IntRBTNode.deleteFixup(intRedBlackTree, intRBTNode4);
            }
        }
    }

    private static final void deleteFixup(IntRedBlackTree intRedBlackTree, IntRBTNode intRBTNode) {
        while (intRBTNode != intRedBlackTree.root && !intRBTNode.color) {
            IntRBTNode intRBTNode2;
            if (intRBTNode == intRBTNode.parent.left) {
                intRBTNode2 = intRBTNode.parent.right;
                if (intRBTNode2.color) {
                    intRBTNode2.color = false;
                    intRBTNode.parent.color = true;
                    intRBTNode.parent.leftRotate(intRedBlackTree);
                    intRBTNode2 = intRBTNode.parent.right;
                }
                if (!IntRBTNode.colorOf(IntRBTNode.leftOf(intRBTNode2)) && !IntRBTNode.colorOf(IntRBTNode.rightOf(intRBTNode2))) {
                    intRBTNode2.color = true;
                    intRBTNode = intRBTNode.parent;
                    continue;
                }
                if (!IntRBTNode.colorOf(IntRBTNode.rightOf(intRBTNode2))) {
                    intRBTNode2.color = true;
                    intRBTNode2.rightRotate(intRedBlackTree);
                    intRBTNode2 = intRBTNode.parent.right;
                }
                intRBTNode2.color = intRBTNode.parent.color;
                intRBTNode.parent.color = false;
                if (intRBTNode2.right != null) {
                    intRBTNode2.right.color = false;
                }
                intRBTNode.parent.leftRotate(intRedBlackTree);
                intRBTNode = intRedBlackTree.root;
                continue;
            }
            intRBTNode2 = intRBTNode.parent.left;
            if (intRBTNode2.color) {
                intRBTNode2.color = false;
                intRBTNode.parent.color = true;
                intRBTNode.parent.rightRotate(intRedBlackTree);
                intRBTNode2 = intRBTNode.parent.left;
            }
            if (!IntRBTNode.colorOf(IntRBTNode.rightOf(intRBTNode2)) && !IntRBTNode.colorOf(IntRBTNode.leftOf(intRBTNode2))) {
                intRBTNode2.color = true;
                intRBTNode = intRBTNode.parent;
                continue;
            }
            if (!IntRBTNode.colorOf(IntRBTNode.leftOf(intRBTNode2))) {
                intRBTNode2.color = true;
                intRBTNode2.leftRotate(intRedBlackTree);
                intRBTNode2 = intRBTNode.parent.left;
            }
            intRBTNode2.color = intRBTNode.parent.color;
            intRBTNode.parent.color = false;
            if (intRBTNode2.left != null) {
                intRBTNode2.left.color = false;
            }
            intRBTNode.parent.rightRotate(intRedBlackTree);
            intRBTNode = intRedBlackTree.root;
        }
        intRBTNode.color = false;
    }

    private static final void deleteFixupNull(IntRedBlackTree intRedBlackTree, IntRBTNode intRBTNode) {
        IntRBTNode intRBTNode2;
        if (intRBTNode == null) {
            return;
        }
        if (intRBTNode.left == null) {
            intRBTNode2 = intRBTNode.right;
            if (intRBTNode2.color) {
                intRBTNode2.color = false;
                intRBTNode.color = true;
                intRBTNode.leftRotate(intRedBlackTree);
                intRBTNode2 = intRBTNode.right;
            }
            if (!IntRBTNode.colorOf(IntRBTNode.leftOf(intRBTNode2)) && !IntRBTNode.colorOf(IntRBTNode.rightOf(intRBTNode2))) {
                intRBTNode2.color = true;
            } else {
                if (!IntRBTNode.colorOf(IntRBTNode.rightOf(intRBTNode2))) {
                    intRBTNode2.color = true;
                    intRBTNode2.rightRotate(intRedBlackTree);
                    intRBTNode2 = intRBTNode.right;
                }
                intRBTNode2.color = intRBTNode.color;
                intRBTNode.color = false;
                if (intRBTNode2.right != null) {
                    intRBTNode2.right.color = false;
                }
                intRBTNode.leftRotate(intRedBlackTree);
                intRBTNode = intRedBlackTree.root;
            }
        } else {
            intRBTNode2 = intRBTNode.left;
            if (intRBTNode2.color) {
                intRBTNode2.color = false;
                intRBTNode.color = true;
                intRBTNode.rightRotate(intRedBlackTree);
                intRBTNode2 = intRBTNode.left;
            }
            if (!IntRBTNode.colorOf(IntRBTNode.rightOf(intRBTNode2)) && !IntRBTNode.colorOf(IntRBTNode.leftOf(intRBTNode2))) {
                intRBTNode2.color = true;
            } else {
                if (!IntRBTNode.colorOf(IntRBTNode.leftOf(intRBTNode2))) {
                    intRBTNode2.color = true;
                    intRBTNode2.leftRotate(intRedBlackTree);
                    intRBTNode2 = intRBTNode.left;
                }
                intRBTNode2.color = intRBTNode.color;
                intRBTNode.color = false;
                if (intRBTNode2.left != null) {
                    intRBTNode2.left.color = false;
                }
                intRBTNode.rightRotate(intRedBlackTree);
                intRBTNode = intRedBlackTree.root;
            }
        }
        while (intRBTNode != intRedBlackTree.root && !intRBTNode.color) {
            if (intRBTNode == intRBTNode.parent.left) {
                intRBTNode2 = intRBTNode.parent.right;
                if (intRBTNode2.color) {
                    intRBTNode2.color = false;
                    intRBTNode.parent.color = true;
                    intRBTNode.parent.leftRotate(intRedBlackTree);
                    intRBTNode2 = intRBTNode.parent.right;
                }
                if (!IntRBTNode.colorOf(IntRBTNode.leftOf(intRBTNode2)) && !IntRBTNode.colorOf(IntRBTNode.rightOf(intRBTNode2))) {
                    intRBTNode2.color = true;
                    intRBTNode = intRBTNode.parent;
                    continue;
                }
                if (!IntRBTNode.colorOf(IntRBTNode.rightOf(intRBTNode2))) {
                    intRBTNode2.color = true;
                    intRBTNode2.rightRotate(intRedBlackTree);
                    intRBTNode2 = intRBTNode.parent.right;
                }
                intRBTNode2.color = intRBTNode.parent.color;
                intRBTNode.parent.color = false;
                if (intRBTNode2.right != null) {
                    intRBTNode2.right.color = false;
                }
                intRBTNode.parent.leftRotate(intRedBlackTree);
                intRBTNode = intRedBlackTree.root;
                continue;
            }
            intRBTNode2 = intRBTNode.parent.left;
            if (intRBTNode2.color) {
                intRBTNode2.color = false;
                intRBTNode.parent.color = true;
                intRBTNode.parent.rightRotate(intRedBlackTree);
                intRBTNode2 = intRBTNode.parent.left;
            }
            if (!IntRBTNode.colorOf(IntRBTNode.rightOf(intRBTNode2)) && !IntRBTNode.colorOf(IntRBTNode.leftOf(intRBTNode2))) {
                intRBTNode2.color = true;
                intRBTNode = intRBTNode.parent;
                continue;
            }
            if (!IntRBTNode.colorOf(IntRBTNode.leftOf(intRBTNode2))) {
                intRBTNode2.color = true;
                intRBTNode2.leftRotate(intRedBlackTree);
                intRBTNode2 = intRBTNode.parent.left;
            }
            intRBTNode2.color = intRBTNode.parent.color;
            intRBTNode.parent.color = false;
            if (intRBTNode2.left != null) {
                intRBTNode2.left.color = false;
            }
            intRBTNode.parent.rightRotate(intRedBlackTree);
            intRBTNode = intRedBlackTree.root;
        }
        intRBTNode.color = false;
    }

    int keys(int n, int[] nArray) {
        int n2 = n;
        if (this.left != null) {
            n2 = this.left.keys(n2, nArray);
        }
        nArray[n2] = this.key;
        ++n2;
        if (this.right != null) {
            n2 = this.right.keys(n2, nArray);
        }
        return n2;
    }

    int[] toArray(int n) {
        IntVector intVector = new IntVector();
        Stack<IntRBTNode> stack = new Stack<IntRBTNode>();
        IntStack intStack = new IntStack();
        IntRBTNode intRBTNode = this;
        while (true) {
            if (intRBTNode.left != null || intRBTNode.right != null) {
                intVector.add(intRBTNode.key);
                intVector.add(intRBTNode.element);
                if (intRBTNode.left != null) {
                    if (intRBTNode.right != null) {
                        intVector.add(3);
                        intStack.push(intVector.size());
                        intVector.add(-1);
                        stack.push(intRBTNode.right);
                    } else {
                        intVector.add(1);
                    }
                    intRBTNode = intRBTNode.left;
                    continue;
                }
                intVector.add(2);
                intRBTNode = intRBTNode.right;
                continue;
            }
            intVector.add(intRBTNode.key);
            intVector.add(intRBTNode.element);
            intVector.add(0);
            if (intStack.empty()) {
                intRBTNode = null;
            } else {
                intRBTNode = (IntRBTNode)stack.pop();
                int n2 = intStack.pop();
                intVector.set(n2, intVector.size() + n);
            }
            if (intRBTNode == null) break;
        }
        return intVector.toArray();
    }

    private static final boolean colorOf(IntRBTNode intRBTNode) {
        return intRBTNode == null ? false : intRBTNode.color;
    }

    private static final void setColor(IntRBTNode intRBTNode, boolean bl) {
        if (intRBTNode != null) {
            intRBTNode.color = bl;
        }
    }

    private static final IntRBTNode leftOf(IntRBTNode intRBTNode) {
        return intRBTNode == null ? null : intRBTNode.left;
    }

    private static final IntRBTNode rightOf(IntRBTNode intRBTNode) {
        return intRBTNode == null ? null : intRBTNode.right;
    }

    public void printKeys(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(' ');
        }
        System.out.print(this.key);
        System.out.print(":");
        if (this.color) {
            System.out.println("red");
        } else {
            System.out.println("black");
        }
        n += 2;
        if (this.left != null) {
            this.left.printKeys(n);
        }
        if (this.right != null) {
            this.right.printKeys(n);
        }
    }

    public void printElements(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(' ');
        }
        System.out.println(this.element);
        n += 2;
        if (this.left != null) {
            this.left.printElements(n);
        }
        if (this.right != null) {
            this.right.printElements(n);
        }
    }
}

