/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.util.rb_trees;

import com.ibm.uima.util.ComparableIntIterator;
import com.ibm.uima.util.ComparableIntPointerIterator;
import com.ibm.uima.util.IntArrayUtils;
import com.ibm.uima.util.IntComparator;
import com.ibm.uima.util.IntListIterator;
import com.ibm.uima.util.IntPointerIterator;
import com.ibm.uima.util.StringUtils;
import java.util.NoSuchElementException;
import java.util.Random;

public class IntArrayRBT {
    protected int[] key;
    protected int[] left;
    protected int[] right;
    protected int[] parent;
    protected boolean[] color;
    private int next;
    private int size;
    protected int root;
    protected int greatestNode;
    protected static final int default_size = 1024;
    private static final int default_growth_factor = 2;
    private static final int default_multiplication_limit = 2000000;
    private int growth_factor;
    private int multiplication_limit;
    public static final int NIL = 0;
    protected static final boolean red = true;
    protected static final boolean black = false;
    protected final Random rand = new Random();

    public IntArrayRBT() {
        this(1024);
    }

    public IntArrayRBT(int n) {
        if (n < 1) {
            n = 1;
        }
        this.initVars();
        this.growth_factor = 2;
        this.multiplication_limit = 2000000;
        this.key = new int[++n];
        this.left = new int[n];
        this.right = new int[n];
        this.parent = new int[n];
        this.color = new boolean[n];
        this.left[0] = 0;
        this.right[0] = 0;
        this.parent[0] = 0;
        this.color[0] = false;
    }

    private void initVars() {
        this.root = 0;
        this.greatestNode = 0;
        this.next = 1;
        this.size = 0;
    }

    public void flush() {
        this.initVars();
    }

    public final int size() {
        return this.size;
    }

    private void grow(int n) {
        this.key = this.grow(this.key, n);
        this.left = this.grow(this.left, n);
        this.right = this.grow(this.right, n);
        this.parent = this.grow(this.parent, n);
        this.color = this.grow(this.color, n);
    }

    protected int treeInsert(int n) {
        int n2;
        int n3;
        int n4 = this.root;
        if (this.greatestNode != 0 && this.key[this.greatestNode] < n) {
            n3 = this.greatestNode;
            this.greatestNode = n2 = this.newNode(n);
        } else {
            n3 = 0;
            while (n4 != 0) {
                n3 = n4;
                int n5 = this.key[n4];
                if (n < n5) {
                    n4 = this.left[n4];
                    continue;
                }
                if (n == n5) {
                    return -n4;
                }
                n4 = this.right[n4];
            }
            n2 = this.newNode(n);
        }
        if (n3 == 0) {
            this.setAsRoot(n2);
            this.greatestNode = n2;
            this.parent[n2] = 0;
        } else {
            this.parent[n2] = n3;
            if (n < this.key[n3]) {
                this.left[n3] = n2;
            } else {
                this.right[n3] = n2;
            }
        }
        return n2;
    }

    protected int treeInsertWithDups(int n) {
        int n2 = this.root;
        if (this.greatestNode != 0 && this.key[this.greatestNode] <= n) {
            int n3;
            int n4 = this.greatestNode;
            this.greatestNode = n3 = this.newNode(n);
            this.right[n4] = n3;
            this.parent[n3] = n4;
            return n3;
        }
        int n5 = 0;
        while (n2 != 0) {
            n5 = n2;
            int n6 = this.key[n2];
            if (n < n6) {
                n2 = this.left[n2];
                continue;
            }
            if (n > n6) {
                n2 = this.right[n2];
                continue;
            }
            if (this.rand.nextBoolean()) {
                n2 = this.left[n2];
                continue;
            }
            n2 = this.right[n2];
        }
        int n7 = this.newNode(n);
        if (n5 == 0) {
            this.setAsRoot(n7);
            this.greatestNode = n7;
            this.parent[n7] = 0;
        } else {
            this.parent[n7] = n5;
            if (n < this.key[n5]) {
                this.left[n5] = n7;
            } else if (n > this.key[n5]) {
                this.right[n5] = n7;
            } else if (this.rand.nextBoolean()) {
                this.left[n5] = n7;
            } else {
                this.right[n5] = n7;
            }
        }
        return n7;
    }

    protected int newNode(int n) {
        if (this.next >= this.key.length) {
            this.grow(this.next + 1);
        }
        int n2 = this.next++;
        ++this.size;
        this.key[n2] = n;
        this.left[n2] = 0;
        this.right[n2] = 0;
        this.color[n2] = true;
        return n2;
    }

    private final void setAsRoot(int n) {
        this.root = n;
        this.parent[this.root] = 0;
    }

    private final int[] grow(int[] nArray, int n) {
        return IntArrayUtils.ensure_size(nArray, n, this.growth_factor, this.multiplication_limit);
    }

    private final boolean[] grow(boolean[] blArray, int n) {
        return IntArrayUtils.ensure_size(blArray, n, this.growth_factor, this.multiplication_limit);
    }

    private final void leftRotate(int n) {
        int n2 = this.right[n];
        this.right[n] = this.left[n2];
        if (this.left[n2] != 0) {
            this.parent[this.left[n2]] = n;
        }
        this.parent[n2] = this.parent[n];
        if (this.root == n) {
            this.setAsRoot(n2);
        } else if (n == this.left[this.parent[n]]) {
            this.left[this.parent[n]] = n2;
        } else {
            this.right[this.parent[n]] = n2;
        }
        this.left[n2] = n;
        this.parent[n] = n2;
    }

    private final void rightRotate(int n) {
        int n2 = this.left[n];
        this.left[n] = this.right[n2];
        if (this.right[n2] != 0) {
            this.parent[this.right[n2]] = n;
        }
        this.parent[n2] = this.parent[n];
        if (this.root == n) {
            this.setAsRoot(n2);
        } else if (n == this.right[this.parent[n]]) {
            this.right[this.parent[n]] = n2;
        } else {
            this.left[this.parent[n]] = n2;
        }
        this.right[n2] = n;
        this.parent[n] = n2;
    }

    public int insertKey(int n) {
        return this.insertKey(n, false);
    }

    public int insertKeyWithDups(int n) {
        return this.insertKey(n, true);
    }

    private int insertKey(int n, boolean bl) {
        int n2;
        if (this.root == 0) {
            int n3 = this.newNode(n);
            this.setAsRoot(n3);
            this.color[this.root] = false;
            this.greatestNode = n3;
            return n3;
        }
        if (bl) {
            n2 = this.treeInsertWithDups(n);
        } else {
            n2 = this.treeInsert(n);
            if (n2 < 0) {
                return -n2;
            }
        }
        this.color[n2] = true;
        int n4 = n2;
        while (n2 != this.root && this.color[this.parent[n2]]) {
            int n5;
            if (this.parent[n2] == this.left[this.parent[this.parent[n2]]]) {
                n5 = this.right[this.parent[this.parent[n2]]];
                if (this.color[n5]) {
                    this.color[this.parent[n2]] = false;
                    this.color[n5] = false;
                    this.color[this.parent[this.parent[n2]]] = true;
                    n2 = this.parent[this.parent[n2]];
                    continue;
                }
                if (n2 == this.right[this.parent[n2]]) {
                    n2 = this.parent[n2];
                    this.leftRotate(n2);
                }
                this.color[this.parent[n2]] = false;
                this.color[this.parent[this.parent[n2]]] = true;
                this.rightRotate(this.parent[this.parent[n2]]);
                continue;
            }
            n5 = this.left[this.parent[this.parent[n2]]];
            if (this.color[n5]) {
                this.color[this.parent[n2]] = false;
                this.color[n5] = false;
                this.color[this.parent[this.parent[n2]]] = true;
                n2 = this.parent[this.parent[n2]];
                continue;
            }
            if (n2 == this.left[this.parent[n2]]) {
                n2 = this.parent[n2];
                this.rightRotate(n2);
            }
            this.color[this.parent[n2]] = false;
            this.color[this.parent[this.parent[n2]]] = true;
            this.leftRotate(this.parent[this.parent[n2]]);
        }
        this.color[this.root] = false;
        return n4;
    }

    public int findKey(int n) {
        int n2 = this.root;
        while (n2 != 0) {
            if (n < this.key[n2]) {
                n2 = this.left[n2];
                continue;
            }
            if (n == this.key[n2]) {
                return n2;
            }
            n2 = this.right[n2];
        }
        return 0;
    }

    public int findInsertionPoint(int n) {
        int n2;
        int n3 = n2 = this.root;
        while (n2 != 0) {
            n3 = n2;
            if (n < this.key[n2]) {
                n2 = this.left[n2];
                continue;
            }
            if (n == this.key[n2]) {
                while (this.left[n2] != 0 && this.key[this.left[n2]] == this.key[n2]) {
                    n2 = this.left[n2];
                }
                return n2;
            }
            n2 = this.right[n2];
        }
        return n3;
    }

    public int findInsertionPointNoDups(int n) {
        int n2;
        int n3 = n2 = this.root;
        while (n2 != 0) {
            n3 = n2;
            if (n < this.key[n2]) {
                n2 = this.left[n2];
                continue;
            }
            if (n == this.key[n2]) {
                return n2;
            }
            n2 = this.right[n2];
        }
        return n3;
    }

    public final boolean containsKey(int n) {
        return this.findKey(n) != 0;
    }

    private final boolean isLeftDtr(int n) {
        return n != this.root && n == this.left[this.parent[n]];
    }

    private final int getFirstNode() {
        if (this.root == 0) {
            return 0;
        }
        int n = this.root;
        while (this.left[n] != 0) {
            n = this.left[n];
        }
        return n;
    }

    protected final int nextNode(int n) {
        if (this.right[n] != 0) {
            n = this.right[n];
            while (this.left[n] != 0) {
                n = this.left[n];
            }
        } else {
            int n2 = this.parent[n];
            while (n2 != 0 && n == this.right[n2]) {
                n = n2;
                n2 = this.parent[n2];
            }
            n = n2;
        }
        return n;
    }

    private final int previousNode(int n) {
        if (this.left[n] != 0) {
            n = this.left[n];
            while (this.right[n] != 0) {
                n = this.right[n];
            }
        } else {
            while (this.isLeftDtr(n)) {
                n = this.parent[n];
            }
            if (n == this.root) {
                return 0;
            }
            n = this.parent[n];
        }
        return n;
    }

    public boolean deleteKey(int n) {
        int n2 = this.findKey(n);
        if (n2 == 0) {
            return false;
        }
        this.deleteNode(n2);
        --this.size;
        return true;
    }

    private void deleteNode(int n) {
        int n2 = this.left[n] == 0 || this.right[n] == 0 ? n : this.nextNode(n);
        int n3 = this.left[n2] != 0 ? this.left[n2] : this.right[n2];
        this.parent[n3] = this.parent[n2];
        if (this.parent[n2] == 0) {
            this.setAsRoot(n3);
        } else if (n2 == this.left[this.parent[n2]]) {
            this.left[this.parent[n2]] = n3;
        } else {
            this.right[this.parent[n2]] = n3;
        }
        if (n2 != n) {
            this.key[n] = this.key[n2];
        }
        if (!this.color[n2]) {
            this.deleteFixup(n3);
        }
    }

    private void deleteFixup(int n) {
        while (n != this.root && !this.color[n]) {
            int n2;
            if (n == this.left[this.parent[n]]) {
                n2 = this.right[this.parent[n]];
                if (this.color[n2]) {
                    this.color[n2] = false;
                    this.color[this.parent[n]] = true;
                    this.leftRotate(this.parent[n]);
                    n2 = this.right[this.parent[n]];
                }
                if (!this.color[this.left[n2]] && !this.color[this.right[n2]]) {
                    this.color[n2] = true;
                    n = this.parent[n];
                    continue;
                }
                if (!this.color[this.right[n2]]) {
                    this.color[this.left[n2]] = false;
                    this.color[n2] = true;
                    this.rightRotate(n2);
                    n2 = this.right[this.parent[n]];
                }
                this.color[n2] = this.color[this.parent[n]];
                this.color[this.parent[n]] = false;
                this.color[this.right[n2]] = false;
                this.leftRotate(this.parent[n]);
                n = this.root;
                continue;
            }
            n2 = this.left[this.parent[n]];
            if (this.color[n2]) {
                this.color[n2] = false;
                this.color[this.parent[n]] = true;
                this.rightRotate(this.parent[n]);
                n2 = this.left[this.parent[n]];
            }
            if (!this.color[this.left[n2]] && !this.color[this.right[n2]]) {
                this.color[n2] = true;
                n = this.parent[n];
                continue;
            }
            if (!this.color[this.left[n2]]) {
                this.color[this.right[n2]] = false;
                this.color[n2] = true;
                this.leftRotate(n2);
                n2 = this.left[this.parent[n]];
            }
            this.color[n2] = this.color[this.parent[n]];
            this.color[this.parent[n]] = false;
            this.color[this.left[n2]] = false;
            this.rightRotate(this.parent[n]);
            n = this.root;
        }
        this.color[n] = false;
    }

    public ComparableIntIterator iterator(IntComparator intComparator) {
        return new ComparableIterator(intComparator);
    }

    public IntListIterator iterator() {
        return new IntArrayRBTKeyIterator();
    }

    public IntPointerIterator pointerIterator() {
        return new PointerIterator();
    }

    public IntPointerIterator pointerIterator(int n) {
        PointerIterator pointerIterator = new PointerIterator();
        pointerIterator.currentNode = this.findKey(n);
        return pointerIterator;
    }

    public ComparableIntPointerIterator pointerIterator(IntComparator intComparator) {
        return new ComparablePointerIterator(intComparator);
    }

    public boolean satisfiesRedBlackProperties() {
        int n = this.root;
        int n2 = 0;
        while (n != 0) {
            if (!this.color[n]) {
                ++n2;
            }
            n = this.left[n];
        }
        return this.satisfiesRBProps(this.root, n2, 0);
    }

    private boolean satisfiesRBProps(int n, int n2, int n3) {
        if (n == 0) {
            return n3 == n2;
        }
        if (this.color[n]) {
            if (this.color[this.left[n]] || this.color[this.right[n]]) {
                return false;
            }
        } else {
            ++n3;
        }
        return this.satisfiesRBProps(this.left[n], n2, n3) && this.satisfiesRBProps(this.right[n], n2, n3);
    }

    public int maxDepth() {
        return this.maxDepth(this.root, 0);
    }

    public int minDepth() {
        return this.minDepth(this.root, 0);
    }

    public int nodeDepth(int n) {
        return this.nodeDepth(this.root, 1, n);
    }

    private int nodeDepth(int n, int n2, int n3) {
        if (n == 0) {
            return -1;
        }
        if (n3 == this.key[n]) {
            return n2;
        }
        if (n3 < this.key[n]) {
            return this.nodeDepth(this.left[n], n2 + 1, n3);
        }
        return this.nodeDepth(this.right[n], n2 + 1, n3);
    }

    private int maxDepth(int n, int n2) {
        int n3;
        if (n == 0) {
            return n2;
        }
        int n4 = this.maxDepth(this.left[n], n2 + 1);
        return n4 > (n3 = this.maxDepth(this.right[n], n2 + 1)) ? n4 : n3;
    }

    private int minDepth(int n, int n2) {
        int n3;
        if (n == 0) {
            return n2;
        }
        int n4 = this.maxDepth(this.left[n], n2 + 1);
        return n4 > (n3 = this.maxDepth(this.right[n], n2 + 1)) ? n3 : n4;
    }

    public final void printKeys() {
        if (this.size() == 0) {
            System.out.println("Tree is empty.");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.printKeys(this.root, 0, stringBuffer);
        System.out.println(stringBuffer);
    }

    private final void printKeys(int n, int n2, StringBuffer stringBuffer) {
        if (n == 0) {
            return;
        }
        StringUtils.printSpaces(n2, stringBuffer);
        stringBuffer.append(Integer.toString(this.key[n]));
        if (!this.color[n]) {
            stringBuffer.append(" BLACK");
        }
        stringBuffer.append("\n");
        this.printKeys(this.left[n], n2 + 2, stringBuffer);
        this.printKeys(this.right[n], n2 + 2, stringBuffer);
    }

    public static void main(String[] stringArray) {
        System.out.println("Constructing tree.");
        IntArrayRBT intArrayRBT = new IntArrayRBT();
        intArrayRBT.insertKeyWithDups(2);
        intArrayRBT.insertKeyWithDups(1);
    }

    private class ComparableIterator
    extends IntArrayRBTKeyIterator
    implements ComparableIntIterator {
        private final IntComparator comparator;

        private ComparableIterator(IntComparator intComparator) {
            this.comparator = intComparator;
        }

        public int compareTo(Object object) {
            ComparableIterator comparableIterator = (ComparableIterator)object;
            return this.comparator.compare(IntArrayRBT.this.key[this.currentNode], comparableIterator.getKey(comparableIterator.currentNode));
        }
    }

    private class IntArrayRBTKeyIterator
    implements IntListIterator {
        protected int currentNode = 0;

        protected IntArrayRBTKeyIterator() {
        }

        public final boolean hasNext() {
            return this.currentNode != IntArrayRBT.this.greatestNode;
        }

        public final int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentNode = IntArrayRBT.this.nextNode(this.currentNode);
            return IntArrayRBT.this.key[this.currentNode];
        }

        public boolean hasPrevious() {
            return this.currentNode != 0;
        }

        public int previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            int n = IntArrayRBT.this.key[this.currentNode];
            this.currentNode = this.currentNode == IntArrayRBT.this.getFirstNode() ? 0 : IntArrayRBT.this.previousNode(this.currentNode);
            return n;
        }

        public void moveToEnd() {
            this.currentNode = IntArrayRBT.this.greatestNode;
        }

        public void moveToStart() {
            this.currentNode = 0;
        }

        protected final int getKey(int n) {
            return IntArrayRBT.this.key[n];
        }
    }

    private class PointerIterator
    implements IntPointerIterator {
        protected int currentNode;

        private PointerIterator() {
            this.moveToFirst();
        }

        public void dec() {
            this.currentNode = IntArrayRBT.this.previousNode(this.currentNode);
        }

        public int get() {
            if (!this.isValid()) {
                throw new NoSuchElementException();
            }
            return IntArrayRBT.this.key[this.currentNode];
        }

        public void inc() {
            this.currentNode = IntArrayRBT.this.nextNode(this.currentNode);
        }

        public boolean isValid() {
            return this.currentNode != 0;
        }

        public void moveToFirst() {
            this.currentNode = IntArrayRBT.this.getFirstNode();
        }

        public void moveToLast() {
            this.currentNode = IntArrayRBT.this.greatestNode;
        }

        public Object copy() {
            PointerIterator pointerIterator = new PointerIterator();
            pointerIterator.currentNode = this.currentNode;
            return pointerIterator;
        }

        public void moveTo(int n) {
            this.currentNode = IntArrayRBT.this.findInsertionPoint(n);
        }
    }

    private class ComparablePointerIterator
    extends PointerIterator
    implements ComparableIntPointerIterator {
        private final IntComparator comp;

        private ComparablePointerIterator(IntComparator intComparator) {
            this.comp = intComparator;
        }

        public int compareTo(Object object) throws NoSuchElementException {
            ComparableIntPointerIterator comparableIntPointerIterator = (ComparableIntPointerIterator)object;
            return this.comp.compare(this.get(), comparableIntPointerIterator.get());
        }

        public Object copy() {
            ComparablePointerIterator comparablePointerIterator = new ComparablePointerIterator(this.comp);
            comparablePointerIterator.currentNode = this.currentNode;
            return comparablePointerIterator;
        }
    }
}

