/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.util;

import com.ibm.uima.UIMARuntimeException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class XMLSerializer {
    private static final SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
    private TransformerHandler mHandler;
    private Transformer mTransformer;
    private Result mResult;

    public XMLSerializer() {
        this(true);
    }

    public XMLSerializer(boolean bl) {
        try {
            this.mHandler = transformerFactory.newTransformerHandler();
            this.mTransformer = this.mHandler.getTransformer();
            if (bl) {
                this.mTransformer.setOutputProperty("indent", "yes");
                this.mTransformer.setOutputProperty("encoding", "UTF-8");
                this.mTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                this.mTransformer.setOutputProperty("method", "xml");
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new UIMARuntimeException(transformerConfigurationException);
        }
    }

    public XMLSerializer(OutputStream outputStream) {
        this();
        this.setOutputStream(outputStream);
    }

    public XMLSerializer(OutputStream outputStream, boolean bl) {
        this(bl);
        this.setOutputStream(outputStream);
    }

    public XMLSerializer(Writer writer) {
        this();
        this.setWriter(writer);
    }

    public XMLSerializer(Writer writer, boolean bl) {
        this(bl);
        this.setWriter(writer);
    }

    public void setOutputStream(OutputStream outputStream) {
        this.mResult = new StreamResult(outputStream);
        this.mHandler.setResult(this.mResult);
    }

    public void setWriter(Writer writer) {
        this.mResult = new StreamResult(writer);
        this.mHandler.setResult(this.mResult);
    }

    public ContentHandler getContentHandler() {
        return this.mHandler;
    }

    public void serialize(Node node) {
        try {
            this.mTransformer.transform(new DOMSource(node), this.mResult);
        }
        catch (TransformerException transformerException) {
            throw new UIMARuntimeException(transformerException);
        }
    }

    public void dom2sax(Node node, ContentHandler contentHandler) {
        try {
            this.mTransformer.transform(new DOMSource(node), new SAXResult(contentHandler));
        }
        catch (TransformerException transformerException) {
            throw new UIMARuntimeException(transformerException);
        }
    }

    public void setOutputProperty(String string, String string2) {
        try {
            this.mTransformer.setOutputProperty(string, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UIMARuntimeException(illegalArgumentException);
        }
    }
}

