/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.util;

import com.ibm.uima.UIMAFramework;
import com.ibm.uima.cas.CAS;
import com.ibm.uima.cas.CASException;
import com.ibm.uima.cas.FSIterator;
import com.ibm.uima.cas.impl.XCASSerializer;
import com.ibm.uima.collection.CasConsumerDescription;
import com.ibm.uima.collection.CasConsumer_ImplBase;
import com.ibm.uima.examples.SourceDocumentInformation;
import com.ibm.uima.jcas.impl.JCas;
import com.ibm.uima.resource.ResourceInitializationException;
import com.ibm.uima.resource.ResourceProcessException;
import com.ibm.uima.util.InvalidXMLException;
import com.ibm.uima.util.XMLInputSource;
import com.ibm.uima.util.XMLSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.SAXException;

public class XCasWriterCasConsumer
extends CasConsumer_ImplBase {
    public static final String PARAM_OUTPUTDIR = "OutputDirectory";
    private File mOutputDir;
    private int mDocNum;
    static /* synthetic */ Class class$com$ibm$uima$util$XCasWriterCasConsumer;

    public void initialize() throws ResourceInitializationException {
        this.mDocNum = 0;
        this.mOutputDir = new File(((String)this.getConfigParameterValue(PARAM_OUTPUTDIR)).trim());
        if (!this.mOutputDir.exists()) {
            this.mOutputDir.mkdirs();
        }
    }

    public void processCas(CAS cAS) throws ResourceProcessException {
        JCas jCas;
        try {
            jCas = cAS.getJCas();
        }
        catch (CASException cASException) {
            throw new ResourceProcessException(cASException);
        }
        FSIterator fSIterator = jCas.getJFSIndexRepository().getAnnotationIndex(SourceDocumentInformation.type).iterator();
        File file = null;
        if (fSIterator.hasNext()) {
            SourceDocumentInformation sourceDocumentInformation = (SourceDocumentInformation)fSIterator.next();
            try {
                File file2 = new File(new URL(sourceDocumentInformation.getUri()).getPath());
                file = new File(this.mOutputDir, file2.getName());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (file == null) {
            file = new File(this.mOutputDir, "doc" + this.mDocNum++);
        }
        try {
            this.writeXCas(jCas.getCas(), file);
        }
        catch (IOException iOException) {
            throw new ResourceProcessException(iOException);
        }
        catch (SAXException sAXException) {
            throw new ResourceProcessException(sAXException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXCas(CAS cAS, File file) throws IOException, SAXException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            XCASSerializer xCASSerializer = new XCASSerializer(cAS.getTypeSystem());
            XMLSerializer xMLSerializer = new XMLSerializer(fileOutputStream, false);
            xCASSerializer.serialize(cAS, xMLSerializer.getContentHandler());
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public static CasConsumerDescription getDescription() throws InvalidXMLException {
        InputStream inputStream = (class$com$ibm$uima$util$XCasWriterCasConsumer == null ? (class$com$ibm$uima$util$XCasWriterCasConsumer = XCasWriterCasConsumer.class$("com.ibm.uima.util.XCasWriterCasConsumer")) : class$com$ibm$uima$util$XCasWriterCasConsumer).getResourceAsStream("XCasWriterCasConsumer.xml");
        return UIMAFramework.getXMLParser().parseCasConsumerDescription(new XMLInputSource(inputStream, null));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

