/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.util;

public class TimeSpan {
    private long all;
    private int years;
    private int days;
    private int hours;
    private int minutes;
    private int seconds;
    private int milliseconds;
    private boolean knowsFull = false;
    private boolean knowsMS = false;
    private static final long msSecond = 1000L;
    private static final long msMinute = 60000L;
    private static final long msHour = 3600000L;
    private static final long msDay = 86400000L;
    private static final long msYear = 31536000000L;
    private static final String yearsString = "yrs";
    private static final String daysString = "days";
    private static final String hoursString = "hrs";
    private static final String minutesString = "min";
    private static final String secondsString = "sec";
    private static final String msString = "ms";
    private static final String unknownTime = "unknown";

    public TimeSpan() {
    }

    public TimeSpan(long l) {
        if (l >= 0L) {
            this.all = l;
            this.knowsMS = true;
        }
    }

    public boolean isInstantiated() {
        return this.knowsMS || this.knowsFull;
    }

    public boolean setYears(int n) {
        if (n < 0) {
            return false;
        }
        this.years = n;
        this.knowsFull = true;
        this.knowsMS = false;
        return true;
    }

    public boolean setDays(int n) {
        if (n < 0) {
            return false;
        }
        this.days = n;
        this.knowsFull = true;
        this.knowsMS = false;
        return true;
    }

    public boolean setHours(int n) {
        if (n < 0) {
            return false;
        }
        this.hours = n;
        this.knowsFull = true;
        this.knowsMS = false;
        return true;
    }

    public boolean setMinutes(int n) {
        if (n < 0) {
            return false;
        }
        this.minutes = n;
        this.knowsFull = true;
        this.knowsMS = false;
        return true;
    }

    public boolean setSeconds(int n) {
        if (n < 0) {
            return false;
        }
        this.seconds = n;
        this.knowsFull = true;
        this.knowsMS = false;
        return true;
    }

    public boolean setMilliseconds(int n) {
        if (n < 0) {
            return false;
        }
        this.milliseconds = n;
        this.knowsFull = true;
        this.knowsMS = false;
        return true;
    }

    public boolean setFullMilliseconds(long l) {
        if (l < 0L) {
            return false;
        }
        this.all = l;
        this.knowsMS = true;
        this.knowsFull = false;
        return true;
    }

    public long getFullMilliseconds() {
        this.ensureAll();
        if (!this.knowsMS) {
            return -1L;
        }
        return this.all;
    }

    public int getYears() {
        this.ensureFull();
        return this.isInstantiated() ? this.years : -1;
    }

    public int getDays() {
        this.ensureFull();
        return this.isInstantiated() ? this.days : -1;
    }

    public int getHours() {
        this.ensureFull();
        return this.isInstantiated() ? this.hours : -1;
    }

    public int getMinutes() {
        this.ensureFull();
        return this.isInstantiated() ? this.minutes : -1;
    }

    public int getSeconds() {
        this.ensureFull();
        return this.isInstantiated() ? this.seconds : -1;
    }

    public int getMilliseconds() {
        this.ensureFull();
        return this.isInstantiated() ? this.milliseconds : -1;
    }

    public String toString() {
        this.ensureFull();
        if (!this.knowsFull) {
            return unknownTime;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (this.years > 0) {
            stringBuffer.append(this.years);
            stringBuffer.append(" ");
            stringBuffer.append(yearsString);
            bl = true;
        }
        if (bl || this.days > 0) {
            if (bl) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.days);
            stringBuffer.append(" ");
            stringBuffer.append(daysString);
            bl = true;
        }
        if (bl || this.hours > 0) {
            if (bl) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.hours);
            stringBuffer.append(" ");
            stringBuffer.append(hoursString);
            bl = true;
        }
        if (bl || this.minutes > 0) {
            if (bl) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.minutes);
            stringBuffer.append(" ");
            stringBuffer.append(minutesString);
            bl = true;
        }
        if (bl || this.seconds > 0) {
            if (bl) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.seconds);
            bl = true;
        }
        if (bl) {
            stringBuffer.append(".");
            if (this.milliseconds < 100) {
                stringBuffer.append("0");
                if (this.milliseconds < 10) {
                    stringBuffer.append("0");
                }
            }
            stringBuffer.append(this.milliseconds);
            stringBuffer.append(" ");
            stringBuffer.append(secondsString);
        } else {
            stringBuffer.append(this.milliseconds);
            stringBuffer.append(" ");
            stringBuffer.append(msString);
        }
        return stringBuffer.toString();
    }

    private void ensureAll() {
        if (this.knowsMS || !this.knowsFull) {
            return;
        }
        this.all = 0L;
        this.all += (long)this.years * 31536000000L;
        this.all += (long)this.days * 86400000L;
        this.all += (long)this.hours * 3600000L;
        this.all += (long)this.minutes * 60000L;
        this.all += (long)this.seconds * 1000L;
        this.all += (long)this.milliseconds;
        this.knowsMS = true;
    }

    private void ensureFull() {
        if (this.knowsFull || !this.knowsMS) {
            return;
        }
        long l = this.all;
        this.years = (int)(l / 31536000000L);
        this.days = (int)((l %= 31536000000L) / 86400000L);
        this.hours = (int)((l %= 86400000L) / 3600000L);
        this.minutes = (int)((l %= 3600000L) / 60000L);
        this.seconds = (int)((l %= 60000L) / 1000L);
        this.milliseconds = (int)(l %= 1000L);
        this.knowsFull = true;
    }
}

