/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.util;

import com.ibm.uima.UIMARuntimeException;
import com.ibm.uima.cas.CASException;
import com.ibm.uima.cas.FSIterator;
import com.ibm.uima.cas.FSMatchConstraint;
import com.ibm.uima.cas.Feature;
import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.FloatArrayFS;
import com.ibm.uima.cas.IntArrayFS;
import com.ibm.uima.cas.StringArrayFS;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.text.AnnotationFS;
import com.ibm.uima.cas.text.TCAS;
import com.ibm.uima.util.TCasFormatter;
import com.ibm.uima.util.XMLSerializer;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class TCasToInlineXml
implements TCasFormatter {
    public void destroy() {
    }

    public String format(TCAS tCAS) throws CASException {
        return this.generateXML(tCAS, null);
    }

    public String format(TCAS tCAS, FSMatchConstraint fSMatchConstraint) throws CASException {
        return this.generateXML(tCAS, fSMatchConstraint);
    }

    public String generateXML(TCAS tCAS) throws CASException {
        return this.generateXML(tCAS, null);
    }

    public String generateXML(TCAS tCAS, FSMatchConstraint fSMatchConstraint) throws CASException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLSerializer xMLSerializer = new XMLSerializer(byteArrayOutputStream);
        String string = tCAS.getDocumentText();
        char[] cArray = string.toCharArray();
        this.replaceInvalidXmlChars(cArray);
        FSIterator fSIterator = tCAS.getAnnotationIndex().iterator();
        if (fSMatchConstraint != null) {
            fSIterator = tCAS.createFilteredIterator(fSIterator, fSMatchConstraint);
        }
        ArrayList<AnnotationFS> arrayList = new ArrayList<AnnotationFS>();
        int n = 0;
        try {
            ContentHandler contentHandler = xMLSerializer.getContentHandler();
            contentHandler.startDocument();
            contentHandler.startElement("", "Document", "Document", new AttributesImpl());
            AnnotationFS annotationFS = null;
            while (fSIterator.isValid()) {
                AnnotationFS annotationFS2 = (AnnotationFS)fSIterator.get();
                if (annotationFS == null || annotationFS2.getBegin() < annotationFS.getEnd()) {
                    if (annotationFS == null || annotationFS2.getEnd() <= annotationFS.getEnd()) {
                        try {
                            contentHandler.characters(cArray, n, annotationFS2.getBegin() - n);
                            n = annotationFS2.getBegin();
                            contentHandler.startElement("", annotationFS2.getType().getName(), annotationFS2.getType().getName(), this.getFeatureAttributes(annotationFS2, tCAS));
                            arrayList.add(annotationFS);
                            annotationFS = annotationFS2;
                        }
                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                            System.err.println("Invalid annotation range: " + annotationFS2.getBegin() + "," + annotationFS2.getEnd() + " in document of length " + string.length());
                        }
                    }
                    fSIterator.moveToNext();
                    continue;
                }
                try {
                    contentHandler.characters(cArray, n, annotationFS.getEnd() - n);
                    n = annotationFS.getEnd();
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    System.err.println("Invalid annotation range: " + annotationFS.getBegin() + "," + annotationFS.getEnd() + " in document of length " + string.length());
                }
                contentHandler.endElement("", annotationFS.getType().getName(), annotationFS.getType().getName());
                annotationFS = (AnnotationFS)arrayList.remove(arrayList.size() - 1);
            }
            if (annotationFS != null) {
                try {
                    contentHandler.characters(cArray, n, annotationFS.getEnd() - n);
                    n = annotationFS.getEnd();
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    System.err.println("Invalid annotation range: " + annotationFS.getBegin() + "," + annotationFS.getEnd() + "in document of length " + string.length());
                }
                contentHandler.endElement("", annotationFS.getType().getName(), annotationFS.getType().getName());
                while (!arrayList.isEmpty() && (annotationFS = (AnnotationFS)arrayList.remove(arrayList.size() - 1)) != null) {
                    try {
                        contentHandler.characters(cArray, n, annotationFS.getEnd() - n);
                        n = annotationFS.getEnd();
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        System.err.println("Invalid annotation range: " + annotationFS.getBegin() + "," + annotationFS.getEnd() + "in document of length " + string.length());
                    }
                    contentHandler.endElement("", annotationFS.getType().getName(), annotationFS.getType().getName());
                }
            }
            if (n < cArray.length) {
                contentHandler.characters(cArray, n, cArray.length - n);
            }
            contentHandler.endElement("", "Document", "Document");
            contentHandler.endDocument();
            return new String(byteArrayOutputStream.toByteArray());
        }
        catch (SAXException sAXException) {
            throw new UIMARuntimeException(sAXException);
        }
    }

    private final Attributes getFeatureAttributes(FeatureStructure featureStructure, TCAS tCAS) {
        AttributesImpl attributesImpl = new AttributesImpl();
        Type type = tCAS.getTypeSystem().getType("uima.cas.String");
        List list = featureStructure.getType().getFeatures();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n;
            Object object;
            StringBuffer stringBuffer;
            Object object2;
            Feature feature = (Feature)iterator.next();
            String string = feature.getShortName();
            String string2 = feature.getRange().getName();
            if (tCAS.getTypeSystem().subsumes(type, feature.getRange())) {
                object2 = featureStructure.getStringValue(feature);
                if (object2 == null) {
                    attributesImpl.addAttribute("", string, string, "CDATA", "null");
                    continue;
                }
                if (((String)object2).length() > 64) {
                    object2 = ((String)object2).substring(0, 64) + "...";
                }
                attributesImpl.addAttribute("", string, string, "CDATA", (String)object2);
                continue;
            }
            if ("uima.cas.Integer".equals(string2)) {
                attributesImpl.addAttribute("", string, string, "CDATA", Integer.toString(featureStructure.getIntValue(feature)));
                continue;
            }
            if ("uima.cas.Float".equals(string2)) {
                attributesImpl.addAttribute("", string, string, "CDATA", Float.toString(featureStructure.getFloatValue(feature)));
                continue;
            }
            if ("uima.cas.StringArray".equals(string2)) {
                object2 = (StringArrayFS)featureStructure.getFeatureValue(feature);
                if (object2 == null) {
                    attributesImpl.addAttribute("", string, string, "CDATA", "null");
                    continue;
                }
                stringBuffer = new StringBuffer();
                object = object2.toArray();
                stringBuffer.append('[');
                for (n = 0; n < ((String[])object).length - 1; ++n) {
                    stringBuffer.append(object[n]);
                    stringBuffer.append(',');
                }
                if (((String[])object).length > 0) {
                    stringBuffer.append(object[((String[])object).length - 1]);
                }
                stringBuffer.append(']');
                attributesImpl.addAttribute("", string, string, "CDATA", stringBuffer.toString());
                continue;
            }
            if ("uima.cas.IntegerArray".equals(string2)) {
                object2 = (IntArrayFS)featureStructure.getFeatureValue(feature);
                if (object2 == null) {
                    attributesImpl.addAttribute("", string, string, "CDATA", "null");
                    continue;
                }
                stringBuffer = new StringBuffer();
                object = object2.toArray();
                stringBuffer.append('[');
                for (n = 0; n < ((String[])object).length - 1; ++n) {
                    stringBuffer.append((int)object[n]);
                    stringBuffer.append(',');
                }
                if (((String[])object).length > 0) {
                    stringBuffer.append((int)object[((String[])object).length - 1]);
                }
                stringBuffer.append(']');
                attributesImpl.addAttribute("", string, string, "CDATA", stringBuffer.toString());
                continue;
            }
            if ("uima.cas.FloatArray".equals(string2)) {
                object2 = (FloatArrayFS)featureStructure.getFeatureValue(feature);
                if (object2 == null) {
                    attributesImpl.addAttribute("", string, string, "CDATA", "null");
                    continue;
                }
                stringBuffer = new StringBuffer();
                object = object2.toArray();
                stringBuffer.append('[');
                for (n = 0; n < ((String[])object).length - 1; ++n) {
                    stringBuffer.append((float)object[n]);
                    stringBuffer.append(',');
                }
                if (((String[])object).length > 0) {
                    stringBuffer.append((float)object[((Object)object).length - 1]);
                }
                stringBuffer.append(']');
                attributesImpl.addAttribute("", string, string, "CDATA", stringBuffer.toString());
                continue;
            }
            object2 = featureStructure.getFeatureValue(feature);
            if (object2 == null) {
                attributesImpl.addAttribute("", string, string, "CDATA", "null");
                continue;
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append(object2.getType().getShortName());
            if (object2 instanceof AnnotationFS) {
                stringBuffer.append(" [");
                object = ((AnnotationFS)object2).getCoveredText();
                if (((String)object).length() > 64) {
                    object = ((String)object).substring(0, 64) + "...";
                }
                stringBuffer.append((String)object);
                stringBuffer.append(']');
            }
            attributesImpl.addAttribute("", string, string, "CDATA", stringBuffer.toString());
        }
        return attributesImpl;
    }

    private void replaceInvalidXmlChars(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            if (!(cArray[i] < ' ' && cArray[i] != '\t' && cArray[i] != '\n' && cArray[i] != '\r' || cArray[i] > '\ud7ff' && cArray[i] < '\ue000' || cArray[i] == '\ufffe') && cArray[i] != '\uffff') continue;
            cArray[i] = 32;
        }
    }
}

