/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.util;

import com.ibm.uima.UIMAFramework;
import com.ibm.uima.analysis_engine.TextAnalysisEngine;
import com.ibm.uima.cas.text.TCAS;
import com.ibm.uima.resource.ResourceInitializationException;
import com.ibm.uima.resource.metadata.ProcessingResourceMetaData;
import com.ibm.uima.util.CasCreationUtils;
import com.ibm.uima.util.Level;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class TCasPool {
    private static final String LOG_RESOURCE_BUNDLE = "com.ibm.uima.reference_impl.log_messages";
    private static final Class CLASS_NAME = class$com$ibm$uima$util$TCasPool == null ? (class$com$ibm$uima$util$TCasPool = TCasPool.class$("com.ibm.uima.util.TCasPool")) : class$com$ibm$uima$util$TCasPool;
    private Vector mAllInstances = new Vector();
    private Vector mFreeInstances = new Vector();
    private int mNumInstances;
    static /* synthetic */ Class class$com$ibm$uima$util$TCasPool;

    public TCasPool(int n, TextAnalysisEngine textAnalysisEngine) throws ResourceInitializationException {
        this.mNumInstances = n;
        this.fillPool(textAnalysisEngine.getAnalysisEngineMetaData());
    }

    public TCasPool(int n, ProcessingResourceMetaData processingResourceMetaData) throws ResourceInitializationException {
        this.mNumInstances = n;
        this.fillPool(processingResourceMetaData);
    }

    public TCasPool(int n, List list) throws ResourceInitializationException {
        this.mNumInstances = n;
        this.fillPool(list);
    }

    public synchronized TCAS getTCas() {
        if (!this.mFreeInstances.isEmpty()) {
            return (TCAS)this.mFreeInstances.remove(0);
        }
        return null;
    }

    public synchronized void releaseTCas(TCAS tCAS) {
        if (!this.mAllInstances.contains(tCAS) || this.mFreeInstances.contains(tCAS)) {
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "releaseTCas", LOG_RESOURCE_BUNDLE, "UIMA_return_tcas_to_pool__WARNING");
        } else {
            tCAS.reset();
            this.mFreeInstances.add(tCAS);
        }
        this.notifyAll();
    }

    public synchronized TCAS getTCas(long l) {
        TCAS tCAS;
        long l2 = new Date().getTime();
        while ((tCAS = this.getTCas()) == null) {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (l <= 0L || new Date().getTime() - l2 < l) continue;
            return null;
        }
        return tCAS;
    }

    public int getSize() {
        return this.mNumInstances;
    }

    protected void fillPool(ProcessingResourceMetaData processingResourceMetaData) throws ResourceInitializationException {
        ArrayList<ProcessingResourceMetaData> arrayList = new ArrayList<ProcessingResourceMetaData>();
        arrayList.add(processingResourceMetaData);
        TCAS tCAS = CasCreationUtils.createTCas(arrayList);
        this.mAllInstances.add(tCAS);
        this.mFreeInstances.add(tCAS);
        for (int i = 1; i < this.mNumInstances; ++i) {
            TCAS tCAS2 = CasCreationUtils.createTCas(tCAS.getTypeSystem(), processingResourceMetaData.getTypePriorities(), processingResourceMetaData.getFsIndexes());
            this.mAllInstances.add(tCAS2);
            this.mFreeInstances.add(tCAS2);
        }
    }

    protected void fillPool(List list) throws ResourceInitializationException {
        TCAS tCAS = CasCreationUtils.createTCas(list);
        this.mAllInstances.add(tCAS);
        this.mFreeInstances.add(tCAS);
        for (int i = 1; i < this.mNumInstances; ++i) {
            TCAS tCAS2 = CasCreationUtils.createTCas((Collection)list, tCAS.getTypeSystem());
            this.mAllInstances.add(tCAS2);
            this.mFreeInstances.add(tCAS2);
        }
    }

    protected Vector getAllInstances() {
        return this.mAllInstances;
    }

    protected Vector getFreeInstances() {
        return this.mFreeInstances;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

