/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;

public class SymbolTable {
    private static final int DEFAULT_START = 0;
    private int start;
    private HashMap hashtable = new HashMap();
    private Vector symbols = new Vector();

    public SymbolTable(int n) {
        this.start = n;
    }

    public SymbolTable() {
        this(0);
    }

    public SymbolTable(String[] stringArray) {
        this(0);
        for (int i = 0; i < stringArray.length; ++i) {
            this.set(stringArray[i]);
        }
    }

    public boolean contains(String string) {
        return this.getStart() <= this.get(string);
    }

    public int getStart() {
        return this.start;
    }

    public SymbolTable copy() {
        SymbolTable symbolTable = new SymbolTable(this.start);
        int n = this.symbols.size();
        for (int i = 0; i < n; ++i) {
            symbolTable.set((String)this.symbols.get(i));
        }
        return symbolTable;
    }

    private final int rel2abs(int n) {
        return n - this.start;
    }

    private final int abs2rel(int n) {
        return n + this.start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set(String string) {
        int n;
        if (this.hashtable.containsKey(string)) {
            return (Integer)this.hashtable.get(string);
        }
        SymbolTable symbolTable = this;
        synchronized (symbolTable) {
            int n2 = this.hashtable.size();
            n = this.abs2rel(n2);
            this.hashtable.put(string, new Integer(n));
            this.symbols.insertElementAt(string, n2);
        }
        return n;
    }

    public int get(String string) {
        if (this.hashtable.containsKey(string)) {
            return (Integer)this.hashtable.get(string);
        }
        return this.start - 1;
    }

    public String getSymbol(int n) {
        int n2 = this.rel2abs(n);
        if (n2 < 0 || n2 >= this.symbols.size()) {
            return null;
        }
        return (String)this.symbols.get(n2);
    }

    public int size() {
        return this.symbols.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        int n = this.getStart() + this.size();
        for (int i = this.getStart(); i < n; ++i) {
            stringBuffer.append(i + ":" + this.getSymbol(i));
            if (i + 1 >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SymbolTable readFromFile(String string) throws IOException {
        File file = new File(string);
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            SymbolTable symbolTable = new SymbolTable();
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.equals("")) continue;
                symbolTable.set(string2);
            }
            SymbolTable symbolTable2 = symbolTable;
            return symbolTable2;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }
}

