/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.util;

import com.ibm.uima.util.IntArrayUtils;
import com.ibm.uima.util.IntVector;

public class SortedIntSet {
    private IntVector vector = new IntVector();

    public SortedIntSet() {
    }

    public SortedIntSet(int[] nArray) {
        this();
        for (int i = 0; i < nArray.length; ++i) {
            this.add(nArray[i]);
        }
    }

    public int find(int n) {
        int[] nArray = this.vector.getArray();
        return IntArrayUtils.binarySearch(nArray, n, 0, this.vector.size());
    }

    public boolean contains(int n) {
        return this.find(n) >= 0;
    }

    public boolean add(int n) {
        int n2 = this.find(n);
        if (n2 >= 0) {
            return false;
        }
        this.vector.add(-(n2 + 1), n);
        return true;
    }

    public boolean remove(int n) {
        int n2 = this.find(n);
        if (n2 < 0) {
            return false;
        }
        this.vector.remove(n2);
        return true;
    }

    public int size() {
        return this.vector.size();
    }

    public int get(int n) {
        return this.vector.get(n);
    }

    public void union(SortedIntSet sortedIntSet) {
        int n = sortedIntSet.size();
        for (int i = 0; i < n; ++i) {
            this.add(sortedIntSet.get(i));
        }
    }

    public void removeAll() {
        this.vector.removeAllElements();
    }

    public int[] toArray() {
        return this.vector.toArrayCopy();
    }
}

