/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.util;

import com.ibm.uima.util.FileUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

public class ReplaceStringInFiles {
    private static DirFileFilter dirFileFilter = new DirFileFilter();

    public static int indexOfCaseSensitive(String string, String string2, int n, boolean bl) {
        if (bl) {
            return string.indexOf(string2, n);
        }
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        int n2 = string3.indexOf(string4, n);
        return n2;
    }

    public static final void replaceStringInString(String string, String string2, String string3, ReplacementResult replacementResult, boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        while ((n = ReplaceStringInFiles.indexOfCaseSensitive(string, string2, n2, bl)) >= 0) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
            n2 = n + string2.length();
            ++n3;
        }
        stringBuffer.append(string.substring(n2, string.length()));
        replacementResult.outString = stringBuffer.toString();
        replacementResult.numReplaced = n3;
    }

    public static final void replaceStringInFiles(File file, FileFilter fileFilter, String string, String string2, boolean bl) throws IOException {
        int n;
        File[] fileArray = null;
        fileArray = fileFilter == null ? file.listFiles() : file.listFiles(fileFilter);
        ReplacementResult replacementResult = new ReplacementResult();
        for (n = 0; n < fileArray.length; ++n) {
            File file2 = fileArray[n];
            if (!file2.isFile()) continue;
            if (!file2.canRead()) {
                System.err.println("Warning, can't read file: " + file2.getAbsolutePath());
                continue;
            }
            if (!file2.canWrite()) {
                System.err.println("Warning, can't write file: " + file2.getAbsolutePath());
                continue;
            }
            System.out.println("Working on file: " + file2.getAbsolutePath());
            String string3 = FileUtils.file2String(file2);
            ReplaceStringInFiles.replaceStringInString(string3, string, string2, replacementResult, bl);
            string3 = replacementResult.outString;
            if (replacementResult.numReplaced <= 0) continue;
            FileUtils.saveString2File(string3, file2);
            System.out.println("File modified, number of instances replaced: " + replacementResult.numReplaced);
        }
        fileArray = file.listFiles(dirFileFilter);
        for (n = 0; n < fileArray.length; ++n) {
            ReplaceStringInFiles.replaceStringInFiles(fileArray[n], fileFilter, string, string2, bl);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 4 && stringArray.length != 5) {
            System.out.println("Usage: java com.ibm.uima.util.ReplaceStringInFile <Dir> <Extension> <ToReplace> <Replacement> [-ignorecase]");
            System.exit(1);
        }
        try {
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            String string4 = stringArray[3];
            boolean bl = false;
            if (stringArray.length >= 5) {
                boolean bl2 = bl = stringArray[4].compareToIgnoreCase("-ignorecase") != 0;
            }
            if (bl) {
                System.out.println("Case sensitive");
            } else {
                System.out.println("Ignoring case");
            }
            File file = new File(string);
            if (file.isDirectory()) {
                ReplaceStringInFiles.replaceStringInFiles(file, new ExtFileFilter(string2), string3, string4, bl);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class ReplacementResult {
        public String outString;
        public int numReplaced;
    }

    private static class DirFileFilter
    implements FileFilter {
        private DirFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }
    }

    private static class ExtFileFilter
    implements FileFilter {
        private String ext;

        private ExtFileFilter(String string) {
            this.ext = string;
        }

        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(this.ext);
        }
    }
}

