/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.util;

import com.ibm.uima.UIMAFramework;
import com.ibm.uima.analysis_engine.TextAnalysisEngine;
import com.ibm.uima.cas.CASException;
import com.ibm.uima.jcas.impl.JCas;
import com.ibm.uima.resource.ResourceInitializationException;
import com.ibm.uima.resource.metadata.ProcessingResourceMetaData;
import com.ibm.uima.util.CasCreationUtils;
import com.ibm.uima.util.Level;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class JCasPool {
    private static final String LOG_RESOURCE_BUNDLE = "com.ibm.uima.reference_impl.log_messages";
    private static final Class CLASS_NAME = class$com$ibm$uima$util$JCasPool == null ? (class$com$ibm$uima$util$JCasPool = JCasPool.class$("com.ibm.uima.util.JCasPool")) : class$com$ibm$uima$util$JCasPool;
    private Vector mAllInstances = new Vector();
    private Vector mFreeInstances = new Vector();
    private int mNumInstances;
    static /* synthetic */ Class class$com$ibm$uima$util$JCasPool;

    public JCasPool(int n, TextAnalysisEngine textAnalysisEngine) throws ResourceInitializationException {
        this.mNumInstances = n;
        this.fillPool(textAnalysisEngine.getAnalysisEngineMetaData());
    }

    public JCasPool(int n, ProcessingResourceMetaData processingResourceMetaData) throws ResourceInitializationException {
        this.mNumInstances = n;
        this.fillPool(processingResourceMetaData);
    }

    public synchronized JCas getJCas() {
        if (!this.mFreeInstances.isEmpty()) {
            return (JCas)this.mFreeInstances.remove(0);
        }
        return null;
    }

    public synchronized void releaseJCas(JCas jCas) {
        if (!this.mAllInstances.contains(jCas) || this.mFreeInstances.contains(jCas)) {
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "releaseJCas", LOG_RESOURCE_BUNDLE, "UIMA_return_jcas_to_pool__WARNING");
        } else {
            jCas.reset();
            this.mFreeInstances.add(jCas);
        }
        this.notifyAll();
    }

    public synchronized JCas getJCas(long l) {
        JCas jCas;
        long l2 = new Date().getTime();
        while ((jCas = this.getJCas()) == null) {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (l <= 0L || new Date().getTime() - l2 < l) continue;
            return null;
        }
        return jCas;
    }

    public int getSize() {
        return this.mNumInstances;
    }

    protected void fillPool(ProcessingResourceMetaData processingResourceMetaData) throws ResourceInitializationException {
        ArrayList<ProcessingResourceMetaData> arrayList = new ArrayList<ProcessingResourceMetaData>();
        arrayList.add(processingResourceMetaData);
        for (int i = 0; i < this.mNumInstances; ++i) {
            JCas jCas;
            try {
                jCas = CasCreationUtils.createTCas(arrayList).getJCas();
            }
            catch (CASException cASException) {
                throw new ResourceInitializationException(cASException);
            }
            this.mAllInstances.add(jCas);
            this.mFreeInstances.add(jCas);
        }
    }

    protected Vector getAllInstances() {
        return this.mAllInstances;
    }

    protected Vector getFreeInstances() {
        return this.mFreeInstances;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

