/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.util;

import com.ibm.uima.util.IntArrayUtils;
import java.io.Serializable;
import java.util.Arrays;

public class IntVector
implements Serializable {
    private static final int default_size = 16;
    private static final int default_growth_factor = 2;
    private static final int default_multiplication_limit = 2000000;
    private int growth_factor;
    private int multiplication_limit;
    protected int pos = 0;
    protected int[] array = null;

    public IntVector() {
        this(16, 2, 2000000);
    }

    public IntVector(int[] nArray) {
        if (nArray == null) {
            nArray = new int[]{};
        }
        this.pos = nArray.length;
        this.array = nArray;
        this.growth_factor = 2;
        this.multiplication_limit = 2000000;
    }

    public IntVector(int n) {
        this(n, 2, 2000000);
    }

    public IntVector(int n, int n2, int n3) {
        if (n < 0) {
            n = 16;
        }
        if (n2 < 1) {
            n2 = 2;
        }
        if (n3 < 1) {
            n3 = 2000000;
        }
        this.growth_factor = n2;
        this.multiplication_limit = n3;
        this.array = new int[n];
    }

    public void setSize(int n) {
        if (n > 0) {
            this.ensure_size(n);
        }
    }

    public void add(int n) {
        int n2 = this.pos++;
        this.ensure_size(this.pos);
        this.array[n2] = n;
    }

    public void add(int n, int n2) {
        if (n >= this.pos) {
            this.ensure_size(n + 1);
        } else {
            if (this.array.length <= this.pos) {
                this.ensure_size(this.pos + 1);
            } else {
                ++this.pos;
            }
            System.arraycopy(this.array, n, this.array, n + 1, this.pos - (n + 1));
        }
        this.array[n] = n2;
    }

    public void set(int n, int n2) {
        if (n >= this.pos) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.array[n] = n2;
    }

    public void put(int n, int n2) {
        this.ensure_size(n + 1);
        this.array[n] = n2;
    }

    public int get(int n) {
        if (n >= this.pos) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.array[n];
    }

    public int remove(int n) {
        if (n >= this.pos) {
            throw new ArrayIndexOutOfBoundsException();
        }
        --this.pos;
        int n2 = this.array[n];
        for (int i = n; i < this.pos; ++i) {
            this.array[i] = this.array[i + 1];
        }
        return n2;
    }

    public void removeAllElements() {
        this.pos = 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        IntVector intVector = (IntVector)object;
        if (this.size() != intVector.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.array[i] == intVector.get(i)) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.pos;
    }

    public boolean contains(int n) {
        return this.position(n) >= 0;
    }

    public int position(int n) {
        for (int i = 0; i < this.pos; ++i) {
            if (this.array[i] != n) continue;
            return i;
        }
        return -1;
    }

    public void fill(int n) {
        Arrays.fill(this.array, n);
    }

    public int[] toArray() {
        this.trimToSize();
        return this.array;
    }

    public int[] toArrayCopy() {
        int n = this.size();
        int[] nArray = new int[n];
        System.arraycopy(this.array, 0, nArray, 0, n);
        return nArray;
    }

    public int[] getArray() {
        return this.array;
    }

    public int indexOf(int n) {
        int n2 = -1;
        for (int i = 0; i < this.pos; ++i) {
            if (n != this.array[i]) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    public void trimToSize() {
        if (this.pos == this.array.length) {
            return;
        }
        int[] nArray = new int[this.pos];
        System.arraycopy(this.array, 0, nArray, 0, this.pos);
        this.array = nArray;
    }

    public IntVector copy() {
        IntVector intVector = new IntVector(this.array.length, this.growth_factor, this.multiplication_limit);
        intVector.pos = this.pos;
        for (int i = 0; i < this.pos; ++i) {
            intVector.array[i] = this.array[i];
        }
        return intVector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < this.pos; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.array[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void ensure_size(int n) {
        this.array = IntArrayUtils.ensure_size(this.array, n, this.growth_factor, this.multiplication_limit);
        if (this.pos < n) {
            this.pos = n;
        }
    }

    public int hashCode() {
        if (this.array == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.size(); ++i) {
            n += this.get(i);
        }
        return n;
    }
}

