/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Random;

public class FileUtils {
    public static final ArrayList getFiles(File file, boolean bl) {
        if (!file.exists() || !file.isDirectory()) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                if (!bl) continue;
                arrayList.addAll(FileUtils.getFiles(file2, bl));
                continue;
            }
            arrayList.add(file2);
        }
        return arrayList;
    }

    public static final ArrayList getFiles(File file) {
        return FileUtils.getFiles(file, false);
    }

    public static final ArrayList getSubDirs(File file) {
        if (!file.exists() || !file.isDirectory()) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!file2.isDirectory()) continue;
            arrayList.add(file2);
        }
        return arrayList;
    }

    public static String file2String(File file) throws IOException {
        int n;
        char[] cArray = new char[10000];
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = bufferedReader.read(cArray)) >= 0) {
            stringBuffer.append(cArray, 0, n);
        }
        bufferedReader.close();
        String string = stringBuffer.toString();
        return string;
    }

    public static String file2String(File file, String string) throws IOException {
        int n;
        char[] cArray = new char[10000];
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = bufferedReader.read(cArray)) >= 0) {
            stringBuffer.append(cArray, 0, n);
        }
        bufferedReader.close();
        String string2 = stringBuffer.toString();
        return string2;
    }

    public static void saveString2File(String string, File file) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(string);
        bufferedWriter.close();
    }

    public static void saveString2File(String string, File file, String string2) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string2));
        bufferedWriter.write(string);
        bufferedWriter.close();
    }

    public static final void deleteAllFiles(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!file2.isFile()) continue;
            file2.delete();
        }
    }

    public static final boolean deleteRecursive(File file) {
        if (!file.exists()) {
            return false;
        }
        boolean bl = true;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                bl &= FileUtils.deleteRecursive(fileArray[i]);
            }
        }
        return bl &= file.delete();
    }

    public static final boolean mkdir(File file) {
        if (file.exists()) {
            return false;
        }
        return file.mkdir();
    }

    public static final File createTempDir(File file, String string) {
        File file2;
        Random random = new Random();
        while ((file2 = new File(file, string + random.nextInt())).exists()) {
        }
        if (file2.mkdirs()) {
            file2.deleteOnExit();
            return file2;
        }
        return null;
    }

    public static final File createTempFile(String string, String string2, File file) throws IOException {
        File file2 = File.createTempFile(string, string2, file);
        file2.deleteOnExit();
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyFile(File file, File file2) throws IOException {
        if (!file.exists() || !file.canRead()) {
            throw new IOException("File does not exist or is not readable: " + file.getAbsolutePath());
        }
        if (!file2.exists() || !file2.isDirectory()) {
            throw new IOException("Destination does not exist or is not a directory: " + file2.getAbsolutePath());
        }
        File file3 = new File(file2, file.getName());
        if (file3.exists() && !file3.canWrite()) {
            throw new IOException("Can't write output file: " + file3);
        }
        byte[] byArray = new byte[(int)file.length()];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        bufferedInputStream.read(byArray);
        bufferedInputStream.close();
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
            filterOutputStream.write(byArray);
            filterOutputStream.close();
        }
        finally {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            return;
        }
        String string = stringArray[0];
        System.out.println("Deleting: " + string);
        if (FileUtils.deleteRecursive(new File(string))) {
            System.out.println("File successfully deleted.");
        } else {
            System.out.println("Could not delete (all) file(s).");
        }
    }
}

