/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.util;

import com.ibm.uima.UIMAFramework;
import com.ibm.uima.cas.CAS;
import com.ibm.uima.cas.CASException;
import com.ibm.uima.collection.CollectionException;
import com.ibm.uima.collection.CollectionReaderDescription;
import com.ibm.uima.collection.CollectionReader_ImplBase;
import com.ibm.uima.examples.SourceDocumentInformation;
import com.ibm.uima.jcas.cas.TOP;
import com.ibm.uima.jcas.impl.JCas;
import com.ibm.uima.jcas.tcas.DocumentAnnotation;
import com.ibm.uima.resource.ResourceInitializationException;
import com.ibm.uima.util.InvalidXMLException;
import com.ibm.uima.util.Progress;
import com.ibm.uima.util.ProgressImpl;
import com.ibm.uima.util.XMLInputSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class FileSystemCollectionReader
extends CollectionReader_ImplBase {
    public static final String PARAM_INPUTDIR = "InputDirectory";
    public static final String PARAM_ENCODING = "Encoding";
    public static final String PARAM_LANGUAGE = "Language";
    private ArrayList mFiles;
    private String mEncoding;
    private String mLanguage;
    private int mCurrentIndex;
    static /* synthetic */ Class class$com$ibm$uima$util$FileSystemCollectionReader;

    public void initialize() throws ResourceInitializationException {
        String string = ((String)this.getConfigParameterValue(PARAM_INPUTDIR)).trim();
        File file = new File(string);
        this.mEncoding = (String)this.getConfigParameterValue(PARAM_ENCODING);
        this.mLanguage = (String)this.getConfigParameterValue(PARAM_LANGUAGE);
        this.mCurrentIndex = 0;
        if (!file.exists() || !file.isDirectory()) {
            throw new ResourceInitializationException("directory_not_found", new Object[]{PARAM_INPUTDIR, this.getMetaData().getName(), file.getPath()});
        }
        this.mFiles = new ArrayList();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) continue;
            this.mFiles.add(fileArray[i]);
        }
    }

    public boolean hasNext() {
        return this.mCurrentIndex < this.mFiles.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNext(CAS cAS) throws IOException, CollectionException {
        Object object;
        JCas jCas;
        try {
            jCas = cAS.getJCas();
        }
        catch (CASException cASException) {
            throw new CollectionException(cASException);
        }
        File file = (File)this.mFiles.get(this.mCurrentIndex++);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            if (this.getCasInitializer() != null) {
                this.getCasInitializer().initializeCas(fileInputStream, cAS);
            } else {
                object = new byte[(int)file.length()];
                fileInputStream.read((byte[])object);
                String string = this.mEncoding != null ? new String((byte[])object, this.mEncoding) : new String((byte[])object);
                jCas.setDocumentText(string);
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        if (this.mLanguage != null) {
            ((DocumentAnnotation)jCas.getDocumentAnnotationFs()).setLanguage(this.mLanguage);
        }
        object = new SourceDocumentInformation(jCas);
        ((SourceDocumentInformation)object).setUri(file.getAbsoluteFile().toURL().toString());
        ((SourceDocumentInformation)object).setOffsetInSource(0);
        ((SourceDocumentInformation)object).setDocumentSize((int)file.length());
        ((TOP)object).addToIndexes();
    }

    public void close() throws IOException {
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.mCurrentIndex, this.mFiles.size(), "entities")};
    }

    public int getNumberOfDocuments() {
        return this.mFiles.size();
    }

    public static CollectionReaderDescription getDescription() throws InvalidXMLException {
        InputStream inputStream = (class$com$ibm$uima$util$FileSystemCollectionReader == null ? (class$com$ibm$uima$util$FileSystemCollectionReader = FileSystemCollectionReader.class$("com.ibm.uima.util.FileSystemCollectionReader")) : class$com$ibm$uima$util$FileSystemCollectionReader).getResourceAsStream("FileSystemCollectionReader.xml");
        return UIMAFramework.getXMLParser().parseCollectionReaderDescription(new XMLInputSource(inputStream, null));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

