/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.util;

import java.util.HashMap;

public class CommandLineParser {
    private HashMap paramMap = new HashMap();
    private HashMap cmdLineMap = null;
    private String[] restArgs;

    public boolean addParameter(String string, boolean bl) {
        if (this.paramMap.containsKey(string)) {
            return false;
        }
        this.paramMap.put(string, new CmdLineParam(bl));
        return true;
    }

    public boolean addParameter(String string) {
        return this.addParameter(string, false);
    }

    public boolean addAlias(String string, String string2) {
        if (this.paramMap.containsKey(string2) || !this.paramMap.containsKey(string)) {
            return false;
        }
        this.paramMap.put(string2, this.paramMap.get(string));
        return true;
    }

    public void parseCmdLine(String[] stringArray) throws Exception {
        this.cmdLineMap = new HashMap();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (this.paramMap.containsKey(string)) {
                CmdLineParam cmdLineParam = (CmdLineParam)this.paramMap.get(string);
                if (cmdLineParam.hasArg) {
                    if (++i >= stringArray.length) {
                        throw new Exception("Required argument to parameter missing: " + string);
                    }
                    this.cmdLineMap.put(cmdLineParam, stringArray[i]);
                    continue;
                }
                this.cmdLineMap.put(cmdLineParam, null);
                continue;
            }
            this.restArgs = new String[stringArray.length - i];
            System.arraycopy(stringArray, i, this.restArgs, 0, this.restArgs.length);
            return;
        }
        this.restArgs = new String[0];
    }

    public String[] getRestArgs() {
        return this.restArgs;
    }

    public boolean isKnownParameter(String string) {
        return this.paramMap.containsKey(string);
    }

    public boolean isInArgsList(String string) {
        if (!this.paramMap.containsKey(string)) {
            return false;
        }
        return this.cmdLineMap.containsKey(this.paramMap.get(string));
    }

    public String getParamArgument(String string) {
        if (this.isKnownParameter(string)) {
            return (String)this.cmdLineMap.get(this.paramMap.get(string));
        }
        return null;
    }

    private static class CmdLineParam {
        private final boolean hasArg;

        private CmdLineParam(boolean bl) {
            this.hasArg = bl;
        }
    }
}

