/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.util;

import com.ibm.uima.UIMAFramework;
import com.ibm.uima.analysis_engine.AnalysisEngine;
import com.ibm.uima.cas.CAS;
import com.ibm.uima.resource.ResourceInitializationException;
import com.ibm.uima.resource.ResourceManager;
import com.ibm.uima.resource.metadata.ProcessingResourceMetaData;
import com.ibm.uima.util.CasCreationUtils;
import com.ibm.uima.util.Level;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class CasPool {
    private static final String LOG_RESOURCE_BUNDLE = "com.ibm.uima.reference_impl.log_messages";
    private static final Class CLASS_NAME = class$com$ibm$uima$util$CasPool == null ? (class$com$ibm$uima$util$CasPool = CasPool.class$("com.ibm.uima.util.CasPool")) : class$com$ibm$uima$util$CasPool;
    private Vector mAllInstances = new Vector();
    private Vector mFreeInstances = new Vector();
    private int mNumInstances;
    static /* synthetic */ Class class$com$ibm$uima$util$CasPool;

    public CasPool(int n, AnalysisEngine analysisEngine) throws ResourceInitializationException {
        this.mNumInstances = n;
        this.fillPool(analysisEngine.getAnalysisEngineMetaData(), analysisEngine.getResourceManager());
    }

    public CasPool(int n, ProcessingResourceMetaData processingResourceMetaData) throws ResourceInitializationException {
        this.mNumInstances = n;
        this.fillPool(processingResourceMetaData, null);
    }

    public CasPool(int n, ProcessingResourceMetaData processingResourceMetaData, ResourceManager resourceManager) throws ResourceInitializationException {
        this.mNumInstances = n;
        this.fillPool(processingResourceMetaData, resourceManager);
    }

    public synchronized CAS getCas() {
        if (!this.mFreeInstances.isEmpty()) {
            return (CAS)this.mFreeInstances.remove(0);
        }
        return null;
    }

    public synchronized void releaseCas(CAS cAS) {
        if (!this.mAllInstances.contains(cAS) || this.mFreeInstances.contains(cAS)) {
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "releaseCas", LOG_RESOURCE_BUNDLE, "UIMA_return_cas_to_pool__WARNING");
        } else {
            cAS.reset();
            this.mFreeInstances.add(cAS);
        }
        this.notifyAll();
    }

    public synchronized CAS getCas(long l) {
        CAS cAS;
        long l2 = new Date().getTime();
        while ((cAS = this.getCas()) == null) {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (l <= 0L || new Date().getTime() - l2 < l) continue;
            return null;
        }
        return cAS;
    }

    public int getSize() {
        return this.mNumInstances;
    }

    protected void fillPool(ProcessingResourceMetaData processingResourceMetaData, ResourceManager resourceManager) throws ResourceInitializationException {
        ArrayList<ProcessingResourceMetaData> arrayList = new ArrayList<ProcessingResourceMetaData>();
        arrayList.add(processingResourceMetaData);
        for (int i = 0; i < this.mNumInstances; ++i) {
            CAS cAS = CasCreationUtils.createCas(arrayList, null, resourceManager);
            this.mAllInstances.add(cAS);
            this.mFreeInstances.add(cAS);
        }
    }

    protected Vector getAllInstances() {
        return this.mAllInstances;
    }

    protected Vector getFreeInstances() {
        return this.mFreeInstances;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

