/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.util;

import com.ibm.uima.UIMAFramework;
import com.ibm.uima.analysis_engine.AnalysisEngineDescription;
import com.ibm.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import com.ibm.uima.cas.CAS;
import com.ibm.uima.cas.CASException;
import com.ibm.uima.cas.Feature;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.cas.admin.CASFactory;
import com.ibm.uima.cas.admin.CASMgr;
import com.ibm.uima.cas.admin.FSIndexComparator;
import com.ibm.uima.cas.admin.FSIndexRepositoryMgr;
import com.ibm.uima.cas.admin.LinearTypeOrderBuilder;
import com.ibm.uima.cas.admin.TypeSystemMgr;
import com.ibm.uima.cas.text.TCAS;
import com.ibm.uima.cas_data.CasData;
import com.ibm.uima.cas_data.PrimitiveValue;
import com.ibm.uima.collection.CasConsumerDescription;
import com.ibm.uima.collection.CasInitializerDescription;
import com.ibm.uima.collection.CollectionReaderDescription;
import com.ibm.uima.resource.ResourceInitializationException;
import com.ibm.uima.resource.ResourceManager;
import com.ibm.uima.resource.metadata.AllowedValue;
import com.ibm.uima.resource.metadata.FeatureDescription;
import com.ibm.uima.resource.metadata.FsIndexCollection;
import com.ibm.uima.resource.metadata.FsIndexDescription;
import com.ibm.uima.resource.metadata.FsIndexKeyDescription;
import com.ibm.uima.resource.metadata.MetaDataObject;
import com.ibm.uima.resource.metadata.ProcessingResourceMetaData;
import com.ibm.uima.resource.metadata.TypeDescription;
import com.ibm.uima.resource.metadata.TypePriorities;
import com.ibm.uima.resource.metadata.TypePriorityList;
import com.ibm.uima.resource.metadata.TypeSystemDescription;
import com.ibm.uima.util.InvalidXMLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class CasCreationUtils {
    public static CAS createCas(AnalysisEngineMetaData analysisEngineMetaData) throws ResourceInitializationException {
        ArrayList<AnalysisEngineMetaData> arrayList = new ArrayList<AnalysisEngineMetaData>();
        arrayList.add(analysisEngineMetaData);
        return CasCreationUtils.createCas(arrayList);
    }

    public static CAS createCas(ProcessingResourceMetaData processingResourceMetaData) throws ResourceInitializationException {
        ArrayList<ProcessingResourceMetaData> arrayList = new ArrayList<ProcessingResourceMetaData>();
        arrayList.add(processingResourceMetaData);
        return CasCreationUtils.createCas(arrayList);
    }

    public static CAS createCas(AnalysisEngineDescription analysisEngineDescription) throws ResourceInitializationException {
        return CasCreationUtils.createCas(analysisEngineDescription, UIMAFramework.getDefaultPerformanceTuningProperties());
    }

    public static CAS createCas(AnalysisEngineDescription analysisEngineDescription, Properties properties) throws ResourceInitializationException {
        ArrayList<AnalysisEngineDescription> arrayList = new ArrayList<AnalysisEngineDescription>();
        arrayList.add(analysisEngineDescription);
        return CasCreationUtils.createCas(arrayList, properties);
    }

    public static CAS createCas(Collection collection) throws ResourceInitializationException {
        return CasCreationUtils.createCas(collection, UIMAFramework.getDefaultPerformanceTuningProperties());
    }

    public static CAS createCas(Collection collection, Properties properties) throws ResourceInitializationException {
        return CasCreationUtils.createCas(collection, properties, UIMAFramework.newDefaultResourceManager());
    }

    public static CAS createCas(Collection collection, Properties properties, ResourceManager resourceManager) throws ResourceInitializationException {
        MetaDataObject metaDataObject;
        List list = CasCreationUtils.getMetaDataList(collection, resourceManager);
        ArrayList<TypeSystemDescription> arrayList = new ArrayList<TypeSystemDescription>();
        ArrayList<TypePriorities> arrayList2 = new ArrayList<TypePriorities>();
        ArrayList<FsIndexCollection> arrayList3 = new ArrayList<FsIndexCollection>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            metaDataObject = (ProcessingResourceMetaData)iterator.next();
            if (metaDataObject.getTypeSystem() != null) {
                arrayList.add(metaDataObject.getTypeSystem());
            }
            if (metaDataObject.getTypePriorities() != null) {
                arrayList2.add(metaDataObject.getTypePriorities());
            }
            if (metaDataObject.getFsIndexCollection() == null) continue;
            arrayList3.add(metaDataObject.getFsIndexCollection());
        }
        metaDataObject = CasCreationUtils.mergeTypeSystems(arrayList, resourceManager);
        TypePriorities typePriorities = CasCreationUtils.mergeTypePriorities(arrayList2, resourceManager);
        FsIndexCollection fsIndexCollection = CasCreationUtils.mergeFsIndexes(arrayList3, resourceManager);
        return CasCreationUtils.createCas((TypeSystemDescription)metaDataObject, typePriorities, fsIndexCollection.getFsIndexes(), properties, resourceManager);
    }

    public static CAS createCas(TypeSystemDescription typeSystemDescription, TypePriorities typePriorities, FsIndexDescription[] fsIndexDescriptionArray) throws ResourceInitializationException {
        return CasCreationUtils.createCas(typeSystemDescription, typePriorities, fsIndexDescriptionArray, null, null);
    }

    public static CAS createCas(TypeSystemDescription typeSystemDescription, TypePriorities typePriorities, FsIndexDescription[] fsIndexDescriptionArray, Properties properties) throws ResourceInitializationException {
        return CasCreationUtils.createCas(typeSystemDescription, typePriorities, fsIndexDescriptionArray, properties, null);
    }

    public static CAS createCas(TypeSystemDescription typeSystemDescription, TypePriorities typePriorities, FsIndexDescription[] fsIndexDescriptionArray, Properties properties, ResourceManager resourceManager) throws ResourceInitializationException {
        return CasCreationUtils.doCreateCas(null, typeSystemDescription, typePriorities, fsIndexDescriptionArray, properties, resourceManager);
    }

    public static CAS createCas(Collection collection, TypeSystem typeSystem, Properties properties) throws ResourceInitializationException {
        return CasCreationUtils.createCas(collection, typeSystem, properties, UIMAFramework.newDefaultResourceManager());
    }

    public static CAS createCas(Collection collection, TypeSystem typeSystem, Properties properties, ResourceManager resourceManager) throws ResourceInitializationException {
        MetaDataObject metaDataObject;
        List list = CasCreationUtils.getMetaDataList(collection, resourceManager);
        ArrayList<TypeSystemDescription> arrayList = new ArrayList<TypeSystemDescription>();
        ArrayList<TypePriorities> arrayList2 = new ArrayList<TypePriorities>();
        ArrayList<FsIndexCollection> arrayList3 = new ArrayList<FsIndexCollection>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            metaDataObject = (ProcessingResourceMetaData)iterator.next();
            if (metaDataObject.getTypeSystem() != null) {
                arrayList.add(metaDataObject.getTypeSystem());
            }
            if (metaDataObject.getTypePriorities() != null) {
                arrayList2.add(metaDataObject.getTypePriorities());
            }
            if (metaDataObject.getFsIndexCollection() == null) continue;
            arrayList3.add(metaDataObject.getFsIndexCollection());
        }
        metaDataObject = CasCreationUtils.mergeTypePriorities(arrayList2, resourceManager);
        FsIndexCollection fsIndexCollection = CasCreationUtils.mergeFsIndexes(arrayList3, resourceManager);
        if (typeSystem != null) {
            return CasCreationUtils.createCas(typeSystem, (TypePriorities)metaDataObject, fsIndexCollection.getFsIndexes(), properties, resourceManager);
        }
        TypeSystemDescription typeSystemDescription = CasCreationUtils.mergeTypeSystems(arrayList);
        return CasCreationUtils.createCas(typeSystemDescription, (TypePriorities)metaDataObject, fsIndexCollection.getFsIndexes(), properties, resourceManager);
    }

    public static CAS createCas(TypeSystem typeSystem, TypePriorities typePriorities, FsIndexDescription[] fsIndexDescriptionArray, Properties properties) throws ResourceInitializationException {
        return CasCreationUtils.createCas(typeSystem, typePriorities, fsIndexDescriptionArray, properties, null);
    }

    public static CAS createCas(TypeSystem typeSystem, TypePriorities typePriorities, FsIndexDescription[] fsIndexDescriptionArray, Properties properties, ResourceManager resourceManager) throws ResourceInitializationException {
        return CasCreationUtils.doCreateCas(typeSystem, null, typePriorities, fsIndexDescriptionArray, properties, resourceManager);
    }

    private static CAS doCreateCas(TypeSystem typeSystem, TypeSystemDescription typeSystemDescription, TypePriorities typePriorities, FsIndexDescription[] fsIndexDescriptionArray, Properties properties, ResourceManager resourceManager) throws ResourceInitializationException {
        CASMgr cASMgr;
        if (resourceManager == null) {
            resourceManager = UIMAFramework.newDefaultResourceManager();
        }
        try {
            if (typeSystemDescription != null) {
                typeSystemDescription.resolveImports(resourceManager);
            }
            if (typePriorities != null) {
                typePriorities.resolveImports(resourceManager);
            }
        }
        catch (InvalidXMLException invalidXMLException) {
            throw new ResourceInitializationException(invalidXMLException);
        }
        String string = null;
        if (properties != null) {
            string = properties.getProperty("cas_initial_heap_size");
        }
        if (typeSystem != null) {
            cASMgr = string != null ? CASFactory.createCAS(Integer.parseInt(string), typeSystem) : CASFactory.createCAS(typeSystem);
        } else {
            cASMgr = string != null ? CASFactory.createCAS(Integer.parseInt(string)) : CASFactory.createCAS();
            CasCreationUtils.setupTypeSystem(cASMgr, typeSystemDescription);
            cASMgr.getTypeSystemMgr().commit();
        }
        try {
            CasCreationUtils.setupTypePriorities(cASMgr, typePriorities);
            cASMgr.initCASIndexes();
        }
        catch (CASException cASException) {
            throw new ResourceInitializationException(cASException);
        }
        CasCreationUtils.setupIndexes(cASMgr, fsIndexDescriptionArray);
        cASMgr.getIndexRepositoryMgr().commit();
        if (resourceManager.getExtensionClassLoader() != null) {
            cASMgr.setJCasClassLoader(resourceManager.getExtensionClassLoader());
        }
        return cASMgr.getCAS();
    }

    public static TCAS createTCas(AnalysisEngineMetaData analysisEngineMetaData) throws ResourceInitializationException {
        ArrayList<AnalysisEngineMetaData> arrayList = new ArrayList<AnalysisEngineMetaData>();
        arrayList.add(analysisEngineMetaData);
        return CasCreationUtils.createTCas(arrayList);
    }

    public static TCAS createTCas(ProcessingResourceMetaData processingResourceMetaData) throws ResourceInitializationException {
        ArrayList<ProcessingResourceMetaData> arrayList = new ArrayList<ProcessingResourceMetaData>();
        arrayList.add(processingResourceMetaData);
        return CasCreationUtils.createTCas(arrayList);
    }

    public static TCAS createTCas(AnalysisEngineDescription analysisEngineDescription) throws ResourceInitializationException {
        return CasCreationUtils.createTCas(analysisEngineDescription, UIMAFramework.getDefaultPerformanceTuningProperties());
    }

    public static TCAS createTCas(AnalysisEngineDescription analysisEngineDescription, Properties properties) throws ResourceInitializationException {
        ArrayList<AnalysisEngineDescription> arrayList = new ArrayList<AnalysisEngineDescription>();
        arrayList.add(analysisEngineDescription);
        return CasCreationUtils.createTCas(arrayList, properties);
    }

    public static TCAS createTCas(Collection collection) throws ResourceInitializationException {
        return CasCreationUtils.createTCas(collection, UIMAFramework.getDefaultPerformanceTuningProperties());
    }

    public static TCAS createTCas(Collection collection, Properties properties) throws ResourceInitializationException {
        return CasCreationUtils.createTCas(collection, properties, UIMAFramework.newDefaultResourceManager());
    }

    public static TCAS createTCas(Collection collection, Properties properties, ResourceManager resourceManager) throws ResourceInitializationException {
        MetaDataObject metaDataObject;
        List list = CasCreationUtils.getMetaDataList(collection, resourceManager);
        ArrayList<TypeSystemDescription> arrayList = new ArrayList<TypeSystemDescription>();
        ArrayList<TypePriorities> arrayList2 = new ArrayList<TypePriorities>();
        ArrayList<FsIndexCollection> arrayList3 = new ArrayList<FsIndexCollection>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            metaDataObject = (ProcessingResourceMetaData)iterator.next();
            if (metaDataObject.getTypeSystem() != null) {
                arrayList.add(metaDataObject.getTypeSystem());
            }
            if (metaDataObject.getTypePriorities() != null) {
                arrayList2.add(metaDataObject.getTypePriorities());
            }
            if (metaDataObject.getFsIndexCollection() == null) continue;
            arrayList3.add(metaDataObject.getFsIndexCollection());
        }
        metaDataObject = CasCreationUtils.mergeTypeSystems(arrayList, resourceManager);
        TypePriorities typePriorities = CasCreationUtils.mergeTypePriorities(arrayList2, resourceManager);
        FsIndexCollection fsIndexCollection = CasCreationUtils.mergeFsIndexes(arrayList3, resourceManager);
        return CasCreationUtils.createTCas((TypeSystemDescription)metaDataObject, typePriorities, fsIndexCollection.getFsIndexes(), properties, resourceManager);
    }

    public static TCAS createTCas(Collection collection, TypeSystem typeSystem) throws ResourceInitializationException {
        return CasCreationUtils.createTCas(collection, typeSystem, UIMAFramework.getDefaultPerformanceTuningProperties());
    }

    public static TCAS createTCas(Collection collection, TypeSystem typeSystem, Properties properties) throws ResourceInitializationException {
        return CasCreationUtils.createTCas(collection, typeSystem, properties, UIMAFramework.newDefaultResourceManager());
    }

    public static TCAS createTCas(Collection collection, TypeSystem typeSystem, Properties properties, ResourceManager resourceManager) throws ResourceInitializationException {
        MetaDataObject metaDataObject;
        List list = CasCreationUtils.getMetaDataList(collection, resourceManager);
        ArrayList<TypeSystemDescription> arrayList = new ArrayList<TypeSystemDescription>();
        ArrayList<TypePriorities> arrayList2 = new ArrayList<TypePriorities>();
        ArrayList<FsIndexCollection> arrayList3 = new ArrayList<FsIndexCollection>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            metaDataObject = (ProcessingResourceMetaData)iterator.next();
            if (metaDataObject.getTypeSystem() != null) {
                arrayList.add(metaDataObject.getTypeSystem());
            }
            if (metaDataObject.getTypePriorities() != null) {
                arrayList2.add(metaDataObject.getTypePriorities());
            }
            if (metaDataObject.getFsIndexCollection() == null) continue;
            arrayList3.add(metaDataObject.getFsIndexCollection());
        }
        metaDataObject = CasCreationUtils.mergeTypePriorities(arrayList2, resourceManager);
        FsIndexCollection fsIndexCollection = CasCreationUtils.mergeFsIndexes(arrayList3, resourceManager);
        if (typeSystem != null) {
            return CasCreationUtils.createTCas(typeSystem, (TypePriorities)metaDataObject, fsIndexCollection.getFsIndexes(), properties, resourceManager);
        }
        TypeSystemDescription typeSystemDescription = CasCreationUtils.mergeTypeSystems(arrayList);
        return CasCreationUtils.createTCas(typeSystemDescription, (TypePriorities)metaDataObject, fsIndexCollection.getFsIndexes(), properties, resourceManager);
    }

    public static TCAS createTCas(TypeSystemDescription typeSystemDescription, TypePriorities typePriorities, FsIndexDescription[] fsIndexDescriptionArray) throws ResourceInitializationException {
        return CasCreationUtils.createTCas(typeSystemDescription, typePriorities, fsIndexDescriptionArray, UIMAFramework.getDefaultPerformanceTuningProperties());
    }

    public static TCAS createTCas(TypeSystemDescription typeSystemDescription, TypePriorities typePriorities, FsIndexDescription[] fsIndexDescriptionArray, Properties properties) throws ResourceInitializationException {
        return CasCreationUtils.createTCas(typeSystemDescription, typePriorities, fsIndexDescriptionArray, properties, null);
    }

    public static TCAS createTCas(TypeSystemDescription typeSystemDescription, TypePriorities typePriorities, FsIndexDescription[] fsIndexDescriptionArray, Properties properties, ResourceManager resourceManager) throws ResourceInitializationException {
        CAS cAS = CasCreationUtils.createCas(typeSystemDescription, typePriorities, fsIndexDescriptionArray, properties, resourceManager);
        return cAS.getTCAS();
    }

    public static TCAS createTCas(TypeSystem typeSystem, TypePriorities typePriorities, FsIndexDescription[] fsIndexDescriptionArray) throws ResourceInitializationException {
        return CasCreationUtils.createTCas(typeSystem, typePriorities, fsIndexDescriptionArray, UIMAFramework.getDefaultPerformanceTuningProperties());
    }

    public static TCAS createTCas(TypeSystem typeSystem, TypePriorities typePriorities, FsIndexDescription[] fsIndexDescriptionArray, Properties properties) throws ResourceInitializationException {
        return CasCreationUtils.createTCas(typeSystem, typePriorities, fsIndexDescriptionArray, properties, null);
    }

    public static TCAS createTCas(TypeSystem typeSystem, TypePriorities typePriorities, FsIndexDescription[] fsIndexDescriptionArray, Properties properties, ResourceManager resourceManager) throws ResourceInitializationException {
        CAS cAS = CasCreationUtils.createCas(typeSystem, typePriorities, fsIndexDescriptionArray, properties, resourceManager);
        return cAS.getTCAS();
    }

    public static void setupTypeSystem(CASMgr cASMgr, TypeSystemDescription typeSystemDescription) throws ResourceInitializationException {
        TypeDescription[] typeDescriptionArray;
        TypeSystemMgr typeSystemMgr = cASMgr.getTypeSystemMgr();
        if (typeSystemDescription != null && (typeDescriptionArray = typeSystemDescription.getTypes()) != null) {
            Object object;
            Object object2;
            Object object3;
            FeatureDescription[] featureDescriptionArray;
            Object object4;
            Object object5;
            int n;
            LinkedList<TypeDescription> linkedList = new LinkedList<TypeDescription>();
            linkedList.addAll(Arrays.asList(typeDescriptionArray));
            int n2 = linkedList.size();
            do {
                n = n2;
                object5 = linkedList.iterator();
                while (object5.hasNext()) {
                    object4 = (TypeDescription)object5.next();
                    featureDescriptionArray = object4.getName();
                    String string = object4.getSupertypeName();
                    if (string == null) {
                        throw new ResourceInitializationException("no_supertype", new Object[]{featureDescriptionArray, object4.getSourceUrlString()});
                    }
                    object3 = typeSystemMgr.getType(string);
                    if (object3 == null) continue;
                    if (object4.getSupertypeName().equals("uima.cas.String")) {
                        object2 = object4.getAllowedValues();
                        if (object2 == null) {
                            throw new ResourceInitializationException("missing_allowed_values", new Object[]{featureDescriptionArray, object4.getSourceUrlString()});
                        }
                        object = new String[((AllowedValue[])object2).length];
                        for (int i = 0; i < ((String[])object).length; ++i) {
                            object[i] = object2[i].getString();
                        }
                        typeSystemMgr.addStringSubtype((String)featureDescriptionArray, (String[])object);
                    } else {
                        typeSystemMgr.addType((String)featureDescriptionArray, (Type)object3);
                    }
                    object5.remove();
                }
            } while ((n2 = linkedList.size()) > 0 && n2 != n);
            if (n2 > 0) {
                object5 = (TypeDescription)linkedList.getFirst();
                throw new ResourceInitializationException("undefined_supertype", new Object[]{object5.getSupertypeName(), object5.getName(), object5.getSourceUrlString()});
            }
            for (int i = 0; i < typeDescriptionArray.length; ++i) {
                object4 = typeSystemMgr.getType(typeDescriptionArray[i].getName());
                featureDescriptionArray = typeDescriptionArray[i].getFeatures();
                if (featureDescriptionArray == null) continue;
                for (int j = 0; j < featureDescriptionArray.length; ++j) {
                    Object object6;
                    object3 = featureDescriptionArray[j].getName();
                    object2 = featureDescriptionArray[j].getRangeTypeName();
                    object = typeSystemMgr.getType((String)object2);
                    if (object == null) {
                        throw new ResourceInitializationException("undefined_range_type", new Object[]{object2, object3, typeDescriptionArray[i].getName(), featureDescriptionArray[j].getSourceUrlString()});
                    }
                    if (object.isArray() && (object6 = featureDescriptionArray[j].getElementType()) != null && ((String)object6).length() > 0) {
                        Type type = typeSystemMgr.getType((String)object6);
                        if (type == null) {
                            throw new ResourceInitializationException("undefined_range_type", new Object[]{object6, object3, typeDescriptionArray[i].getName(), featureDescriptionArray[j].getSourceUrlString()});
                        }
                        object = typeSystemMgr.getArrayType(type);
                    }
                    if ((object6 = featureDescriptionArray[j].getMultipleReferencesAllowed()) == null) {
                        object6 = Boolean.FALSE;
                    }
                    typeSystemMgr.addFeature((String)object3, (Type)object4, (Type)object, (Boolean)object6);
                }
            }
        }
    }

    public static void setupTypePriorities(CASMgr cASMgr, TypePriorities typePriorities) throws ResourceInitializationException {
        if (typePriorities != null) {
            LinearTypeOrderBuilder linearTypeOrderBuilder = cASMgr.getIndexRepositoryMgr().getDefaultOrderBuilder();
            TypePriorityList[] typePriorityListArray = typePriorities.getPriorityLists();
            for (int i = 0; i < typePriorityListArray.length; ++i) {
                String[] stringArray = typePriorityListArray[i].getTypes();
                for (int j = 0; j < stringArray.length; ++j) {
                    if (cASMgr.getTypeSystemMgr().getType(stringArray[j]) != null) continue;
                    throw new ResourceInitializationException("undefined_type_for_priority_list", new Object[]{stringArray[j], typePriorityListArray[i].getSourceUrlString()});
                }
                try {
                    linearTypeOrderBuilder.add(typePriorityListArray[i].getTypes());
                    continue;
                }
                catch (CASException cASException) {
                    throw new ResourceInitializationException("invalid_type_priorities", new Object[]{typePriorityListArray[i].getSourceUrlString()}, cASException);
                }
            }
        }
    }

    public static void setupIndexes(CASMgr cASMgr, FsIndexDescription[] fsIndexDescriptionArray) throws ResourceInitializationException {
        if (fsIndexDescriptionArray != null) {
            TypeSystemMgr typeSystemMgr = cASMgr.getTypeSystemMgr();
            FSIndexRepositoryMgr fSIndexRepositoryMgr = cASMgr.getIndexRepositoryMgr();
            for (int i = 0; i < fsIndexDescriptionArray.length; ++i) {
                Type type;
                int n = 0;
                String string = fsIndexDescriptionArray[i].getKind();
                if (string != null) {
                    if (string.equals("bag")) {
                        n = 2;
                    } else if (string.equals("set")) {
                        n = 1;
                    } else if (string.equals("sorted")) {
                        n = 0;
                    }
                }
                if ((type = typeSystemMgr.getType(fsIndexDescriptionArray[i].getTypeName())) == null) {
                    throw new ResourceInitializationException("undefined_type_for_index", new Object[]{fsIndexDescriptionArray[i].getTypeName(), fsIndexDescriptionArray[i].getLabel(), fsIndexDescriptionArray[i].getSourceUrlString()});
                }
                FSIndexComparator fSIndexComparator = fSIndexRepositoryMgr.createComparator();
                fSIndexComparator.setType(type);
                FsIndexKeyDescription[] fsIndexKeyDescriptionArray = fsIndexDescriptionArray[i].getKeys();
                if (fsIndexKeyDescriptionArray != null) {
                    for (int j = 0; j < fsIndexKeyDescriptionArray.length; ++j) {
                        if (fsIndexKeyDescriptionArray[j].isTypePriority()) {
                            fSIndexComparator.addKey(fSIndexRepositoryMgr.getDefaultTypeOrder(), 0);
                            continue;
                        }
                        Feature feature = type.getFeatureByBaseName(fsIndexKeyDescriptionArray[j].getFeatureName());
                        if (feature == null) {
                            throw new ResourceInitializationException("index_key_feature_not_found", new Object[]{fsIndexKeyDescriptionArray[j].getFeatureName(), fsIndexDescriptionArray[i].getLabel(), fsIndexDescriptionArray[i].getSourceUrlString()});
                        }
                        fSIndexComparator.addKey(feature, fsIndexKeyDescriptionArray[j].getComparator());
                    }
                }
                fSIndexRepositoryMgr.createIndex(fSIndexComparator, fsIndexDescriptionArray[i].getLabel(), n);
            }
        }
    }

    public static TypeSystemDescription convertData2TypeSystem(CasData casData) {
        TypeDescription[] typeDescriptionArray;
        TypeSystemDescription typeSystemDescription = UIMAFramework.getResourceSpecifierFactory().createTypeSystemDescription();
        Iterator iterator = casData.getFeatureStructures();
        ArrayList<TypeDescription> arrayList = new ArrayList<TypeDescription>();
        while (iterator.hasNext()) {
            typeDescriptionArray = (TypeDescription[])iterator.next();
            TypeDescription typeDescription = UIMAFramework.getResourceSpecifierFactory().createTypeDescription();
            typeDescription.setName(typeDescriptionArray.getType());
            typeDescription.setSupertypeName("uima.tcas.annotation");
            typeDescription.setDescription("CasData Type");
            String[] stringArray = typeDescriptionArray.getFeatureNames();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    String string2 = "";
                    String string3 = "";
                    PrimitiveValue primitiveValue = (PrimitiveValue)typeDescriptionArray.getFeatureValue(string);
                    if (primitiveValue.get().getClass().getName().equals("java.lang.String")) {
                        System.out.println(" the feature is a String ");
                        string2 = "uima.cas.String";
                        string3 = " featue of the casDataType";
                    }
                    typeDescription.addFeature(string, string3, string2);
                }
            }
            arrayList.add(typeDescription);
        }
        typeDescriptionArray = new TypeDescription[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            typeDescriptionArray[i] = (TypeDescription)arrayList.get(i);
        }
        typeSystemDescription.setTypes(typeDescriptionArray);
        return typeSystemDescription;
    }

    public static TypeSystemDescription mergeTypeSystems(Collection collection) throws ResourceInitializationException {
        return CasCreationUtils.mergeTypeSystems(collection, UIMAFramework.newDefaultResourceManager());
    }

    public static TypeSystemDescription mergeTypeSystems(Collection collection, ResourceManager resourceManager) throws ResourceInitializationException {
        TypeSystemDescription typeSystemDescription = UIMAFramework.getResourceSpecifierFactory().createTypeSystemDescription();
        HashMap<String, TypeDescription> hashMap = new HashMap<String, TypeDescription>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            TypeSystemDescription typeSystemDescription2 = (TypeSystemDescription)iterator.next();
            if (typeSystemDescription2 == null) continue;
            try {
                typeSystemDescription2.resolveImports(resourceManager);
            }
            catch (InvalidXMLException invalidXMLException) {
                throw new ResourceInitializationException(invalidXMLException);
            }
            TypeDescription[] typeDescriptionArray = typeSystemDescription2.getTypes();
            if (typeDescriptionArray == null) continue;
            for (int i = 0; i < typeDescriptionArray.length; ++i) {
                FeatureDescription[] featureDescriptionArray;
                String string = typeDescriptionArray[i].getName();
                TypeDescription typeDescription = (TypeDescription)hashMap.get(string);
                if (typeDescription == null) {
                    typeDescription = typeSystemDescription.addType(typeDescriptionArray[i].getName(), typeDescriptionArray[i].getDescription(), typeDescriptionArray[i].getSupertypeName());
                    typeDescription.setAllowedValues(typeDescriptionArray[i].getAllowedValues());
                    typeDescription.setSourceUrl(typeDescriptionArray[i].getSourceUrl());
                    hashMap.put(typeDescriptionArray[i].getName(), typeDescription);
                } else {
                    featureDescriptionArray = typeDescriptionArray[i].getSupertypeName();
                    String string2 = typeDescription.getSupertypeName();
                    if (!string2.equals(featureDescriptionArray)) {
                        if (CasCreationUtils.subsumes(string2, (String)featureDescriptionArray, hashMap)) {
                            typeDescription.setSupertypeName((String)featureDescriptionArray);
                        } else if (!CasCreationUtils.subsumes((String)featureDescriptionArray, string2, hashMap)) {
                            throw new ResourceInitializationException("incompatible_supertypes", new Object[]{string, featureDescriptionArray, string2, typeDescriptionArray[i].getSourceUrlString()});
                        }
                    }
                }
                featureDescriptionArray = typeDescriptionArray[i].getFeatures();
                if (featureDescriptionArray == null) continue;
                CasCreationUtils.mergeFeatures(typeDescription, typeDescriptionArray[i].getFeatures());
            }
        }
        return typeSystemDescription;
    }

    public static TypeSystemDescription mergeDelegateAnalysisEngineTypeSystems(AnalysisEngineDescription analysisEngineDescription) throws ResourceInitializationException {
        return CasCreationUtils.mergeDelegateAnalysisEngineTypeSystems(analysisEngineDescription, UIMAFramework.newDefaultResourceManager());
    }

    public static TypeSystemDescription mergeDelegateAnalysisEngineTypeSystems(AnalysisEngineDescription analysisEngineDescription, ResourceManager resourceManager) throws ResourceInitializationException {
        ArrayList<AnalysisEngineDescription> arrayList = new ArrayList<AnalysisEngineDescription>();
        arrayList.add(analysisEngineDescription);
        List list = CasCreationUtils.getMetaDataList(arrayList, resourceManager);
        ArrayList<TypeSystemDescription> arrayList2 = new ArrayList<TypeSystemDescription>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ProcessingResourceMetaData processingResourceMetaData = (ProcessingResourceMetaData)iterator.next();
            if (processingResourceMetaData.getTypeSystem() == null) continue;
            arrayList2.add(processingResourceMetaData.getTypeSystem());
        }
        return CasCreationUtils.mergeTypeSystems(arrayList2, resourceManager);
    }

    public static FsIndexCollection mergeFsIndexes(List list, ResourceManager resourceManager) throws ResourceInitializationException {
        FsIndexDescription[] fsIndexDescriptionArray;
        FsIndexCollection fsIndexCollection;
        HashMap<String, FsIndexDescription> hashMap = new HashMap<String, FsIndexDescription>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            fsIndexCollection = (FsIndexCollection)iterator.next();
            if (fsIndexCollection == null) continue;
            try {
                fsIndexCollection.resolveImports(resourceManager);
            }
            catch (InvalidXMLException invalidXMLException) {
                throw new ResourceInitializationException(invalidXMLException);
            }
            fsIndexDescriptionArray = fsIndexCollection.getFsIndexes();
            for (int i = 0; i < fsIndexDescriptionArray.length; ++i) {
                FsIndexDescription fsIndexDescription = (FsIndexDescription)hashMap.get(fsIndexDescriptionArray[i].getLabel());
                if (fsIndexDescription == null) {
                    hashMap.put(fsIndexDescriptionArray[i].getLabel(), fsIndexDescriptionArray[i]);
                    continue;
                }
                if (fsIndexDescription.equals(fsIndexDescriptionArray[i])) continue;
                throw new ResourceInitializationException("duplicate_index_name", new Object[]{fsIndexDescription.getLabel(), fsIndexDescription.getSourceUrlString(), fsIndexDescriptionArray[i].getSourceUrlString()});
            }
        }
        fsIndexCollection = UIMAFramework.getResourceSpecifierFactory().createFsIndexCollection();
        fsIndexDescriptionArray = hashMap.values();
        FsIndexDescription[] fsIndexDescriptionArray2 = new FsIndexDescription[fsIndexDescriptionArray.size()];
        fsIndexDescriptionArray.toArray(fsIndexDescriptionArray2);
        fsIndexCollection.setFsIndexes(fsIndexDescriptionArray2);
        return fsIndexCollection;
    }

    public static FsIndexCollection mergeDelegateAnalysisEngineFsIndexCollections(AnalysisEngineDescription analysisEngineDescription) throws ResourceInitializationException {
        return CasCreationUtils.mergeDelegateAnalysisEngineFsIndexCollections(analysisEngineDescription, UIMAFramework.newDefaultResourceManager());
    }

    public static FsIndexCollection mergeDelegateAnalysisEngineFsIndexCollections(AnalysisEngineDescription analysisEngineDescription, ResourceManager resourceManager) throws ResourceInitializationException {
        ArrayList<AnalysisEngineDescription> arrayList = new ArrayList<AnalysisEngineDescription>();
        arrayList.add(analysisEngineDescription);
        List list = CasCreationUtils.getMetaDataList(arrayList, resourceManager);
        ArrayList<FsIndexCollection> arrayList2 = new ArrayList<FsIndexCollection>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ProcessingResourceMetaData processingResourceMetaData = (ProcessingResourceMetaData)iterator.next();
            if (processingResourceMetaData.getFsIndexCollection() == null) continue;
            arrayList2.add(processingResourceMetaData.getFsIndexCollection());
        }
        return CasCreationUtils.mergeFsIndexes(arrayList2, resourceManager);
    }

    public static TypePriorities mergeTypePriorities(List list, ResourceManager resourceManager) throws ResourceInitializationException {
        TypePriorities typePriorities = UIMAFramework.getResourceSpecifierFactory().createTypePriorities();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TypePriorities typePriorities2 = (TypePriorities)iterator.next();
            try {
                typePriorities2.resolveImports(resourceManager);
            }
            catch (InvalidXMLException invalidXMLException) {
                throw new ResourceInitializationException(invalidXMLException);
            }
            TypePriorityList[] typePriorityListArray = typePriorities2.getPriorityLists();
            if (typePriorityListArray == null) continue;
            for (int i = 0; i < typePriorityListArray.length; ++i) {
                typePriorities.addPriorityList(typePriorityListArray[i]);
            }
        }
        return typePriorities;
    }

    public static TypePriorities mergeDelegateAnalysisEngineTypePriorities(AnalysisEngineDescription analysisEngineDescription) throws ResourceInitializationException {
        return CasCreationUtils.mergeDelegateAnalysisEngineTypePriorities(analysisEngineDescription, UIMAFramework.newDefaultResourceManager());
    }

    public static TypePriorities mergeDelegateAnalysisEngineTypePriorities(AnalysisEngineDescription analysisEngineDescription, ResourceManager resourceManager) throws ResourceInitializationException {
        ArrayList<AnalysisEngineDescription> arrayList = new ArrayList<AnalysisEngineDescription>();
        arrayList.add(analysisEngineDescription);
        List list = CasCreationUtils.getMetaDataList(arrayList, resourceManager);
        ArrayList<TypePriorities> arrayList2 = new ArrayList<TypePriorities>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ProcessingResourceMetaData processingResourceMetaData = (ProcessingResourceMetaData)iterator.next();
            if (processingResourceMetaData.getTypePriorities() == null) continue;
            arrayList2.add(processingResourceMetaData.getTypePriorities());
        }
        return CasCreationUtils.mergeTypePriorities(arrayList2, resourceManager);
    }

    protected static boolean subsumes(String string, String string2, Map map) {
        if ("uima.cas.TOP".equals(string)) {
            return true;
        }
        String string3 = string2;
        while (string3 != null && !string3.equals(string)) {
            TypeDescription typeDescription = (TypeDescription)map.get(string3);
            if (typeDescription == null) {
                string3 = null;
                continue;
            }
            string3 = typeDescription.getSupertypeName();
        }
        return string3 != null;
    }

    protected static void mergeFeatures(TypeDescription typeDescription, FeatureDescription[] featureDescriptionArray) throws ResourceInitializationException {
        FeatureDescription[] featureDescriptionArray2 = typeDescription.getFeatures();
        if (featureDescriptionArray2 == null) {
            featureDescriptionArray2 = new FeatureDescription[]{};
        }
        for (int i = 0; i < featureDescriptionArray.length; ++i) {
            String string = featureDescriptionArray[i].getName();
            String string2 = featureDescriptionArray[i].getRangeTypeName();
            String string3 = featureDescriptionArray[i].getElementType();
            Boolean bl = featureDescriptionArray[i].getMultipleReferencesAllowed();
            FeatureDescription featureDescription = null;
            for (int j = 0; j < featureDescriptionArray2.length; ++j) {
                if (!featureDescriptionArray2[j].getName().equals(string)) continue;
                featureDescription = featureDescriptionArray2[j];
                break;
            }
            if (featureDescription == null) {
                FeatureDescription featureDescription2 = typeDescription.addFeature(string, featureDescriptionArray[i].getDescription(), string2, string3, bl);
                featureDescription2.setSourceUrl(featureDescriptionArray[i].getSourceUrl());
                continue;
            }
            if (featureDescription.getRangeTypeName().equals(string2)) continue;
            throw new ResourceInitializationException("incompatible_range_types", new Object[]{typeDescription.getName() + ":" + featureDescription.getName(), string2, featureDescription.getRangeTypeName(), typeDescription.getSourceUrlString()});
        }
    }

    public static List getMetaDataList(Collection collection, ResourceManager resourceManager) throws ResourceInitializationException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (null == collection) {
            return arrayList;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof ProcessingResourceMetaData) {
                arrayList.add(((ProcessingResourceMetaData)e).clone());
            }
            if (e instanceof AnalysisEngineDescription) {
                Map map;
                AnalysisEngineDescription analysisEngineDescription = (AnalysisEngineDescription)e;
                arrayList.add(analysisEngineDescription.getMetaData().clone());
                if (analysisEngineDescription.isPrimitive()) continue;
                try {
                    map = analysisEngineDescription.getDelegateAnalysisEngineSpecifiers(resourceManager);
                }
                catch (InvalidXMLException invalidXMLException) {
                    throw new ResourceInitializationException(invalidXMLException);
                }
                arrayList.addAll(CasCreationUtils.getMetaDataList(map.values(), resourceManager));
                continue;
            }
            if (e instanceof CollectionReaderDescription) {
                arrayList.add(((CollectionReaderDescription)e).getMetaData().clone());
                continue;
            }
            if (e instanceof CasInitializerDescription) {
                arrayList.add(((CasInitializerDescription)e).getMetaData().clone());
                continue;
            }
            if (!(e instanceof CasConsumerDescription)) continue;
            arrayList.add(((CasConsumerDescription)e).getMetaData().clone());
        }
        return arrayList;
    }
}

