/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.util;

import com.ibm.uima.util.ProcessTrace;
import com.ibm.uima.util.ProcessTraceEvent;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AnalysisEnginePerformanceReports {
    private ProcessTrace mProcessTrace;
    private Map mAnnotatorAnalysisTimes = new HashMap();
    private int mAnalysisTime = 0;
    private int mFrameworkOverhead = 0;
    private int mServiceWrapperOverhead = 0;
    private int mServiceCallOverhead = 0;
    private int mTotalTime = 0;
    private NumberFormat pctFormat;

    public AnalysisEnginePerformanceReports(ProcessTrace processTrace) {
        this.mProcessTrace = processTrace;
        this.pctFormat = NumberFormat.getPercentInstance();
        this.pctFormat.setMaximumFractionDigits(2);
        List list = processTrace.getEvents();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ProcessTraceEvent processTraceEvent = (ProcessTraceEvent)iterator.next();
            if ("ANALYSIS_ENGINE".equals(processTraceEvent.getType()) || "SERVICE_CALL".equals(processTraceEvent.getType())) {
                this.mTotalTime += processTraceEvent.getDuration();
            }
            this.addEventData(processTraceEvent);
        }
    }

    protected void addEventData(ProcessTraceEvent processTraceEvent) {
        int n;
        int n2;
        Object object;
        if ("ANALYSIS".equals(processTraceEvent.getType())) {
            this.mAnalysisTime += processTraceEvent.getDuration();
            object = processTraceEvent.getComponentName();
            this.mAnnotatorAnalysisTimes.put(object, new Integer(processTraceEvent.getDuration()));
        } else if ("ANALYSIS_ENGINE".equals(processTraceEvent.getType())) {
            object = new String[]{"ANALYSIS", "ANALYSIS_ENGINE"};
            n2 = processTraceEvent.getDuration();
            n = this.getSubEventDuration(processTraceEvent, (String[])object);
            if (n > 0) {
                this.mFrameworkOverhead += n2 - n;
            }
        } else if ("SERVICE".equals(processTraceEvent.getType())) {
            object = new String[]{"ANALYSIS", "ANALYSIS_ENGINE"};
            n2 = processTraceEvent.getDuration();
            n = this.getSubEventDuration(processTraceEvent, (String[])object);
            if (n > 0) {
                this.mServiceWrapperOverhead += n2 - n;
            }
        } else if ("SERVICE_CALL".equals(processTraceEvent.getType())) {
            object = new String[]{"SERVICE", "ANALYSIS", "ANALYSIS_ENGINE"};
            n2 = processTraceEvent.getDuration();
            n = this.getSubEventDuration(processTraceEvent, (String[])object);
            if (n > 0) {
                this.mServiceCallOverhead += n2 - n;
            }
        }
        object = processTraceEvent.getSubEvents().iterator();
        while (object.hasNext()) {
            ProcessTraceEvent processTraceEvent2 = (ProcessTraceEvent)object.next();
            this.addEventData(processTraceEvent2);
        }
    }

    public int getTotalTime() {
        return this.mTotalTime;
    }

    public int getAnalysisTime() {
        return this.mAnalysisTime;
    }

    public int getFrameworkOverhead() {
        return this.mFrameworkOverhead;
    }

    public int getServiceWrapperOverhead() {
        return this.mServiceWrapperOverhead;
    }

    public int getServiceCallOverhead() {
        return this.mServiceCallOverhead;
    }

    public String getFullReport() {
        return ((Object)this.mProcessTrace).toString();
    }

    public String toString() {
        int n = this.getTotalTime();
        int n2 = this.getAnalysisTime();
        int n3 = this.getFrameworkOverhead();
        int n4 = this.getServiceWrapperOverhead();
        int n5 = this.getServiceCallOverhead();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Total Analysis Engine Time: " + n + "ms\n");
        if (n2 > 0) {
            stringBuffer.append("Annotator Time: " + this.getAnalysisTime() + "ms (" + this.toPct(n2, n) + ")\n");
        } else {
            stringBuffer.append("Analysis: <10ms\n");
        }
        if (n3 > 0) {
            stringBuffer.append("Framework Overhead: " + n3 + "ms (" + this.toPct(n3, n) + ")\n");
        } else {
            stringBuffer.append("Framework Overhead: <10ms\n");
        }
        if (n5 > 0) {
            stringBuffer.append("Service Wrapper Overhead: " + n4 + "ms (" + this.toPct(n4, n) + ")\n");
            stringBuffer.append("Service Call Overhead: " + n5 + "ms (" + this.toPct(n5, n) + ")\n");
        }
        return stringBuffer.toString();
    }

    private String toPct(long l, long l2) {
        return this.pctFormat.format((double)l / (double)l2);
    }

    private int getSubEventDuration(ProcessTraceEvent processTraceEvent, String[] stringArray) {
        int n = 0;
        List list = processTraceEvent.getSubEvents();
        Iterator iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            ProcessTraceEvent processTraceEvent2 = (ProcessTraceEvent)iterator.next();
            String string = processTraceEvent2.getType();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                n += processTraceEvent2.getDuration();
                continue block0;
            }
            n += this.getSubEventDuration(processTraceEvent2, stringArray);
        }
        return n;
    }
}

