/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.tttypesystem;

public class TokenProperties {
    public static final int TAF_TOKEN_PROP_LEADING_UPPER = 1;
    public static final int TAF_TOKEN_PROP_TRAILING_UPPER = 2;
    public static final int TAF_TOKEN_PROP_LOWER = 4;
    public static final int TAF_TOKEN_PROP_NUMERIC = 8;
    public static final int TAF_TOKEN_PROP_SPECIAL = 16;
    public static final int TOKEN_PROP_NGRAM = 32;
    private int bits = 0;

    public TokenProperties() {
    }

    public TokenProperties(int n) {
        this();
        this.bits = n;
    }

    public int getInt() {
        return this.bits;
    }

    public void setInt(int n) {
        this.bits = n;
    }

    public boolean hasLeadingUpper() {
        return (this.bits & 1) != 0;
    }

    public void setLeadingUpper(boolean bl) {
        this.bits = bl ? (this.bits |= 1) : (this.bits &= 0xFFFFFFFE);
    }

    public boolean hasTrailingUpper() {
        return (this.bits & 2) != 0;
    }

    public void setTrailingUpper(boolean bl) {
        this.bits = bl ? (this.bits |= 2) : (this.bits &= 0xFFFFFFFD);
    }

    public boolean hasUpper() {
        return this.hasLeadingUpper() || this.hasTrailingUpper();
    }

    public boolean hasLower() {
        return (this.bits & 4) != 0;
    }

    public void setLower(boolean bl) {
        this.bits = bl ? (this.bits |= 4) : (this.bits &= 0xFFFFFFFB);
    }

    public boolean hasNumeric() {
        return (this.bits & 8) != 0;
    }

    public void setNumeric(boolean bl) {
        this.bits = bl ? (this.bits |= 8) : (this.bits &= 0xFFFFFFF7);
    }

    public boolean hasSpecial() {
        return (this.bits & 0x10) != 0;
    }

    public void setSpecial(boolean bl) {
        this.bits = bl ? (this.bits |= 0x10) : (this.bits &= 0xFFFFFFEF);
    }

    public boolean hasNgram() {
        return (this.bits & 0x20) != 0;
    }

    public void setNgram(boolean bl) {
        this.bits = bl ? (this.bits |= 0x20) : (this.bits &= 0xFFFFFFDF);
    }

    public boolean isPlainWord() {
        return !this.hasSpecial() && !this.hasNumeric();
    }

    public boolean isAllUppercaseWord() {
        return (this.bits & 0xFFFFFFFC) == 0;
    }

    public boolean isAllLowercaseWord() {
        return (this.bits & 0xFFFFFFFB) == 0;
    }

    public boolean isInitialUppercaseWord() {
        return (this.bits & 1) != 0 && (this.bits & 0x1A) == 0;
    }

    public boolean isPlainNumber() {
        return (this.bits & 8) != 0 && (this.bits & 7) == 0;
    }

    public boolean isPureNumber() {
        return this.bits == 8;
    }

    public boolean isPureSpecial() {
        return this.bits == 16;
    }

    public boolean isPureNgram() {
        return this.bits == 32;
    }

    public void reset() {
        this.bits = 0;
    }

    private static final boolean CHECK_U_UPPER(char c) {
        return c >= 'A' && c <= 'Z' || Character.isUpperCase(c);
    }

    private static final boolean CHECK_U_LOWER(char c) {
        return c >= 'a' && c <= 'z' || Character.isLowerCase(c);
    }

    private static final boolean CHECK_U_DIGIT(char c) {
        return c >= '0' && c <= '9' || Character.isDigit(c);
    }

    public void initFromString(String string) {
        this.initFromCharArray(string.toCharArray(), 0, string.length());
    }

    public void initFromCharArray(char[] cArray, int n, int n2) {
        this.bits = 0;
        int n3 = n;
        int n4 = n + n2;
        if (n3 >= n4) {
            return;
        }
        char c = cArray[n3];
        if (TokenProperties.CHECK_U_LOWER(c)) {
            this.setLower(true);
        } else if (TokenProperties.CHECK_U_UPPER(c)) {
            this.setLeadingUpper(true);
        } else if (TokenProperties.CHECK_U_DIGIT(c)) {
            this.setNumeric(true);
        } else {
            this.setSpecial(true);
        }
        ++n3;
        while (n3 < n4) {
            c = cArray[n3];
            if (TokenProperties.CHECK_U_LOWER(c)) {
                this.setLower(true);
            } else if (TokenProperties.CHECK_U_UPPER(c)) {
                this.setTrailingUpper(true);
            } else if (TokenProperties.CHECK_U_DIGIT(c)) {
                this.setNumeric(true);
            } else {
                this.setSpecial(true);
            }
            ++n3;
        }
    }
}

